/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.xml.war.writers;

import com.ibm.etools.j2ee.common.RunAsSpecifiedIdentity;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.MofXmlWriterFactory;
import com.ibm.etools.j2ee.xml.common.writers.RunAsXmlWriter;
import com.ibm.etools.j2ee.xml.common.writers.SecurityRoleRefXmlWriter;
import com.ibm.etools.j2ee.xml.war.writers.InitParamXmlWriter;
import com.ibm.etools.j2ee.xml.war.writers.ServletIconXmlWriter;
import com.ibm.etools.j2ee.xml.war.writers.WarDeploymentDescriptorXmlWriter;
import com.ibm.etools.webapplication.JSPType;
import com.ibm.etools.webapplication.Servlet;
import com.ibm.etools.webapplication.ServletType;
import com.ibm.etools.webapplication.WebType;
import java.io.Writer;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class ServletXmlWriter
extends WarDeploymentDescriptorXmlWriter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public ServletXmlWriter() {
    }

    public ServletXmlWriter(EObject eObject, Writer writer, int n) {
        super(eObject, writer, n);
    }

    public MofXmlWriterFactory getInitParamXmlWriterFactory() {
        return new MofXmlWriterFactory(){

            public MofXmlWriter create(EObject eObject) {
                return new InitParamXmlWriter(eObject, ServletXmlWriter.this.getWriter(), ServletXmlWriter.this.getNestLevel() + 1);
            }
        };
    }

    public MofXmlWriterFactory getSecurityRoleRefXmlWriterFactory() {
        return new MofXmlWriterFactory(){

            public MofXmlWriter create(EObject eObject) {
                return new SecurityRoleRefXmlWriter(eObject, ServletXmlWriter.this.getWriter(), ServletXmlWriter.this.getNestLevel() + 1);
            }
        };
    }

    public Servlet getServlet() {
        return (Servlet)this.getObject();
    }

    public String getTagName() {
        return "servlet";
    }

    public void writeData() {
        Servlet servlet = this.getServlet();
        WebType webType = this.getServlet().getWebType();
        this.writeIcon();
        this.writeRequiredAttribute("servlet-name", servlet.getServletName());
        this.writeOptionalAttribute("display-name", servlet.getDisplayName());
        this.writeDescription(servlet.getDescription());
        if (webType != null) {
            if (webType.isServletType()) {
                this.writeRequiredAttribute("servlet-class", ((ServletType)webType).getClassName());
            } else if (webType.isJspType()) {
                this.writeRequiredAttribute("jsp-file", ((JSPType)webType).getJspFile());
            }
        }
        this.writeList((List)this.getServlet().getParams(), this.getInitParamXmlWriterFactory());
        if (servlet.isSetLoadOnStartup() && servlet.getLoadOnStartup() == null) {
            this.writeEmptyAttribute("load-on-startup");
        } else {
            this.writeOptionalAttribute("load-on-startup", servlet.getLoadOnStartup());
        }
        this.writeRunAsSpecifiedIdentity();
        this.writeList((List)this.getServlet().getSecurityRoleRefs(), this.getSecurityRoleRefXmlWriterFactory());
    }

    public void writeIcon() {
        if (this.getServlet().getLargeIcon() != null || this.getServlet().getSmallIcon() != null) {
            new ServletIconXmlWriter(this.getObject(), this.getWriter(), this.getNestLevel() + 1).toXml(this);
        }
    }

    public void writeRunAsSpecifiedIdentity() {
        RunAsSpecifiedIdentity runAsSpecifiedIdentity = this.getServlet().getRunAs();
        if (runAsSpecifiedIdentity == null) {
            return;
        }
        new RunAsXmlWriter(runAsSpecifiedIdentity, this.getWriter(), this.getNestLevel() + 1).toXml(this);
    }
}

