/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.i18n.localizabletext;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class LocalizableTextEJBDeploy {
    private String applicationName = null;
    private String hostName = null;
    private String serverName = null;
    private String installRoot = null;
    private boolean debug = false;
    private boolean requiredArgsPassed = false;
    private String workingDirectory = null;
    private String version = "7.16.2001.12.49";
    private ResourceBundle msg = ResourceBundle.getBundle("com/ibm/websphere/i18n/localizabletext/LocalizableText");
    private String toolErr = this.msg.getString("toolErr") + " ";
    private String toolMsg = this.msg.getString("toolMsg") + " ";
    private String stdExiting = this.toolErr + this.msg.getString("stdExiting");

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getInstallRoot() {
        return this.installRoot;
    }

    public String getServerName() {
        return this.serverName;
    }

    private boolean isRequiredArgsSet() {
        this.requiredArgsPassed = this.hostName != null && this.installRoot != null && this.applicationName != null && this.serverName != null && this.workingDirectory != null;
        return this.requiredArgsPassed;
    }

    private void processArguments(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].toLowerCase().equals("-a")) {
                this.applicationName = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-h")) {
                this.hostName = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-s")) {
                this.serverName = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-i")) {
                this.setInstallRoot(stringArray[i + 1]);
                continue;
            }
            if (stringArray[i].toLowerCase().equals("-w")) {
                this.workingDirectory = stringArray[i + 1];
                continue;
            }
            if (!stringArray[i].toLowerCase().equals("-d")) continue;
            this.debug = true;
        }
    }

    public void run() {
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Tool Version: " + this.version);
        }
        if (this.isRequiredArgsSet()) {
            boolean bl = true;
            if (bl) {
                bl = this.extractXMFiles();
            }
            if (bl) {
                bl = this.parseXMLFile();
            }
            if (bl) {
                bl = this.parseXMIFile();
            }
            if (bl) {
                bl = this.createLTEJBjar();
            }
            if (bl) {
                bl = this.runEJBDeployTool();
            }
            if (bl) {
                bl = this.addXMIFiles();
            }
            if (bl) {
                bl = this.cleanUp();
            }
        } else {
            System.out.println(this.toolErr + " Required arguments not passed / set.");
            System.out.println(this.toolErr + " Exiting.");
            return;
        }
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public void setInstallRoot(String string) {
        this.installRoot = string;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void usage() {
        String string = this.msg.getString("usage1");
        String string2 = this.msg.getString("usage2");
        String string3 = this.msg.getString("usage3");
        String string4 = this.msg.getString("usage4");
        String string5 = this.msg.getString("usage5");
        String string6 = this.msg.getString("usage6");
        String string7 = this.msg.getString("usage7");
        System.out.println("\njava com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy\n\t\t\t -i <" + string + "> (" + string7 + ")" + "\n\t\t\t -a <" + string2 + ">            (" + string7 + ")" + "\n\t\t\t -h <" + string3 + ">                   (" + string7 + ")" + "\n\t\t\t -s <" + string4 + ">                 (" + string7 + ")" + "\n\t\t\t -w <" + string5 + ">           (" + string7 + ")");
        System.out.println("\n" + string6);
        System.out.println("\njava com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy -a MyApplication -h BigHost -s MightyServer -i C:\\WebSphere\\AppServer -w C:\\workingDirectory");
    }

    private boolean addXMIFiles() {
        JarFile jarFile = null;
        JarEntry jarEntry = null;
        Manifest manifest = new Manifest();
        String string = null;
        FileInputStream fileInputStream = null;
        InputStream inputStream = null;
        JarOutputStream jarOutputStream = null;
        byte[] byArray = new byte[4096];
        int n = 0;
        String string2 = File.separator;
        String string3 = this.workingDirectory + string2 + "LocalizableTextEJBDeployedTemp.jar";
        String string4 = this.workingDirectory + string2 + "LocalizableTextEJBDeployed-" + this.applicationName + ".jar";
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Starting addXMIFiles method");
        }
        System.out.println(this.toolMsg + this.msg.getString("LTED_06I"));
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(string4));
            jarFile = new JarFile(string3);
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message: Jar file to use: " + string3);
                System.out.println("LocalizableTextEJBDeploy Debug Message: Jar file to write to: " + string4);
            }
            System.out.println(this.toolMsg + this.msg.getString("LTED_07I") + " " + string4);
            jarEntry = new JarEntry("META-INF/ibm-ejb-jar-bnd.xmi");
            fileInputStream = new FileInputStream(new File(this.workingDirectory + string2 + "META-INF" + string2 + "ibm-ejb-jar-bnd.xmi"));
            jarOutputStream.putNextEntry(jarEntry);
            while ((n = fileInputStream.read(byArray)) >= 0) {
                jarOutputStream.write(byArray, 0, n);
            }
            if (this.debug) {
                string = jarEntry.getName();
                System.out.println("LocalizableTextEJBDeploy Debug Message. Jar entry added: " + string);
            }
            jarEntry = new JarEntry("META-INF/ibm-ejb-jar-ext.xmi");
            fileInputStream = new FileInputStream(new File(this.workingDirectory + string2 + "META-INF" + string2 + "ibm-ejb-jar-ext.xmi"));
            jarOutputStream.putNextEntry(jarEntry);
            while ((n = fileInputStream.read(byArray)) >= 0) {
                jarOutputStream.write(byArray, 0, n);
            }
            if (this.debug) {
                string = jarEntry.getName();
                System.out.println("LocalizableTextEJBDeploy Debug Message. Jar entry added: " + string);
            }
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message. Starting to copy files from temp jar to final jar.");
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                string = jarEntry.getName();
                if (string.trim().indexOf(".xmi") == -1) {
                    if (this.debug) {
                        System.out.println("LocalizableTextEJBDeploy Debug Message. Jar entry added: " + string);
                    }
                    inputStream = jarFile.getInputStream(jarEntry);
                    jarOutputStream.putNextEntry(jarEntry);
                    while ((n = inputStream.read(byArray)) >= 0) {
                        jarOutputStream.write(byArray, 0, n);
                    }
                    continue;
                }
                if (!this.debug) continue;
                System.out.println("LocalizableTextEJBDeploy Debug Message. Jar entry skipped: " + string);
            }
            try {
                jarFile.close();
                jarOutputStream.closeEntry();
                inputStream.close();
                jarOutputStream.flush();
                jarOutputStream.close();
            }
            catch (NullPointerException nullPointerException) {
                FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.addXMIFiles", (String)"435", (Object)this);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.addXMIFiles", (String)"438", (Object)this);
            System.out.println(this.toolErr + iOException.getMessage());
            System.out.println(this.stdExiting);
            iOException.printStackTrace();
            return false;
        }
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Ending addXMIFiles method");
        }
        return true;
    }

    private boolean cleanUp() {
        File file = null;
        String string = File.separator;
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Starting cleanUp method");
        }
        file = new File(this.workingDirectory + string + "META-INF" + string + "ejb-jar.xml");
        file.delete();
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message: Removing file: " + file.getPath());
        }
        file = new File(this.workingDirectory + string + "META-INF" + string + "ibm-ejb-jar-bnd.xmi");
        file.delete();
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message: Removing file: " + file.getPath());
        }
        file = new File(this.workingDirectory + string + "META-INF" + string + "ibm-ejb-jar-ext.xmi");
        file.delete();
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message: Removing file: " + file.getPath());
        }
        file = new File(this.workingDirectory + string + "META-INF");
        file.delete();
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message: Removing file: " + file.getPath());
        }
        file = new File(this.workingDirectory + string + "LocalizableText.jar");
        file.delete();
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message: Removing file: " + file.getPath());
        }
        file = new File(this.workingDirectory + string + "LocalizableTextEJBDeployedTemp.jar");
        file.delete();
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message: Removing file: " + file.getPath());
        }
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Ending cleanUp method");
        }
        return true;
    }

    private boolean createLTEJBjar() {
        JarFile jarFile = null;
        JarEntry jarEntry = null;
        Manifest manifest = new Manifest();
        String string = null;
        InputStream inputStream = null;
        JarOutputStream jarOutputStream = null;
        byte[] byArray = new byte[4096];
        int n = 0;
        String string2 = File.separator;
        String string3 = this.installRoot + string2 + "lib" + string2 + "ltext.jar";
        String string4 = this.workingDirectory + string2 + "LocalizableText.jar";
        String string5 = "LocalizableTextResourceAccessor";
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Starting createLTEJBjar method");
        }
        System.out.println(this.toolMsg + this.msg.getString("LTED_04I"));
        File file = new File(string3);
        if (!file.exists()) {
            System.out.println(this.toolErr + this.msg.getString("LTED_05E"));
            return false;
        }
        file = new File(string4);
        if (file.exists()) {
            System.out.println(this.toolErr + " " + this.msg.getString("LTED_08I"));
            if (!file.delete()) {
                System.out.println(this.toolErr + this.msg.getString("LTED_07E") + " " + string4);
                System.out.println(this.stdExiting);
                return false;
            }
        }
        try {
            jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(string4), manifest);
            jarFile = new JarFile(string3);
            string5 = string5.trim();
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message: Jar file to use: " + string3);
                System.out.println("LocalizableTextEJBDeploy Debug Message: Jar file to write to: " + string4);
                System.out.println("LocalizableTextEJBDeploy Debug Message: String to match for new jar file entries: " + string5);
            }
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message: Adding META-INF/ejb-jar.xml to jar.");
            }
            JarEntry jarEntry2 = new JarEntry("META-INF/ejb-jar.xml");
            FileInputStream fileInputStream = new FileInputStream(new File(this.workingDirectory + string2 + "META-INF" + string2 + "ejb-jar.xml"));
            jarOutputStream.putNextEntry(jarEntry2);
            while ((n = fileInputStream.read(byArray)) >= 0) {
                jarOutputStream.write(byArray, 0, n);
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                string = jarEntry.getName();
                if (string.indexOf(string5) != -1) {
                    if (string.indexOf("Finder") != -1 || string.indexOf("_") != -1) continue;
                    if (this.debug) {
                        System.out.println("LocalizableTextEJBDeploy Debug Message. Jar entry added: " + string);
                    }
                    inputStream = jarFile.getInputStream(jarEntry);
                    jarOutputStream.putNextEntry(jarEntry);
                    while ((n = inputStream.read(byArray)) >= 0) {
                        jarOutputStream.write(byArray, 0, n);
                    }
                    continue;
                }
                if (!this.debug) continue;
                System.out.println("LocalizableTextEJBDeploy Debug Message. Jar entry skipped: " + string);
            }
            try {
                jarFile.close();
                fileInputStream.close();
                jarOutputStream.closeEntry();
                inputStream.close();
                jarOutputStream.flush();
                jarOutputStream.close();
            }
            catch (NullPointerException nullPointerException) {
                FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.createLTEJBjar", (String)"577", (Object)this);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.createLTEJBjar", (String)"580", (Object)this);
            System.out.println(this.toolErr + iOException.getMessage());
            System.out.println(this.stdExiting);
            iOException.printStackTrace();
            return false;
        }
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Ending createLTEJBjar method");
        }
        return true;
    }

    private boolean extractXMFiles() {
        JarFile jarFile = null;
        JarEntry jarEntry = null;
        String string = null;
        String string2 = File.separator;
        String string3 = this.installRoot + string2 + "lib" + string2 + "ltext.jar";
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = null;
        int n = 0;
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Starting extractXMFiles method");
        }
        System.out.println(this.toolMsg + this.msg.getString("LTED_01I") + " " + string3);
        try {
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message. Creating '" + this.workingDirectory + string2 + "META-INF' directory.");
            }
            file = new File(this.workingDirectory + string2 + "META-INF");
            file.mkdir();
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message. Extracting files from ltext.jar.");
            }
            if (!(file = new File(string3)).exists()) {
                System.out.println(this.toolErr + this.msg.getString("LTED_08E"));
                System.out.println(this.stdExiting);
                return false;
            }
            jarFile = new JarFile(string3);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n2;
                jarEntry = enumeration.nextElement();
                string = jarEntry.getName();
                if (this.debug) {
                    System.out.println("LocalizableTextEJBDeploy Debug Message: entryName: " + string);
                }
                if (string.indexOf("ibm-ejb-jar-bnd.xmi") != -1) {
                    inputStream = jarFile.getInputStream(jarEntry);
                    fileOutputStream = new FileOutputStream(this.workingDirectory + string2 + "META-INF" + string2 + "ibm-ejb-jar-bnd.xmi");
                    n2 = inputStream.read();
                    while (n2 != -1) {
                        fileOutputStream.write(n2);
                        n2 = inputStream.read();
                    }
                    fileOutputStream.close();
                    inputStream.close();
                    ++n;
                    continue;
                }
                if (string.indexOf("ibm-ejb-jar-ext.xmi") != -1) {
                    inputStream = jarFile.getInputStream(jarEntry);
                    fileOutputStream = new FileOutputStream(this.workingDirectory + string2 + "META-INF" + string2 + "ibm-ejb-jar-ext.xmi");
                    n2 = inputStream.read();
                    while (n2 != -1) {
                        fileOutputStream.write(n2);
                        n2 = inputStream.read();
                    }
                    fileOutputStream.close();
                    inputStream.close();
                    ++n;
                    continue;
                }
                if (string.indexOf("ejb-jar.xml") == -1) continue;
                inputStream = jarFile.getInputStream(jarEntry);
                fileOutputStream = new FileOutputStream(this.workingDirectory + string2 + "META-INF" + string2 + "ejb-jar.xml");
                n2 = inputStream.read();
                while (n2 != -1) {
                    fileOutputStream.write(n2);
                    n2 = inputStream.read();
                }
                fileOutputStream.close();
                inputStream.close();
                ++n;
            }
            jarFile.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.extractXMFiles", (String)"663", (Object)this);
            System.out.println(this.toolErr + iOException.getMessage());
            System.out.println(this.stdExiting);
            iOException.printStackTrace();
            return false;
        }
        if (n != 3) {
            System.out.println(this.toolErr + this.msg.getString("LTED_09E"));
            System.out.println(this.stdExiting);
            return false;
        }
        if (this.debug) {
            System.out.println(this.toolMsg + "Ending extractXMFiles method");
        }
        return true;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public static void main(String[] stringArray) {
        LocalizableTextEJBDeploy localizableTextEJBDeploy = new LocalizableTextEJBDeploy();
        localizableTextEJBDeploy.processArguments(stringArray);
        if (localizableTextEJBDeploy.isRequiredArgsSet()) {
            localizableTextEJBDeploy.run();
        } else {
            localizableTextEJBDeploy.usage();
        }
    }

    private boolean parseXMIFile() {
        File file = null;
        FileWriter fileWriter = null;
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        String string3 = File.separator;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Starting parseXMIFile method");
        }
        System.out.println(this.toolMsg + this.msg.getString("LTED_03I"));
        try {
            bufferedReader = new BufferedReader(new FileReader(this.workingDirectory + string3 + "META-INF" + string3 + "ibm-ejb-jar-bnd.xmi"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.parseXMIFile", (String)"722", (Object)this);
            System.out.println(this.toolErr + fileNotFoundException.getMessage());
            System.out.println(this.stdExiting);
            fileNotFoundException.printStackTrace();
            return false;
        }
        try {
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.indexOf("jndiName=") != -1) {
                    string4 = string4.substring(0, string4.indexOf("jndiName=") + 10) + "com/ibm/websphere/i18n/localizabletext/homes/" + this.applicationName + "/" + this.hostName + "__" + this.serverName + "__" + "LocalizableTextEJBHome\">";
                }
                stringBuffer.append(string4 + "\n");
            }
            string2 = stringBuffer.toString();
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message: XMI to write out:");
                System.out.println(string2);
            }
            file = new File(this.workingDirectory + string3 + "META-INF" + string3 + "ibm-ejb-jar-bnd.xmi");
            file.delete();
            string = this.workingDirectory + string3 + "META-INF" + string3 + "ibm-ejb-jar-bnd.xmi";
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message. Writing: " + string);
            }
            fileWriter = new FileWriter(string);
            fileWriter.write(string2, 0, string2.length());
            fileWriter.flush();
            fileWriter.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.parseXMIFile", (String)"758", (Object)this);
            System.out.println(this.toolErr + iOException.getMessage());
            System.out.println(this.stdExiting);
            iOException.printStackTrace();
            return false;
        }
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Ending parseXMIFile method");
        }
        return true;
    }

    private boolean parseXMLFile() {
        File file = null;
        FileWriter fileWriter = null;
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        String string3 = File.separator;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Starting parseXMLFile method");
        }
        System.out.println(this.toolMsg + this.msg.getString("LTED_02I"));
        try {
            bufferedReader = new BufferedReader(new FileReader(this.workingDirectory + string3 + "META-INF" + string3 + "ejb-jar.xml"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.parseXMLFile", (String)"789", (Object)this);
            System.out.println(this.toolErr + fileNotFoundException.getMessage());
            System.out.println(this.stdExiting);
            fileNotFoundException.printStackTrace();
            return false;
        }
        try {
            while ((string4 = bufferedReader.readLine()) != null) {
                if (string4.indexOf("<ejb-name>") != -1) {
                    string4 = string4.substring(0, string4.indexOf("<ejb-name>")) + "<ejb-name>LocalizableTextEJB-" + this.applicationName + "</ejb-name>";
                }
                stringBuffer.append(string4 + "\n");
            }
            string2 = stringBuffer.toString();
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message: XML to write out:");
                System.out.println(string2);
            }
            file = new File(this.workingDirectory + string3 + "META-INF" + string3 + "ejb-jar.xml");
            file.delete();
            string = this.workingDirectory + string3 + "META-INF" + string3 + "ejb-jar.xml";
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message. Writing: " + string);
            }
            fileWriter = new FileWriter(string);
            fileWriter.write(string2, 0, string2.length());
            fileWriter.flush();
            fileWriter.close();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.parseXMLFile", (String)"825", (Object)this);
            System.out.println(this.toolErr + iOException.getMessage());
            System.out.println(this.stdExiting);
            iOException.printStackTrace();
            return false;
        }
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Ending parseXMLFile method");
        }
        return true;
    }

    private boolean runEJBDeployTool() {
        String string = File.separator;
        String string2 = "";
        String string3 = "ejbdeploy.sh ";
        Process process = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        boolean bl = false;
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = null;
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Starting runEJBDeployTool method");
        }
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. os.name: " + System.getProperty("os.name").toLowerCase());
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            string2 = "cmd /c ";
            string3 = "ejbdeploy ";
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message. OS is Windows");
            }
        } else if (System.getProperty("os.name").toLowerCase().indexOf("400") != -1) {
            string3 = "ejbdeploy ";
            bl = true;
            if (this.debug) {
                System.out.println("LocalizableTextEJBDeploy Debug Message. OS is iSeries");
            }
        }
        string2 = string2 + this.installRoot + string + "bin" + string + string3 + this.workingDirectory + string + "LocalizableText.jar " + this.workingDirectory + " " + this.workingDirectory + string + "LocalizableTextEJBDeployedTemp.jar -nowarn -quiet -cp " + this.installRoot + string + "lib" + string + "ltext.jar";
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            System.out.println(this.toolMsg + this.msg.getString("LTED_05I") + " " + string2);
            process = Runtime.getRuntime().exec(string2);
            inputStream = process.getInputStream();
            inputStream2 = process.getErrorStream();
            if (bl) {
                inputStreamReader = new InputStreamReader(inputStream, "cp037");
                inputStreamReader2 = new InputStreamReader(inputStream2, "cp037");
            } else {
                inputStreamReader = new InputStreamReader(inputStream);
                inputStreamReader2 = new InputStreamReader(inputStream2);
            }
            while ((n = inputStreamReader.read()) != -1) {
                stringBuffer.append((char)n);
            }
            if (stringBuffer.length() != 0) {
                System.out.print(this.toolMsg + stringBuffer);
                if (this.debug) {
                    System.out.println("LocalizableTextEJBDeploy Debug Message. InputStream encoding: " + inputStreamReader.getEncoding());
                }
            }
            stringBuffer = new StringBuffer();
            while ((n = inputStreamReader2.read()) != -1) {
                stringBuffer.append((char)n);
            }
            if (stringBuffer.length() != 0) {
                System.out.print(this.toolMsg + stringBuffer);
                if (this.debug) {
                    System.out.println("LocalizableTextEJBDeploy Debug Message. ErrorStream encoding: " + inputStreamReader2.getEncoding());
                }
                if (!bl) {
                    return false;
                }
            }
            process.waitFor();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.i18n.localizabletext.LocalizableTextEJBDeploy.runEJBDeployTool", (String)"914", (Object)this);
            System.out.println(this.toolErr + exception.getMessage());
            System.out.println(this.stdExiting);
            exception.printStackTrace();
            return false;
        }
        if (this.debug) {
            System.out.println("LocalizableTextEJBDeploy Debug Message. Ending runEJBDeployTool method");
        }
        return true;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }
}

