/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class BaseFunction
extends IdScriptable
implements Function {
    private static final int Id_length = 1;
    private static final int Id_arity = 2;
    private static final int Id_name = 3;
    private static final int Id_prototype = 4;
    private static final int Id_arguments = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_constructor = 6;
    private static final int Id_toString = 7;
    private static final int Id_apply = 8;
    private static final int Id_call = 9;
    private static final int MAX_PROTOTYPE_ID = 9;
    protected String functionName;
    private Object prototypeProperty;
    private int prototypePropertyAttrs = 2;
    private boolean prototypeFlag;

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        return Undefined.instance;
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        NativeObject nativeObject = new NativeObject();
        nativeObject.setPrototype(this.getClassPrototype());
        nativeObject.setParentScope(this.getParentScope());
        Object object = this.call(context, scriptable, nativeObject, objectArray);
        if (object instanceof Scriptable && object != Undefined.instance) {
            return (Scriptable)object;
        }
        return nativeObject;
    }

    public String decompile(Context context, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() {\n\t");
        }
        stringBuffer.append("[native code, arity=");
        stringBuffer.append(this.getArity());
        stringBuffer.append("]\n");
        if (!bl) {
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }

    protected void deleteIdValue(int n) {
        if (n == 4) {
            this.prototypeProperty = Scriptable.NOT_FOUND;
            return;
        }
        super.deleteIdValue(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return BaseFunction.jsConstructor(context, scriptable, objectArray);
                }
                case 7: {
                    return BaseFunction.jsFunction_toString(context, scriptable2, objectArray);
                }
                case 8: {
                    return BaseFunction.jsFunction_apply(context, scriptable, scriptable2, objectArray);
                }
                case 9: {
                    return BaseFunction.jsFunction_call(context, scriptable, scriptable2, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    protected void fillConstructorProperties(Context context, IdFunction idFunction, boolean bl) {
        idFunction.setPrototype(this);
    }

    NativeCall getActivation(Context context) {
        NativeCall nativeCall = context.currentActivation;
        while (nativeCall != null) {
            if (nativeCall.getFunctionObject() == this) {
                return nativeCall;
            }
            nativeCall = nativeCall.caller;
        }
        return null;
    }

    private Object getArguments() {
        NativeCall nativeCall = this.getActivation(Context.getContext());
        return nativeCall == null ? null : nativeCall.get("arguments", (Scriptable)nativeCall);
    }

    public int getArity() {
        return 0;
    }

    public String getClassName() {
        return "Function";
    }

    protected Scriptable getClassPrototype() {
        Object object = this.getPrototypeProperty();
        if (object == null || !(object instanceof Scriptable) || object == Undefined.instance) {
            object = ScriptableObject.getClassPrototype(this, "Object");
        }
        return (Scriptable)object;
    }

    public String getFunctionName() {
        Context context;
        if (this.functionName == null) {
            return "";
        }
        if (this.functionName.equals("anonymous") && (context = Context.getCurrentContext()) != null && context.getLanguageVersion() == 120) {
            return "";
        }
        return this.functionName;
    }

    protected int getIdDefaultAttributes(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return 7;
            }
            case 4: {
                return this.prototypePropertyAttrs;
            }
            case 5: {
                return 0;
            }
        }
        return super.getIdDefaultAttributes(n);
    }

    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "length";
            }
            case 2: {
                return "arity";
            }
            case 3: {
                return "name";
            }
            case 4: {
                return "prototype";
            }
            case 5: {
                return "arguments";
            }
        }
        if (this.prototypeFlag) {
            switch (n) {
                case 6: {
                    return "constructor";
                }
                case 7: {
                    return "toString";
                }
                case 8: {
                    return "apply";
                }
                case 9: {
                    return "call";
                }
            }
        }
        return null;
    }

    protected Object getIdValue(int n) {
        switch (n) {
            case 1: {
                return this.wrap_int(this.getLength());
            }
            case 2: {
                return this.wrap_int(this.getArity());
            }
            case 3: {
                return this.getFunctionName();
            }
            case 4: {
                return this.getPrototypeProperty();
            }
            case 5: {
                return this.getArguments();
            }
        }
        return super.getIdValue(n);
    }

    public int getLength() {
        return 0;
    }

    private Object getPrototypeProperty() {
        Object object = this.prototypeProperty;
        if (object == null) {
            BaseFunction baseFunction = this;
            synchronized (baseFunction) {
                object = this.prototypeProperty;
                if (object == null) {
                    this.setupDefaultPrototype();
                    object = this.prototypeProperty;
                }
            }
        } else if (object == IdScriptable.NULL_TAG) {
            object = null;
        }
        return object;
    }

    protected boolean hasIdValue(int n) {
        if (n == 4) {
            return this.prototypeProperty != Scriptable.NOT_FOUND;
        }
        if (n == 5) {
            return this.getActivation(Context.getContext()) != null;
        }
        return super.hasIdValue(n);
    }

    public boolean hasInstance(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty((Scriptable)this, "prototype");
        if (object instanceof Scriptable && object != Undefined.instance) {
            return ScriptRuntime.jsDelegatesTo(scriptable, (Scriptable)object);
        }
        throw NativeGlobal.typeError1("msg.instanceof.bad.prototype", this.functionName, scriptable);
    }

    static void init(Context context, Scriptable scriptable, boolean bl) {
        BaseFunction baseFunction = new BaseFunction();
        baseFunction.prototypeFlag = true;
        baseFunction.functionName = "";
        baseFunction.prototypePropertyAttrs = 7;
        baseFunction.addAsPrototype(9, context, scriptable, bl);
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        NativeFunction nativeFunction;
        int n = objectArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n - 1) {
            if (n2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(ScriptRuntime.toString(objectArray[n2]));
            ++n2;
        }
        String string = n == 0 ? "" : ScriptRuntime.toString(objectArray[n2]);
        String string2 = "function (" + stringBuffer.toString() + ") {" + string + "}";
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        if (string3 == null) {
            string3 = "<eval'ed string>";
            nArray[0] = 1;
        }
        Object object = context.getSecurityDomainForStackDepth(4);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        int n3 = context.getOptimizationLevel();
        context.setOptimizationLevel(-1);
        try {
            nativeFunction = (NativeFunction)context.compileFunction(scriptable2, string2, string3, nArray[0], object);
        }
        finally {
            Object var15_14 = null;
            context.setOptimizationLevel(n3);
        }
        nativeFunction.functionName = "anonymous";
        nativeFunction.setPrototype(ScriptableObject.getFunctionPrototype(scriptable2));
        nativeFunction.setParentScope(scriptable2);
        return nativeFunction;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object jsFunction_apply(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object[] objectArray2;
        Scriptable scriptable3;
        if (objectArray.length != 2) {
            return BaseFunction.jsFunction_call(context, scriptable, scriptable2, objectArray);
        }
        Object object = scriptable2.getDefaultValue(ScriptRuntime.FunctionClass);
        Scriptable scriptable4 = scriptable3 = objectArray[0] == null ? ScriptableObject.getTopLevelScope(scriptable2) : ScriptRuntime.toObject(scriptable, objectArray[0]);
        if (objectArray.length > 1) {
            if (!(objectArray[1] instanceof NativeArray) && !(objectArray[1] instanceof Arguments)) throw NativeGlobal.typeError0("msg.arg.isnt.array", scriptable2);
            objectArray2 = context.getElements((Scriptable)objectArray[1]);
            return ScriptRuntime.call(context, object, scriptable3, objectArray2, scriptable3);
        } else {
            objectArray2 = ScriptRuntime.emptyArgs;
        }
        return ScriptRuntime.call(context, object, scriptable3, objectArray2, scriptable3);
    }

    private static Object jsFunction_call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object = scriptable2.getDefaultValue(ScriptRuntime.FunctionClass);
        if (objectArray.length == 0) {
            Scriptable scriptable3 = ScriptRuntime.toObject(scriptable, object);
            Scriptable scriptable4 = scriptable3.getParentScope();
            return ScriptRuntime.call(context, object, scriptable4, ScriptRuntime.emptyArgs, scriptable4);
        }
        Scriptable scriptable5 = objectArray[0] == null ? ScriptableObject.getTopLevelScope(scriptable2) : ScriptRuntime.toObject(scriptable, objectArray[0]);
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return ScriptRuntime.call(context, object, scriptable5, objectArray2, scriptable5);
    }

    private static Object jsFunction_toString(Context context, Scriptable scriptable, Object[] objectArray) {
        int n = ScriptRuntime.toInt32(objectArray, 0);
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (object instanceof BaseFunction) {
            return ((BaseFunction)object).decompile(context, n, false);
        }
        throw NativeGlobal.typeError1("msg.incompat.call", "toString", scriptable);
    }

    protected int mapNameToId(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "name";
                n = 3;
                break;
            }
            case 5: {
                string2 = "arity";
                n = 2;
                break;
            }
            case 6: {
                string2 = "length";
                n = 1;
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'a') {
                    string2 = "arguments";
                    n = 5;
                    break;
                }
                if (c != 'p') break;
                string2 = "prototype";
                n = 4;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n != 0 || !this.prototypeFlag) {
            return n;
        }
        n = 0;
        string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "call";
                n = 9;
                break;
            }
            case 5: {
                string2 = "apply";
                n = 8;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 7;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 6;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    protected int maxInstanceId() {
        return 5;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    protected void setIdValue(int n, Object object) {
        if (n == 4) {
            this.prototypeProperty = object != null ? object : IdScriptable.NULL_TAG;
            return;
        }
        super.setIdValue(n, object);
    }

    public void setImmunePrototypeProperty(Object object) {
        this.prototypeProperty = object != null ? object : IdScriptable.NULL_TAG;
        this.prototypePropertyAttrs = 7;
    }

    private void setupDefaultPrototype() {
        NativeObject nativeObject = new NativeObject();
        int n = 7;
        nativeObject.defineProperty("constructor", this, 7);
        this.prototypeProperty = nativeObject;
        Scriptable scriptable = ScriptableObject.getObjectPrototype(this);
        if (scriptable != nativeObject) {
            nativeObject.setPrototype(scriptable);
        }
    }
}

