/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Invoker;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class FunctionObject
extends NativeFunction {
    private static final String INVOKER_MASTER_CLASS = "org.mozilla.javascript.optimizer.InvokerImpl";
    static Invoker invokerMaster = FunctionObject.newInvokerMaster();
    private static final short VARARGS_METHOD = -1;
    private static final short VARARGS_CTOR = -2;
    private static boolean sawSecurityException;
    static Method[] methodsCache;
    Method method;
    Constructor ctor;
    private Class[] types;
    Invoker invoker;
    private short parmsLength;
    private short lengthPropertyValue;
    private boolean hasVoidReturn;
    private boolean isStatic;
    private boolean useDynamicScope;
    static /* synthetic */ Class class$org$mozilla$javascript$Context;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;

    public FunctionObject(String string, Member member, Scriptable scriptable) {
        short s;
        String string2;
        if (member instanceof Constructor) {
            this.ctor = (Constructor)member;
            this.isStatic = true;
            this.types = this.ctor.getParameterTypes();
            string2 = this.ctor.getName();
        } else {
            this.method = (Method)member;
            this.isStatic = Modifier.isStatic(this.method.getModifiers());
            this.types = this.method.getParameterTypes();
            string2 = this.method.getName();
        }
        this.functionName = string;
        if (this.types.length == 4 && (this.types[1].isArray() || this.types[2].isArray())) {
            if (this.types[1].isArray()) {
                if (!this.isStatic || this.types[0] != (class$org$mozilla$javascript$Context != null ? class$org$mozilla$javascript$Context : (class$org$mozilla$javascript$Context = FunctionObject.class$("org.mozilla.javascript.Context"))) || this.types[1].getComponentType() != ScriptRuntime.ObjectClass || this.types[2] != ScriptRuntime.FunctionClass || this.types[3] != Boolean.TYPE) {
                    throw Context.reportRuntimeError1("msg.varargs.ctor", string2);
                }
                this.parmsLength = (short)-2;
            } else {
                if (!this.isStatic || this.types[0] != (class$org$mozilla$javascript$Context != null ? class$org$mozilla$javascript$Context : (class$org$mozilla$javascript$Context = FunctionObject.class$("org.mozilla.javascript.Context"))) || this.types[1] != ScriptRuntime.ScriptableClass || this.types[2].getComponentType() != ScriptRuntime.ObjectClass || this.types[3] != ScriptRuntime.FunctionClass) {
                    throw Context.reportRuntimeError1("msg.varargs.fun", string2);
                }
                this.parmsLength = (short)-1;
            }
            s = 1;
        } else {
            this.parmsLength = (short)this.types.length;
            int n = 0;
            while (n < this.parmsLength) {
                Class clazz = this.types[n];
                if (clazz != ScriptRuntime.ObjectClass && clazz != ScriptRuntime.StringClass && clazz != ScriptRuntime.BooleanClass && !ScriptRuntime.NumberClass.isAssignableFrom(clazz) && !(class$org$mozilla$javascript$Scriptable != null ? class$org$mozilla$javascript$Scriptable : FunctionObject.class$("org.mozilla.javascript.Scriptable")).isAssignableFrom(clazz) && clazz != Boolean.TYPE && clazz != Byte.TYPE && clazz != Short.TYPE && clazz != Integer.TYPE && clazz != Float.TYPE && clazz != Double.TYPE) {
                    throw Context.reportRuntimeError1("msg.bad.parms", string2);
                }
                ++n;
            }
            s = this.parmsLength;
        }
        this.lengthPropertyValue = s;
        this.hasVoidReturn = this.method != null && this.method.getReturnType() == Void.TYPE;
        this.argCount = s;
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        Context context = Context.getCurrentContext();
        this.useDynamicScope = context != null && context.hasCompileFunctionsWithDynamicScope();
    }

    public void addAsConstructor(Scriptable scriptable, Scriptable scriptable2) {
        this.setParentScope(scriptable);
        this.setPrototype(ScriptableObject.getFunctionPrototype(scriptable));
        this.setImmunePrototypeProperty(scriptable2);
        scriptable2.setParentScope(this);
        int n = 7;
        ScriptableObject.defineProperty(scriptable2, "constructor", this, 7);
        String string = scriptable2.getClassName();
        ScriptableObject.defineProperty(scriptable, string, this, 2);
        this.setParentScope(scriptable);
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        short s;
        Object[] objectArray2;
        if (this.parmsLength < 0) {
            return this.callVarargs(context, scriptable2, objectArray, false);
        }
        if (!this.isStatic) {
            objectArray2 = this.method != null ? this.method.getDeclaringClass() : this.ctor.getDeclaringClass();
            while (!objectArray2.isInstance(scriptable2)) {
                if ((scriptable2 = scriptable2.getPrototype()) != null && this.useDynamicScope) continue;
                throw NativeGlobal.typeError1("msg.incompat.call", this.functionName, scriptable);
            }
        }
        if (this.parmsLength == objectArray.length) {
            objectArray2 = objectArray;
            s = this.types == null ? this.parmsLength : (short)0;
        } else {
            objectArray2 = new Object[this.parmsLength];
            s = 0;
        }
        while (s < this.parmsLength) {
            Object object2 = object = s < objectArray.length ? objectArray[s] : Undefined.instance;
            if (this.types != null) {
                object = FunctionObject.convertArg(this, object, this.types[s]);
            }
            objectArray2[s] = object;
            s = (short)(s + 1);
        }
        try {
            object = this.method == null ? this.ctor.newInstance(objectArray2) : this.doInvoke(scriptable2, objectArray2);
            return this.hasVoidReturn ? Undefined.instance : object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JavaScriptException.wrapException(scriptable, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
    }

    private Object callVarargs(Context context, Scriptable scriptable, Object[] objectArray, boolean bl) throws JavaScriptException {
        try {
            if (this.parmsLength == -1) {
                Object[] objectArray2 = new Object[]{context, scriptable, objectArray, this};
                Object object = this.doInvoke(null, objectArray2);
                return this.hasVoidReturn ? Undefined.instance : object;
            }
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            Object[] objectArray3 = new Object[]{context, objectArray, this, bl2};
            return this.method == null ? this.ctor.newInstance(objectArray3) : this.doInvoke(null, objectArray3);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof EvaluatorException) {
                throw (EvaluatorException)throwable;
            }
            if (throwable instanceof EcmaError) {
                throw (EcmaError)throwable;
            }
            Scriptable scriptable2 = scriptable == null ? this : scriptable;
            throw JavaScriptException.wrapException(scriptable2, throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrappedException.wrapException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw WrappedException.wrapException(instantiationException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        if (this.method == null || this.parmsLength == -2) {
            Scriptable scriptable2;
            Scriptable scriptable3 = this.method != null ? (Scriptable)this.callVarargs(context, null, objectArray, true) : (Scriptable)this.call(context, scriptable, null, objectArray);
            if (scriptable3.getPrototype() == null) {
                scriptable3.setPrototype(this.getClassPrototype());
            }
            if (scriptable3.getParentScope() == null && scriptable3 != (scriptable2 = this.getParentScope())) {
                scriptable3.setParentScope(scriptable2);
            }
            return scriptable3;
        }
        if (this.method != null && !this.isStatic) {
            Scriptable scriptable4;
            try {
                scriptable4 = (Scriptable)this.method.getDeclaringClass().newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw WrappedException.wrapException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw WrappedException.wrapException(instantiationException);
            }
            scriptable4.setPrototype(this.getClassPrototype());
            scriptable4.setParentScope(this.getParentScope());
            Object object = this.call(context, scriptable, scriptable4, objectArray);
            if (object != null && object != Undefined.instance && object instanceof Scriptable) {
                return (Scriptable)object;
            }
            return scriptable4;
        }
        return super.construct(context, scriptable, objectArray);
    }

    public static Object convertArg(Scriptable scriptable, Object object, Class clazz) {
        if (clazz == ScriptRuntime.StringClass) {
            return ScriptRuntime.toString(object);
        }
        if (clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE) {
            return new Integer(ScriptRuntime.toInt32(object));
        }
        if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
            return ScriptRuntime.toBoolean(object) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
            return new Double(ScriptRuntime.toNumber(object));
        }
        if (clazz == ScriptRuntime.ScriptableClass) {
            return ScriptRuntime.toObject(scriptable, object);
        }
        if (clazz == ScriptRuntime.ObjectClass) {
            return object;
        }
        throw Context.reportRuntimeError1("msg.cant.convert", clazz.getName());
    }

    private final Object doInvoke(Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
        Invoker invoker = invokerMaster;
        if (invoker != null) {
            if (this.invoker == null) {
                this.invoker = invoker.createInvoker(this.method, this.types);
            }
            try {
                return this.invoker.invoke(object, objectArray);
            }
            catch (RuntimeException runtimeException) {
                throw new InvocationTargetException(runtimeException);
            }
        }
        return this.method.invoke(object, objectArray);
    }

    public static Method[] findMethods(Class clazz, String string) {
        return FunctionObject.findMethods(FunctionObject.getMethodList(clazz), string);
    }

    static Method[] findMethods(Method[] methodArray, String string) {
        Vector<Method> vector = null;
        Method method = null;
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n] != null && methodArray[n].getName().equals(string)) {
                if (method == null) {
                    method = methodArray[n];
                } else {
                    if (vector == null) {
                        vector = new Vector<Method>(5);
                        vector.addElement(method);
                    }
                    vector.addElement(methodArray[n]);
                }
            }
            ++n;
        }
        if (vector == null) {
            if (method == null) {
                return null;
            }
            Method[] methodArray2 = new Method[]{method};
            return methodArray2;
        }
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int getLength() {
        return this.lengthPropertyValue;
    }

    /*
     * Unable to fully structure code
     */
    static Method[] getMethodList(Class var0) {
        var1_1 = FunctionObject.methodsCache;
        if (var1_1 != null && var1_1[0].getDeclaringClass() == var0) {
            return var1_1;
        }
        var2_2 = null;
        try {
            if (!FunctionObject.sawSecurityException) {
                var2_2 = var0.getDeclaredMethods();
            }
        }
        catch (SecurityException v0) {
            FunctionObject.sawSecurityException = true;
        }
        if (var2_2 == null) {
            var2_2 = var0.getMethods();
        }
        var3_3 = 0;
        var4_4 = 0;
        while (var4_4 < var2_2.length) {
            block12: {
                block11: {
                    if (!FunctionObject.sawSecurityException) break block11;
                    if (var2_2[var4_4].getDeclaringClass() != var0) ** GOTO lbl-1000
                    v1 = false;
                    break block12;
                }
                v1 = Modifier.isPublic(var2_2[var4_4].getModifiers()) ^ true;
            }
            if (v1) lbl-1000:
            // 2 sources

            {
                var2_2[var4_4] = null;
            } else {
                ++var3_3;
            }
            ++var4_4;
        }
        var5_5 = new Method[var3_3];
        var6_6 = 0;
        var7_7 = 0;
        while (var7_7 < var2_2.length) {
            if (var2_2[var7_7] != null) {
                var5_5[var6_6++] = var2_2[var7_7];
            }
            ++var7_7;
        }
        if (var5_5.length > 0 && Context.isCachingEnabled) {
            FunctionObject.methodsCache = var5_5;
        }
        return var5_5;
    }

    boolean isVarArgsConstructor() {
        return this.parmsLength == -2;
    }

    boolean isVarArgsMethod() {
        return this.parmsLength == -1;
    }

    private static Invoker newInvokerMaster() {
        try {
            Class clazz = ScriptRuntime.loadClassName(INVOKER_MASTER_CLASS);
            return (Invoker)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (SecurityException securityException) {}
        return null;
    }

    static void setCachingEnabled(boolean bl) {
        if (!bl) {
            methodsCache = null;
            invokerMaster = null;
        } else if (invokerMaster == null) {
            invokerMaster = FunctionObject.newInvokerMaster();
        }
    }

    public void setLength(short s) {
        this.lengthPropertyValue = s;
    }
}

