/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.StringReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdFunctionMaster;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.Undefined;

public class NativeGlobal
implements IdFunctionMaster {
    private static String uriReservedPlusPound = ";/?:@&=+$,#";
    private static String uriUnescaped = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'()";
    private static final int Id_decodeURI = 1;
    private static final int Id_decodeURIComponent = 2;
    private static final int Id_encodeURI = 3;
    private static final int Id_encodeURIComponent = 4;
    private static final int Id_escape = 5;
    private static final int Id_eval = 6;
    private static final int Id_isFinite = 7;
    private static final int Id_isNaN = 8;
    private static final int Id_parseFloat = 9;
    private static final int Id_parseInt = 10;
    private static final int Id_unescape = 11;
    private static final int LAST_SCOPE_FUNCTION_ID = 11;
    private static final int Id_new_CommonError = 12;
    private boolean scopeSlaveFlag;

    public static EcmaError constructError(Context context, String string, String string2, Object object) {
        int[] nArray = new int[1];
        String string3 = Context.getSourcePositionFromStack(nArray);
        return NativeGlobal.constructError(context, string, string2, object, string3, nArray[0], 0, null);
    }

    public static EcmaError constructError(Context context, String string, String string2, Object object, String string3, int n, int n2, String string4) {
        Scriptable scriptable;
        try {
            scriptable = (Scriptable)object;
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(classCastException.toString());
        }
        Object[] objectArray = new Object[]{string2};
        try {
            Scriptable scriptable2 = context.newObject(scriptable, string, objectArray);
            return new EcmaError((NativeError)scriptable2, string3, n, n2, string4);
        }
        catch (PropertyException propertyException) {
            throw new RuntimeException(propertyException.toString());
        }
        catch (JavaScriptException javaScriptException) {
            throw new RuntimeException(javaScriptException.toString());
        }
        catch (NotAFunctionException notAFunctionException) {
            throw new RuntimeException(notAFunctionException.toString());
        }
    }

    private static String decode(Context context, String string, String string2) {
        int n = 0;
        char[] cArray = new char[6];
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '%') {
                int n2 = n;
                if (n + 2 >= string.length()) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                if (!NativeGlobal.isHex(string.charAt(n + 1)) || !NativeGlobal.isHex(string.charAt(n + 2))) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                int n3 = NativeGlobal.unHex(string.charAt(n + 1)) * 16 + NativeGlobal.unHex(string.charAt(n + 2));
                n += 2;
                if ((n3 & 0x80) == 0) {
                    c = (char)n3;
                } else {
                    int n4 = 1;
                    while ((n3 & 128 >>> n4) != 0) {
                        ++n4;
                    }
                    if (n4 == 1 || n4 > 6) {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    cArray[0] = (char)n3;
                    if (n + 3 * (n4 - 1) >= string.length()) {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    int n5 = 1;
                    while (n5 < n4) {
                        if (string.charAt(++n) != '%') {
                            throw Context.reportRuntimeError0("msg.bad.uri");
                        }
                        if (!NativeGlobal.isHex(string.charAt(n + 1)) || !NativeGlobal.isHex(string.charAt(n + 2))) {
                            throw Context.reportRuntimeError0("msg.bad.uri");
                        }
                        n3 = NativeGlobal.unHex(string.charAt(n + 1)) * 16 + NativeGlobal.unHex(string.charAt(n + 2));
                        if ((n3 & 0xC0) != 128) {
                            throw Context.reportRuntimeError0("msg.bad.uri");
                        }
                        n += 2;
                        cArray[n5] = (char)n3;
                        ++n5;
                    }
                    int n6 = NativeGlobal.utf8ToOneUcs4Char(cArray, n4);
                    if (n6 >= 65536) {
                        if ((n6 -= 65536) > 1048575) {
                            throw Context.reportRuntimeError0("msg.bad.uri");
                        }
                        c = (char)((n6 & 0x3FF) + 56320);
                        char c2 = (char)((n6 >>> 10) + 55296);
                        stringBuffer.append(c2);
                    } else {
                        c = (char)n6;
                    }
                }
                if (string2.indexOf(c) != -1) {
                    int n7 = 0;
                    while (n7 < n - n2 + 1) {
                        stringBuffer.append(string.charAt(n2 + n7));
                        ++n7;
                    }
                } else {
                    stringBuffer.append(c);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String encode(Context context, String string, String string2) {
        int n = 0;
        char[] cArray = new char[6];
        StringBuffer stringBuffer = new StringBuffer();
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (string2.indexOf(n2) != -1) {
                stringBuffer.append((char)n2);
            } else {
                int n3;
                if (n2 >= 56320 && n2 <= 57343) {
                    throw Context.reportRuntimeError0("msg.bad.uri");
                }
                if (n2 < 55296 || n2 > 56319) {
                    n3 = n2;
                } else {
                    if (++n == string.length()) {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    char c = string.charAt(n);
                    if (c < '\udc00' || c > '\udfff') {
                        throw Context.reportRuntimeError0("msg.bad.uri");
                    }
                    n3 = (n2 - 55296 << 10) + (c - 56320) + 65536;
                }
                int n4 = NativeGlobal.oneUcs4ToUtf8Char(cArray, n3);
                int n5 = 0;
                while (n5 < n4) {
                    stringBuffer.append('%');
                    if (cArray[n5] < '\u0010') {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(Integer.toHexString(cArray[n5]));
                    ++n5;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Object evalSpecial(Context context, Scriptable scriptable, Object object, Object[] objectArray, String string, int n) throws JavaScriptException {
        if (objectArray.length < 1) {
            return Undefined.instance;
        }
        Object object2 = objectArray[0];
        if (!(object2 instanceof String)) {
            String string2 = Context.getMessage0("msg.eval.nonstring");
            Context.reportWarning(string2);
            return object2;
        }
        int[] nArray = new int[]{n};
        if (string == null && (string = Context.getSourcePositionFromStack(nArray)) == null) {
            string = "";
            nArray[0] = 1;
        }
        string = String.valueOf(string) + "(eval)";
        try {
            StringReader stringReader = new StringReader((String)object2);
            Object object3 = context.getSecurityDomainForStackDepth(3);
            int n2 = context.getOptimizationLevel();
            context.setOptimizationLevel(-1);
            Script script = context.compileReader(scriptable, stringReader, string, nArray[0], object3);
            context.setOptimizationLevel(n2);
            if (script == null) {
                String string3 = Context.getMessage0("msg.syntax");
                throw new EvaluatorException(string3);
            }
            InterpretedScript interpretedScript = (InterpretedScript)script;
            interpretedScript.itsData.itsFromEvalCode = true;
            Object object4 = interpretedScript.call(context, scriptable, (Scriptable)object, null);
            return object4;
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected io exception");
        }
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.scopeSlaveFlag) {
            switch (n) {
                case 1: {
                    return this.js_decodeURI(context, objectArray);
                }
                case 2: {
                    return this.js_decodeURIComponent(context, objectArray);
                }
                case 3: {
                    return this.js_encodeURI(context, objectArray);
                }
                case 4: {
                    return this.js_encodeURIComponent(context, objectArray);
                }
                case 5: {
                    return this.js_escape(context, objectArray);
                }
                case 6: {
                    return this.js_eval(context, scriptable, objectArray);
                }
                case 7: {
                    return this.js_isFinite(context, objectArray);
                }
                case 8: {
                    return this.js_isNaN(context, objectArray);
                }
                case 9: {
                    return this.js_parseFloat(context, objectArray);
                }
                case 10: {
                    return this.js_parseInt(context, objectArray);
                }
                case 11: {
                    return this.js_unescape(context, objectArray);
                }
                case 12: {
                    return this.new_CommonError(idFunction, context, scriptable, objectArray);
                }
            }
        }
        throw IdFunction.onBadMethodId(this, n);
    }

    private static String getMethodName(int n) {
        switch (n) {
            case 1: {
                return "decodeURI";
            }
            case 2: {
                return "decodeURIComponent";
            }
            case 3: {
                return "encodeURI";
            }
            case 4: {
                return "encodeURIComponent";
            }
            case 5: {
                return "escape";
            }
            case 6: {
                return "eval";
            }
            case 7: {
                return "isFinite";
            }
            case 8: {
                return "isNaN";
            }
            case 9: {
                return "parseFloat";
            }
            case 10: {
                return "parseInt";
            }
            case 11: {
                return "unescape";
            }
        }
        return null;
    }

    private static char hex_digit_to_char(int n) {
        return (char)(n <= 9 ? n + 48 : n + 55);
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        String[] stringArray;
        NativeGlobal nativeGlobal = new NativeGlobal();
        nativeGlobal.scopeSlaveFlag = true;
        int n = 1;
        while (n <= 11) {
            stringArray = NativeGlobal.getMethodName(n);
            IdFunction idFunction = new IdFunction(nativeGlobal, (String)stringArray, n);
            idFunction.setParentScope(scriptable);
            if (bl) {
                idFunction.sealObject();
            }
            ScriptableObject.defineProperty(scriptable, (String)stringArray, idFunction, 2);
            ++n;
        }
        ScriptableObject.defineProperty(scriptable, "NaN", ScriptRuntime.NaNobj, 2);
        ScriptableObject.defineProperty(scriptable, "Infinity", new Double(Double.POSITIVE_INFINITY), 2);
        ScriptableObject.defineProperty(scriptable, "undefined", Undefined.instance, 2);
        stringArray = new String[]{"ConversionError", "EvalError", "RangeError", "ReferenceError", "SyntaxError", "TypeError", "URIError"};
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            IdFunction idFunction = new IdFunction(nativeGlobal, string, 12);
            idFunction.setFunctionType(2);
            idFunction.setParentScope(scriptable);
            ScriptableObject.defineProperty(scriptable, string, idFunction, 2);
            Scriptable scriptable2 = ScriptRuntime.newObject(context, scriptable, "Error", ScriptRuntime.emptyArgs);
            scriptable2.put("name", scriptable2, (Object)string);
            idFunction.put("prototype", (Scriptable)idFunction, (Object)scriptable2);
            if (bl) {
                idFunction.sealObject();
                if (scriptable2 instanceof ScriptableObject) {
                    ((ScriptableObject)scriptable2).sealObject();
                }
            }
            ++n2;
        }
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private String js_decodeURI(Context context, Object[] objectArray) {
        String string = ScriptRuntime.toString(objectArray, 0);
        return NativeGlobal.decode(context, string, uriReservedPlusPound);
    }

    private String js_decodeURIComponent(Context context, Object[] objectArray) {
        String string = ScriptRuntime.toString(objectArray, 0);
        return NativeGlobal.decode(context, string, "");
    }

    private Object js_encodeURI(Context context, Object[] objectArray) {
        String string = ScriptRuntime.toString(objectArray, 0);
        return NativeGlobal.encode(context, string, String.valueOf(uriReservedPlusPound) + uriUnescaped);
    }

    private String js_encodeURIComponent(Context context, Object[] objectArray) {
        String string = ScriptRuntime.toString(objectArray, 0);
        return NativeGlobal.encode(context, string, uriUnescaped);
    }

    private Object js_escape(Context context, Object[] objectArray) {
        double d;
        boolean bl = true;
        int n = 2;
        int n2 = 4;
        String string = ScriptRuntime.toString(objectArray, 0);
        int n3 = 7;
        if (objectArray.length > 1 && ((d = ScriptRuntime.toNumber(objectArray[1])) != d || (double)(n3 = (int)d) != d || (n3 & 0xFFFFFFF8) != 0)) {
            String string2 = Context.getMessage0("msg.bad.esc.mask");
            Context.reportError(string2);
            n3 = 7;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (n3 != 0 && (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '@' || c == '*' || c == '_' || c == '-' || c == '.' || (c == '/' || c == '+') && n3 > 3)) {
                stringBuffer.append(c);
            } else if (c < '\u0100') {
                if (c == ' ' && n3 == 2) {
                    stringBuffer.append('+');
                } else {
                    stringBuffer.append('%');
                    stringBuffer.append(NativeGlobal.hex_digit_to_char(c >>> 4));
                    stringBuffer.append(NativeGlobal.hex_digit_to_char(c & 0xF));
                }
            } else {
                stringBuffer.append('%');
                stringBuffer.append('u');
                stringBuffer.append(NativeGlobal.hex_digit_to_char(c >>> 12));
                stringBuffer.append(NativeGlobal.hex_digit_to_char((c & 0xF00) >>> 8));
                stringBuffer.append(NativeGlobal.hex_digit_to_char((c & 0xF0) >>> 4));
                stringBuffer.append(NativeGlobal.hex_digit_to_char(c & 0xF));
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    private Object js_eval(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        String string = ScriptRuntime.getMessage1("msg.cant.call.indirect", "eval");
        throw NativeGlobal.constructError(context, "EvalError", string, scriptable);
    }

    private Object js_isFinite(Context context, Object[] objectArray) {
        if (objectArray.length < 1) {
            return Boolean.FALSE;
        }
        double d = ScriptRuntime.toNumber(objectArray[0]);
        return d != d || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY ? Boolean.FALSE : Boolean.TRUE;
    }

    private Object js_isNaN(Context context, Object[] objectArray) {
        if (objectArray.length < 1) {
            return Boolean.TRUE;
        }
        double d = ScriptRuntime.toNumber(objectArray[0]);
        return d != d ? Boolean.TRUE : Boolean.FALSE;
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object js_parseFloat(Context context, Object[] objectArray) {
        char c;
        if (objectArray.length < 1) {
            return ScriptRuntime.NaNobj;
        }
        String string = ScriptRuntime.toString(objectArray[0]);
        int n = string.length();
        if (n == 0) {
            return ScriptRuntime.NaNobj;
        }
        int n2 = 0;
        while (TokenStream.isJSSpace(c = string.charAt(n2)) && n2 + 1 < n) {
            ++n2;
        }
        int n3 = n2;
        if (c == '+' || c == '-') {
            c = string.charAt(++n2);
        }
        if (c == 'I') {
            if (n2 + 8 > n) return ScriptRuntime.NaNobj;
            if (!string.substring(n2, n2 + 8).equals("Infinity")) return ScriptRuntime.NaNobj;
            double d = string.charAt(n3) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            return new Double(d);
        }
        int n4 = -1;
        int n5 = -1;
        block9: while (n2 < n) {
            char c2 = '\u0000';
            block10: do {
                switch (c2 == '\u0000' ? string.charAt(n2) : c2) {
                    case '.': {
                        if (n4 != -1) break block9;
                        n4 = n2;
                        c2 = '0';
                        continue block10;
                    }
                    case 'E': 
                    case 'e': {
                        if (n5 != -1) break block9;
                        n5 = n2;
                        c2 = '0';
                        continue block10;
                    }
                    case '+': 
                    case '-': {
                        if (n5 != n2 - 1) break block9;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ++n2;
                        continue block9;
                    }
                }
                break block9;
            } while (true);
        }
        string = string.substring(n3, n2);
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return ScriptRuntime.NaNobj;
        }
    }

    private Object js_parseInt(Context context, Object[] objectArray) {
        char c;
        String string = ScriptRuntime.toString(objectArray, 0);
        int n = ScriptRuntime.toInt32(objectArray, 1);
        int n2 = string.length();
        if (n2 == 0) {
            return ScriptRuntime.NaNobj;
        }
        boolean bl = false;
        int n3 = 0;
        while (Character.isWhitespace(c = string.charAt(n3)) && ++n3 < n2) {
        }
        if (c == '+' || (bl = c == '-')) {
            ++n3;
        }
        int n4 = -1;
        if (n == 0) {
            n = -1;
        } else {
            if (n < 2 || n > 36) {
                return ScriptRuntime.NaNobj;
            }
            if (n == 16 && n2 - n3 > 1 && string.charAt(n3) == '0' && ((c = string.charAt(n3 + 1)) == 'x' || c == 'X')) {
                n3 += 2;
            }
        }
        if (n == -1) {
            n = 10;
            if (n2 - n3 > 1 && string.charAt(n3) == '0') {
                c = string.charAt(n3 + 1);
                if (c == 'x' || c == 'X') {
                    n = 16;
                    n3 += 2;
                } else if (c != '.') {
                    n = 8;
                    ++n3;
                }
            }
        }
        double d = ScriptRuntime.stringToNumber(string, n3, n);
        return new Double(bl ? -d : d);
    }

    private Object js_unescape(Context context, Object[] objectArray) {
        String string = ScriptRuntime.toString(objectArray, 0);
        int n = string.indexOf(37);
        if (n >= 0) {
            int n2 = string.length();
            char[] cArray = string.toCharArray();
            int n3 = n;
            int n4 = n;
            while (n4 != n2) {
                char c = cArray[n4];
                if (c == '%' && ++n4 != n2) {
                    int n5;
                    int n6;
                    if (cArray[n4] == 'u') {
                        n6 = n4 + 1;
                        n5 = n4 + 5;
                    } else {
                        n6 = n4;
                        n5 = n4 + 2;
                    }
                    if (n5 <= n2) {
                        int n7 = 0;
                        int n8 = n6;
                        while (n8 != n5) {
                            n7 = n7 << 4 | TokenStream.xDigitToInt(cArray[n8]);
                            ++n8;
                        }
                        if (n7 >= 0) {
                            c = (char)n7;
                            n4 = n5;
                        }
                    }
                }
                cArray[n3] = c;
                ++n3;
            }
            string = new String(cArray, 0, n3);
        }
        return string;
    }

    public int methodArity(int n) {
        if (this.scopeSlaveFlag) {
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 2;
                }
                case 11: {
                    return 1;
                }
                case 12: {
                    return 1;
                }
            }
        }
        return -1;
    }

    private Object new_CommonError(IdFunction idFunction, Context context, Scriptable scriptable, Object[] objectArray) {
        NativeError nativeError = new NativeError();
        nativeError.setPrototype((Scriptable)idFunction.get("prototype", (Scriptable)idFunction));
        nativeError.setParentScope(scriptable);
        if (objectArray.length > 0) {
            nativeError.put("message", (Scriptable)nativeError, objectArray[0]);
        }
        return nativeError;
    }

    private static int oneUcs4ToUtf8Char(char[] cArray, int n) {
        int n2 = 1;
        if ((n & 0xFFFFFF80) == 0) {
            cArray[0] = (char)n;
        } else {
            int n3 = n >>> 11;
            n2 = 2;
            while (n3 != 0) {
                n3 >>>= 5;
                ++n2;
            }
            int n4 = n2;
            while (--n4 > 0) {
                cArray[n4] = (char)(n & 0x3F | 0x80);
                n >>>= 6;
            }
            cArray[0] = (char)(256 - (1 << 8 - n2) + n);
        }
        return n2;
    }

    static EcmaError typeError0(String string, Object object) {
        return NativeGlobal.constructError(Context.getContext(), "TypeError", ScriptRuntime.getMessage0(string), object);
    }

    static EcmaError typeError1(String string, Object object, Object object2) {
        return NativeGlobal.constructError(Context.getContext(), "TypeError", ScriptRuntime.getMessage1(string, object), object2);
    }

    private static int unHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    private static int utf8ToOneUcs4Char(char[] cArray, int n) {
        int n2;
        int n3 = 0;
        if (n == 1) {
            n2 = cArray[0];
        } else {
            n2 = cArray[n3++] & (1 << 7 - n) - 1;
            while (--n > 0) {
                n2 = n2 << 6 | cArray[n3++] & 0x3F;
            }
        }
        return n2;
    }
}

