/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaArray
extends NativeJavaObject {
    Object array;
    int length;
    Class cls;
    Scriptable prototype;

    public NativeJavaArray(Scriptable scriptable, Object object) {
        super(scriptable, null, ScriptRuntime.ObjectClass);
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new RuntimeException("Array expected");
        }
        this.array = object;
        this.length = Array.getLength(object);
        this.cls = clazz.getComponentType();
    }

    public Object get(int n, Scriptable scriptable) {
        if (n >= 0 && n < this.length) {
            return NativeJavaObject.wrap(this, Array.get(this.array, n), this.cls);
        }
        return Undefined.instance;
    }

    public Object get(String string, Scriptable scriptable) {
        if (string.equals("length")) {
            return new Integer(this.length);
        }
        Object object = super.get(string, scriptable);
        if (object == Scriptable.NOT_FOUND && !ScriptRuntime.hasProp(this.getPrototype(), string)) {
            throw Context.reportRuntimeError2("msg.java.member.not.found", this.array.getClass().getName(), string);
        }
        return object;
    }

    public String getClassName() {
        return "JavaArray";
    }

    public Object getDefaultValue(Class clazz) {
        if (clazz == null || clazz == ScriptRuntime.StringClass) {
            return this.array.toString();
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (clazz == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    public Object[] getIds() {
        Object[] objectArray = new Object[this.length];
        int n = this.length;
        while (--n >= 0) {
            objectArray[n] = new Integer(n);
        }
        return objectArray;
    }

    public Scriptable getPrototype() {
        if (this.prototype == null) {
            this.prototype = ScriptableObject.getClassPrototype(this.getParentScope(), "Array");
        }
        return this.prototype;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n >= 0 && n < this.length;
    }

    public boolean has(String string, Scriptable scriptable) {
        return string.equals("length") || super.has(string, scriptable);
    }

    public boolean hasInstance(Scriptable scriptable) {
        if (!(scriptable instanceof Wrapper)) {
            return false;
        }
        Object object = ((Wrapper)((Object)scriptable)).unwrap();
        return this.cls.isInstance(object);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (n >= 0 && n < this.length) {
            Array.set(this.array, n, NativeJavaObject.coerceType(this.cls, object));
            return;
        }
        super.put(n, scriptable, object);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (!string.equals("length")) {
            super.put(string, scriptable, object);
        }
    }

    public Object unwrap() {
        return this.array;
    }

    public static NativeJavaArray wrap(Scriptable scriptable, Object object) {
        return new NativeJavaArray(scriptable, object);
    }
}

