/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeObject
extends IdScriptable {
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int MAX_PROTOTYPE_ID = 7;
    private boolean prototypeFlag;

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return NativeObject.jsConstructor(context, objectArray, idFunction, scriptable2 == null);
                }
                case 2: {
                    return NativeObject.jsFunction_toString(context, scriptable2);
                }
                case 3: {
                    return NativeObject.jsFunction_toLocaleString(context, scriptable2);
                }
                case 4: {
                    return NativeObject.jsFunction_valueOf(scriptable2);
                }
                case 5: {
                    return NativeObject.jsFunction_hasOwnProperty(scriptable2, objectArray);
                }
                case 6: {
                    return NativeObject.jsFunction_propertyIsEnumerable(context, scriptable2, objectArray);
                }
                case 7: {
                    return NativeObject.jsFunction_isPrototypeOf(context, scriptable2, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    public String getClassName() {
        return "Object";
    }

    protected String getIdName(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return "constructor";
                }
                case 2: {
                    return "toString";
                }
                case 3: {
                    return "toLocaleString";
                }
                case 4: {
                    return "valueOf";
                }
                case 5: {
                    return "hasOwnProperty";
                }
                case 6: {
                    return "propertyIsEnumerable";
                }
                case 7: {
                    return "isPrototypeOf";
                }
            }
        }
        return null;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeObject nativeObject = new NativeObject();
        nativeObject.prototypeFlag = true;
        nativeObject.addAsPrototype(7, context, scriptable, bl);
    }

    private static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) throws JavaScriptException {
        if (!bl) {
            return function.construct(context, function.getParentScope(), objectArray);
        }
        if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
            return new NativeObject();
        }
        return ScriptRuntime.toObject(function.getParentScope(), objectArray[0]);
    }

    private static Object jsFunction_hasOwnProperty(Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length != 0 && scriptable.has(ScriptRuntime.toString(objectArray[0]), scriptable)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Object jsFunction_isPrototypeOf(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray.length != 0 && objectArray[0] instanceof Scriptable) {
            Scriptable scriptable2 = (Scriptable)objectArray[0];
            do {
                if ((scriptable2 = scriptable2.getPrototype()) != scriptable) continue;
                return Boolean.TRUE;
            } while (scriptable2 != null);
        }
        return Boolean.FALSE;
    }

    private static Object jsFunction_propertyIsEnumerable(Context context, Scriptable scriptable, Object[] objectArray) {
        try {
            int n;
            String string;
            if (objectArray.length != 0 && scriptable.has(string = ScriptRuntime.toString(objectArray[0]), scriptable) && ((n = ((ScriptableObject)scriptable).getAttributes(string, scriptable)) & 2) == 0) {
                return Boolean.TRUE;
            }
        }
        catch (PropertyException propertyException) {
        }
        catch (ClassCastException classCastException) {}
        return Boolean.FALSE;
    }

    private static String jsFunction_toLocaleString(Context context, Scriptable scriptable) {
        return NativeObject.jsFunction_toString(context, scriptable);
    }

    private static String jsFunction_toString(Context context, Scriptable scriptable) {
        if (context.getLanguageVersion() != 120) {
            return "[object " + scriptable.getClassName() + "]";
        }
        return NativeObject.toSource(context, scriptable);
    }

    private static Object jsFunction_valueOf(Scriptable scriptable) {
        return scriptable;
    }

    protected int mapNameToId(String string) {
        if (!this.prototypeFlag) {
            return 0;
        }
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 7: {
                string2 = "valueOf";
                n = 4;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 1;
                break;
            }
            case 13: {
                string2 = "isPrototypeOf";
                n = 7;
                break;
            }
            case 14: {
                char c = string.charAt(0);
                if (c == 'h') {
                    string2 = "hasOwnProperty";
                    n = 5;
                    break;
                }
                if (c != 't') break;
                string2 = "toLocaleString";
                n = 3;
                break;
            }
            case 20: {
                string2 = "propertyIsEnumerable";
                n = 6;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 1;
                }
                case 7: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    private static String toSource(Context context, Scriptable scriptable) {
        Scriptable scriptable2 = scriptable;
        if (context.iterating == null) {
            context.iterating = new Hashtable(31);
        }
        if (context.iterating.get(scriptable2) == Boolean.TRUE) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        Object[] objectArray = scriptable2.getIds();
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            if (n > 0) {
                stringBuffer.append(", ");
            }
            Object object2 = objectArray[n];
            String string = ScriptRuntime.toString(object2);
            Object object3 = object = object2 instanceof String ? scriptable2.get((String)object2, scriptable2) : scriptable2.get(((Number)object2).intValue(), scriptable2);
            if (object instanceof String) {
                stringBuffer.append(String.valueOf(string) + ":\"" + ScriptRuntime.escapeString(ScriptRuntime.toString(object)) + "\"");
            } else {
                try {
                    context.iterating.put(scriptable2, Boolean.TRUE);
                    stringBuffer.append(String.valueOf(string) + ":" + ScriptRuntime.toString(object));
                }
                finally {
                    Object var10_9 = null;
                    context.iterating.remove(scriptable2);
                }
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public String toString() {
        Context context = Context.getCurrentContext();
        if (context != null) {
            return NativeObject.jsFunction_toString(context, this);
        }
        return "[object " + this.getClassName() + "]";
    }
}

