/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.io.File;
import java.util.Hashtable;
import org.mozilla.javascript.ClassNameHelper;
import org.mozilla.javascript.ClassOutput;

public class OptClassNameHelper
implements ClassNameHelper {
    private String generatingDirectory;
    private String packageName;
    private String initialName;
    private static int globalSerial = 1;
    private int serial = 1;
    private Class targetExtends;
    private Class[] targetImplements;
    private ClassOutput classOutput;
    private Hashtable classNames;

    public OptClassNameHelper() {
        this.setTargetClassFileName(null);
    }

    public ClassOutput getClassOutput() {
        return this.classOutput;
    }

    public String getGeneratingDirectory() {
        return this.generatingDirectory;
    }

    String getInitialClassName() {
        return this.initialName;
    }

    public synchronized String getJavaScriptClassName(String string, boolean bl) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.packageName != null && this.packageName.length() > 0) {
            stringBuffer.append(this.packageName);
            stringBuffer.append('.');
        }
        stringBuffer.append(this.initialName);
        if (this.generatingDirectory != null) {
            if (string != null) {
                stringBuffer.append('$');
                stringBuffer.append(string);
            } else if (!bl) {
                stringBuffer.append(++this.serial);
            }
        } else {
            stringBuffer.append(globalSerial++);
        }
        String string3 = stringBuffer.toString();
        String string4 = string2 = string3.toLowerCase();
        int n = 0;
        if (this.classNames == null) {
            this.classNames = new Hashtable();
        }
        while (this.classNames.get(string2) != null) {
            string2 = String.valueOf(string4) + ++n;
        }
        this.classNames.put(string2, Boolean.TRUE);
        return n == 0 ? string3 : String.valueOf(string3) + n;
    }

    public String getTargetClassFileName() {
        return this.getTargetClassFileName(this.getInitialClassName());
    }

    public String getTargetClassFileName(String string) {
        if (this.generatingDirectory == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.generatingDirectory.length() > 0) {
            stringBuffer.append(this.generatingDirectory);
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(string);
        stringBuffer.append(".class");
        return stringBuffer.toString();
    }

    public Class getTargetExtends() {
        return this.targetExtends;
    }

    public Class[] getTargetImplements() {
        return this.targetImplements;
    }

    public String getTargetPackage() {
        return this.packageName;
    }

    public void reset() {
        this.classNames = null;
    }

    public void setClassOutput(ClassOutput classOutput) {
        this.classOutput = classOutput;
    }

    void setInitialClassName(String string) {
        this.initialName = string;
        this.serial = 0;
    }

    public void setTargetClassFileName(String string) {
        String string2;
        if (string == null) {
            this.packageName = "org.mozilla.javascript.gen";
            this.initialName = "c";
            return;
        }
        int n = string.lastIndexOf(File.separatorChar);
        if (n == -1) {
            this.generatingDirectory = "";
            string2 = string;
        } else {
            this.generatingDirectory = string.substring(0, n);
            string2 = string.substring(n + 1);
        }
        if (string2.endsWith(".class")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        this.setInitialClassName(string2);
    }

    public void setTargetExtends(Class clazz) {
        this.targetExtends = clazz;
    }

    public void setTargetImplements(Class[] classArray) {
        this.targetImplements = classArray;
    }

    public void setTargetPackage(String string) {
        this.packageName = string;
    }
}

