/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.rmic.iiop;

import com.ibm.tools.rmic.iiop.AbstractType;
import com.ibm.tools.rmic.iiop.BatchEnvironment;
import com.ibm.tools.rmic.iiop.CompoundType;
import com.ibm.tools.rmic.iiop.ContextStack;
import com.ibm.tools.rmic.iiop.IDLNames;
import com.ibm.tools.rmic.iiop.ImplementationType;
import com.ibm.tools.rmic.iiop.RemoteType;
import com.ibm.tools.rmic.iiop.Type;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import sun.rmi.rmic.Generator;
import sun.rmi.rmic.Main;
import sun.rmi.rmic.Util;
import sun.tools.java.ClassDefinition;
import sun.tools.java.Identifier;

public class MangledNameTableGenerator
implements Generator {
    private static final String MNMT_FILE_EXTENSION = ".txt";
    private static final String MNMT_FILE_PREFIX = "_";
    private static final String MNMT_FILE_SUFFIX = "_mnt";
    private static final String MNMT_FILE_ARG_OPTION = "-mnt";
    protected BatchEnvironment env = null;
    protected ContextStack contextStack = null;

    public boolean parseArgs(String[] stringArray, Main main) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (stringArray[i] == null || !(string = stringArray[i].toLowerCase()).equals(MNMT_FILE_ARG_OPTION)) continue;
            bl = true;
            stringArray[i] = null;
        }
        return bl;
    }

    public void generate(sun.rmi.rmic.BatchEnvironment batchEnvironment, ClassDefinition classDefinition, File file) {
        this.env = (BatchEnvironment)batchEnvironment;
        this.env.reset();
        this.contextStack = new ContextStack(this.env);
        this.contextStack.setTrace(false);
        this.env.setParseNonConforming(false);
        CompoundType compoundType = this.getTopType(classDefinition, this.contextStack);
        if (compoundType != null) {
            this.generateOutputFiles(compoundType, this.env, file);
        }
        this.env.reset();
    }

    protected CompoundType getTopType(ClassDefinition classDefinition, ContextStack contextStack) {
        CompoundType compoundType = null;
        if (classDefinition.isInterface()) {
            compoundType = AbstractType.forAbstract(classDefinition, contextStack, true);
            if (compoundType == null) {
                compoundType = RemoteType.forRemote(classDefinition, contextStack, false);
            }
        } else {
            compoundType = ImplementationType.forImplementation(classDefinition, contextStack, false);
        }
        return compoundType;
    }

    protected File getFileFor(OutputType outputType, File file) {
        Identifier identifier = outputType.getType().getIdentifier();
        File file2 = Util.getOutputDirectoryFor(identifier, file, this.env);
        String string = outputType.getName() + MNMT_FILE_EXTENSION;
        return new File(file2, string);
    }

    protected OutputType[] getOutputTypesFor(CompoundType compoundType, HashSet hashSet) {
        int n = 4096;
        Type[] typeArray = compoundType.collectMatching(n, hashSet);
        OutputType[] outputTypeArray = new OutputType[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            String string = type.getName();
            outputTypeArray[i] = new OutputType(MNMT_FILE_PREFIX + string + MNMT_FILE_SUFFIX, type);
        }
        return outputTypeArray;
    }

    protected void generateOutputFiles(CompoundType compoundType, BatchEnvironment batchEnvironment, File file) {
        HashSet hashSet = batchEnvironment.alreadyChecked;
        OutputType[] outputTypeArray = this.getOutputTypesFor(compoundType, hashSet);
        for (int i = 0; i < outputTypeArray.length; ++i) {
            OutputType outputType = outputTypeArray[i];
            File file2 = this.getFileFor(outputType, file);
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                long l = 0L;
                if (batchEnvironment.verbose()) {
                    l = System.currentTimeMillis();
                }
                this.writeContent(outputType, bufferedWriter);
                bufferedWriter.close();
                if (!batchEnvironment.verbose()) continue;
                long l2 = System.currentTimeMillis() - l;
                batchEnvironment.output(Main.getText("rmic.generated", file2.getPath(), Long.toString(l2)));
                continue;
            }
            catch (IOException iOException) {
                batchEnvironment.error(0L, "cant.write", file2.toString());
                return;
            }
        }
    }

    protected void writeContent(OutputType outputType, BufferedWriter bufferedWriter) throws IOException {
        CompoundType compoundType = (CompoundType)outputType.getType();
        CompoundType.Method[] methodArray = compoundType.getMethods();
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            if (methodArray[i].isConstructor()) continue;
            bufferedWriter.write(IDLNames.expandEscapedSourceCharacters(methodArray[i].getName()));
            Type[] typeArray = methodArray[i].getArguments();
            for (int j = 0; j < typeArray.length; ++j) {
                if (j == 0) {
                    bufferedWriter.write(" " + typeArray[j]);
                    continue;
                }
                bufferedWriter.write("," + typeArray[j]);
            }
            if (typeArray.length == 0) {
                bufferedWriter.write(" void");
            }
            bufferedWriter.write(" " + methodArray[i].getIDLName());
            bufferedWriter.newLine();
        }
    }

    public class OutputType {
        private String name;
        private Type type;

        public OutputType(String string, Type type) {
            this.name = string;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }
}

