/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.PKCS5KeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

class PBEKey
implements SecretKey {
    static final long serialVersionUID = 6550714301310581595L;
    private byte[] key;

    public PBEKey(KeySpec keySpec) throws InvalidKeySpecException {
        int n2;
        KeySpec keySpec2;
        if (!(keySpec instanceof PBEKeySpec || keySpec instanceof PKCS5KeySpec || keySpec instanceof SecretKeySpec)) {
            throw new InvalidKeySpecException(PBEKey.a("\u0012*`\u0019{)+q\u001bb:0dI`>=!\u001a{>'h\u000fb8%u\u0000d5"));
        }
        char[] cArray = null;
        if (keySpec instanceof PBEKeySpec) {
            keySpec2 = (PBEKeySpec)keySpec;
            cArray = ((PBEKeySpec)keySpec2).getPassword();
        }
        if (keySpec instanceof PKCS5KeySpec) {
            keySpec2 = (PKCS5KeySpec)keySpec;
            cArray = ((PKCS5KeySpec)keySpec2).getPassword();
        }
        if (keySpec instanceof SecretKeySpec) {
            keySpec2 = (SecretKeySpec)keySpec;
            byte[] byArray = ((SecretKeySpec)keySpec2).getEncoded();
            String string = new String(byArray);
            cArray = string.toCharArray();
        }
        if (cArray == null) {
            throw new InvalidKeySpecException(PBEKey.a("\u001e)q\u001dr{4`\u001ax,+s\r"));
        }
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray[n2] >= ' ' && cArray[n2] <= '~') continue;
            throw new InvalidKeySpecException(PBEKey.a("\u000b%r\u001a|46eIb(do\u0006\u007f{\u0005R*B\u0012"));
        }
        this.key = new byte[cArray.length];
        for (n2 = 0; n2 < cArray.length; ++n2) {
            this.key[n2] = (byte)(cArray[n2] & 0x7F);
        }
        Arrays.fill(cArray, ' ');
    }

    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public String getAlgorithm() {
        return PBEKey.a("\u000b\u0006D");
    }

    public String getFormat() {
        return PBEKey.a("\t\u0005V");
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return n2 ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().toUpperCase().startsWith(PBEKey.a("\u000b\u0006D"))) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl2 = Arrays.equals(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.key = (byte[])this.key.clone();
    }

    protected void finalize() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 91;
                        break;
                    }
                    case 1: {
                        n5 = 68;
                        break;
                    }
                    case 2: {
                        n5 = 1;
                        break;
                    }
                    case 3: {
                        n5 = 105;
                        break;
                    }
                    default: {
                        n5 = 11;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

