/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Parameters
extends AlgorithmParametersSpi {
    private byte[] a;
    private int b;
    private int c;
    private static final byte[] d = new byte[]{-67, 86, -22, -14, -94, -15, -84, 42, -80, -109, -47, -100, 27, 51, -3, -48, 48, 4, -74, -36, 125, -33, 50, 75, -9, -53, 69, -101, 49, -69, 33, 90, 65, -97, -31, -39, 74, 77, -98, -38, -96, 104, 44, -61, 39, 95, -128, 54, 62, -18, -5, -107, 26, -2, -50, -88, 52, -87, 19, -16, -90, 63, -40, 12, 120, 36, -81, 35, 82, -63, 103, 23, -11, 102, -112, -25, -24, 7, -72, 96, 72, -26, 30, 83, -13, -110, -92, 114, -116, 8, 21, 110, -122, 0, -124, -6, -12, 127, -118, 66, 25, -10, -37, -51, 20, -115, 80, 18, -70, 60, 6, 78, -20, -77, 53, 17, -95, -120, -114, 43, -108, -103, -73, 113, 116, -45, -28, -65, 58, -34, -106, 14, -68, 10, -19, 119, -4, 55, 107, 3, 121, -119, 98, -58, -41, -64, -46, 124, 106, -117, 34, -93, 91, 5, 93, 2, 117, -43, 97, -29, 24, -113, 85, 81, -83, 31, 11, 94, -123, -27, -62, 87, 99, -54, 61, 108, -76, -59, -52, 112, -78, -111, 89, 13, 71, 32, -56, 79, 88, -32, 1, -30, 22, 56, -60, 111, 59, 15, 101, 70, -66, 126, 45, 123, -126, -7, 64, -75, 29, 115, -8, -21, 38, -57, -121, -105, 37, 84, -79, 40, -86, -104, -99, -91, 100, 109, 122, -44, 16, -127, 68, -17, 73, -42, -82, 46, -35, 118, 92, 47, -89, 28, -55, 9, 105, -102, -125, -49, 41, 57, -71, -23, 76, -1, 67, -85};

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        int n2;
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            throw new InvalidParameterSpecException(RC2Parameters.a("\u0007\b2k=<\t#i$/\u00126;=/\u00142v(:\u0003!;>>\u00030r+'\u00052o$!\b"));
        }
        byte[] byArray = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
        if (byArray != null) {
            if (byArray.length != 8) {
                throw new InvalidParameterSpecException(RC2Parameters.a("\u00070su\":Fk;/7\u00126hm\"\t=|"));
            }
            this.a = (byte[])byArray.clone();
        }
        if ((n2 = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits()) < 1 || n2 > 1024) {
            throw new InvalidParameterSpecException(RC2Parameters.a("\u000b\u00005~.:\u000f%~m%\u0003*;>'\u001c6;$=F=t9n\u000f=;9&\u0003si, \u00016;\"(Fb;`nWc)yn\u0004:o>`"));
        }
        this.c = n2;
        this.b = n2 >= 256 ? n2 : this.a(n2);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        byte[] byArray2;
        block8: {
            byArray2 = null;
            try {
                DerValue derValue = new DerValue(byArray);
                if (derValue.getTag() == 4) {
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(RC2Parameters.a("\u00070sk,<\u0015:u*n\u0003!i\"<\\s~5:\u00142;)/\u00122"));
                    }
                    this.b = this.a(32);
                    this.c = 32;
                    break block8;
                }
                if (derValue.getTag() == 48) {
                    int n2 = derValue.getData().getInteger().intValue();
                    byArray2 = derValue.getData().getOctetString();
                    if (derValue.getData().available() != 0) {
                        throw new IOException(RC2Parameters.a("\u001c%a;\u001d/\u00142v(:\u0003!hm>\u0007!h$ \u0001s~?<\t!!m\u000b\u001e'i,n\u00022o,"));
                    }
                    if (n2 < 1 || n2 > 1024) {
                        throw new IOException(RC2Parameters.a("\u001c%aM(<\u0015:t#n\u000f ;#!\u0012sr#n\u0012;~m<\u0007=|(n\t5;|nKs*}|R}"));
                    }
                    this.c = n2 >= 256 ? n2 : this.b(n2);
                    this.b = n2;
                    break block8;
                }
                throw new IOException(RC2Parameters.a("\u001c%a;\u001d/\u00142v(:\u0003!hm>\u0007!h$ \u0001s~?<\t!!m:\u00074;") + derValue.getTag() + RC2Parameters.a("n\b<om=\u0013#k\"<\u00126\u007f"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(RC2Parameters.a("\u001c%aM(<\u0015:t#n\n6u*:\u000eso\"!F1r*"));
            }
        }
        if (byArray2.length != 8) {
            throw new IOException(RC2Parameters.a("\u00070su\":Fk;/7\u00126hm\"\t=|"));
        }
        this.a = byArray2;
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName(RC2Parameters.a("$\u0007%z5`\u0005!b=:\t}h=+\u0005}I\u000e|62i,#\u0003'~?\u001d\u00166x"));
            if (clazz2.isAssignableFrom(clazz)) {
                if (this.a == null) {
                    return new RC2ParameterSpec(this.c);
                }
                return new RC2ParameterSpec(this.c, this.a);
            }
            throw new InvalidParameterSpecException(RC2Parameters.a("\u0007\b2k=<\t#i$/\u00126;=/\u00142v(:\u0003!;>>\u00030r+'\u00052o$!\b"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException(RC2Parameters.a("\u001b\b n=>\t!o(*F#z?/\u000b6o(<F k(-\u000f5r./\u0012:t#tF") + classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.c == 32) {
            derOutputStream.putOctetString(this.a);
        } else {
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.putInteger(BigInteger.valueOf(this.b));
            derOutputStream2.putOctetString(this.a);
            derOutputStream.write((byte)48, derOutputStream2);
        }
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String string = RC2Parameters.a("DFs;m\u00070i\u0011\u0016");
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string = string + hexDumpEncoder.encodeBuffer(this.a);
        string = string + "]";
        return RC2Parameters.a("\u000b\u00005~.:\u000f%~m%\u0003*;/'\u0012 !G") + BigInteger.valueOf(this.c).toString() + "\n" + string;
    }

    private int a(int n2) {
        byte by2 = d[n2];
        if (by2 >= 0) {
            return by2;
        }
        return by2 + 256;
    }

    private int b(int n2) throws IOException {
        int n3;
        for (n3 = 1; n3 < 256; ++n3) {
            int n4;
            int n5 = d[n3];
            int n6 = n4 = n5 >= 0 ? n5 : n5 + 256;
            if (n2 == n4) break;
        }
        if (n3 < 256) {
            return n3;
        }
        throw new IOException(RC2Parameters.a("\u001c%aM(<\u0015:t#n\u00052u#!\u0012sy(n\u0000<n#*F:um:\u000e6;9<\u0007=h!/\u0012:t#n\u00122y!+H"));
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 78;
                        break;
                    }
                    case 1: {
                        n5 = 102;
                        break;
                    }
                    case 2: {
                        n5 = 83;
                        break;
                    }
                    case 3: {
                        n5 = 27;
                        break;
                    }
                    default: {
                        n5 = 77;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

