/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.client.selection;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.WLMIORBuilder;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.client.WLMClientRequestInterceptor;
import com.ibm.ws.wlm.client.selection.InterOp40Server;
import com.ibm.ws.wlm.client.selection.LSDSelector;
import com.ibm.ws.wlm.client.selection.NoUsableTargetException;
import com.ibm.ws.wlm.client.selection.TargetSelector;
import com.ibm.ws.wlm.client.selection.TargetSelectorFactory;
import com.ibm.ws.wlm.configuration.ClusterDescription;
import com.ibm.ws.wlm.configuration.ClusterKey;
import com.ibm.ws.wlm.configuration.ConfigurationManager;
import com.ibm.ws.wlm.configuration.LSDAddress;
import com.ibm.ws.wlm.configuration.LSDDescription;
import com.ibm.ws.wlm.configuration.MemberDescription;
import com.ibm.ws.wlm.configuration.WLMIOR;
import java.util.HashMap;
import java.util.List;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORBPackage.InvalidName;

public class MasterProxy {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$wlm$client$selection$MasterProxy == null ? (class$com$ibm$ws$wlm$client$selection$MasterProxy = MasterProxy.class$("com.ibm.ws.wlm.client.selection.MasterProxy")) : class$com$ibm$ws$wlm$client$selection$MasterProxy, "WLM", "com.ibm.ws.wlm.resources.WLMMessages");
    private ClusterKey sgKey;
    private ClusterDescription serverGroup;
    private long epoch;
    private boolean usable = true;
    private TargetSelector proxySelector;
    private IOR ior;
    private LSDSelector lsdSelector;
    private HashMap cacheMap = new HashMap();
    private MemberDescription local_process;
    static /* synthetic */ Class class$com$ibm$ws$wlm$client$selection$MasterProxy;

    public MasterProxy(WLMIOR wLMIOR) {
        ClusterDescription clusterDescription;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", wLMIOR);
        }
        this.ior = wLMIOR.getIOR();
        this.sgKey = wLMIOR.getClusterKey();
        if (WLMProperties.getServerGroupName() != null && this.sgKey.equals(ClusterKey.getClusterKey(WLMProperties.getAdminDomainName(), WLMProperties.getServerGroupName()))) {
            this.local_process = new MemberDescription(this.sgKey, WLMProperties.getLocalTemplateIOR());
        }
        if ((clusterDescription = (this.serverGroup = ConfigurationManager.getInstance().lookupClusterDescription(this.sgKey))) == null || !clusterDescription.getMemento().hasReachableTarget()) {
            MemberDescription[] memberDescriptionArray = new MemberDescription[]{new MemberDescription(this.sgKey, "ORIGINAL_IOR_MEMBER", this.ior.stringify(), 0, 10)};
            LSDAddress[] lSDAddressArray = new LSDAddress[]{};
            LSDAddress[] lSDAddressArray2 = new LSDAddress[]{};
            clusterDescription = new ClusterDescription(this.sgKey, 0, -1L, memberDescriptionArray, lSDAddressArray, lSDAddressArray2);
        }
        this.updateMemento(clusterDescription);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public ClusterKey getClusterKey() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClusterKey", this.sgKey.toString());
        }
        return this.sgKey;
    }

    public synchronized MemberDescription getNextClone(List list) {
        MemberDescription memberDescription;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextClone", this.local_process);
        }
        if ((memberDescription = this.local_process) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getNextClone", memberDescription);
            }
            return memberDescription;
        }
        try {
            if (this.epoch < this.serverGroup.getEpoch()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getNextClone", "updating proxy selector");
                }
                this.updateMemento(this.serverGroup);
            }
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    memberDescription = (MemberDescription)list.get(i);
                    if (!this.sgKey.equals(memberDescription.getClusterKey())) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getNextClone", memberDescription);
                    }
                    return memberDescription;
                }
                memberDescription = null;
            }
            memberDescription = this.proxySelector.getNextClone();
        }
        catch (NoUsableTargetException noUsableTargetException) {
            FFDCFilter.processException((Throwable)((Object)noUsableTargetException), "com.ibm.ws.wlm.client.selection.MasterProxy.getNextClone", "263", this);
            if (this.usable) {
                this.usable = false;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "No usable proxies found in server list");
                }
                if (this.serverGroup.getStreamVersion() == 0) {
                    memberDescription = this.refreshClusterfromAdminServer();
                }
                if (memberDescription == null) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "No usable proxies found in server list after refresh.");
                    }
                    throw new NO_IMPLEMENT("", 1229066304, CompletionStatus.COMPLETED_NO);
                }
            }
            this.usable = true;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No usable proxies found in server list after second attempt.");
            }
            Tr.service(tc, "WLMKEY_CLUSTER_MARKED_UNUSABLE", new Object[]{this.sgKey.clusterName, noUsableTargetException});
            throw new NO_IMPLEMENT("", 1229066304, CompletionStatus.COMPLETED_NO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextClone", memberDescription);
        }
        return memberDescription;
    }

    public void markSelected(MemberDescription memberDescription) {
        this.proxySelector.markSelected(memberDescription);
    }

    void postInvoke() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "postInvoke marking usable = true");
        }
        this.usable = true;
    }

    synchronized boolean usableProxiesAvailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "usableSlaveProxiesAvailable");
        }
        if (this.epoch != this.serverGroup.getEpoch()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "usableProxyAvailable", "updating proxy selector");
            }
            this.updateMemento(this.serverGroup);
        }
        boolean bl = this.proxySelector.usableProxiesAvailable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "usableSlaveProxiesAvailable", new Boolean(bl));
        }
        return bl;
    }

    private void updateMemento(ClusterDescription clusterDescription) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMemento", new Object[]{clusterDescription, this.proxySelector});
        }
        this.cacheMap.clear();
        ClusterDescription.Memento memento = clusterDescription.getMemento();
        this.epoch = memento.getEpoch();
        this.proxySelector = TargetSelectorFactory.getTargetSelector(memento);
        LSDAddress[] lSDAddressArray = memento.getLSDAddressList();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "LSDAddress size is", new Integer(lSDAddressArray.length));
        }
        this.lsdSelector = lSDAddressArray.length != 0 ? new LSDSelector(lSDAddressArray) : new LSDSelector(this.ior);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMemento", new Object[]{this.proxySelector});
        }
    }

    public String toString() {
        String string = this.getClass().getName() + "@" + this.ior.getTypeId() + ":" + this.sgKey + ":" + this.proxySelector + ":" + this.epoch;
        return string;
    }

    IOR assembleTargetIOR(ORB oRB, MemberDescription memberDescription) {
        IOR iOR;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "assembleTargetIOR", memberDescription);
        }
        if ((iOR = (IOR)this.cacheMap.get(memberDescription)) == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "cache miss assemble the ior");
            }
            iOR = WLMIORBuilder.assembleTargetIOR(oRB, memberDescription, this.ior);
            this.cacheMap.put(memberDescription, iOR);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "assembleTargetIOR", iOR.stringify());
        }
        return iOR;
    }

    void registerContextForClientInterceptor(ORB oRB) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerContextForClientInterceptor", oRB);
            }
            try {
                WLMClientRequestInterceptor wLMClientRequestInterceptor = (WLMClientRequestInterceptor)oRB.resolve_initial_references("WLMClientRequestInterceptor");
                wLMClientRequestInterceptor.registerServiceContextListener(oRB, this.serverGroup);
            }
            catch (InvalidName invalidName) {
                FFDCFilter.processException((Throwable)invalidName, "com.ibm.ws.wlm.client.selection.MasterProxy.registerContextForClientInterceptor", "448", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unexpected exception", (Object)invalidName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerContextForClientInterceptor");
        }
    }

    void deregisterContextForClientInterceptor(ORB oRB) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deregisterContextForClientInterceptor");
            }
            try {
                WLMClientRequestInterceptor wLMClientRequestInterceptor = (WLMClientRequestInterceptor)oRB.resolve_initial_references("WLMClientRequestInterceptor");
                wLMClientRequestInterceptor.deregisterServiceContextListener(oRB, this.serverGroup);
            }
            catch (InvalidName invalidName) {
                FFDCFilter.processException((Throwable)invalidName, "com.ibm.ws.wlm.client.selection.MasterProxy.registerContextForClientInterceptor", "477", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Unexpected exception", (Object)invalidName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterContextForClientInterceptor");
        }
    }

    public LSDDescription getNextLSD() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextLSD");
        }
        LSDDescription lSDDescription = null;
        if (this.lsdSelector != null) {
            lSDDescription = this.lsdSelector.getNextLSD();
        } else {
            Tr.warning(tc, "WLMKEY_NO_LSDSELECTOR", "getNextLSD");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextLSD", lSDDescription);
        }
        return lSDDescription;
    }

    public LSDSelector getLSDSelector() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLSDSelector");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLSDSelector", this.lsdSelector);
        }
        return this.lsdSelector;
    }

    private MemberDescription refreshClusterfromAdminServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshClusterfromAdminServer");
        }
        MemberDescription memberDescription = null;
        try {
            InterOp40Server interOp40Server = InterOp40Server.getInterOp40Server();
            interOp40Server.refreshServerGroup(this.serverGroup);
            this.updateMemento(this.serverGroup);
            memberDescription = this.proxySelector.getNextClone();
        }
        catch (NoUsableTargetException noUsableTargetException) {
            FFDCFilter.processException((Throwable)((Object)noUsableTargetException), "com.ibm.ws.wlm.client.selection.MasterProxy.refreshClusterfromAdminServer", "561", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No usable proxies found in admin server group or after getting the cluster refreshed.");
            }
            memberDescription = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshClusterfromAdminServer", memberDescription);
        }
        return memberDescription;
    }

    public IOR getIOR() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIOR", this.ior.stringify());
        }
        return this.ior;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.27 : none");
        }
    }
}

