/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.client.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wlm.client.selection.NoUsableTargetException;
import com.ibm.ws.wlm.client.selection.TargetSelector;
import com.ibm.ws.wlm.configuration.MemberDescription;
import java.util.Random;

class WeightedOutstandingRequestTargetSelector
implements TargetSelector {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$wlm$client$selection$WeightedOutstandingRequestTargetSelector == null ? (class$com$ibm$ws$wlm$client$selection$WeightedOutstandingRequestTargetSelector = WeightedOutstandingRequestTargetSelector.class$("com.ibm.ws.wlm.client.selection.WeightedOutstandingRequestTargetSelector")) : class$com$ibm$ws$wlm$client$selection$WeightedOutstandingRequestTargetSelector, "WLM", "com.ibm.ws.wlm.resources.WLMMessages");
    private Selector positiveSelector;
    private Selector negativeSelector;
    static /* synthetic */ Class class$com$ibm$ws$wlm$client$selection$WeightedOutstandingRequestTargetSelector;

    WeightedOutstandingRequestTargetSelector() {
        this.positiveSelector = new Selector(new MemberDescription[0]);
        this.negativeSelector = new Selector(new MemberDescription[0]);
    }

    WeightedOutstandingRequestTargetSelector(MemberDescription[] memberDescriptionArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = memberDescriptionArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            n = memberDescriptionArray[n2].getWeight();
            if (n > 0) {
                ++n3;
                continue;
            }
            if (n >= 0) continue;
            ++n4;
        }
        MemberDescription[] memberDescriptionArray2 = new MemberDescription[n4];
        MemberDescription[] memberDescriptionArray3 = new MemberDescription[n3];
        n4 = 0;
        n3 = 0;
        n5 = memberDescriptionArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            n = memberDescriptionArray[n2].getWeight();
            if (n > 0) {
                memberDescriptionArray3[n3] = memberDescriptionArray[n2];
                ++n3;
                continue;
            }
            if (n >= 0) continue;
            memberDescriptionArray2[n4] = memberDescriptionArray[n2];
            ++n4;
        }
        this.positiveSelector = new Selector(memberDescriptionArray3);
        this.negativeSelector = new Selector(memberDescriptionArray2);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "Size of postiveMemberList is" + memberDescriptionArray3.length);
            Tr.event(tc, "Size of negativeMemberList is" + memberDescriptionArray2.length);
        }
    }

    public MemberDescription getNextClone() throws NoUsableTargetException {
        MemberDescription memberDescription;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextClone");
        }
        if ((memberDescription = this.positiveSelector.select()) == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No positive proxy found.");
            }
            memberDescription = this.negativeSelector.select();
        }
        if (memberDescription == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No usable proxy found.");
            }
            throw new NoUsableTargetException("com.ibm.ws.wlm.resources.WLMMessages", "WLMKEY_NO_USEABLE_PROXIES", new Object[]{"getNextClone", ""}, "Method getNextClone found no useable proxies in the list.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextClone", memberDescription);
        }
        return memberDescription;
    }

    public boolean usableProxiesAvailable() {
        return this.positiveSelector.usableProxiesAvailable() || this.negativeSelector.usableProxiesAvailable();
    }

    public void markSelected(MemberDescription memberDescription) {
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + this.positiveSelector.toString() + this.negativeSelector.toString();
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.3 : none");
        }
    }

    protected class Selector {
        private int cursor = new Random().nextInt(29);
        private MemberDescription[] targets;
        private int[] weights;
        private int[] thresholds;

        protected Selector(MemberDescription[] memberDescriptionArray) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", memberDescriptionArray);
            }
            this.targets = memberDescriptionArray;
            int n = this.targets.length;
            this.weights = new int[n];
            this.thresholds = new int[n];
            long l = this.refreshWeights();
            if (l > 0L) {
                this.cursor = (int)((long)this.cursor % l);
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    if (this.cursor >= (n2 += this.weights[i])) continue;
                    this.cursor = (i + (n - 1)) % n;
                    break;
                }
                this.updateThresholds();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", this);
            }
        }

        private long refreshWeights() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshWeights");
            }
            long l = 0L;
            boolean bl = tc.isDebugEnabled();
            int n = this.targets.length;
            for (int i = 0; i < n; ++i) {
                this.weights[i] = this.targets[i].getWeight();
                if (this.weights[i] < 0) {
                    this.weights[i] = this.weights[i] * -1;
                }
                l += (long)this.weights[i];
                if (!bl) continue;
                Tr.debug(tc, "Target weight", this.targets[i] + " [" + this.weights[i] + "]");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "refreshWeights", String.valueOf(l));
            }
            return l;
        }

        private void updateThresholds() {
            int n;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateThresholds");
            }
            int n2 = this.targets.length;
            int[] nArray = new int[n2];
            boolean bl = true;
            int n3 = 0;
            int n4 = 0;
            long l = 0L;
            for (n = 0; n < n2; ++n) {
                int n5 = this.targets[n].getNumDataPoints();
                int n6 = n5 = n5 == 0 ? 1 : n5;
                if (this.targets[n].isUsable()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Oustanding ", new Object[]{n + " " + this.targets[n].getOutstandingRequests()});
                    }
                    n4 += this.targets[n].getTotalOutstandingRequests() / n5 + n3;
                    l += (long)this.weights[n];
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unused ", new Object[]{n + " " + this.targets[n].getOutstandingRequests()});
            }
            for (n = 0; n < n2; ++n) {
                l = l < 1L ? 1L : l;
                nArray[n] = n4 * this.weights[n] / (int)l + 1;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Threshold ", new Object[]{n + " " + nArray[n]});
            }
            this.thresholds = nArray;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateThresholds");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void increaseThresholds() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "increaseThresholds");
            }
            int n = 0;
            int n2 = this.thresholds.length;
            while (true) {
                if (n >= n2) {
                    if (!tc.isEntryEnabled()) return;
                    Tr.exit(tc, "increaseThresholds");
                    return;
                }
                int[] nArray = this.thresholds;
                // MONITORENTER : this.thresholds
                int n3 = n;
                this.thresholds[n3] = this.thresholds[n3] + 1;
                // MONITOREXIT : nArray
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Threshold ", new Integer(this.thresholds[n]));
                }
                ++n;
            }
        }

        protected MemberDescription select() {
            String string = "";
            int n = this.targets.length;
            if (n == 0) {
                return null;
            }
            boolean bl = false;
            for (int i = 0; i < 3; ++i) {
                boolean bl2 = false;
                for (int j = 0; j < n; ++j) {
                    ++this.cursor;
                    int n2 = this.cursor %= n;
                    if (this.weights[n2] > 0) {
                        MemberDescription memberDescription = this.targets[n2];
                        if (!memberDescription.isUsable() || !bl && memberDescription.getOutstandingRequests() >= this.thresholds[n2]) continue;
                        int n3 = n2;
                        this.weights[n3] = this.weights[n3] - 1;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getNextClone", new Object[]{memberDescription, String.valueOf(this.weights[n2])});
                        }
                        return memberDescription;
                    }
                    bl2 = true;
                }
                if (bl2) {
                    this.refreshWeights();
                    this.updateThresholds();
                    continue;
                }
                if (i != 1 && bl2) continue;
                bl = true;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "could not find usable proxy");
            }
            return null;
        }

        public boolean usableProxiesAvailable() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "usableProxiesAvailable");
            }
            int n = this.targets.length;
            for (int i = 0; i < n; ++i) {
                MemberDescription memberDescription = this.targets[i];
                if (!memberDescription.isUsable()) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "usableProxiesAvailable", "true");
                }
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "usableProxiesAvailable", "false");
            }
            return false;
        }

        public String toString() {
            String string = this.getClass().getName();
            string = string + " targets =";
            for (int i = 0; i < this.targets.length; ++i) {
                string = string + " " + this.targets[i] + ":" + this.weights[i];
            }
            return string;
        }
    }
}

