/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.client.selection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wlm.client.selection.NoUsableTargetException;
import com.ibm.ws.wlm.client.selection.TargetSelector;
import com.ibm.ws.wlm.configuration.MemberDescription;
import java.util.Random;

class WeightedRoundRobinTargetSelector
implements TargetSelector {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$wlm$client$selection$WeightedRoundRobinTargetSelector == null ? (class$com$ibm$ws$wlm$client$selection$WeightedRoundRobinTargetSelector = WeightedRoundRobinTargetSelector.class$("com.ibm.ws.wlm.client.selection.WeightedRoundRobinTargetSelector")) : class$com$ibm$ws$wlm$client$selection$WeightedRoundRobinTargetSelector, "WLM", "com.ibm.ws.wlm.resources.WLMMessages");
    private Selector selector;
    static /* synthetic */ Class class$com$ibm$ws$wlm$client$selection$WeightedRoundRobinTargetSelector;

    WeightedRoundRobinTargetSelector(MemberDescription[] memberDescriptionArray) {
        this.selector = new Selector(memberDescriptionArray);
    }

    public MemberDescription getNextClone() throws NoUsableTargetException {
        MemberDescription memberDescription;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextClone");
        }
        if ((memberDescription = this.selector.select()) == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No usable proxy found.");
            }
            throw new NoUsableTargetException("com.ibm.ws.wlm.resources.WLMMessages", "WLMKEY_NO_USEABLE_PROXIES", new Object[]{"getNextClone", ""}, "Method getNextClone found no useable proxies in the list.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextClone", memberDescription);
        }
        return memberDescription;
    }

    public void markSelected(MemberDescription memberDescription) {
        this.selector.decrement(memberDescription);
    }

    public boolean usableProxiesAvailable() {
        return this.selector.usableProxiesAvailable();
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + this.selector.toString();
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.9 : none");
        }
    }

    protected class Selector {
        private int cursor = new Random().nextInt(29);
        private MemberDescription[] targets;
        private int[] weights;

        protected Selector(MemberDescription[] memberDescriptionArray) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>", memberDescriptionArray);
            }
            this.targets = memberDescriptionArray;
            int n = this.targets.length;
            this.weights = new int[n];
            long l = this.refreshWeights();
            if (l > 0L) {
                this.cursor = (int)((long)this.cursor % l);
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    if (this.cursor >= (n2 += this.weights[i])) continue;
                    this.cursor = (i + (n - 1)) % n;
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", this);
            }
        }

        private long refreshWeights() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "refreshWeights");
            }
            long l = 0L;
            boolean bl = tc.isDebugEnabled();
            int n = this.targets.length;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                this.weights[n2] = this.weights[n2] + this.targets[i].getWeight();
                l += (long)this.weights[i];
                if (!bl) continue;
                Tr.debug(tc, "Target weight", this.targets[i] + " [" + this.weights[i] + "]");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "refreshWeights", String.valueOf(l));
            }
            return l;
        }

        protected MemberDescription select() {
            MemberDescription memberDescription;
            int n;
            int n2;
            int n3 = this.targets.length;
            for (n2 = 0; n2 < n3; ++n2) {
                ++this.cursor;
                n = this.cursor %= n3;
                if (this.weights[n] <= 0) continue;
                memberDescription = this.targets[n];
                int n4 = n;
                this.weights[n4] = this.weights[n4] - 1;
                if (!memberDescription.isUsable()) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNextClone", new Object[]{memberDescription, String.valueOf(this.weights[n])});
                }
                return memberDescription;
            }
            this.refreshWeights();
            for (n2 = 0; n2 < n3; ++n2) {
                ++this.cursor;
                n = this.cursor %= n3;
                if (this.weights[n] <= 0 || !(memberDescription = this.targets[n]).isUsable()) continue;
                int n5 = n;
                this.weights[n5] = this.weights[n5] - 1;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getNextClone", new Object[]{memberDescription, String.valueOf(this.weights[n])});
                }
                return memberDescription;
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "could not find usable proxy");
            }
            return null;
        }

        protected void decrement(MemberDescription memberDescription) {
            int n = this.targets.length;
            for (int i = 0; i < n; ++i) {
                if (!memberDescription.equals(this.targets[i])) continue;
                int n2 = i;
                this.weights[n2] = this.weights[n2] - 1;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "decrement", new Object[]{memberDescription, String.valueOf(this.weights[i])});
                }
                return;
            }
        }

        public boolean usableProxiesAvailable() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "usableSlaveProxiesAvailable");
            }
            int n = this.targets.length;
            for (int i = 0; i < n; ++i) {
                MemberDescription memberDescription = this.targets[i];
                if (!memberDescription.isUsable()) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "usableSlaveProxiesAvailable", "true");
                }
                return true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "usableSlaveProxiesAvailable", "false");
            }
            return false;
        }

        public String toString() {
            String string = this.getClass().getName();
            string = string + " targets =";
            for (int i = 0; i < this.targets.length; ++i) {
                string = string + " " + this.targets[i] + ":" + this.weights[i];
            }
            return string;
        }
    }
}

