/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm.configuration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wlm.PMIManager;
import com.ibm.ws.wlm.WLMProperties;
import com.ibm.ws.wlm.WLMServiceContextListener;
import com.ibm.ws.wlm.configuration.ClusterKey;
import com.ibm.ws.wlm.configuration.ConfigurationManager;
import com.ibm.ws.wlm.configuration.LSDAddress;
import com.ibm.ws.wlm.configuration.MemberDescription;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ClusterDescription
implements WLMServiceContextListener {
    static final long serialVersionUID = 2656246416369976293L;
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$wlm$configuration$ClusterDescription == null ? (class$com$ibm$ws$wlm$configuration$ClusterDescription = ClusterDescription.class$("com.ibm.ws.wlm.configuration.ClusterDescription")) : class$com$ibm$ws$wlm$configuration$ClusterDescription, "WLM", "com.ibm.ws.wlm.resources.WLMMessages");
    private static final TraceComponent mtc = Tr.register(class$com$ibm$ws$wlm$configuration$ClusterDescription$Memento == null ? (class$com$ibm$ws$wlm$configuration$ClusterDescription$Memento = ClusterDescription.class$("com.ibm.ws.wlm.configuration.ClusterDescription$Memento")) : class$com$ibm$ws$wlm$configuration$ClusterDescription$Memento, "WLM", "com.ibm.ws.wlm.resources.WLMMessages");
    private static final TraceComponent sptc = Tr.register(class$com$ibm$ws$wlm$configuration$ClusterDescription$WLMContextStreamHandler == null ? (class$com$ibm$ws$wlm$configuration$ClusterDescription$WLMContextStreamHandler = ClusterDescription.class$("com.ibm.ws.wlm.configuration.ClusterDescription$WLMContextStreamHandler")) : class$com$ibm$ws$wlm$configuration$ClusterDescription$WLMContextStreamHandler, "WLM", "com.ibm.ws.wlm.resources.WLMMessages");
    private static final int current = 1;
    public static final byte POLICY_WEIGHTED = 0;
    public static final byte POLICY_WEIGHTED_LOCAL = 1;
    public static final long EPOCH_NOT_INITIALIZED = -2L;
    public static final long EPOCH_NO_INFORMATION = -1L;
    public static final long EPOCH_STANDALONE_MEMBER = 0L;
    public static final int STREAMVERSION0 = 0;
    public static final int STREAMVERSION1 = 1;
    public static int CURRENTVERSION;
    protected ClusterKey sgKey;
    protected MemberDescription[] serverList = new MemberDescription[0];
    protected byte selectionPolicy = 0;
    protected long epoch = -2L;
    protected Memento currentState;
    protected final Object lock = new Object();
    protected LSDAddress[] lsdList = new LSDAddress[0];
    protected LSDAddress[] lsdMirroredList = new LSDAddress[0];
    private WLMContextStreamHandler streamHandler;
    private int streamVersion = 1;
    static /* synthetic */ Class class$com$ibm$ws$wlm$configuration$ClusterDescription;
    static /* synthetic */ Class class$com$ibm$ws$wlm$configuration$ClusterDescription$Memento;
    static /* synthetic */ Class class$com$ibm$ws$wlm$configuration$ClusterDescription$WLMContextStreamHandler;

    public ClusterDescription(ClusterKey clusterKey, byte by, long l, MemberDescription[] memberDescriptionArray, LSDAddress[] lSDAddressArray, LSDAddress[] lSDAddressArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{clusterKey.toString(), String.valueOf(by), String.valueOf(l)});
        }
        this.initialize(clusterKey, by, l, memberDescriptionArray, lSDAddressArray, lSDAddressArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this.currentState);
        }
    }

    public ClusterDescription(ClusterKey clusterKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{clusterKey.toString()});
        }
        this.initialize(clusterKey, (byte)0, -2L, new MemberDescription[0], new LSDAddress[0], new LSDAddress[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this.currentState);
        }
    }

    public ClusterDescription(byte[] byArray, ClusterKey clusterKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", "Creating empty server group");
        }
        this.initialize(clusterKey, (byte)0, -2L, new MemberDescription[0], new LSDAddress[0], new LSDAddress[0]);
        this.update(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this.currentState);
        }
    }

    private void initialize(ClusterKey clusterKey, byte by, long l, MemberDescription[] memberDescriptionArray, LSDAddress[] lSDAddressArray, LSDAddress[] lSDAddressArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{clusterKey.toString(), String.valueOf(by), String.valueOf(l)});
        }
        this.sgKey = clusterKey;
        this.epoch = l;
        this.selectionPolicy = by;
        this.serverList = memberDescriptionArray;
        this.lsdList = lSDAddressArray;
        this.lsdMirroredList = lSDAddressArray2;
        this.currentState = new Memento(this.epoch, this.selectionPolicy, this.serverList, this.lsdList, this.lsdMirroredList);
        this.streamHandler = new WLMContextStreamHandler();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.currentState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEpoch() {
        long l;
        Object object = this.lock;
        synchronized (object) {
            l = this.epoch;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getEpoch", String.valueOf(l));
        }
        return l;
    }

    public String getName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getName", this.sgKey.clusterName);
        }
        return this.sgKey.clusterName;
    }

    public String getAdminDomainName() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getName", this.sgKey.domainName);
        }
        return this.sgKey.domainName;
    }

    public ClusterKey getClusterKey() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClusterKey", this.sgKey);
        }
        return this.sgKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memento getMemento() {
        Memento memento;
        Object object = this.lock;
        synchronized (object) {
            memento = this.currentState;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getMemento", memento);
        }
        return memento;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string = "" + this.sgKey + "@" + this.epoch + ":" + this.selectionPolicy;
        Object object = this.lock;
        synchronized (object) {
            if (this.serverList != null) {
                for (int i = 0; i < this.serverList.length; ++i) {
                    string = string + ":" + this.serverList[i].toString();
                }
            }
        }
        return string;
    }

    public void update(byte by, long l, MemberDescription[] memberDescriptionArray, LSDAddress[] lSDAddressArray, LSDAddress[] lSDAddressArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", new Object[]{this.sgKey.toString(), String.valueOf(by), String.valueOf(l)});
        }
        this.epoch = l;
        this.selectionPolicy = by;
        this.serverList = memberDescriptionArray;
        this.lsdList = lSDAddressArray;
        this.lsdMirroredList = lSDAddressArray2;
        this.currentState = new Memento(this.epoch, this.selectionPolicy, this.serverList, this.lsdList, this.lsdMirroredList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update", this.currentState);
        }
    }

    public void update(LSDAddress[] lSDAddressArray, LSDAddress[] lSDAddressArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", lSDAddressArray);
        }
        this.lsdList = lSDAddressArray;
        this.lsdMirroredList = lSDAddressArray2;
        this.currentState = new Memento(this.epoch, this.selectionPolicy, this.serverList, this.lsdList, this.lsdMirroredList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update", this.currentState);
        }
    }

    public void update(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update");
        }
        this.streamHandler.parse(byArray, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toStream() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toStream");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Object object = this.lock;
            synchronized (object) {
                int n;
                int n2;
                dataOutputStream.writeInt(CURRENTVERSION);
                dataOutputStream.writeUTF(this.sgKey.domainName);
                dataOutputStream.writeUTF(this.sgKey.clusterName);
                dataOutputStream.writeLong(this.epoch);
                dataOutputStream.writeByte(this.selectionPolicy);
                int n3 = this.serverList.length;
                dataOutputStream.writeInt(n3);
                for (n2 = 0; n2 < n3; ++n2) {
                    dataOutputStream.writeUTF(this.serverList[n2].getKey());
                    dataOutputStream.writeInt(this.serverList[n2].getState());
                    dataOutputStream.writeInt(this.serverList[n2].getWeight());
                    dataOutputStream.writeUTF(this.serverList[n2].getDummyIOR().stringify());
                }
                n2 = this.lsdList.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LsdListSize is", new Integer(n2));
                }
                dataOutputStream.writeInt(n2);
                for (n = 0; n < n2; ++n) {
                    dataOutputStream.writeUTF(this.lsdList[n].getHost());
                    dataOutputStream.writeShort(this.lsdList[n].getPort());
                    dataOutputStream.writeShort(this.lsdList[n].getSSLPort());
                    dataOutputStream.writeShort(this.lsdList[n].getSSLCCPort());
                }
                n2 = this.lsdMirroredList.length;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LsdMirroredListSize is", new Integer(n2));
                }
                dataOutputStream.writeInt(n2);
                for (n = 0; n < n2; ++n) {
                    dataOutputStream.writeUTF(this.lsdMirroredList[n].getHost());
                    dataOutputStream.writeShort(this.lsdMirroredList[n].getPort());
                    dataOutputStream.writeShort(this.lsdMirroredList[n].getSSLPort());
                    dataOutputStream.writeShort(this.lsdMirroredList[n].getSSLCCPort());
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.ClusterDescription.toStream", "616", this);
            Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"toStream", iOException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toStream");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toStream(ClusterKey clusterKey, byte by, long l, String[] stringArray, int[] nArray, int[] nArray2, String[] stringArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toStream", new Object[]{clusterKey.toString(), String.valueOf(by), String.valueOf(l)});
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeUTF(clusterKey.domainName);
            dataOutputStream.writeUTF(clusterKey.clusterName);
            dataOutputStream.writeLong(l);
            dataOutputStream.writeByte(by);
            dataOutputStream.writeInt(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                dataOutputStream.writeUTF(stringArray[i]);
                dataOutputStream.writeInt(nArray[i]);
                dataOutputStream.writeInt(nArray2[i]);
                dataOutputStream.writeUTF(stringArray2[i]);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.wlm.configuration.ClusterDescription.toStream", "671");
            Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"toStream", iOException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toStream");
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toStream40(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toStream40");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Object object = this.lock;
            synchronized (object) {
                dataOutputStream.writeInt(0);
                dataOutputStream.writeUTF(this.sgKey.domainName);
                dataOutputStream.writeUTF(this.sgKey.clusterName);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF("roundrobinpreferlocal");
                int n2 = this.serverList.length;
                dataOutputStream.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    long l;
                    try {
                        l = Long.valueOf(this.serverList[i].getKey());
                    }
                    catch (NumberFormatException numberFormatException) {
                        l = this.serverList[i].getKey().hashCode();
                    }
                    dataOutputStream.writeLong(l);
                    dataOutputStream.writeInt(0);
                    dataOutputStream.writeInt(3);
                    dataOutputStream.writeUTF(this.serverList[i].getDummyIOR().stringify());
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.ClusterDescription.toStream40", "731", this);
            Tr.warning(tc, "WLMKEY_UNEXPECTED_EXCEPTION", new Object[]{"toStream40", iOException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toStream40");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getClusterDescriptionXMLFragment(int n) {
        String string = new String("<WLM version=\"" + n + "\">" + "<Cell name=\"" + this.sgKey.domainName + "\">" + "<ServerCluster name=\"" + this.sgKey.clusterName + "\" epoch=\"" + this.epoch + "\">");
        for (int i = 0; i < this.serverList.length; ++i) {
            string = string + "<Server name=\"" + this.serverList[i].getKey() + "\" loadbalanceweight=\"" + this.serverList[i].getWeight() + "\"/>";
        }
        string = string + "</ServerCluster></Cell></WLM>";
        return string;
    }

    public byte[] sendClientContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendClientContext");
        }
        byte[] byArray = new byte[17];
        this.intToBytes(1, byArray, 0);
        this.longToBytes(this.epoch, byArray, 4);
        this.intToBytes(PMIManager.getClientId(), byArray, 12);
        byArray[16] = PMIManager.getAffinityType();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendClientContext", byArray);
        }
        return byArray;
    }

    public byte[] receiveServerContext(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveServerContext", byArray);
        }
        byte[] byArray2 = null;
        if (byArray.length == 4) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stream is 3.5");
            }
            int n = this.bytesToInt(byArray, 0);
            int n2 = (int)(this.epoch - 946710061656L >> 8);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "client and server epochs", new Object[]{String.valueOf(n), String.valueOf(n2), String.valueOf(this.epoch)});
            }
            if (n < n2) {
                byArray2 = this.toStream40(n2);
            }
        } else {
            int n = this.bytesToInt(byArray, 0);
            if (n == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stream is 4.0");
                }
                int n3 = this.bytesToInt(byArray, 4);
                int n4 = (int)(this.epoch - 946710061656L >> 8);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "client and server epochs", new Object[]{String.valueOf(n3), String.valueOf(n4), String.valueOf(this.epoch)});
                }
                if (n3 < n4) {
                    byArray2 = this.toStream40(n4);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Stream is 5.0");
                }
                long l = this.bytesTolong(byArray, 4);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "client and server epochs", new Object[]{String.valueOf(l), String.valueOf(this.epoch)});
                }
                if (l < this.epoch) {
                    byArray2 = this.toStream();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveServerContext", String.valueOf(byArray2));
        }
        return byArray2;
    }

    public void receiveClientContext(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiveClientContext", byArray);
        }
        this.update(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiveClientContext");
        }
    }

    public int getListenerTag() {
        return 0;
    }

    public int getStreamVersion() {
        return this.streamVersion;
    }

    private int bytesToInt(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = n; i < n + 4; ++i) {
            n2 <<= 8;
            n2 |= byArray[i] & 0xFF;
        }
        return n2;
    }

    private long bytesTolong(byte[] byArray, int n) {
        long l = 0L;
        for (int i = n; i < n + 8; ++i) {
            l <<= 8;
            l |= (long)byArray[i] & 0xFFL;
        }
        return l;
    }

    protected void intToBytes(int n, byte[] byArray, int n2) {
        for (int i = n2 + 3; i >= n2; --i) {
            byArray[i] = (byte)n;
            n >>= 8;
        }
    }

    private void longToBytes(long l, byte[] byArray, int n) {
        for (int i = n + 7; i >= n; --i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : efix", "1.28 : none");
        }
        CURRENTVERSION = 1;
    }

    public class WLMContextStreamHandler {
        WLMContextStreamHandler() {
        }

        public void parse(byte[] byArray, ClusterDescription clusterDescription) {
            if (sptc.isEntryEnabled()) {
                Tr.entry(sptc, "parse", byArray);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            try {
                ClusterDescription.this.streamVersion = dataInputStream.readInt();
                if (ClusterDescription.this.streamVersion == 0) {
                    this.parseVersion0(dataInputStream, clusterDescription);
                    ClusterDescription.this.streamVersion = 0;
                } else if (!ClusterDescription.this.sgKey.domainName.equals("INIT")) {
                    this.parseVersion1(dataInputStream);
                }
                dataInputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.wlm.configuration.ClusterDescription.update", "1019", this);
            }
            if (sptc.isEntryEnabled()) {
                Tr.exit(sptc, "parse");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseVersion1(DataInputStream dataInputStream) throws IOException {
            short s;
            int n;
            LSDAddress[] lSDAddressArray;
            int n2;
            String string;
            String string2;
            ClusterKey clusterKey;
            if (sptc.isEntryEnabled()) {
                Tr.entry(sptc, "parseVersion1");
            }
            if (!(clusterKey = ClusterKey.getClusterKey(string2 = dataInputStream.readUTF(), string = dataInputStream.readUTF())).equals(ClusterDescription.this.sgKey)) {
                Tr.warning(sptc, "WLMKEY_CLUSTER_UPDATE_ERROR", new Object[]{clusterKey, ClusterDescription.this.sgKey});
                return;
            }
            long l = dataInputStream.readLong();
            if (ClusterDescription.this.epoch < l) {
                if (sptc.isEventEnabled()) {
                    Tr.event(sptc, "parseVersion1: Cached ClusterDescription info is stale: wire epoch=" + l + " cached epoch=" + ClusterDescription.this.epoch);
                }
                if (PMIManager.clientModule != null) {
                    String string3 = WLMProperties.getServerGroupName();
                    String string4 = WLMProperties.getAdminDomainName();
                    if (string3 != null && string4 != null && string4.equals(string2) && string3.equals(string)) {
                        PMIManager.serverModule.onServerClusterUpdate();
                    } else {
                        PMIManager.clientModule.onClientClusterUpdate();
                    }
                }
            } else {
                if (sptc.isEntryEnabled()) {
                    Tr.exit(sptc, "parseVersion1: Cached ClusterDescription info is current: wire epoch=" + l + " cached epoch=" + ClusterDescription.this.epoch);
                }
                return;
            }
            byte by = dataInputStream.readByte();
            int n3 = dataInputStream.readInt();
            MemberDescription[] memberDescriptionArray = new MemberDescription[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lSDAddressArray = dataInputStream.readUTF();
                n = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                String string5 = dataInputStream.readUTF();
                if (sptc.isDebugEnabled()) {
                    Tr.debug(sptc, "Create or update server", new Object[]{String.valueOf(lSDAddressArray), String.valueOf(n) + String.valueOf(n4)});
                }
                for (s = 0; s < ClusterDescription.this.serverList.length; ++s) {
                    if (!ClusterDescription.this.serverList[s].getKey().equals(lSDAddressArray)) continue;
                    ClusterDescription.this.serverList[s].update(string5, n, n4);
                    memberDescriptionArray[n2] = ClusterDescription.this.serverList[s];
                    if (!sptc.isDebugEnabled()) break;
                    Tr.debug(sptc, "updated server", memberDescriptionArray[n2]);
                    break;
                }
                if (memberDescriptionArray[n2] != null) continue;
                memberDescriptionArray[n2] = new MemberDescription(ClusterDescription.this.sgKey, (String)lSDAddressArray, string5, n, n4);
                if (!sptc.isDebugEnabled()) continue;
                Tr.debug(sptc, "created server", memberDescriptionArray[n2]);
            }
            n2 = dataInputStream.readInt();
            if (sptc.isDebugEnabled()) {
                Tr.debug(sptc, "LSD list size ", String.valueOf(n2));
            }
            lSDAddressArray = new LSDAddress[n2];
            for (n = 0; n < n2; ++n) {
                String string6 = dataInputStream.readUTF();
                short s2 = dataInputStream.readShort();
                s = dataInputStream.readShort();
                short s3 = dataInputStream.readShort();
                if (sptc.isDebugEnabled()) {
                    Tr.debug(sptc, "Create a new lsd list", new Object[]{String.valueOf(string6), String.valueOf(s2)});
                }
                lSDAddressArray[n] = new LSDAddress(string6, s2, s, s3);
            }
            n = dataInputStream.readInt();
            if (sptc.isDebugEnabled()) {
                Tr.debug(sptc, "Mirrored LSD list size ", String.valueOf(n));
            }
            LSDAddress[] lSDAddressArray2 = new LSDAddress[n];
            if (n > 0) {
                // empty if block
            }
            Object object = ClusterDescription.this.lock;
            synchronized (object) {
                ClusterDescription.this.epoch = l;
                ClusterDescription.this.selectionPolicy = by;
                ClusterDescription.this.serverList = memberDescriptionArray;
                ClusterDescription.this.currentState = new Memento(ClusterDescription.this.epoch, ClusterDescription.this.selectionPolicy, ClusterDescription.this.serverList, lSDAddressArray, lSDAddressArray2);
            }
            if (sptc.isEntryEnabled()) {
                Tr.exit(sptc, "parseVersion1", this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseVersion0(DataInputStream dataInputStream, ClusterDescription clusterDescription) throws IOException {
            LSDAddress[] lSDAddressArray;
            if (sptc.isEntryEnabled()) {
                Tr.entry(sptc, "parseVersion0");
            }
            boolean bl = false;
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            ClusterKey clusterKey = ClusterKey.getClusterKey(string, string2);
            bl = ClusterDescription.this.sgKey.domainName.equals("INIT");
            if (!clusterKey.equals(ClusterDescription.this.sgKey) && !bl) {
                Tr.warning(sptc, "WLMKEY_CLUSTER_UPDATE_ERROR", new Object[]{clusterKey, ClusterDescription.this.sgKey});
                return;
            }
            long l = dataInputStream.readInt();
            if (ClusterDescription.this.epoch < l) {
                if (sptc.isEventEnabled()) {
                    Tr.event(sptc, "parseVersion0: Cached ClusterDescription is stale: wire epoch=" + l + " cached epoch=" + ClusterDescription.this.epoch);
                }
            } else {
                if (sptc.isEntryEnabled()) {
                    Tr.exit(sptc, "parseVersion0: Cached ClusterDescription is current: wire epoch=" + l + " cached epoch=" + ClusterDescription.this.epoch);
                }
                return;
            }
            String string3 = dataInputStream.readUTF();
            byte by = 0;
            if (string3.equals("randompreferlocal") || string3.equals("roundrobinpreferlocal")) {
                by = 1;
            }
            int n = dataInputStream.readInt();
            if (sptc.isDebugEnabled()) {
                Tr.debug(sptc, "Number of MemberDescriptions in the server group is: " + n);
            }
            MemberDescription[] memberDescriptionArray = new MemberDescription[n];
            for (int i = 0; i < n; ++i) {
                lSDAddressArray = new Long(dataInputStream.readLong()).toString();
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                n3 = 0;
                int n4 = Integer.MAX_VALUE;
                String string4 = dataInputStream.readUTF();
                if (sptc.isDebugEnabled()) {
                    Tr.debug(sptc, "Create or update server", new Object[]{String.valueOf(lSDAddressArray), String.valueOf(n3)});
                }
                for (int j = 0; j < ClusterDescription.this.serverList.length; ++j) {
                    if (!ClusterDescription.this.serverList[j].getKey().equals(lSDAddressArray)) continue;
                    ClusterDescription.this.serverList[j].update(string4, n3, n4);
                    memberDescriptionArray[i] = ClusterDescription.this.serverList[j];
                    if (!sptc.isDebugEnabled()) break;
                    Tr.debug(sptc, "updated server", memberDescriptionArray[i]);
                    break;
                }
                if (memberDescriptionArray[i] != null) continue;
                memberDescriptionArray[i] = new MemberDescription(ClusterDescription.this.sgKey, (String)lSDAddressArray, string4, n3, n4);
                if (!sptc.isDebugEnabled()) continue;
                Tr.debug(sptc, "created server", memberDescriptionArray[i]);
            }
            LSDAddress[] lSDAddressArray2 = new LSDAddress[]{};
            lSDAddressArray = new LSDAddress[]{};
            if (sptc.isDebugEnabled()) {
                Tr.debug(sptc, "No LSD lists");
            }
            Object object = ClusterDescription.this.lock;
            synchronized (object) {
                ClusterDescription.this.epoch = l;
                ClusterDescription.this.selectionPolicy = by;
                ClusterDescription.this.serverList = memberDescriptionArray;
                ClusterDescription.this.currentState = new Memento(ClusterDescription.this.epoch, ClusterDescription.this.selectionPolicy, ClusterDescription.this.serverList, lSDAddressArray2, lSDAddressArray);
                if (bl) {
                    if (sptc.isDebugEnabled()) {
                        Tr.debug(sptc, "Add a new mapping in ConfigurationManager for the sgKey returned." + clusterKey);
                    }
                    ClusterDescription.this.sgKey = clusterKey;
                    ConfigurationManager.getInstance().addClusterDescription(clusterKey, clusterDescription);
                }
            }
            if (sptc.isEntryEnabled()) {
                Tr.exit(sptc, "parseVersion0", this);
            }
        }
    }

    public class Memento {
        final long m_epoch;
        final byte m_selectionPolicy;
        final MemberDescription[] m_serverList;
        final LSDAddress[] m_lsdList;
        final LSDAddress[] m_lsdMirroredList;

        Memento(long l, byte by, MemberDescription[] memberDescriptionArray, LSDAddress[] lSDAddressArray, LSDAddress[] lSDAddressArray2) {
            if (mtc.isEntryEnabled()) {
                Tr.entry(mtc, "<init>", new Object[]{String.valueOf(l), String.valueOf(by), String.valueOf(memberDescriptionArray.length), String.valueOf(lSDAddressArray.length), String.valueOf(lSDAddressArray2.length)});
            }
            this.m_epoch = l;
            this.m_selectionPolicy = by;
            this.m_serverList = new MemberDescription[memberDescriptionArray.length];
            System.arraycopy(memberDescriptionArray, 0, this.m_serverList, 0, memberDescriptionArray.length);
            this.m_lsdList = new LSDAddress[lSDAddressArray.length];
            System.arraycopy(lSDAddressArray, 0, this.m_lsdList, 0, lSDAddressArray.length);
            this.m_lsdMirroredList = new LSDAddress[lSDAddressArray2.length];
            System.arraycopy(lSDAddressArray2, 0, this.m_lsdMirroredList, 0, lSDAddressArray2.length);
            if (mtc.isEntryEnabled()) {
                Tr.exit(mtc, "<init>", this);
            }
        }

        public long getEpoch() {
            return this.m_epoch;
        }

        public byte getSelectionPolicy() {
            return this.m_selectionPolicy;
        }

        public LSDAddress[] getLSDAddressList() {
            if (mtc.isEntryEnabled()) {
                Tr.entry(mtc, "LSDAddressList", new Object[]{String.valueOf(this.m_lsdList.length)});
            }
            return this.m_lsdList;
        }

        public LSDAddress[] getMirroredLSDAddressList() {
            if (mtc.isEntryEnabled()) {
                Tr.entry(mtc, "getMirroredLSDAddressList", new Object[]{String.valueOf(ClusterDescription.this.lsdMirroredList.length)});
            }
            return this.m_lsdMirroredList;
        }

        public MemberDescription[] getMemberDescriptions() {
            return this.m_serverList;
        }

        public boolean hasReachableTarget() {
            for (int i = 0; i < this.m_serverList.length; ++i) {
                if (!this.m_serverList[i].isUsable()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.m_selectionPolicy + ":" + this.m_epoch;
        }
    }
}

