/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth.login;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.auth.login.ConfigFile;
import com.ibm.ws.security.auth.login.WCCMLoginConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;

public final class Configuration
extends javax.security.auth.login.Configuration {
    private ConfigFile _fileBasedConfig = null;
    private WCCMLoginConfig _wccmLoginConfig = null;
    private String _cname = null;
    private static final AuthPermission refreshLoginConfigPerm = new AuthPermission("refreshLoginConfiguration");
    private static final AuthPermission getLoginConfigPerm = new AuthPermission("getLoginConfiguration");
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$login$Configuration == null ? (class$com$ibm$ws$security$auth$login$Configuration = Configuration.class$("com.ibm.ws.security.auth.login.Configuration")) : class$com$ibm$ws$security$auth$login$Configuration), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$ws$security$auth$login$Configuration;

    public Configuration() throws Exception {
        try {
            this._cname = this.getClass().getName();
            Tr.audit((TraceComponent)tc, (String)"security.init.wccmjaas.setcfg", (Object)new Object[]{this._cname});
            this._fileBasedConfig = new ConfigFile();
            this._wccmLoginConfig = new WCCMLoginConfig();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"security.jaas.configNewInstance");
            throw new Exception("Failed to create a Configuration instance.");
        }
    }

    public String toString() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + getLoginConfigPerm.toString()));
            }
            securityManager.checkPermission(getLoginConfigPerm);
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append(this._cname + ": Dumping JAAS Configuration\n");
        stringBuffer.append(this._fileBasedConfig.toString2()).append(this._wccmLoginConfig.toString2());
        return stringBuffer.toString();
    }

    public synchronized AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this._cname + " :Entry: getAppConfigurationEntry(" + string + ")"));
        }
        if (string == null && string.length() == 0) {
            Tr.warning((TraceComponent)tc, (String)"security.jaas.noConfig", (Object)new Object[]{this._cname});
            return null;
        }
        List list = this._wccmLoginConfig.get(string);
        if (list == null || list.size() == 0) {
            return this._fileBasedConfig.getAppConfigurationEntry(string);
        }
        int n = list.size();
        AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[n];
        Iterator iterator = list.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            AppConfigurationEntry appConfigurationEntry = (AppConfigurationEntry)iterator.next();
            appConfigurationEntryArray[n2] = new AppConfigurationEntry(appConfigurationEntry.getLoginModuleName(), appConfigurationEntry.getControlFlag(), appConfigurationEntry.getOptions());
            ++n2;
        }
        return appConfigurationEntryArray;
    }

    public void updateWCCMConfig(HashMap hashMap) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + refreshLoginConfigPerm.toString()));
            }
            securityManager.checkPermission(refreshLoginConfigPerm);
        }
        this._wccmLoginConfig.update(hashMap);
    }

    public void updateWCCMConfig(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + refreshLoginConfigPerm.toString()));
            }
            securityManager.checkPermission(refreshLoginConfigPerm);
        }
        this._wccmLoginConfig.update(string);
    }

    public void refresh() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this._cname + "Performing Java 2 Security Permission Check ..." + "Expecting : " + refreshLoginConfigPerm.toString()));
            }
            securityManager.checkPermission(refreshLoginConfigPerm);
        }
        this._fileBasedConfig.refresh();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

