/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SafeFileOutputStream
extends OutputStream {
    protected File temp;
    protected File target;
    protected OutputStream output;
    protected boolean failed = false;
    protected static final String EXTENSION = ".bak";

    public SafeFileOutputStream(File file) throws IOException {
        this(file.getAbsolutePath(), null);
    }

    public SafeFileOutputStream(String targetName) throws IOException {
        this(targetName, null);
    }

    public SafeFileOutputStream(String targetPath, String tempPath) throws IOException {
        this.target = new File(targetPath);
        this.createTempFile(tempPath);
        if (!this.target.exists()) {
            if (!this.temp.exists()) {
                this.output = new BufferedOutputStream(new FileOutputStream(this.target));
                return;
            }
            this.copy(this.temp, this.target);
        }
        this.output = new BufferedOutputStream(new FileOutputStream(this.temp));
    }

    public void close() throws IOException {
        try {
            this.output.close();
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
        if (this.failed) {
            this.temp.delete();
        } else {
            this.commit();
        }
    }

    protected void commit() throws IOException {
        if (!this.temp.exists()) {
            return;
        }
        this.target.delete();
        this.copy(this.temp, this.target);
        this.temp.delete();
    }

    protected void copy(File sourceFile, File destinationFile) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        if (sourceFile.renameTo(destinationFile)) {
            return;
        }
        BufferedInputStream source = new BufferedInputStream(new FileInputStream(sourceFile));
        BufferedOutputStream destination = new BufferedOutputStream(new FileOutputStream(destinationFile));
        this.transferStreams(source, destination);
    }

    protected void createTempFile(String tempPath) throws IOException {
        if (tempPath == null) {
            tempPath = String.valueOf(this.target.getAbsolutePath()) + EXTENSION;
        }
        this.temp = new File(tempPath);
    }

    public void flush() throws IOException {
        try {
            this.output.flush();
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }

    public String getTempFilePath() {
        return this.temp.getAbsolutePath();
    }

    protected void transferStreams(InputStream source, OutputStream destination) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = source.read(buffer)) != -1) {
                destination.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var5_7 = null;
        try {
            source.close();
        }
        catch (IOException iOException) {}
        try {
            destination.close();
        }
        catch (IOException iOException) {}
    }

    public void write(int b) throws IOException {
        try {
            this.output.write(b);
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }
}

