/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class File
extends Resource
implements IFile {
    protected File(IPath path, Workspace container) {
        super(path, container);
    }

    public void appendContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        boolean force = (updateFlags & 1) != 0;
        boolean keepHistory = (updateFlags & 2) != 0;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.settingContents", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            Assert.isNotNull(content, "Content cannot be null.");
            try {
                try {
                    this.workspace.prepareOperation();
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    if (this.workspace.shouldValidate) {
                        this.workspace.validateSave(this);
                        info = this.getResourceInfo(false, false);
                        this.checkAccessible(this.getFlags(info));
                    }
                    this.internalSetContents(content, this.getLocalManager().locationFor(this), force, keepHistory, true, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.workspace.endOperation(true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            Object var8_11 = null;
            this.workspace.endOperation(true, Policy.subMonitorFor(monitor, Policy.buildWork));
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            monitor.done();
            throw throwable;
        }
        Object var10_14 = null;
        monitor.done();
    }

    public void appendContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.appendContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    public IFolder changeToFolder() throws CoreException {
        this.getPropertyManager().deleteProperties(this, 0);
        IFolder result = this.workspace.getRoot().getFolder(this.path);
        if (this.isLinked()) {
            IPath location = this.getRawLocation();
            this.delete(0, null);
            result.createLink(location, 16, null);
        } else {
            this.workspace.deleteResource(this);
            this.workspace.createResource(result, false);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        boolean force = (updateFlags & 1) != 0;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.creating", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            this.checkValidPath(this.path, 1);
            try {
                try {
                    boolean local;
                    this.workspace.prepareOperation();
                    this.checkDoesNotExist();
                    Container parent = (Container)this.getParent();
                    ResourceInfo info = parent.getResourceInfo(false, false);
                    parent.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    IPath location = this.getLocalManager().locationFor(this);
                    if (location == null) {
                        message = Policy.bind("localstore.locationUndefined", this.getFullPath().toString());
                        throw new ResourceException(271, this.getFullPath(), message, null);
                    }
                    java.io.File localFile = location.toFile();
                    if (force) {
                        if (!CoreFileSystemLibrary.isCaseSensitive() && localFile.exists()) {
                            String name = this.getLocalManager().getLocalName(localFile);
                            if (name != null && !localFile.getName().equals(name)) {
                                message = Policy.bind("resources.existsLocalDifferentCase", location.removeLastSegments(1).append(name).toOSString());
                                throw new ResourceException(275, this.getFullPath(), message, null);
                            }
                            this.delete(true, null);
                        }
                    } else if (localFile.exists()) {
                        String name;
                        if (!CoreFileSystemLibrary.isCaseSensitive() && (name = this.getLocalManager().getLocalName(localFile)) != null && !localFile.getName().equals(name)) {
                            message = Policy.bind("resources.existsLocalDifferentCase", location.removeLastSegments(1).append(name).toOSString());
                            throw new ResourceException(275, this.getFullPath(), message, null);
                        }
                        message = Policy.bind("resources.fileExists", localFile.getAbsolutePath());
                        throw new ResourceException(272, this.getFullPath(), message, null);
                    }
                    monitor.worked(Policy.opWork * 40 / 100);
                    this.workspace.createResource(this, false);
                    boolean bl = local = content != null;
                    if (local) {
                        try {
                            this.internalSetContents(content, location, force, false, false, Policy.subMonitorFor(monitor, Policy.opWork * 40 / 100));
                        }
                        catch (CoreException e) {
                            this.workspace.deleteResource(this);
                            location.toFile().delete();
                            throw e;
                        }
                    }
                    this.setLocal(local, 0, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
                    if (!local) {
                        this.getResourceInfo(true, true).setModificationStamp(-1L);
                    }
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                this.workspace.endOperation(true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            Object var12_17 = null;
            this.workspace.endOperation(true, Policy.subMonitorFor(monitor, Policy.buildWork));
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            monitor.done();
            this.ensureClosed(content);
            throw throwable;
        }
        Object var14_20 = null;
        monitor.done();
        this.ensureClosed(content);
    }

    public void create(InputStream content, boolean force, IProgressMonitor monitor) throws CoreException {
        this.create(content, force ? 1 : 0, monitor);
    }

    protected void ensureClosed(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public InputStream getContents() throws CoreException {
        return this.getContents(false);
    }

    public InputStream getContents(boolean force) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().read(this, force, null);
    }

    public int getEncoding() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().getEncoding(this);
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        return this.getLocalManager().getHistoryStore().getStates(this.getFullPath());
    }

    public int getType() {
        return 1;
    }

    protected void internalSetContents(InputStream content, IPath location, boolean force, boolean keepHistory, boolean append, IProgressMonitor monitor) throws CoreException {
        if (content == null) {
            content = new ByteArrayInputStream(new byte[0]);
        }
        this.getLocalManager().write(this, location, content, force, keepHistory, append, monitor);
        ResourceInfo info = this.getResourceInfo(false, true);
        info.incrementContentId();
        this.workspace.updateModificationStamp(info);
        this.updateProjectDescription();
        this.workspace.getAliasManager().updateAliases(this, location, 0, monitor);
    }

    public void setContents(IFileState content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.setContents(content.getContents(), updateFlags, monitor);
    }

    public void setContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        boolean force = (updateFlags & 1) != 0;
        boolean keepHistory = (updateFlags & 2) != 0;
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("resources.settingContents", this.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            try {
                try {
                    this.workspace.prepareOperation();
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    if (this.workspace.shouldValidate) {
                        this.workspace.validateSave(this);
                        info = this.getResourceInfo(false, false);
                        this.checkAccessible(this.getFlags(info));
                    }
                    this.internalSetContents(content, this.getLocalManager().locationFor(this), force, keepHistory, false, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.workspace.endOperation(true, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            Object var8_11 = null;
            this.workspace.endOperation(true, Policy.subMonitorFor(monitor, Policy.buildWork));
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            monitor.done();
            this.ensureClosed(content);
            throw throwable;
        }
        Object var10_14 = null;
        monitor.done();
        this.ensureClosed(content);
    }

    public void updateProjectDescription() throws CoreException {
        if (this.path.segmentCount() == 2 && this.path.segment(1).equals(".project")) {
            ((Project)this.getProject()).updateDescription();
        }
    }

    public void setContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(source.getContents(), updateFlags |= keepHistory ? 2 : 0, monitor);
    }
}

