/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.localstore.SafeFileOutputStream;
import org.eclipse.core.internal.resources.IModelObjectConstants;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.XMLWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ModelObjectWriter
implements IModelObjectConstants {
    protected String[] getReferencedProjects(ProjectDescription description) {
        IProject[] projects = description.getReferencedProjects();
        String[] result = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            result[i] = projects[i].getName();
            ++i;
        }
        return result;
    }

    public void write(Object object, OutputStream output) throws IOException {
        try {
            XMLWriter writer = new XMLWriter(output);
            this.write(object, writer);
            writer.flush();
            writer.close();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            output.close();
            throw throwable;
        }
        Object var4_6 = null;
        output.close();
    }

    protected void write(Object obj, XMLWriter writer) throws IOException {
        if (obj instanceof BuildCommand) {
            this.write((BuildCommand)obj, writer);
            return;
        }
        if (obj instanceof ProjectDescription) {
            this.write((ProjectDescription)obj, writer);
            return;
        }
        if (obj instanceof WorkspaceDescription) {
            this.write((WorkspaceDescription)obj, writer);
            return;
        }
        if (obj instanceof LinkDescription) {
            this.write((LinkDescription)obj, writer);
            return;
        }
        writer.printTabulation();
        writer.println(obj.toString());
    }

    public void write(Object object, IPath location, IPath tempLocation) throws IOException {
        block3: {
            SafeFileOutputStream file = null;
            String tempPath = tempLocation == null ? null : tempLocation.toOSString();
            try {
                file = new SafeFileOutputStream(location.toOSString(), tempPath);
                this.write(object, file);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (file != null) {
                    file.close();
                }
                throw throwable;
            }
            Object var6_8 = null;
            if (file == null) break block3;
            file.close();
        }
    }

    protected void write(String name, String elementTagName, String[] array, XMLWriter writer) throws IOException {
        writer.startTag(name, null);
        int i = 0;
        while (i < array.length) {
            writer.printSimpleTag(elementTagName, array[i]);
            ++i;
        }
        writer.endTag(name);
    }

    protected void write(String name, Collection collection, XMLWriter writer) throws IOException {
        writer.startTag(name, null);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.write(it.next(), writer);
        }
        writer.endTag(name);
    }

    protected void write(String name, Map table, XMLWriter writer) throws IOException {
        writer.startTag(name, null);
        Iterator it = table.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            writer.startTag("dictionary", null);
            writer.printSimpleTag("key", key);
            writer.printSimpleTag("value", value);
            writer.endTag("dictionary");
        }
        writer.endTag(name);
    }

    protected void write(BuildCommand command, XMLWriter writer) throws IOException {
        writer.startTag("buildCommand", null);
        if (command != null) {
            writer.printSimpleTag("name", command.getName());
            this.write("arguments", command.getArguments(false), writer);
        }
        writer.endTag("buildCommand");
    }

    protected void write(LinkDescription description, XMLWriter writer) throws IOException {
        writer.startTag("link", null);
        if (description != null) {
            writer.printSimpleTag("name", description.getName());
            writer.printSimpleTag("type", Integer.toString(description.getType()));
            writer.printSimpleTag("location", description.getLocation());
        }
        writer.endTag("link");
    }

    protected void write(ProjectDescription description, XMLWriter writer) throws IOException {
        writer.startTag("projectDescription", null);
        if (description != null) {
            writer.printSimpleTag("name", description.getName());
            String comment = description.getComment();
            writer.printSimpleTag("comment", comment == null ? "" : comment);
            this.write("projects", "project", this.getReferencedProjects(description), writer);
            this.write("buildSpec", Arrays.asList(description.getBuildSpec(false)), writer);
            this.write("natures", "nature", description.getNatureIds(false), writer);
            HashMap links = description.getLinks();
            if (links != null) {
                this.write("linkedResources", links.values(), writer);
            }
        }
        writer.endTag("projectDescription");
    }

    protected void write(WorkspaceDescription description, XMLWriter writer) throws IOException {
        writer.startTag("workspaceDescription", null);
        if (description != null) {
            writer.printSimpleTag("name", description.getName());
            writer.printSimpleTag("autobuild", description.isAutoBuilding() ? "1" : "0");
            writer.printSimpleTag("snapshotInterval", new Long(description.getSnapshotInterval()));
            writer.printSimpleTag("fileStateLongevity", new Long(description.getFileStateLongevity()));
            writer.printSimpleTag("maxFileStateSize", new Long(description.getMaxFileStateSize()));
            writer.printSimpleTag("maxFileStates", new Integer(description.getMaxFileStates()));
            String[] order = description.getBuildOrder(false);
            if (order != null) {
                this.write("buildOrder", "project", order, writer);
            }
        }
        writer.endTag("workspaceDescription");
    }
}

