/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Hashtable;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Queue;
import org.eclipse.core.internal.utils.Semaphore;
import org.eclipse.core.resources.WorkspaceLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkManager
implements IManager {
    protected int currentOperationId = -1;
    protected Hashtable identifiers = new Hashtable(10);
    protected int nextId = 0;
    protected Workspace workspace;
    protected WorkspaceLock workspaceLock;
    protected Queue operations;
    protected Thread currentOperationThread;
    public static final int OPERATION_NONE = -1;
    public static final int OPERATION_EMPTY = 0;

    public WorkManager(Workspace workspace) {
        this.workspace = workspace;
        this.operations = new Queue();
    }

    public synchronized Semaphore acquire() {
        if (this.isCurrentOperation()) {
            return null;
        }
        if (this.currentOperationId == -1 && this.operations.isEmpty()) {
            this.updateCurrentOperation(this.getOperationId());
            return null;
        }
        return this.enqueue(new Semaphore(Thread.currentThread()));
    }

    public void avoidAutoBuild() {
        this.getIdentifier((Thread)this.currentOperationThread).avoidAutoBuild = true;
    }

    public void checkIn() throws CoreException {
        block4: while (true) {
            try {
                while (true) {
                    try {
                        if (this.getWorkspaceLock().acquire()) {
                            Object var1_1 = null;
                            this.incrementPreparedOperations();
                            return;
                        }
                        Thread.sleep(50L);
                        continue block4;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.incrementPreparedOperations();
                throw throwable;
            }
        }
    }

    public synchronized void checkOut() throws CoreException {
        this.decrementPreparedOperations();
        this.rebalanceNestedOperations();
        if (this.getPreparedOperationDepth() > 0) {
            return;
        }
        this.getWorkspaceLock().release();
    }

    private void decrementPreparedOperations() {
        --this.getIdentifier((Thread)this.currentOperationThread).preparedOperations;
    }

    private synchronized Semaphore enqueue(Semaphore newSemaphore) {
        Semaphore semaphore = (Semaphore)this.operations.get(newSemaphore);
        if (semaphore == null) {
            this.operations.add(newSemaphore);
            return newSemaphore;
        }
        return semaphore;
    }

    public synchronized Thread getCurrentOperationThread() {
        return this.currentOperationThread;
    }

    private Identifier getIdentifier(Thread key) {
        Assert.isNotNull(key, "The thread should never be null.");
        Identifier identifier = (Identifier)this.identifiers.get(key);
        if (identifier == null) {
            identifier = this.getNewIdentifier();
            this.identifiers.put(key, identifier);
        }
        return identifier;
    }

    private Identifier getNewIdentifier() {
        Identifier identifier = new Identifier();
        identifier.operationId = this.getNextOperationId();
        return identifier;
    }

    private int getNextOperationId() {
        return ++this.nextId;
    }

    private int getOperationId() {
        return this.getIdentifier((Thread)Thread.currentThread()).operationId;
    }

    public int getPreparedOperationDepth() {
        return this.getIdentifier((Thread)this.currentOperationThread).preparedOperations;
    }

    private WorkspaceLock getWorkspaceLock() throws CoreException {
        if (this.workspaceLock == null) {
            this.workspaceLock = this.workspaceLock = new WorkspaceLock(this.workspace);
        }
        return this.workspaceLock;
    }

    boolean isBalanced() {
        Identifier identifier = this.getIdentifier(this.currentOperationThread);
        return identifier.nestedOperations == identifier.preparedOperations;
    }

    void incrementNestedOperations() {
        ++this.getIdentifier((Thread)this.currentOperationThread).nestedOperations;
    }

    private void incrementPreparedOperations() {
        ++this.getIdentifier((Thread)this.currentOperationThread).preparedOperations;
    }

    public synchronized boolean isCurrentOperation() {
        return this.currentOperationId == this.getOperationId();
    }

    public synchronized boolean isNextOperation(Runnable runnable) {
        Semaphore next = (Semaphore)this.operations.peek();
        return next != null && next.getRunnable() == runnable;
    }

    public void operationCanceled() {
        this.getIdentifier((Thread)this.currentOperationThread).operationCanceled = true;
    }

    public void rebalanceNestedOperations() {
        Identifier identifier = this.getIdentifier(this.currentOperationThread);
        identifier.nestedOperations = identifier.preparedOperations;
    }

    public synchronized void release() {
        this.resetOperationId();
        Semaphore next = (Semaphore)this.operations.peek();
        this.updateCurrentOperation(-1);
        if (next != null) {
            next.release();
        }
    }

    private void resetOperationId() {
        this.identifiers.remove(this.currentOperationThread);
    }

    public void setBuild(boolean build) {
        Identifier identifier = this.getIdentifier(this.currentOperationThread);
        if (identifier.preparedOperations == identifier.nestedOperations) {
            identifier.shouldBuild = identifier.shouldBuild || build;
        }
    }

    public void setWorkspaceLock(WorkspaceLock lock) {
        Assert.isNotNull(lock);
        this.workspaceLock = lock;
    }

    public boolean shouldBuild() {
        Identifier identifier = this.getIdentifier(this.currentOperationThread);
        if (!identifier.avoidAutoBuild && identifier.shouldBuild) {
            return !identifier.operationCanceled;
        }
        return false;
    }

    public void shutdown(IProgressMonitor monitor) {
        this.currentOperationId = -1;
        this.identifiers = null;
        this.nextId = 0;
    }

    public void startup(IProgressMonitor monitor) {
    }

    public synchronized void updateCurrentOperation() {
        this.operations.remove();
        this.updateCurrentOperation(this.getOperationId());
    }

    private void updateCurrentOperation(int newID) {
        this.currentOperationId = newID;
        this.currentOperationThread = newID == -1 ? null : Thread.currentThread();
    }

    public boolean isTreeLocked() {
        return this.workspace.isTreeLocked();
    }

    class Identifier {
        int operationId = 0;
        int preparedOperations = 0;
        int nestedOperations = 0;
        boolean shouldBuild = false;
        boolean avoidAutoBuild = false;
        boolean operationCanceled = false;

        Identifier() {
        }
    }
}

