/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.res.StringManager;

public class InternalOutputBuffer
implements OutputBuffer {
    protected static StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    protected Response response;
    protected MimeHeaders headers;
    protected boolean committed;
    protected boolean finished;
    protected byte[] buf;
    protected int pos;
    protected byte[] headerBuffer;
    protected OutputStream outputStream;
    protected OutputBuffer outputStreamOutputBuffer;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;

    public InternalOutputBuffer(Response response) {
        this(response, 32000);
    }

    public InternalOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.headers = response.getMimeHeaders();
        this.headerBuffer = new byte[headerBufferSize];
        this.buf = this.headerBuffer;
        this.outputStreamOutputBuffer = new OutputStreamOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        int i = 0;
        while (i < this.filterLibrary.length) {
            newFilterLibrary[i] = this.filterLibrary[i];
            ++i;
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void clearFilters() {
        this.filterLibrary = new OutputFilter[0];
        this.lastActiveFilter = -1;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            int i = 0;
            while (i <= this.lastActiveFilter) {
                if (this.activeFilters[i] == filter) {
                    return;
                }
                ++i;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.response.recycle();
    }

    public void recycle() {
        this.response.recycle();
        this.outputStream = null;
        this.buf = this.headerBuffer;
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void nextRequest() {
        this.response.recycle();
        this.buf = this.headerBuffer;
        int i = 0;
        while (i <= this.lastActiveFilter) {
            this.activeFilters[i].recycle();
            ++i;
        }
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
    }

    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.finished = true;
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.outputStream.write(Constants.ACK);
        }
    }

    public void sendStatus() {
        this.write("HTTP/1.1 ");
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write("200");
                break;
            }
            case 400: {
                this.write("400");
                break;
            }
            case 404: {
                this.write("404");
                break;
            }
            default: {
                this.write(status);
            }
        }
        this.write(" ");
        if (this.response.getMessage() == null) {
            this.write(HttpMessages.getMessage((int)status));
        } else {
            this.write(this.response.getMessage());
        }
        this.write("\r\n");
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        this.write(name);
        this.write(": ");
        this.write(value);
        this.write("\r\n");
    }

    public void sendHeader(ByteChunk name, ByteChunk value) {
        this.write(name);
        this.write(": ");
        this.write(value);
        this.write("\r\n");
    }

    public void sendHeader(String name, String value) {
        this.write(name);
        this.write(": ");
        this.write(value);
        this.write("\r\n");
    }

    public void endHeaders() {
        this.write("\r\n");
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.ACTION_COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(chunk, res);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk, res);
    }

    protected void commit() throws IOException {
        if (this.pos > 0) {
            this.outputStream.write(this.buf, 0, this.pos);
            this.outputStream.flush();
        }
        this.committed = true;
        this.response.setCommitted(true);
    }

    protected void write(MessageBytes mb) {
        mb.toBytes();
        if (mb.getType() == 2) {
            ByteChunk bc = mb.getByteChunk();
            this.write(bc);
        } else {
            this.write(mb.toString());
        }
    }

    protected void write(ByteChunk bc) {
        System.arraycopy(bc.getBytes(), bc.getStart(), this.buf, this.pos, bc.getLength());
        this.pos += bc.getLength();
    }

    protected void write(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if ((c & 0xFF00) != 0) {
                // empty if block
            }
            this.buf[this.pos++] = (byte)c;
            ++i;
        }
    }

    protected void write(int i) {
        this.write(String.valueOf(i));
    }

    protected class OutputStreamOutputBuffer
    implements OutputBuffer {
        protected OutputStreamOutputBuffer() {
        }

        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            InternalOutputBuffer.this.outputStream.write(chunk.getBuffer(), chunk.getStart(), chunk.getLength());
            return chunk.getLength();
        }
    }
}

