/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.httpsession.IHttpSession;
import com.ibm.ws.webcontainer.httpsession.MemorySessionData;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionData;
import java.util.Enumeration;

public class MemorySessionContext
extends SessionContext {
    public MemorySessionContext(SessionContextParameters sessionContextParameters, SessionApplicationParameters sessionApplicationParameters) {
        super(sessionContextParameters, sessionApplicationParameters);
    }

    synchronized void initializeParameters() {
        if (turnOffCacheId) {
            this.cacheIdLength = 0;
            defaultCacheId = "";
        }
        super.initializeParameters();
    }

    IHttpSession createSessionData(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MemorySessionContext.createSessionData");
        }
        return new MemorySessionData(this, string);
    }

    void performInvalidation() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MemorySessionContext.performInvalidation");
        }
        this.processInvalidList();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"MemorySessionContext.performInvalidation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processInvalidList() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"MemorySessionContext.processInvalidList");
        }
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.tableKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SessionData sessionData = (SessionData)this.mSessions.get(string);
            if (sessionData == null) continue;
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (sessionData.isValid() && sessionData.getMaxInactiveInterval() != -1) {
                    boolean bl;
                    long l2 = sessionData.getLastAccTime();
                    long l3 = 1000 * sessionData.getMaxInactiveInterval();
                    boolean bl2 = bl = sessionData.getInServiceMethodCount() > 0;
                    if (!bl && l2 <= l - l3 || bl && l2 <= l - 3L * l3) {
                        sessionData.internalInvalidate();
                    }
                }
            }
        }
    }

    void invalidateAllMemorySessions() {
        Enumeration enumeration = this.tableKeys();
        while (enumeration.hasMoreElements()) {
            SessionData sessionData = (SessionData)this.tableGet(enumeration.nextElement());
            sessionData.internalInvalidate();
        }
    }
}

