/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionContextRegistry;

class SessionAlarmListener
implements AlarmListener {
    private short mode;
    public static final short INVALIDATION = 1;
    public static final short TIME_BASED_WRITE = 2;
    public static final short VOTE_INFO = 3;
    private static SessionAlarmListener invalList = new SessionAlarmListener(1);
    private static SessionAlarmListener timeBased = new SessionAlarmListener(2);
    private static SessionAlarmListener voteInfo = new SessionAlarmListener(3);

    private SessionAlarmListener(short s) {
        this.mode = s;
    }

    public void alarm(Object object) {
        if (SessionContext.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)SessionContext.tc, (String)"SessionAlarmListener.alarm");
        }
        SessionContext sessionContext = null;
        if (this.mode == 1) {
            sessionContext = (SessionContext)object;
            sessionContext.pollInvalidations();
        } else if (this.mode == 2) {
            sessionContext = (SessionContext)object;
            sessionContext.asyncExternalWrite();
        } else if (this.mode == 3) {
            SessionContextRegistry.sendLocalVotes();
        }
        if (SessionContext.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)SessionContext.tc, (String)"SessionAlarmListener.alarm");
        }
    }

    static Alarm startInvalidationAlarm(SessionContext sessionContext, long l) {
        if (SessionContext.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)SessionContext.tc, (String)("SessionAlarmListener.registerForInvalidation  for application " + sessionContext.getAppName() + " with alarm interval of " + l + "ms"));
        }
        return AlarmManager.create((long)l, (AlarmListener)invalList, (Object)sessionContext);
    }

    static Alarm startTimeBasedWriteAlarm(SessionContext sessionContext, long l) {
        if (SessionContext.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)SessionContext.tc, (String)("SessionAlarmListener.registerForInvalidation  for application " + sessionContext.getAppName() + " with alarm interval of " + l + "ms"));
        }
        return AlarmManager.create((long)l, (AlarmListener)timeBased, (Object)sessionContext);
    }

    static Alarm startVoteAlarm(Object object, long l) {
        if (SessionContext.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)SessionContext.tc, (String)("SessionAlarmListener.registerForVotes  with alarm interval of " + l + "ms"));
        }
        return AlarmManager.create((long)l, (AlarmListener)voteInfo, (Object)object);
    }

    static void stopListening(Alarm alarm) {
        alarm.cancel();
    }
}

