/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameterException;
import com.ibm.ws.webcontainer.httpsession.WebAppSessionSupport;
import javax.servlet.ServletContext;

public class SessionApplicationParameters {
    private boolean sapInitialized = false;
    private boolean sapInvalid = true;
    private String sapAppName = null;
    private long sapSessionTimeout = 1800L;
    private boolean sapDistributableWebApp;
    private ServletContext sapServletContext;
    private WebAppSessionSupport sapAppClassLoader = null;
    private String _J2EEName = null;

    public SessionApplicationParameters(String string, long l, boolean bl, ServletContext servletContext, WebAppSessionSupport webAppSessionSupport, String string2) throws SessionApplicationParameterException {
        if (string == null) {
            throw new SessionApplicationParameterException("Application name is null");
        }
        if (webAppSessionSupport == null) {
            throw new SessionApplicationParameterException("Application class loader is null");
        }
        this.sapAppName = string;
        this._J2EEName = string2;
        this.sapSessionTimeout = l != -1L ? l * 60L : -1L;
        this.sapDistributableWebApp = bl;
        this.sapServletContext = servletContext;
        this.sapAppClassLoader = webAppSessionSupport;
        this.sapInitialized = true;
        this.sapInvalid = false;
    }

    synchronized void destroy() {
        this.sapInvalid = true;
    }

    boolean isValid() {
        return !this.sapInvalid;
    }

    WebAppSessionSupport getAppClassLoader() throws SessionApplicationParameterException {
        if (this.sapInvalid) {
            throw new SessionApplicationParameterException("This Application Parameter Object is no longer valid.");
        }
        return this.sapAppClassLoader;
    }

    String getAppName() throws SessionApplicationParameterException {
        if (this.sapInvalid) {
            throw new SessionApplicationParameterException("This Application Parameter Object is no longer valid.");
        }
        return this.sapAppName;
    }

    long getSessionTimeout() throws SessionApplicationParameterException {
        if (this.sapInvalid) {
            throw new SessionApplicationParameterException("This Application Parameter Object is no longer valid.");
        }
        return this.sapSessionTimeout;
    }

    boolean getDistributableWebApp() throws SessionApplicationParameterException {
        if (this.sapInvalid) {
            throw new SessionApplicationParameterException("This Application Parameter Object is no longer valid.");
        }
        return this.sapDistributableWebApp;
    }

    ServletContext getServletContext() throws SessionApplicationParameterException {
        if (this.sapInvalid) {
            throw new SessionApplicationParameterException("This Application Parameter Object is no longer valid.");
        }
        return this.sapServletContext;
    }

    String getJ2EEName() {
        return this._J2EEName;
    }
}

