/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.websphere.servlet.session.IBMSessionListener;
import com.ibm.websphere.servlet.session.UnauthorizedSessionRequestException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.httpsession.BaseSessionContext;
import com.ibm.ws.webcontainer.httpsession.HttpSessionSystemProperties;
import com.ibm.ws.webcontainer.httpsession.IDFactory;
import com.ibm.ws.webcontainer.httpsession.IHttpSession;
import com.ibm.ws.webcontainer.httpsession.SessionAlarmListener;
import com.ibm.ws.webcontainer.httpsession.SessionApplicationParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextMBeanAdapter;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameterException;
import com.ibm.ws.webcontainer.httpsession.SessionContextParameters;
import com.ibm.ws.webcontainer.httpsession.SessionContextRegistry;
import com.ibm.ws.webcontainer.httpsession.SessionCrossoverStackTrace;
import com.ibm.ws.webcontainer.httpsession.SessionData;
import com.ibm.ws.webcontainer.httpsession.SessionIDGen;
import com.ibm.ws.webcontainer.httpsession.SessionMgrComponentImpl;
import com.ibm.ws.webcontainer.httpsession.SessionSimpleHashMap;
import com.ibm.ws.webcontainer.httpsession.SessionTrackingPMIApplicationData;
import com.ibm.ws.webcontainer.httpsession.TooManySessionsException;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaData;
import com.ibm.ws.webcontainer.session.IHttpSessionContext;
import com.ibm.ws.webcontainer.srt.IExtendedRequest;
import com.ibm.ws.webcontainer.util.EncodeCloneID;
import com.ibm.ws.webcontainer.webapp.WebApp;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public abstract class SessionContext
extends BaseSessionContext
implements IHttpSessionContext {
    private SessionContext self;
    static NLS rb;
    public static int BASE32;
    public static int BASE64;
    int tableSize = 1000;
    private boolean allowInfinite = true;
    private static final String overflowId = "overflowed-session";
    private SessionData overflowData = null;
    private boolean securityEnabled;
    protected long mInvalidationCheckPollInterval = -1L;
    private long mSessionInvalidationTime = 1800L;
    private boolean mSessionTrackingActive = true;
    private boolean mUsingCookies = true;
    private boolean mUsingURL = false;
    private boolean mURLProtocolSwitchRewritingActive = false;
    private String mSessionCookieName = "JSESSION";
    private String mSessionCookieComment = "Session id";
    private String mSessionCookieDomain;
    private int mSessionCookieMaxAge = -1;
    private String mSessionCookiePath = "/";
    private boolean mSessionCookieSecure = false;
    private Object counterSyncher = new Object();
    protected HashMap mSessions;
    private int mSessionIdCounter = 0;
    private static Random randIdGen;
    private static InetAddress mLocalHost;
    private static byte[] mSessionIdTemplate;
    private static final char[] sBitChars;
    private static final int[] sSecondByteMasks;
    protected SessionContextParameters mParams = null;
    private boolean completedStartup;
    protected SessionApplicationParameters scAppParms = null;
    protected SessionTrackingPMIApplicationData scPmiData = null;
    private boolean scEnablePmi = true;
    private boolean stopSession = false;
    static String cloneId;
    static int cloneIdLength;
    private static IDFactory sessionIDFactory;
    private boolean integrateWASSec = false;
    protected boolean useSSLId = false;
    static char cloneSeparator;
    private static final String timeoutSeparator = "*";
    protected boolean sessionAttributeListener = false;
    protected boolean sessionListener = false;
    protected ArrayList mHttpSessionAttributeListeners = new ArrayList();
    protected ArrayList mHttpSessionListeners = new ArrayList();
    protected ServletContext mServletContext = null;
    private static boolean useJCE;
    protected static boolean passivateUsingCache;
    protected static boolean passivateAtWrite;
    protected boolean timedOutAffinityEnabled = true;
    private long affinityTimeOut = 30L;
    private boolean allowSerializedSessionAccess = false;
    private int serializedSessionAccessMaxWaitTime = 0;
    private boolean accessSessionOnTimeout = false;
    private Alarm invalidaterAlarm;
    private SessionContextMBeanAdapter mbeanAdapter = null;
    private static String sessUrlRewritePrefix;
    private static final String dcookieName = "SSLJSESSION";
    protected int cacheIdLength = 4;
    protected static int sessionIDLength;
    protected int cacheIdPlusIdlength = this.cacheIdLength + sessionIDLength;
    private static boolean trackGCCount;
    private static boolean idReuse;
    private static boolean noSwitchOver;
    static boolean useOracleBLOB;
    static boolean turnOffCacheId;
    static boolean turnOffCloneId;
    static String defaultCacheId;
    HashMap createSync = new HashMap();
    static boolean useBase32;
    boolean mIBMSessionListenerImplemented = false;
    static WSThreadLocal currentThreadSessionId;
    static WSThreadLocal currentThreadDispatchCount;
    static boolean debugSessionCrossover;
    boolean crossoverUserThreadWarningIssued = false;
    boolean useInformixDecimal = false;
    private static String cloneSep;
    private String cloneIdWithSep = null;
    static final String[] unSecStrs;
    private int _refCount = 1;
    protected int maxSessionIdentifierLength = 1024;

    SessionContext(SessionContextParameters sessionContextParameters, SessionApplicationParameters sessionApplicationParameters) {
        this.mParams = sessionContextParameters;
        this.scAppParms = sessionApplicationParameters;
        if (randIdGen == null) {
            randIdGen = new Random(System.currentTimeMillis());
        }
        this.self = this;
        this.mbeanAdapter = new SessionContextMBeanAdapter(this);
        this.scPmiData = new SessionTrackingPMIApplicationData(sessionApplicationParameters, this.mbeanAdapter);
        try {
            this.setServletContext(this.scAppParms.getServletContext());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.moreInit", (String)"294", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        try {
            this.setProperties(SessionMgrComponentImpl.getWebContainerProperties());
            this.setThreadContext();
            this.initializeParameters();
            this.moreInit();
        }
        finally {
            this.unsetThreadContext();
        }
    }

    void moreInit() {
        this.mSessions = this.createSessionTable();
        if (!this.allowInfinite && this.overflowData == null) {
            this.overflowData = (SessionData)this.createSessionData(overflowId);
            this.overflowData.setValidity(false);
            this.overflowData.overflowed = true;
            this.overflowData.setSessionContext(this);
        }
        if (useJCE && sessionIDFactory == null) {
            try {
                sessionIDFactory = useBase32 ? new SessionIDGen(sessionIDLength, BASE32) : new SessionIDGen(sessionIDLength, BASE64);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.moreInit", (String)"264", (Object)this);
                Tr.error((TraceComponent)tc, (String)"SessionContext.loadJCEFail");
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                sessionIDFactory = null;
            }
        }
        this.startSessionContext();
        if (debugSessionCrossover) {
            currentThreadSessionId = new WSThreadLocal();
            currentThreadDispatchCount = new WSThreadLocal();
        }
        this.completedStartup = true;
    }

    static String getXString(String string, String string2) {
        if (rb == null) {
            rb = new NLS("com.ibm.servlet.resources.personalization");
        }
        if (rb != null) {
            return rb.getString(string, string2);
        }
        return string2;
    }

    void startAlarms() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.startAlarms");
        }
        this.invalidaterAlarm = SessionAlarmListener.startInvalidationAlarm(this, this.mInvalidationCheckPollInterval * 1000L);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.startAlarms");
        }
    }

    void stopAlarms() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.stopAlarms");
        }
        SessionAlarmListener.stopListening(this.invalidaterAlarm);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.stopAlarms");
        }
    }

    HashMap createSessionTable() {
        return new SessionSimpleHashMap(this.tableSize, this.allowInfinite);
    }

    void startSessionContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.startSessionContext");
        }
        if (sessionIDFactory == null) {
            this.initializeSessionIdTemplate();
        }
        this.startAlarms();
        this.stopSession = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.startSessionContext");
        }
    }

    void stopSessionContext(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.stopSessionContext");
        }
        if (this.getAppName() == "GLOBAL_HTTP_SESSION_CONTEXT") {
            this.stopListeners(string);
        }
        this.decrementRefCount();
        if (this._refCount > 0) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.stopSessionContext: Reference count is not zero, so returning without stopping");
            return;
        }
        this.invalidateAllMemorySessions();
        this.stopSession = true;
        this.tableClear();
        try {
            SessionContextRegistry.remove(this.scAppParms.getAppName());
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.stop", (String)"2237", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
        this.scPmiData.unregister();
        this.mbeanAdapter.unregisterMBean();
        this.mSessionIdCounter = 0;
        this.stopAlarms();
        this.completedStartup = false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.stopSessionContext");
        }
    }

    void stopListeners(String string) {
        ArrayList arrayList;
        int n;
        if (string == null) {
            Tr.warning((TraceComponent)tc, (String)"SessionContext.stopListeners: j2eename is null");
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.stopListeners for " + string));
        }
        for (n = this.mHttpSessionListeners.size() - 1; n >= 0; --n) {
            arrayList = (ArrayList)this.mHttpSessionListeners.get(n);
            if (!string.equals((String)arrayList.get(0))) continue;
            this.mHttpSessionListeners.remove(n);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("SessionContext.stopListeners: stopping http session listener for: " + string));
        }
        if (this.mHttpSessionListeners.size() == 0) {
            this.sessionListener = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext.stopListeners: stopped all http session listeners");
            }
        }
        for (n = this.mHttpSessionAttributeListeners.size() - 1; n >= 0; --n) {
            arrayList = (ArrayList)this.mHttpSessionAttributeListeners.get(n);
            if (!string.equals((String)arrayList.get(0))) continue;
            this.mHttpSessionAttributeListeners.remove(n);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("SessionContext.stopListeners: stopping http session attribute listener for: " + string));
        }
        if (this.mHttpSessionAttributeListeners.size() == 0) {
            this.sessionAttributeListener = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext.stopListeners: stopped all http session attribute listeners");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.stopListeners");
        }
    }

    void resetmSessions() {
        this.mSessions = null;
    }

    private void setSessionContextParameters(SessionContextParameters sessionContextParameters) {
        this.mParams = sessionContextParameters;
        this.initializeParameters();
    }

    SessionContextParameters getSessionContextParameters() {
        return this.mParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress getLocalHost() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getLocalHost");
        }
        if (mLocalHost == null) {
            SessionContext sessionContext = this;
            synchronized (sessionContext) {
                try {
                    mLocalHost = (InetAddress)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws UnknownHostException {
                            return InetAddress.getLocalHost();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.getLocalHost", (String)"423", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.getLocalHostError");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)privilegedActionException);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.getLocalHost", (String)"427", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.getLocalHostError");
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
                }
            }
        }
        return mLocalHost;
    }

    void initializeSessionIdTemplate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.initializeSessionIdTemplate");
        }
        int n = 14;
        n = useBase32 ? sessionIDLength * 5 / 8 + 1 : sessionIDLength * 6 / 8 + 1;
        mSessionIdTemplate = new byte[n];
        int n2 = 8;
        byte[] byArray = this.getLocalHost().getAddress();
        System.arraycopy(byArray, 0, mSessionIdTemplate, n2, 4);
        n2 += 4;
        int n3 = randIdGen.nextInt();
        SessionContext.mSessionIdTemplate[n2++] = (byte)(n3 >> 8 & 0xFF);
        SessionContext.mSessionIdTemplate[n2++] = (byte)(n3 & 0xFF);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.initializeSessionIdTemplate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateSessionIdCount() {
        int n = 0;
        Object object = this.counterSyncher;
        synchronized (object) {
            n = this.mSessionIdCounter++;
        }
        return n;
    }

    String generateSessionId() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.generateSessionId");
        }
        if (sessionIDFactory != null) {
            return sessionIDFactory.getNextID();
        }
        byte[] byArray = new byte[mSessionIdTemplate.length];
        System.arraycopy(mSessionIdTemplate, 0, byArray, 0, mSessionIdTemplate.length);
        int n2 = 0;
        int n3 = n = this.generateSessionIdCount();
        long l = System.currentTimeMillis();
        n3 = n3 * 39 + (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        n3 = n3 * 39 + (int)(l & 0xFFFFFFFFFFFFFFFFL);
        byArray[n2++] = (byte)(n3 >> 24 & 0xFF);
        byArray[n2++] = (byte)(n3 >> 16 & 0xFF);
        byArray[n2++] = (byte)(n3 >> 8 & 0xFF);
        byArray[n2++] = (byte)(n3 & 0xFF);
        byArray[n2++] = (byte)(n >> 24 & 0xFF);
        byArray[n2++] = (byte)(n >> 16 & 0xFF);
        byArray[n2++] = (byte)(n >> 8 & 0xFF);
        byArray[n2++] = (byte)(n & 0xFF);
        return SessionContext.convertSessionIdBytesToSessionId(byArray);
    }

    static String convertSessionIdBytesToSessionId(byte[] byArray) {
        if (useBase32) {
            return SessionContext.convertSessionIdBytesToSessionIdBase32(byArray);
        }
        return SessionContext.convertSessionIdBytesToSessionIdBase64(byArray);
    }

    static String convertSessionIdBytesToSessionIdBase32(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.convertSessionIdBytesToSessionId");
        }
        int n = byArray.length * 8;
        char[] cArray = new char[sessionIDLength];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < byArray.length && n4 < sessionIDLength) {
            int n5 = 0;
            if (n3 <= 3) {
                n5 = byArray[n2] >> 3 - n3 & 0x1F;
            } else {
                n5 = byArray[n2] << 5 - (8 - n3);
                if (n2 + 1 < byArray.length) {
                    int n6 = byArray[n2 + 1] >> 8 - (5 - (8 - n3));
                    n5 |= (n6 &= sSecondByteMasks[5 - (8 - n3)]);
                }
                n5 &= 0x1F;
            }
            cArray[n4++] = sBitChars[n5];
            if ((n3 += 5) < 8) continue;
            ++n2;
            n3 -= 8;
        }
        return new String(cArray);
    }

    static String convertSessionIdBytesToSessionIdBase64(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.convertSessionIdBytesToSessionId");
        }
        int n = byArray.length * 8;
        char[] cArray = new char[sessionIDLength];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < byArray.length && n4 < sessionIDLength) {
            int n5 = 0;
            if (n3 < 3) {
                n5 = byArray[n2] >> 2 - n3 & 0x3F;
            } else {
                n5 = byArray[n2] << 6 - (8 - n3);
                if (n2 + 1 < byArray.length) {
                    int n6 = byArray[n2 + 1] >> 8 - (6 - (8 - n3));
                    n5 |= (n6 &= sSecondByteMasks[6 - (8 - n3)]);
                }
                n5 &= 0x3F;
            }
            cArray[n4++] = sBitChars[n5];
            if ((n3 += 6) < 8) continue;
            ++n2;
            n3 -= 8;
        }
        return new String(cArray);
    }

    boolean insertSessionOnCreation(String string, SessionData sessionData) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.insertSessionOnCreation" + string));
        }
        if ((object = this.tableGet(string)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:insertSessionOnCreation: Detected duplicate id.  Try Again");
            }
            return true;
        }
        this.tablePut(string, sessionData);
        return false;
    }

    private String getAuthenticatedUser() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getAuthenticatedUser");
        }
        if ((string = SecurityContext.getUser()) == null) {
            return "anonymous";
        }
        return string;
    }

    public Enumeration getIds() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getIds");
        }
        return new Hashtable().keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IHttpSession createSession(HttpServletRequest httpServletRequest, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.createSession");
        }
        String string2 = null;
        boolean bl2 = false;
        if (this.stopSession) {
            String string3 = SessionContext.getXString("SessionContext.createWhenStop", "SESN0006E: SessionContext: an attempt to create a session while WebSphere Session Manager was turned off was made");
            RuntimeException runtimeException = new RuntimeException(string3);
            throw runtimeException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext:createSession entered with long id = " + string));
        }
        String string4 = string;
        String string5 = null;
        String string6 = null;
        if (string != null) {
            string6 = string.substring(0, this.cacheIdLength);
            int n = string.indexOf(cloneSeparator);
            if (n == -1) {
                string = string.substring(this.cacheIdLength);
            } else {
                string = string.substring(this.cacheIdLength, n);
                string5 = string4.substring(n);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext:createSession id without cacheId and clone info is now = " + string));
        }
        IHttpSession iHttpSession = null;
        SessionData sessionData = null;
        int n = 0;
        do {
            bl2 = false;
            ++n;
            if (string == null || bl2) {
                string = this.generateSessionId();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:createSession: generated new sessionid = " + string));
                }
            }
            if (this.allowInfinite) {
                iHttpSession = this.createSessionData(string);
                sessionData = (SessionData)iHttpSession;
            } else {
                if (this.isMaxAllowedReached()) {
                    sessionData = this.overflowData;
                    this.scPmiData.incNoRoomForNewSession();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"SessionContext:createSession: overflow session ");
                    }
                    return sessionData;
                }
                iHttpSession = this.createSessionData(string);
                sessionData = (SessionData)iHttpSession;
            }
            sessionData.initSession(this);
            sessionData.setValidity(true);
            long l = System.currentTimeMillis();
            sessionData.setCreationTime(l);
            sessionData.setLastAccessedTime(l);
            this.updateCloneInfo(sessionData, string5, true);
            if (string6 != null && this.cacheIdLength > 0) {
                sessionData.setCacheId(string6);
            }
            if (this.integrateWASSec) {
                string2 = this.securityEnabled ? this.getAuthenticatedUser() : httpServletRequest.getRemoteUser();
            }
            if (string2 == null) {
                string2 = "anonymous";
            }
            sessionData.setUser(string2);
            sessionData.setMaxInactInterval((int)this.mSessionInvalidationTime);
            if (bl) {
                sessionData.setUsingSSL(bl);
            }
            if (string4 != null) {
                String string7 = null;
                IHttpSession iHttpSession2 = null;
                Object object = this;
                synchronized (object) {
                    string7 = (String)this.createSync.get(string);
                    if (string7 == null) {
                        string7 = string;
                        this.createSync.put(string, string7);
                    }
                }
                object = string7;
                synchronized (object) {
                    iHttpSession2 = (IHttpSession)this.getFromMemory(string);
                    if (iHttpSession2 != null) {
                        this.createSync.remove(string);
                        return iHttpSession2;
                    }
                    bl2 = this.processSessionOnCreation(string, sessionData);
                    this.createSync.remove(string);
                }
            }
            bl2 = this.processSessionOnCreation(string, sessionData);
        } while (bl2 && n < 10);
        if (n == 10 && bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:createSession: Almost stuck in createLoop");
            }
            Tr.warning((TraceComponent)tc, (String)"SessionManager unable to generate unique session id in 10 tries, so gave up");
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"!!!!!SessionContext:createSession: about to increment inServiceMethodCount!!!!!!");
        }
        this.bumpCreateCount();
        sessionData.incrementInServiceMethodCount();
        sessionData.setActive(true, -1L);
        if (this.sessionListener) {
            HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)sessionData);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:createSession: calling sessionCreatedEvent()");
            }
            this.sessionCreatedEvent(httpSessionEvent);
        }
        return sessionData;
    }

    private final boolean processSessionOnCreation(String string, SessionData sessionData) {
        return this.insertSessionOnCreation(string, sessionData);
    }

    boolean isMaxAllowedReached() {
        return this.mSessions.size() == this.tableSize;
    }

    abstract IHttpSession createSessionData(String var1);

    abstract void performInvalidation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void pollInvalidations() {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("SessionContext.pollInvalidations " + this.getAppName()));
            }
            try {
                try {
                    this.setThreadContext();
                    if (debugSessionCrossover) {
                        currentThreadSessionId.set((Object)"WAS-SYSTEM-THREAD");
                    }
                    this.performInvalidation();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.pollInvalidations", (String)"818", (Object)this);
                    Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                    Object var3_2 = null;
                    this.unsetThreadContext();
                    if (debugSessionCrossover) {
                        currentThreadSessionId.set(null);
                    }
                    break block9;
                }
                Object var3_1 = null;
                this.unsetThreadContext();
                if (!debugSessionCrossover) break block9;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.unsetThreadContext();
                if (debugSessionCrossover) {
                    currentThreadSessionId.set(null);
                }
                throw throwable;
            }
            currentThreadSessionId.set(null);
        }
        this.scPmiData.incInvalidatorExecutedCount();
        this.invalidaterAlarm = SessionAlarmListener.startInvalidationAlarm(this, this.mInvalidationCheckPollInterval * 1000L);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.pollInvalidations " + this.getAppName()));
        }
    }

    void asyncExternalWrite() {
    }

    boolean isIBMSessionListenerImplemented() {
        ArrayList arrayList = this.getHttpSessionListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            HttpSessionListener httpSessionListener = (HttpSessionListener)((ArrayList)arrayList.get(i)).get(1);
            if (httpSessionListener == null || !(httpSessionListener instanceof IBMSessionListener)) continue;
            return true;
        }
        return false;
    }

    void notifySessionRemovedFromCache(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.notifySessionRemovedFromCache");
        }
        ArrayList arrayList = this.getHttpSessionListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            HttpSessionListener httpSessionListener = (HttpSessionListener)((ArrayList)arrayList.get(i)).get(1);
            if (httpSessionListener == null || !(httpSessionListener instanceof IBMSessionListener)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionListener + ".sessionremovedFromCache(" + string + ")"));
            }
            ((IBMSessionListener)httpSessionListener).sessionRemovedFromCache(string);
        }
    }

    public void notifySessionInvalidated(SessionData sessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.notifySessionInvalidated");
        }
        try {
            sessionData.sessionUnbound(this);
            this.removeSessionFromTable(sessionData);
            sessionData.setValidity(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void removeSessionFromTable(SessionData sessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.removeSessionFromTable");
        }
        this.tableRemove(sessionData.getId());
    }

    public void notifySessionAccessed(SessionData sessionData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.notifySessionAccessed");
        }
        if (sessionData.isValid()) {
            this.scPmiData.incSessionAccessCount();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.notifySessionAccessed");
        }
    }

    long getSessionInvalidationTime() {
        return this.mSessionInvalidationTime;
    }

    public void setSessionInvalidationTime(long l) {
        this.mSessionInvalidationTime = l;
    }

    boolean isSessionTrackingActive() {
        return this.mSessionTrackingActive;
    }

    public boolean isUsingCookies() {
        return this.mUsingCookies;
    }

    public void setUsingCookies(boolean bl) {
        this.mUsingCookies = bl;
    }

    public boolean isUsingURL() {
        return this.mUsingURL;
    }

    public void setUsingURL(boolean bl) {
        this.mUsingURL = bl;
    }

    public boolean isURLProtocolSwitchRewritingActive() {
        return this.mURLProtocolSwitchRewritingActive;
    }

    public void setURLProtocolSwitchRewritingActive(boolean bl) {
        this.mURLProtocolSwitchRewritingActive = bl;
    }

    String getSessionCookieName() {
        return this.mSessionCookieName;
    }

    public void setSessionCookieName(String string) {
        this.mSessionCookieName = string;
    }

    String getSessionCookieComment() {
        return this.mSessionCookieComment;
    }

    public void setSessionCookieComment(String string) {
        this.mSessionCookieComment = string;
    }

    String getSessionCookieDomain() {
        return this.mSessionCookieDomain;
    }

    public void setSessionCookieDomain(String string) {
        this.mSessionCookieDomain = string != null && string.length() > 0 ? string : null;
    }

    int getSessionCookieMaxAge() {
        return this.mSessionCookieMaxAge;
    }

    public void setSessionCookieMaxAge(int n) {
        this.mSessionCookieMaxAge = n;
    }

    String getSessionCookiePath() {
        return this.mSessionCookiePath;
    }

    public void setSessionCookiePath(String string) {
        this.mSessionCookiePath = string;
    }

    boolean getSessionCookieSecure() {
        return this.mSessionCookieSecure;
    }

    public void setSessionCookieSecure(boolean bl) {
        this.mSessionCookieSecure = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCloneInfo(SessionData sessionData, String string, boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext.saveCloneInfo - input cloneInfo= " + string));
        }
        String string2 = this.getCloneIdWithSeparator();
        if (string != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (!sessionData.isCloneIdUpdated()) {
                    sessionData.setPreviousClones(string);
                    int n = string.indexOf(string2);
                    if (n == -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        if (!noSwitchOver) {
                            stringBuffer.append(string);
                            stringBuffer.append(string2);
                        } else {
                            stringBuffer.append(string2);
                            stringBuffer.append(string);
                        }
                        sessionData.setPreviousClones(stringBuffer.toString());
                        sessionData.setCloneIdUpdated(true);
                        this.scPmiData.incAffinityBreaks();
                        if (this.cacheIdLength + sessionIDLength + sessionData.getPreviousClones().length() > this.maxSessionIdentifierLength) {
                            String[] stringArray = new String[]{sessionData.getBrowserToken(sessionData.usingSSL()), new Integer(this.maxSessionIdentifierLength).toString()};
                            Tr.warning((TraceComponent)tc, (String)"SessionContext.maxSessionIdLengthExceeded", (Object)stringArray);
                        }
                    }
                }
            }
        } else if (bl) {
            sessionData.setPreviousClones(string2);
            sessionData.setCloneIdUpdated(true);
        }
    }

    SessionData findSession(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.lockAndReturn");
        }
        SessionData sessionData = null;
        String string2 = null;
        Object var4_4 = null;
        String string3 = null;
        int n = string.indexOf(cloneSeparator);
        if (n == -1) {
            string2 = string.substring(this.cacheIdLength - this.getCacheIdLengthInUse());
        } else {
            string2 = string.substring(this.cacheIdLength - this.getCacheIdLengthInUse(), n);
            string3 = string.substring(n);
        }
        sessionData = (SessionData)this.tableGet(string2);
        if (sessionData != null) {
            this.updateCloneInfo(sessionData, string3, false);
        }
        return sessionData;
    }

    int getCacheIdLengthInUse() {
        return 0;
    }

    IHttpSession getIHttpSession(String string, HttpServletRequest httpServletRequest) {
        return this.getIHttpSession(string, httpServletRequest, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IHttpSession getIHttpSession(String string, HttpServletRequest httpServletRequest, boolean bl) {
        boolean bl2 = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.getIHttpSession:  " + string + "  isSSL " + bl));
        }
        if (this.stopSession) {
            String string2 = SessionContext.getXString("SessionContext.accessWhenStop", "SESN0007E: SessionContext: an attempt to access a session while WebSphere Session Manager was turned off was made");
            RuntimeException runtimeException = new RuntimeException(string2);
            throw runtimeException;
        }
        SessionData sessionData = null;
        sessionData = this.findSession(string);
        if (sessionData != null) {
            SessionData sessionData2 = sessionData;
            synchronized (sessionData2) {
                if (!sessionData.isValid()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SessionContext:getIHttpSession - session invalidated since  initial retrival;  id - " + string + " session - " + sessionData));
                    }
                    return null;
                }
                sessionData.initSession(this);
                String string3 = null;
                String string4 = sessionData.getUserName();
                if (this.integrateWASSec) {
                    if (this.securityEnabled) {
                        string3 = this.getAuthenticatedUser();
                    } else {
                        string3 = httpServletRequest.getRemoteUser();
                        if (string3 == null) {
                            string3 = "anonymous";
                        }
                    }
                    if (string3 != null && string4 != null && !string3.equals(string4)) {
                        if (string4.equals("anonymous")) {
                            sessionData.setUser(string3);
                        } else {
                            String[] stringArray = new String[]{string3, string4};
                            String string5 = "SESN0008E: SessionContext: a user authenticated as {0} has attempted to access a session owned by {1}(" + string3 + "," + string4 + ")";
                            UnauthorizedSessionRequestException unauthorizedSessionRequestException = new UnauthorizedSessionRequestException(string5);
                            throw unauthorizedSessionRequestException;
                        }
                    }
                }
                long l = sessionData.getLastAccessedTime();
                sessionData.accessSessionData();
                sessionData.setActive(true, sessionData.getLastAccessedTime() - l);
                sessionData.incrementInServiceMethodCount();
                sessionData.setNew(false);
                if (bl) {
                    sessionData.setUsingSSL(true);
                }
                if (tc.isEntryEnabled()) {
                    String string6 = "SessionContext: found the session for the id " + string;
                    Tr.exit((TraceComponent)tc, (String)string6);
                }
                sessionData.notifyActivateListeners();
            }
        } else if (tc.isDebugEnabled()) {
            String string7 = "SessionContext: no valid session for the id " + string;
            Tr.debug((TraceComponent)tc, (String)string7);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext:getIHttpSession - leaving and returning session of  " + sessionData));
        }
        if (sessionData == null) {
            this.scPmiData.IncAttemptToActivateNonExistent();
        }
        return sessionData;
    }

    private String getSessionIDOnly(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getSessionIDOnly - remove the cloneids");
        }
        String string2 = string;
        int n = string.indexOf(cloneSeparator);
        string2 = n == -1 ? string.substring(this.cacheIdLength) : string.substring(this.cacheIdLength, n);
        return string2;
    }

    public HttpSession getSession(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getSession");
        }
        return null;
    }

    ArrayList getHttpSessionAttributeListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext:getHttpSessionAttributeListeners");
        }
        return this.mHttpSessionAttributeListeners;
    }

    ArrayList getHttpSessionListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext:getHttpSessionListeners");
        }
        return this.mHttpSessionListeners;
    }

    private void setServletContext(ServletContext servletContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext:setServletContext");
        }
        this.mServletContext = servletContext;
    }

    public ServletContext getServletContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext:getServletContext");
        }
        return this.mServletContext;
    }

    synchronized void initializeParameters() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.initializeParameters");
        }
        try {
            this.securityEnabled = SecurityContext.isSecurityEnabled();
            this.setSessionTimeoutInfo();
            this.tableSize = this.mParams.getInMemorySize();
            if (this.tableSize <= 0) {
                throw new RuntimeException("In memory session size cannot be less than or equal to 0");
            }
            this.allowInfinite = this.mParams.getEnableOverflow();
            this.setUsingCookies(this.mParams.getEnableCookies());
            this.setUsingURL(this.mParams.getEnableUrlRewriting());
            this.setURLProtocolSwitchRewritingActive(this.mParams.getEnableUrlProtocolSwitchRewriting());
            this.setSessionCookieName(this.mParams.getSessionCookieName());
            this.setSessionCookieComment(this.mParams.getSessionCookieComment());
            String string = this.mParams.getSessionCookieDomain();
            if (string != null && string.length() > 0) {
                this.setSessionCookieDomain(string);
            } else {
                this.setSessionCookieDomain(null);
            }
            this.setSessionCookieMaxAge(this.mParams.getSessionCookieMaxAge());
            this.setSessionCookiePath(this.mParams.getSessionCookiePath());
            this.setSessionCookieSecure(this.mParams.getSessionCookieSecure());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext:initializeParameters - cloneId for this JVM is " + cloneId));
            }
            if (cloneId != null) {
                cloneIdLength = cloneId.length();
            }
            this.useSSLId = this.mParams.useSSLId();
            this.integrateWASSec = this.mParams.getIntegrateSecurity();
            this.timedOutAffinityEnabled = this.mParams.getEnableAffinityTimeout();
            if (this.timedOutAffinityEnabled) {
                this.affinityTimeOut = this.mParams.getAffinityTimeoutInterval();
            }
            this.allowSerializedSessionAccess = this.mParams.getAllowSerializedSessionAccess();
            this.serializedSessionAccessMaxWaitTime = this.mParams.getSerializedSessionAccessMaxWaitTime();
            this.accessSessionOnTimeout = this.mParams.getAccessSessionOnTimeout();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)" ");
                Tr.debug((TraceComponent)tc, (String)("SessionContext:initializeParameters - timedOutAffinityEnabled is : " + this.timedOutAffinityEnabled));
                Tr.debug((TraceComponent)tc, (String)("SessionContext:initializeParameters - affinityTimeOut is : " + this.affinityTimeOut));
            }
            if (turnOffCloneId && SessionMgrComponentImpl.getServerId().equals("-1")) {
                cloneId = "";
                cloneIdLength = 0;
            }
            cloneSeparator = cloneSep.charAt(0);
            this.cloneIdWithSep = cloneId != null && cloneId.length() > 0 ? cloneSep + cloneId : "";
            this.cacheIdPlusIdlength = this.cacheIdLength + sessionIDLength;
        }
        catch (SessionContextParameterException sessionContextParameterException) {
            FFDCFilter.processException((Throwable)sessionContextParameterException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.initializeParameters", (String)"1555", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)sessionContextParameterException);
        }
    }

    void setSessionTimeoutInfo() {
        this.setSessionTimeoutInfo(0);
    }

    synchronized void setSessionTimeoutInfo(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.setSessionTimeoutInfo");
        }
        long l = 0L;
        if (tc.isDebugEnabled()) {
            if (n == 0) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:setSessionTimeoutInfo --  Normal Update");
            } else {
                Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo -- Dynamic Global Update.. input parm = " + n));
            }
        }
        try {
            long l2;
            long l3 = l2 = this.scAppParms.getSessionTimeout();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo timeout value in WebApp is" + l3));
            }
            if (l2 == 0L) {
                l = n != 0 ? (long)n : this.mParams.getSessionInvalidationTime();
                l3 = l;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo Global timeout is: " + l3));
                }
            }
            if (n == 0 || l2 == 0L) {
                l3 = this.checkMinimumInvalidation(l3);
                this.setSessionInvalidationTime(l3);
                int n2 = randIdGen.nextInt() % 30;
                if (n2 < 0) {
                    n2 *= -1;
                }
                if (this.mInvalidationCheckPollInterval <= 0L) {
                    if (l3 < 120L) {
                        this.mInvalidationCheckPollInterval = 60 - n2;
                    }
                    if (l3 >= 120L && l3 < 900L) {
                        this.mInvalidationCheckPollInterval = 60 + n2;
                    }
                    if (l3 >= 900L) {
                        this.mInvalidationCheckPollInterval = 300 + 2 * n2;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo -- Updating timeout value to: " + l3));
                    Tr.debug((TraceComponent)tc, (String)("SessionContext:setSessionTimeoutInfo -- mInvalidationCheckPollInterval is now: " + this.mInvalidationCheckPollInterval));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:setSessionTimeoutInfo -- Timeout Value NOT Updated");
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.setSessionTimeoutInfo", (String)"1646", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
        }
    }

    long checkMinimumInvalidation(long l) {
        return l;
    }

    public boolean shouldEncodeURL(String string, HttpServletRequest httpServletRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.shouldEncodeURL");
        }
        if (!this.isUsingURL()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.encodeOff");
            }
            return false;
        }
        if (!this.isProtocolSwitch(string, httpServletRequest)) {
            return true;
        }
        if (this.isURLProtocolSwitchRewritingActive()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.encodeProtocolSwitchon");
            }
            return true;
        }
        return false;
    }

    public boolean shouldEncodeRedirectURL(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.shouldEncodeRedirectURL");
        }
        if (!this.isUsingURL()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"SessionContext.encodeOff");
            }
            return false;
        }
        return true;
    }

    private boolean isProtocolSwitch(String string, HttpServletRequest httpServletRequest) {
        InetAddress inetAddress;
        int n;
        char c;
        int n2;
        int n3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.isProtocolSwitch");
        }
        if ((n3 = string.indexOf("://")) < 0) {
            return false;
        }
        String string2 = string.substring(0, n3);
        if (!(string2.equalsIgnoreCase("http") && httpServletRequest.getScheme().equalsIgnoreCase("https") || string2.equalsIgnoreCase("https") && httpServletRequest.getScheme().equalsIgnoreCase("http"))) {
            return false;
        }
        int n4 = string.length();
        for (n2 = n = n3 + 3; n2 < n4 && (c = string.charAt(n2)) != ':' && c != '/'; ++n2) {
        }
        String string3 = string.substring(n, n2);
        try {
            inetAddress = InetAddress.getByName(string3);
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.isProtocolSwitch", (String)"1760", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)unknownHostException);
            return false;
        }
        return inetAddress.equals(this.getLocalHost());
    }

    public void sync(HttpSession httpSession) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.sync");
        }
    }

    public void reload(String string) {
        this.stopSessionContext(string);
    }

    public String toHTML() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.toHTML");
        }
        String string = this.scAppParms.getJ2EEName();
        String string2 = "<b> (for this webapp) : </b> ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<center><h3>J2EE NAME(AppName#WebModuleName):: " + string + " </h3></center>" + "<UL>\n").append("<b>  cloneId</b> : ").append(cloneId).append("<BR>").append("<BR>").append("<b>  Number of sessions in memory: </b>").append(string2).append(this.mSessions != null ? this.mSessions.size() : 0).append("<BR>").append("<b>  use overflow</b> : ").append(this.allowInfinite).append("<BR>").append("<b>  overflow size</b> ").append(string2).append("<BR>").append("<b>  Invalidation alarm poll interval (for this webapp) </b> : ").append(this.mInvalidationCheckPollInterval).append("<BR>").append("<b> Max invalidation timeout (for this webapp) </b> : ").append(this.mSessionInvalidationTime).append("<BR>").append("<b> Using Cookies </b> : ").append(this.mUsingCookies).append("<BR>").append("<b> Using URL Rewriting </b> : ").append(this.mUsingURL).append("<BR>").append("<b> use SSLId </b> : ").append(this.useSSLId).append("<BR>").append("<b> URL Protocol Switch Rewriting </b> : ").append(this.mURLProtocolSwitchRewritingActive).append("<BR>").append("<b> Session Cookie Name </b> : ").append(this.mSessionCookieName).append("<BR>").append("<b> Session Cookie Comment </b> : ").append(this.mSessionCookieComment).append("<BR>").append("<b> Session Cookie Domain </b> : ").append(this.mSessionCookieDomain).append("<BR>").append("<b> Session Cookie Path </b> : ").append(this.mSessionCookiePath).append("<BR>").append("<b> Session Cookie MaxAge </b> : ").append(this.mSessionCookieMaxAge).append("<BR>").append("<b> Session Cookie Secure </b> : ").append(this.mSessionCookieSecure).append("<BR>").append("<b> Maximum in memory table size </b> : ").append(this.tableSize).append("<BR>").append("<b> current time </b> : ").append(new Date(System.currentTimeMillis()).toString()).append("<BR>").append("<b>  integrateWASSec</b> :").append(this.integrateWASSec).append("<BR><b>Session locking </b>: ").append(this.allowSerializedSessionAccess).append("<BR><b>Session locking timeout</b>: ").append(this.serializedSessionAccessMaxWaitTime).append("<BR><b>Allow access on lock timeout</b>:").append(this.accessSessionOnTimeout).append(this.scPmiData.toHTML()).append(this.mbeanAdapter.toHTML());
        return stringBuffer.toString();
    }

    public String toHTML2() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.toHTML");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<center><h3>Session Tracking Internals</h3></center><UL>\n").append("<b>  mSessions </b> : ").append(this.mSessions != null ? this.mSessions.toString() : null).append("<BR>");
        return stringBuffer.toString();
    }

    public String toString() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nSession Tracking Internals for webapp " + this.scAppParms.getJ2EEName() + ": \n").append("\n").append("  mSessions size : ").append(this.mSessions != null ? this.mSessions.size() : 0).append("\n").append("  use overflow : ").append(this.allowInfinite).append("\n").append("  overflow size : ").append("\n").append("mInvalidationCheckPollInterval : ").append(this.mInvalidationCheckPollInterval).append("\n").append("mSessionInvalidationTime  : ").append(this.getSessionInvalidationTime()).append("\n").append("mSessionTrackingActive  : ").append(this.isSessionTrackingActive()).append("\n").append("mUsingCookies  : ").append(this.isUsingCookies()).append("\n").append("mUsingURL  : ").append(this.isUsingURL()).append("\n").append("useSSLId  : ").append(this.useSSLId).append("\n").append("mURLProtocolSwitchRewritingActive  : ").append(this.isURLProtocolSwitchRewritingActive()).append("\n").append("mSessionCookieName  : ").append(this.getSessionCookieName()).append("\n").append("mSessionCookieComment  : ").append(this.getSessionCookieComment()).append("\n").append("mSessionCookieDomain  : ").append(this.getSessionCookieDomain()).append("\n").append("mSessionCookiePath  : ").append(this.getSessionCookiePath()).append("\n").append("mSessionCookieSecure  : ").append(this.getSessionCookieSecure()).append("\n").append("mSessionCookieMaxAge  : ").append(this.getSessionCookieMaxAge()).append("\n").append("in memory table size : ").append(this.tableSize).append("\n").append("current time : ").append(new Date(System.currentTimeMillis()).toString()).append("\n").append("integrateWASSec :").append(this.integrateWASSec).append("\n").append("\nSession serialization: ").append(this.allowSerializedSessionAccess).append("\nSession serialization timeout: ").append(this.serializedSessionAccessMaxWaitTime).append("Allow access on serialization timeout:").append(this.accessSessionOnTimeout);
        return stringBuffer.toString();
    }

    String toString2() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.toString2");
        }
        StringBuffer stringBuffer = new StringBuffer(this.toString());
        stringBuffer.append("mSessions : ").append(this.mSessions != null ? this.mSessions.toString() : null).append("\n");
        return stringBuffer.toString();
    }

    void tablePut(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.tablePut");
        }
        try {
            this.mSessions.put(object, object2);
            this.incMemoryCount();
        }
        catch (TooManySessionsException tooManySessionsException) {
            FFDCFilter.processException((Throwable)tooManySessionsException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.tablePut", (String)"2008", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)tooManySessionsException);
        }
    }

    void incMemoryCount() {
        this.scPmiData.incMemoryCount();
    }

    void decMemoryCount() {
        this.scPmiData.decMemoryCount();
    }

    Object tableGet(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.tableGet");
        }
        return this.mSessions.get(object);
    }

    void tableRemove(Object object) {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.tableRemove " + object));
        }
        if ((v = this.mSessions.remove(object)) != null) {
            this.decMemoryCount();
            if (this.mIBMSessionListenerImplemented) {
                this.notifySessionRemovedFromCache((String)object);
            }
        }
    }

    void tableClear() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.tableClear");
        }
        HashSet hashSet = new HashSet(this.mSessions.keySet());
        this.mSessions.clear();
        if (this.mIBMSessionListenerImplemented) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                this.notifySessionRemovedFromCache((String)iterator.next());
            }
        }
    }

    HashMap getHashMap() {
        return this.mSessions;
    }

    boolean isSessionIdInUse(String string) {
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)tc, (String)"SessionContext.IsSessionIdInUse");
        }
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext:isSessionIdInUse: entered with " + string));
        }
        Enumeration enumeration = SessionContextRegistry.getScrSessionContexts();
        while (enumeration.hasMoreElements() && !bl) {
            Object object;
            SessionContext sessionContext = (SessionContext)enumeration.nextElement();
            if (sessionContext == this || (object = sessionContext.getFromMemory(string)) == null) continue;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.event((TraceComponent)tc, (String)("SessionContext.IsSessionIdInUse Cache/Mem found = " + bl));
        }
        if (bl) {
            return bl;
        }
        bl = this.isPresentInExternalStore(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext:isSessionIdInUse: after DB scan found: " + bl));
        }
        return bl;
    }

    Object getFromMemory(Object object) {
        return this.mSessions.get(object);
    }

    boolean isPresentInExternalStore(Object object) {
        return false;
    }

    Enumeration tableKeys() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.tableKeys");
        }
        Set set = this.mSessions.keySet();
        final Iterator iterator = set.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    int getCloneIdLength() {
        return cloneIdLength;
    }

    String getCloneId() {
        return cloneId;
    }

    String getIDFromBytes(byte[] byArray) {
        return SessionContext.convertSessionIdBytesToSessionId(byArray);
    }

    public boolean isSSLSessions() {
        return this.useSSLId;
    }

    boolean getAllowSerializedSessionAccess() {
        return this.allowSerializedSessionAccess;
    }

    int getSerializedSessionAccessMaxWaitTime() {
        return this.serializedSessionAccessMaxWaitTime;
    }

    boolean getAccessSessionOnTimeout() {
        return this.accessSessionOnTimeout;
    }

    void invalidateAllMemorySessions() {
    }

    public synchronized void stop(String string) {
        this.stopSessionContext(string);
    }

    public String getCloneSeparator() {
        return cloneSep;
    }

    String getCloneIdWithSeparator() {
        return this.cloneIdWithSep;
    }

    String getAppName() {
        try {
            return this.scAppParms.getAppName();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.getAppName", (String)"2256", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
            return null;
        }
    }

    public HttpSession getIHttpSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionContext.getIHttpSession(req,res,boolean):  " + bl));
        }
        boolean bl2 = false;
        IHttpSession iHttpSession = null;
        String string = this.getRequestedSessionId(httpServletRequest);
        if (this.useSSLId && ((IExtendedRequest)httpServletRequest).getSSLId() != null) {
            bl2 = true;
        }
        if (string != null) {
            iHttpSession = this.getIHttpSession(string, httpServletRequest, bl2);
        }
        String string2 = ((IExtendedRequest)httpServletRequest).getUpdatedSessionId();
        if (iHttpSession == null && string2 != null) {
            iHttpSession = this.getIHttpSession(string2, httpServletRequest, bl2);
            string = string2;
        }
        if (iHttpSession != null && string2 != null) {
            ((SessionData)iHttpSession).setNew(true);
        }
        if (iHttpSession == null && bl) {
            if (string != null) {
                if (bl2) {
                    iHttpSession = this.createSession(httpServletRequest, string, true);
                } else {
                    objectArray = null;
                    if (!idReuse && string.length() >= this.cacheIdPlusIdlength) {
                        objectArray = string.substring(this.cacheIdLength, this.cacheIdPlusIdlength);
                    }
                    iHttpSession = idReuse || this.isSessionIdInUse((String)objectArray) ? this.createSession(httpServletRequest, string, false) : this.createSession(httpServletRequest, null, false);
                }
            } else {
                iHttpSession = this.createSession(httpServletRequest, null, false);
            }
        }
        if (iHttpSession != null) {
            if (!iHttpSession.isNew()) {
                if (this.crossoverCheck(iHttpSession.getId())) {
                    objectArray = new Object[]{this.getAppName(), iHttpSession.getId(), (String)currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
                    Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnRetrieve", (Object)objectArray);
                }
            } else {
                this.updateCurrentThreadSessionId((SessionData)iHttpSession);
            }
            objectArray = null;
            boolean bl3 = iHttpSession.usingSSL();
            if (this.mUsingCookies && iHttpSession.isBrowserTokenUpdated()) {
                objectArray = iHttpSession.testAndGetBrowserToken(bl3);
                this.setCookie(httpServletRequest, httpServletResponse, (String)objectArray, bl3);
            }
            if (iHttpSession.isValid() && iHttpSession.isNew()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("calling req.setSessionid  " + iHttpSession.getBrowserToken(bl3)));
                }
                ((IExtendedRequest)httpServletRequest).setSessionId(iHttpSession.getBrowserToken(bl3));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionContext.getIHttpSession(req,res,boolean):  " + bl));
        }
        return iHttpSession;
    }

    public String getRequestedSessionId(HttpServletRequest httpServletRequest) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getRequestedSessionId");
        }
        String string = null;
        if (this.useSSLId && (string = this.getRequestedSessionIdFromSSL(httpServletRequest)) != null) {
            return string;
        }
        if (this.mUsingCookies && (string = this.getRequestedSessionIdFromCookie(httpServletRequest)) != null) {
            return string;
        }
        if (this.mUsingURL && (string = this.getRequestedSessionIdFromURL(httpServletRequest)) != null) {
            return string;
        }
        return null;
    }

    public boolean isRequestedSessionIdFromCookie(HttpServletRequest httpServletRequest) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.isRequestedSessionIdFromCookie");
        }
        String string = null;
        if (this.useSSLId && (string = this.getRequestedSessionIdFromSSL(httpServletRequest)) != null) {
            return false;
        }
        return this.mUsingCookies && (string = this.getRequestedSessionIdFromCookie(httpServletRequest)) != null;
    }

    public boolean isRequestedSessionIdFromUrl(HttpServletRequest httpServletRequest) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.isRequestedSessionIdFromUrl");
        }
        String string = null;
        if (this.useSSLId && (string = this.getRequestedSessionIdFromSSL(httpServletRequest)) != null) {
            return false;
        }
        if (this.mUsingCookies && (string = this.getRequestedSessionIdFromCookie(httpServletRequest)) != null) {
            return false;
        }
        return this.mUsingURL && (string = this.getRequestedSessionIdFromURL(httpServletRequest)) != null;
    }

    public boolean isRequestedSessionIdValid(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        String string;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.isRequestedSessionIdValid");
        }
        if ((string = this.getRequestedSessionId(httpServletRequest)) == null) {
            return false;
        }
        if (httpSession == null) {
            return false;
        }
        if (httpSession.isNew()) {
            return false;
        }
        string = this.getSessionIDOnly(string);
        return string.equals(httpSession.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSession sessionPreInvoke(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.sessionPreInvoke");
        }
        if (debugSessionCrossover) {
            Object object2;
            string = (String)currentThreadSessionId.get();
            if (string == null) {
                currentThreadDispatchCount.set((Object)new Integer(1));
                object2 = ((IExtendedRequest)httpServletRequest).getUpdatedSessionId();
                if (object2 == null) {
                    object2 = httpServletRequest.getRequestedSessionId();
                }
                if (object2 != null) {
                    object = this.getSessionIDOnly((String)object2);
                    currentThreadSessionId.set(object);
                } else {
                    object = new String("NONE");
                    currentThreadSessionId.set(object);
                }
            } else {
                object2 = (Integer)currentThreadDispatchCount.get();
                currentThreadDispatchCount.set((Object)new Integer((Integer)object2 + 1));
            }
        }
        if (this.allowSerializedSessionAccess) {
            try {
                string = this.getIHttpSession(httpServletRequest, httpServletResponse, false);
                int n = this.serializedSessionAccessMaxWaitTime;
                if (string != null) {
                    object = ((IHttpSession)((Object)string)).getLockObj();
                    LinkedList linkedList = ((IHttpSession)((Object)string)).getLockList();
                    int n2 = 0;
                    Object object3 = object;
                    synchronized (object3) {
                        LinkedList linkedList2 = linkedList;
                        synchronized (linkedList2) {
                            linkedList.addLast(object);
                            n2 = linkedList.size();
                        }
                        if (n2 != 1) {
                            long l = System.currentTimeMillis();
                            object.wait(n);
                            long l2 = System.currentTimeMillis();
                            if (l2 - (long)n >= l) {
                                LinkedList linkedList3 = linkedList;
                                synchronized (linkedList3) {
                                    while (object != linkedList.getFirst()) {
                                        Object e;
                                        Object e2 = e = linkedList.removeFirst();
                                        synchronized (e2) {
                                            try {
                                                e.notify();
                                            }
                                            catch (Throwable throwable) {
                                                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.sessionPreInvoke", (String)"2454", (Object)string);
                                                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                                            }
                                        }
                                        ((IHttpSession)((Object)string)).retLockObj(e);
                                    }
                                }
                                if (!this.accessSessionOnTimeout) {
                                    linkedList.remove(object);
                                    Tr.error((TraceComponent)tc, (String)"HttpSession transaction timed out - configured to not allow access.  Check  for hung applications, possibly by dumping the threads of the application server");
                                    throw new RuntimeException("Session Lock time outException");
                                }
                            }
                        }
                    }
                    object3 = linkedList;
                    synchronized (object3) {
                        if (linkedList.size() > 0 && object == linkedList.getFirst()) {
                            linkedList.removeFirst();
                            Object object4 = object = linkedList.size() > 0 ? (Object)linkedList.getFirst() : null;
                            if (object != null) {
                                Object object5 = object;
                                synchronized (object5) {
                                    try {
                                        object.notify();
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.sessionPreInvoke", (String)"2484", (Object)string);
                                        Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)throwable);
                                    }
                                }
                                ((IHttpSession)((Object)string)).retLockObj(object);
                            }
                        }
                    }
                }
                return string;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.sessionPreInvoke", (String)"2495", (Object)this);
                Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)interruptedException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionPostInvoke(HttpSession httpSession) {
        Serializable serializable;
        SessionData sessionData;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.sessionPostInvoke");
        }
        if ((sessionData = (SessionData)httpSession) != null) {
            serializable = sessionData;
            synchronized (serializable) {
                sessionData.releaseSession();
                sessionData.decrementInServiceMethodCount();
                sessionData.setActive(false, -2L);
            }
        }
        if (debugSessionCrossover && (serializable = (Integer)currentThreadDispatchCount.get()) != null) {
            int n = (Integer)serializable - 1;
            if (n > 0) {
                currentThreadDispatchCount.set((Object)new Integer(n));
            } else {
                currentThreadDispatchCount.set(null);
                currentThreadSessionId.set(null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionContext.sessionPostInvoke");
        }
    }

    private String getRequestedSessionIdFromSSL(HttpServletRequest httpServletRequest) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionContext.getRequestedSessionIdFromSSL");
        }
        String string = null;
        IExtendedRequest iExtendedRequest = (IExtendedRequest)httpServletRequest;
        if (this.useSSLId) {
            string = this.getSSLId(iExtendedRequest);
            if (string != null) {
                String string2 = "0001";
                String string3 = "";
                String string4 = iExtendedRequest.getCookieValue(dcookieName);
                if (string4 == null) {
                    string4 = this.getRequestedSessionIdFromURL(httpServletRequest);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("getRequestedSessionId - encoded URL contains: " + string4));
                    }
                }
                if (string4 != null) {
                    string2 = string4.substring(0, 4);
                    int n = string4.indexOf(this.getCloneSeparator());
                    if (n != -1) {
                        String string5 = string4.substring(4, n);
                        string3 = string4.substring(n);
                    }
                }
                string = string2 + string + string3;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRequestedSessionId - massaged long SSL id is now: " + string));
            }
        }
        return string;
    }

    private String getRequestedSessionIdFromCookie(HttpServletRequest httpServletRequest) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getRequestedSessionIdFromCookie");
        }
        String string = null;
        if (this.mUsingCookies) {
            IExtendedRequest iExtendedRequest = (IExtendedRequest)httpServletRequest;
            string = iExtendedRequest.getCookieValue(this.mSessionCookieName);
        }
        return string;
    }

    private String getRequestedSessionIdFromURL(HttpServletRequest httpServletRequest) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getRequestedSessionIdFromURL");
        }
        String string = null;
        if (this.mUsingURL) {
            int n;
            String string2 = ((IExtendedRequest)httpServletRequest).getEncodedRequestURI();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("request uri:" + string2));
            }
            if ((n = string2.indexOf(sessUrlRewritePrefix)) != -1) {
                string = string2.substring(n + sessUrlRewritePrefix.length());
            }
        }
        return string;
    }

    private String getSSLId(IExtendedRequest iExtendedRequest) {
        byte[] byArray;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionContext.getSSLId");
        }
        if ((byArray = iExtendedRequest.getSSLId()) != null) {
            return this.getIDFromBytes(byArray);
        }
        return null;
    }

    private void setCookie(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) {
        Object[] objectArray;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionContext.setCookie :" + string));
        }
        if (httpServletResponse.isCommitted()) {
            Tr.warning((TraceComponent)tc, (String)"SessionContext.responseAlreadyCommitted");
        }
        Cookie cookie = null;
        String string2 = null;
        if (!bl) {
            string2 = this.mSessionCookieName;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getSession - sending Dummy Cookie");
            }
            string2 = dcookieName;
        }
        if (this.crossoverCheck(this.getSessionIDOnly(string))) {
            objectArray = new Object[]{this.getAppName(), this.getSessionIDOnly(string), (String)currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
            Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnReturn", (Object)objectArray);
        }
        cookie = new Cookie(string2, string);
        cookie.setComment(this.mSessionCookieComment);
        cookie.setPath(this.mSessionCookiePath);
        cookie.setMaxAge(this.mSessionCookieMaxAge);
        objectArray = this.mSessionCookieDomain;
        if (objectArray != null) {
            cookie.setDomain((String)objectArray);
        }
        cookie.setSecure(this.mSessionCookieSecure);
        httpServletResponse.addCookie(cookie);
    }

    public String encodeURL(HttpSession httpSession, HttpServletRequest httpServletRequest, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encodeURL", (Object)string);
        }
        if (httpSession == null) {
            return null;
        }
        IHttpSession iHttpSession = (IHttpSession)httpSession;
        if (this.shouldEncodeURL(string, httpServletRequest)) {
            boolean bl = iHttpSession.usingSSL();
            String string2 = null;
            string2 = bl ? iHttpSession.getBrowserToken(true) : iHttpSession.getBrowserToken(false);
            if (string2 != null) {
                SessionData sessionData;
                if (!(!this.crossoverCheck(this.getSessionIDOnly(string2)) || (sessionData = (SessionData)iHttpSession).isNew() && sessionData.isCreatedOnUserThread())) {
                    Object[] objectArray = new Object[]{this.getAppName(), httpSession.getId(), (String)currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
                    Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnReturn", (Object)objectArray);
                }
                if (!SessionContext.isSafe(string2)) {
                    return string;
                }
                int n = string.indexOf("?");
                int n2 = string.indexOf("#");
                if (n != -1 && n2 != -1 && n2 < n) {
                    n = n2;
                }
                if (n == -1 && n2 != -1) {
                    n = n2;
                }
                String string3 = null;
                String string4 = null;
                StringBuffer stringBuffer = null;
                if (n != -1) {
                    string3 = string.substring(0, n);
                    string4 = string.substring(n, string.length());
                    stringBuffer = new StringBuffer(string3);
                } else {
                    stringBuffer = new StringBuffer(string);
                }
                stringBuffer.append(sessUrlRewritePrefix);
                stringBuffer.append(string2);
                if (n != -1) {
                    stringBuffer.append(string4);
                }
                string = stringBuffer.toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encodeURL, new ID is ", (Object)string);
        }
        return string;
    }

    public boolean isValid(HttpSession httpSession) {
        boolean bl = ((IHttpSession)httpSession).isValid();
        if (bl && this.crossoverCheck(httpSession.getId())) {
            Object[] objectArray = new Object[]{this.getAppName(), httpSession.getId(), (String)currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
            Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnRetrieve", (Object)objectArray);
        }
        return bl;
    }

    boolean crossoverCheck(String string) {
        if (debugSessionCrossover) {
            String string2 = (String)currentThreadSessionId.get();
            if (string2 == null) {
                if (!this.crossoverUserThreadWarningIssued) {
                    Tr.warning((TraceComponent)tc, (String)"SessionContext.UserThreadDetected", (Object)this.getAppName());
                    this.crossoverUserThreadWarningIssued = true;
                }
            } else if (!string2.equals("WAS-SYSTEM-THREAD") && !string2.equals(string)) {
                return true;
            }
        }
        return false;
    }

    void updateCurrentThreadSessionId(SessionData sessionData) {
        if (debugSessionCrossover) {
            String string = (String)currentThreadSessionId.get();
            if (string != null) {
                currentThreadSessionId.set((Object)sessionData.getId());
            } else if (sessionData.isNew()) {
                sessionData.setCreatedOnUserThread(true);
            }
        }
    }

    private static boolean isSafe(String string) {
        for (int i = 0; i < unSecStrs.length; ++i) {
            if (string.indexOf(unSecStrs[i]) == -1) continue;
            return false;
        }
        return true;
    }

    void incrementActiveSessionCount(long l) {
        this.scPmiData.incActiveSessions(l);
    }

    void decrementActiveSessionCount() {
        this.scPmiData.decActiveSessions();
    }

    void bumpCreateCount() {
        this.scPmiData.incSessionsCreated();
    }

    void incInvalidatedByTimeout() {
        this.scPmiData.incInvalidatedByTimeout();
    }

    void incInvalidatedSessions(long l) {
        this.scPmiData.incInvalidatedSessions(l);
    }

    void incSessionGarbageCollected(long l) {
        this.scPmiData.incSessionGarbageCollected(System.currentTimeMillis());
    }

    static final boolean trackGCCount() {
        return trackGCCount;
    }

    public void addHttpSessionListener(HttpSessionListener httpSessionListener, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, string);
        arrayList.add(1, (String)httpSessionListener);
        this.mHttpSessionListeners.add(arrayList);
        this.sessionListener = true;
        this.mIBMSessionListenerImplemented = this.isIBMSessionListenerImplemented();
    }

    void addHttpSessionAttributeListener(ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addHttpSessionAttributeListener:" + arrayList));
        }
        this.mHttpSessionAttributeListeners.addAll(arrayList);
        if (this.mHttpSessionAttributeListeners.size() > 0) {
            this.sessionAttributeListener = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addHttpSessionAttributeListener:" + arrayList));
        }
    }

    void addHttpSessionListener(ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addHttpSessionListener:" + arrayList));
        }
        this.mHttpSessionListeners.addAll(arrayList);
        if (this.mHttpSessionListeners.size() > 0) {
            this.sessionListener = true;
        }
        this.mIBMSessionListenerImplemented = this.isIBMSessionListenerImplemented();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("addHttpSessionListener:" + arrayList));
        }
    }

    void setThreadContext() {
        WebApp webApp = (WebApp)this.mServletContext;
        WebModuleMetaData webModuleMetaData = (WebModuleMetaData)webApp.getModuleMetaData();
        webApp.getWebAppNameSpaceCollaborator().preInvoke((ComponentMetaData)webModuleMetaData);
    }

    void unsetThreadContext() {
        WebApp webApp = (WebApp)this.mServletContext;
        webApp.getWebAppNameSpaceCollaborator().postInvoke();
    }

    public void sessionAttributeAddedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionAttributedAddedEvent:" + httpSessionBindingEvent));
        }
        ArrayList arrayList = this.getHttpSessionAttributeListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)arrayList2.get(1);
            if (httpSessionAttributeListener == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionAttributeListener + ".attributeAdded()"));
            }
            httpSessionAttributeListener.attributeAdded(httpSessionBindingEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionAttributedAddedEvent:" + httpSessionBindingEvent));
        }
    }

    public void sessionAttributeReplacedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionAttributeReplacedEvent:" + httpSessionBindingEvent));
        }
        ArrayList arrayList = this.getHttpSessionAttributeListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)arrayList2.get(1);
            if (httpSessionAttributeListener == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionAttributeListener + ".attributeReplaced()"));
            }
            httpSessionAttributeListener.attributeReplaced(httpSessionBindingEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionAttributeReplacedEvent:" + httpSessionBindingEvent));
        }
    }

    public void sessionAttributeRemovedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionAttributeRemovedEvent:" + httpSessionBindingEvent));
        }
        ArrayList arrayList = this.getHttpSessionAttributeListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)arrayList2.get(1);
            if (httpSessionAttributeListener == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionAttributeListener + ".attributeRemoved()"));
            }
            httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionAttributeRemovedEvent:" + httpSessionBindingEvent));
        }
    }

    public void sessionCreatedEvent(HttpSessionEvent httpSessionEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionCreatedEvent:" + httpSessionEvent));
        }
        ArrayList arrayList = this.getHttpSessionListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionListener httpSessionListener = (HttpSessionListener)arrayList2.get(1);
            if (httpSessionListener == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionListener + ".sessionCreated()"));
            }
            httpSessionListener.sessionCreated(httpSessionEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionCreatedEvent:" + httpSessionEvent));
        }
    }

    public void sessionDestroyedEvent(HttpSessionEvent httpSessionEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sessionDestroyedEvent:" + httpSessionEvent));
        }
        ArrayList arrayList = this.getHttpSessionListeners();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            HttpSessionListener httpSessionListener = (HttpSessionListener)arrayList2.get(1);
            if (httpSessionListener == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling " + httpSessionListener + ".sessionDestroyed()"));
            }
            httpSessionListener.sessionDestroyed(httpSessionEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sessionDestroyedEvent:" + httpSessionEvent));
        }
    }

    public int getSessionTimeOut() {
        return (int)this.getSessionInvalidationTime();
    }

    public boolean isSessionTimeoutSet() {
        try {
            return this.scAppParms.getSessionTimeout() != 0L;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.httpsession.SessionContext.moreInit", (String)"2777", (Object)this);
            Tr.error((TraceComponent)tc, (String)"SessionContext.exception", (Object)exception);
            return false;
        }
    }

    boolean isUsingWebContainerSM() {
        return this.mParams.isUsingWebContainerSM();
    }

    public boolean isValid() {
        return this._refCount > 0;
    }

    synchronized void incrementRefCount() {
        ++this._refCount;
    }

    synchronized void decrementRefCount() {
        --this._refCount;
    }

    public void setProperties(Properties properties) {
        turnOffCacheId = HttpSessionSystemProperties.useCacheIdIfNecessary();
        turnOffCloneId = HttpSessionSystemProperties.useCloneIdIfNeccessary();
        useJCE = HttpSessionSystemProperties.isUseJCE();
        passivateAtWrite = HttpSessionSystemProperties.isPassivateAtWrite();
        passivateUsingCache = HttpSessionSystemProperties.isPassivateUsingCache();
        cloneSep = HttpSessionSystemProperties.getCloneSeperator();
        sessionIDLength = HttpSessionSystemProperties.getIdLength();
        idReuse = HttpSessionSystemProperties.isIdReuse();
        trackGCCount = HttpSessionSystemProperties.isTrackGC();
        noSwitchOver = HttpSessionSystemProperties.isDontSwitchOver();
        useBase32 = HttpSessionSystemProperties.getBase32Encoding();
        cloneId = EncodeCloneID.encodeString((String)this.mParams.getServerId());
        if (HttpSessionSystemProperties.getReaperPollInterval() > 0L) {
            this.mInvalidationCheckPollInterval = HttpSessionSystemProperties.getReaperPollInterval();
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)properties.get(string);
            if (string.equals("UseInformixDecimal")) {
                if (string2 == null || !string2.equalsIgnoreCase("true")) continue;
                this.useInformixDecimal = true;
                continue;
            }
            if (string.equals("HttpSessionIdLength")) {
                sessionIDLength = Integer.parseInt(string2);
                continue;
            }
            if (string.equals("SessionRewriteIdentifier")) {
                sessUrlRewritePrefix = ";" + string2 + "=";
                continue;
            }
            if (string.equals("HttpSessionCloneId")) {
                cloneId = string2;
                continue;
            }
            if (string.equals("NoAdditionalSessionInfo") && string2.compareToIgnoreCase("true") == 0) {
                turnOffCacheId = true;
                turnOffCloneId = true;
                continue;
            }
            if (string.equals("SessionIdentifierMaxLength")) {
                this.maxSessionIdentifierLength = Integer.parseInt(string2);
                continue;
            }
            if (string.equals("CloneSeperator")) {
                cloneSep = string2;
                continue;
            }
            if (string.equals("CloneSeparatorChange")) {
                cloneSep = "+";
                continue;
            }
            if (string.equals("HttpSessionReaperPollInterval")) {
                this.mInvalidationCheckPollInterval = new Long(string2);
                continue;
            }
            if (string.equals("NoAffinitySwitchBack")) {
                noSwitchOver = Boolean.valueOf(string2);
                continue;
            }
            if (string.equals("HttpSessionIdReuse")) {
                idReuse = new Boolean(string2);
                continue;
            }
            if (string.equals("UseOracleBLOB") && string2.compareToIgnoreCase("true") == 0) {
                useOracleBLOB = true;
                continue;
            }
            if (!string.equals("DebugSessionCrossover") || string2.compareToIgnoreCase("true") != 0 || debugSessionCrossover) continue;
            debugSessionCrossover = true;
            Tr.warning((TraceComponent)tc, (String)"SessionContext.DebugCrossoverEnabled");
        }
    }

    static {
        BASE32 = 0;
        BASE64 = 1;
        sBitChars = new char[]{'G', '9', 'U', 'i', 'b', 'w', '-', '8', '6', 'z', 'u', 'p', 'J', 'R', 'S', 'h', 'K', '5', 'n', 'c', '4', 'C', 't', 'I', 'W', '7', 'F', 'e', 'M', 'g', 'q', '2', '3', 'V', 'Z', 'k', 'O', 'D', 'a', 'v', 'y', 'Y', 'P', 'X', 'E', 'N', '1', 'f', 'l', 'B', '0', 'L', 's', 'o', 'A', 'T', 'd', 'x', 'm', 'r', 'Q', '_', 'j', 'H'};
        sSecondByteMasks = new int[]{0, 1, 3, 7, 15, 31, 63};
        cloneId = null;
        cloneIdLength = 0;
        sessionIDFactory = null;
        cloneSeparator = (char)58;
        useJCE = true;
        passivateUsingCache = true;
        passivateAtWrite = false;
        sessUrlRewritePrefix = ";jsessionid=";
        sessionIDLength = 23;
        trackGCCount = false;
        idReuse = false;
        noSwitchOver = false;
        useOracleBLOB = false;
        turnOffCacheId = false;
        turnOffCloneId = false;
        defaultCacheId = "0000";
        useBase32 = false;
        currentThreadSessionId = null;
        currentThreadDispatchCount = null;
        debugSessionCrossover = false;
        cloneSep = null;
        unSecStrs = new String[]{"<", ">", "&", "!"};
    }
}

