/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.session.IBMSession;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.httpsession.DummyHttpSessionContext;
import com.ibm.ws.webcontainer.httpsession.IHttpSession;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionCrossoverStackTrace;
import com.ibm.ws.webcontainer.httpsession.SessionDataList;
import com.ibm.ws.webcontainer.util.ArrayEnumeration;
import com.ibm.ws.webcontainer.util.SimpleHashtable;
import com.ibm.ws.webcontainer.util.objectpool.IPoolable;
import com.ibm.ws.webcontainer.util.objectpool.ObjectPool;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;

public abstract class SessionData
implements IHttpSession,
IBMSession,
com.ibm.ws.webcontainer.session.IHttpSession {
    SessionContext mManager;
    private String mSessionId;
    Hashtable mSwappableData;
    private SimpleHashtable mNonswappableData;
    private boolean mValid = true;
    private long mCreationTime;
    private long mLastAccessedTime;
    private boolean mIsNew;
    private boolean mIsCreatedOnUserThread = false;
    String cacheId;
    private int inactiveInterval;
    private String userName;
    String appName = null;
    boolean overflowed = false;
    int mInServiceMethodCount = 0;
    boolean cloneIdUpdated = false;
    boolean usingSSLId = false;
    String requestClonesId = null;
    protected LinkedList lockList;
    protected ObjectPool lockPool;
    protected boolean readIntoCache;
    boolean active = false;
    protected SessionDataList mValidList;
    protected SessionGCount _gcCount = null;
    static TraceComponent tc = SessionContext.tc;
    static final String SECURITY_PROP_NAME = "com_ibm_ejs_security_httpsession_info";
    static final StringBuffer dummyId = new StringBuffer("SESSIONMANAGEMENTAFFINI");
    static /* synthetic */ Class class$com$ibm$ws$webcontainer$httpsession$SessionData$SessionLock;

    synchronized void setValidity(boolean bl) {
        this.mValid = bl;
    }

    public SessionData(SessionContext sessionContext, String string) {
        this.mManager = sessionContext;
        this.mSessionId = string;
        this.mIsNew = true;
        if (this.mManager.getAllowSerializedSessionAccess()) {
            this.lockList = new LinkedList();
            this.lockPool = new ObjectPool(class$com$ibm$ws$webcontainer$httpsession$SessionData$SessionLock == null ? (class$com$ibm$ws$webcontainer$httpsession$SessionData$SessionLock = SessionData.class$("com.ibm.ws.webcontainer.httpsession.SessionData$SessionLock")) : class$com$ibm$ws$webcontainer$httpsession$SessionData$SessionLock, 10, false);
            for (int i = 1; i <= 10; ++i) {
                this.lockPool.returnObjectToPool((Object)new SessionLock());
            }
        }
        this.cacheId = SessionContext.defaultCacheId;
        this.readIntoCache = false;
        SessionData sessionData = this;
        if (sessionData.mManager.trackGCCount()) {
            this._gcCount = new SessionGCount();
        }
    }

    public SessionData() {
    }

    void setId(String string) {
        this.mSessionId = string;
    }

    public LinkedList getLockList() {
        return this.lockList;
    }

    public Object getLockObj() {
        Object object = null;
        try {
            object = this.lockPool.getObjectFromPool();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionData.getLockObj", (String)"197", (Object)this);
            object = new SessionLock();
        }
        if (object == null) {
            object = new SessionLock();
        }
        return object;
    }

    public void retLockObj(Object object) {
        this.lockPool.returnObjectToPool(object);
    }

    void setSessionContext(SessionContext sessionContext) {
        this.mManager = sessionContext;
    }

    public HttpSessionContext getSessionContext() {
        return new DummyHttpSessionContext();
    }

    public int getMaxInactiveInterval() {
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        return this.inactiveInterval;
    }

    SessionDataList getValidList() {
        return this.mValidList;
    }

    public void setMaxInactiveInterval(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.setMaxInactiveInterval");
        }
        this.inactiveInterval = n;
    }

    void setMaxInactInterval(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.setMaxInactInterval");
        }
        this.inactiveInterval = n;
    }

    public synchronized void releaseSession() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.releaseSession");
        }
        if (!this.isValid()) {
            return;
        }
        if (this.mManager != null) {
            this.mManager.sync(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionData.releaseSession");
        }
    }

    public synchronized void sync() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.syncSessionData");
        }
        this.mManager.sync(this);
    }

    public String getBrowserToken(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.getBrowserTokenDB");
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (this.cacheId != null) {
            stringBuffer.append(this.cacheId);
        }
        if (bl) {
            stringBuffer.append(dummyId);
        } else {
            stringBuffer.append(this.getId());
        }
        if (this.mManager.getCloneIdLength() > 0) {
            string = this.getPreviousClones();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("DatabaseSessionData:getBrowserToken - previousCloneIDs " + string));
            }
            if (string != null) {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public synchronized String testAndGetBrowserToken(boolean bl) {
        if (this.isBrowserTokenUpdated()) {
            this.setCloneIdUpdated(false);
            return this.getBrowserToken(bl);
        }
        return null;
    }

    public boolean isBrowserTokenUpdated() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.isBrowserTokenUpdated");
        }
        return this.isCloneIdUpdated();
    }

    public boolean isCloneIdUpdated() {
        return this.cloneIdUpdated;
    }

    void setCloneIdUpdated(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionData.setCloneIdUpdated " + this.cloneIdUpdated + " " + bl));
        }
        this.cloneIdUpdated = bl;
    }

    public String getId() {
        return this.mSessionId;
    }

    public long getCreationTime() {
        return this.mCreationTime;
    }

    void setCreationTime(long l) {
        this.mCreationTime = l;
    }

    public synchronized long getLastAccessedTime() {
        if (this.mIsNew) {
            return -1L;
        }
        return this.mLastAccessedTime;
    }

    long getLastAccTime() {
        return this.mLastAccessedTime;
    }

    synchronized void setLastAccessedTime(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.setLastAccessedTime ");
        }
        this.mLastAccessedTime = l;
    }

    void setNew(boolean bl) {
        this.mIsNew = bl;
    }

    public boolean isNew() throws IllegalStateException {
        if (!this.mValid) {
            throw new IllegalStateException();
        }
        return this.mIsNew;
    }

    boolean isCreatedOnUserThread() {
        return this.mIsCreatedOnUserThread;
    }

    void setCreatedOnUserThread(boolean bl) {
        this.mIsCreatedOnUserThread = bl;
    }

    Hashtable getSwappableData() {
        if (this.mSwappableData == null) {
            this.mSwappableData = new Hashtable();
        }
        return this.mSwappableData;
    }

    void setSwappableData(Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.setSwappableData");
        }
        this.mSwappableData = hashtable;
    }

    void setNonswappableData(SimpleHashtable simpleHashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.setNonswappableData");
        }
        this.mNonswappableData = simpleHashtable;
    }

    SimpleHashtable getNonswappableData() {
        if (this.mNonswappableData == null) {
            this.mNonswappableData = new SimpleHashtable(5);
        }
        return this.mNonswappableData;
    }

    void accessSessionData() {
        this.updateAccessTimeToNowOnAccess();
        this.mManager.notifySessionAccessed(this);
    }

    void updateAccessTimeToNowOnAccess() {
        this.mLastAccessedTime = System.currentTimeMillis();
    }

    protected void checkSwappableListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.checkSwappableListeners");
        }
        Enumeration enumeration = this.getSwappableData().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.getSwappableData().get(string);
            if (!(v instanceof HttpSessionBindingListener)) continue;
            this.processListeners(v, string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionData.checkSwappableListeners");
        }
    }

    public synchronized boolean isValid() {
        return this.mValid;
    }

    void internalInvalidate() {
        if (!this.isValid()) {
            return;
        }
        this.invalidate();
        this.mManager.incInvalidatedByTimeout();
    }

    public synchronized void invalidate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionData.invalidate  " + this.mSessionId));
        }
        this.crossoverCheck("invalidate");
        if (!this.isValid()) {
            throw new IllegalStateException();
        }
        this.mManager.incInvalidatedSessions(this.mCreationTime);
        this.setActive(false, 0L);
        if (this.mManager != null) {
            this.mManager.notifySessionInvalidated(this);
        }
        this.resetInServiceCount();
        this.mNonswappableData.clear();
        this.mSwappableData.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SessionData.invalidate  " + this.mSessionId));
        }
    }

    boolean isSwappableData(Object object) {
        return object != null && (object instanceof Serializable || object instanceof Externalizable);
    }

    public synchronized Enumeration getNames() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionData.getNames");
        }
        return new Enumeration(){
            Enumeration e1;
            Enumeration e2;
            {
                this.e1 = SessionData.this.getSwappableData().keys();
                this.e2 = SessionData.this.getNonswappableData().keys();
            }

            Enumeration getCurrent() {
                if (this.e1 != null && this.e1.hasMoreElements()) {
                    return this.e1;
                }
                this.e1 = null;
                if (this.e2 != null && this.e2.hasMoreElements()) {
                    return this.e2;
                }
                this.e2 = null;
                return null;
            }

            public boolean hasMoreElements() {
                return this.getCurrent() != null;
            }

            public Object nextElement() {
                Enumeration enumeration = this.getCurrent();
                if (enumeration == null) {
                    throw new NoSuchElementException();
                }
                return enumeration.nextElement();
            }
        };
    }

    public synchronized String[] getValueNames() throws IllegalStateException {
        String[] stringArray;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionData.getValueNames");
        }
        if (!this.mValid) {
            throw new IllegalStateException();
        }
        String[] stringArray2 = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (this.getSwappableData() != null) {
            n = this.mSwappableData.size();
        }
        if (this.getNonswappableData() != null) {
            n2 = this.mNonswappableData.size();
        }
        if (n == 0 && n2 == 0) {
            return stringArray2;
        }
        stringArray2 = new String[n + n2];
        int n3 = 0;
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!stringArray.equals(SECURITY_PROP_NAME)) {
                stringArray2[n3++] = stringArray;
                continue;
            }
            bl = true;
        }
        if (bl) {
            int n4 = n + n2 - 1;
            stringArray = new String[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                stringArray[n3] = stringArray2[n3];
            }
            return stringArray;
        }
        return stringArray2;
    }

    synchronized void putValueGuts(String string, Object object, boolean bl) throws IllegalStateException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SessionData:putValueGuts");
        }
        if (!this.mValid) {
            throw new IllegalStateException(this.toString());
        }
        if (string == null) {
            Tr.error((TraceComponent)tc, (String)"SessionData.putValErr1");
            return;
        }
        if (object == null) {
            Tr.error((TraceComponent)tc, (String)"SessionData.putValErr2", (Object)string);
            return;
        }
        if (string.equals(SECURITY_PROP_NAME) && !bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionData:putValueGuts - attempt to set Security Info Failed");
            }
            return;
        }
        boolean bl2 = false;
        Object object2 = null;
        if (this.isSwappableData(object)) {
            object2 = this.getSwappableData().get(string);
            if (object2 == null) {
                object2 = this.getNonswappableData().remove((Object)string);
            }
            this.getSwappableData().put(string, object);
        } else {
            object2 = this.getNonswappableData().get((Object)string);
            if (object2 == null) {
                object2 = this.getSwappableData().remove(string);
            }
            this.getNonswappableData().put((Object)string, object);
        }
        if (object2 != null) {
            bl2 = true;
        }
        if (bl2 && object2 instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object2).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string, object2));
        }
        if (object instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)object).valueBound(new HttpSessionBindingEvent((HttpSession)this, string, object));
        }
        if (this.getSessionAttributeListenerBoolean()) {
            if (!bl2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SessionData:PutValueGuts: calling HttpSessionAttributeListener.attributeAdded()");
                }
                this.mManager.sessionAttributeAddedEvent(new HttpSessionBindingEvent((HttpSession)this, string, object));
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SessionData:PutValueGuts: calling HttpSessionAttributeListener.attributeReplaced()");
                }
                this.mManager.sessionAttributeReplacedEvent(new HttpSessionBindingEvent((HttpSession)this, string, object2));
            }
        }
    }

    synchronized Object getValueGuts(String string, boolean bl) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData:getValueGuts");
        }
        if (!this.mValid) {
            throw new IllegalStateException(this.toString());
        }
        if (string.equals(SECURITY_PROP_NAME) && !bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionData:getValueGuts - attempt to retrieve security Info Failed");
            }
            return null;
        }
        Object object = this.getNonswappableData().get((Object)string);
        if (object == null) {
            object = this.getSwappableData().get(string);
        }
        return object;
    }

    synchronized void removeValueGuts(String string, boolean bl) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData:removeValueGuts");
        }
        if (!this.mValid) {
            throw new IllegalStateException();
        }
        if (string.equals(SECURITY_PROP_NAME) && !bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionData:removeValueGuts - attempt to remove Security Info failed");
            }
            return;
        }
        Object object = this.getNonswappableData().remove((Object)string);
        if (object == null) {
            object = this.getSwappableData().remove(string);
        }
        if (object instanceof HttpSessionBindingListener) {
            this.processListeners(object, string);
        }
        if (this.getSessionAttributeListenerBoolean()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionData:removeValueGuts: calling HttpSessionAttributeListener.attributeRemoved()");
            }
            this.mManager.sessionAttributeRemovedEvent(new HttpSessionBindingEvent((HttpSession)this, string, object));
        }
    }

    boolean getSessionAttributeListenerBoolean() {
        return this.mManager.sessionAttributeListener;
    }

    boolean getSessionListenerBoolean() {
        return this.mManager.sessionListener;
    }

    void processListeners(Object object, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.processListeners ");
        }
        ((HttpSessionBindingListener)object).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string, object));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SessionData.processListeners ");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.writeExternal");
        }
        if (this.mSwappableData == null) {
            this.mSwappableData = new Hashtable();
        }
        objectOutput.writeObject(this.mSwappableData);
        objectOutput.writeObject(this.getId());
        objectOutput.writeLong(this.getCreationTime());
        objectOutput.writeLong(this.getLastAccTime());
        objectOutput.writeInt(this.getMaxInactiveInterval());
        objectOutput.writeObject(this.userName);
        objectOutput.writeBoolean(this.isValid());
        objectOutput.writeBoolean(this.isNew());
        objectOutput.writeObject(this.cacheId);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.readExternal");
        }
        this.mSwappableData = (Hashtable)objectInput.readObject();
        this.mSessionId = (String)objectInput.readObject();
        this.setCreationTime(objectInput.readLong());
        this.setLastAccessedTime(objectInput.readLong());
        this.setMaxInactInterval(objectInput.readInt());
        this.userName = (String)objectInput.readObject();
        this.setValidity(objectInput.readBoolean());
        this.setNew(objectInput.readBoolean());
        this.cacheId = (String)objectInput.readObject();
    }

    public void sessionUnbound(SessionContext sessionContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData.sessionUnbound");
        }
        this.checkSwappableListeners();
        Enumeration enumeration = this.getNonswappableData().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.getNonswappableData().get((Object)string);
            if (!(object instanceof HttpSessionBindingListener)) continue;
            this.processListeners(object, string);
        }
        if (this.getSessionListenerBoolean()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionData:invalidate: calling sessionDestroyedEvent()");
            }
            this.mManager.sessionDestroyedEvent(new HttpSessionEvent((HttpSession)this));
        }
    }

    public synchronized String getUserName() {
        return this.userName;
    }

    void setUser(String string) {
        this.userName = string;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nSession Object Internals: \n").append("id : ").append(this.mSessionId).append("\n").append("hashCode : ").append(this.hashCode()).append("\n").append("create time : ").append(new Date(this.mCreationTime).toString()).append("\n").append("last access : ").append(new Date(this.mLastAccessedTime).toString()).append("\n").append("max inactive interval : ").append(this.inactiveInterval).append("\n").append("user name : ").append(this.userName).append("\n").append("valid session : ").append(this.mValid).append("\n").append("new session : ").append(this.mIsNew).append("\n").append("\n").append("overflowed : ").append(this.overflowed).append("\n").append("\n").append("\n").append("non-serializable app specific session data : ").append(this.mNonswappableData == null ? null : this.mNonswappableData.toString()).append("\n").append("serializable app specific session data : ").append(this.mSwappableData == null ? null : this.mSwappableData.toString()).append("\n");
        return stringBuffer.toString();
    }

    void initSession(SessionContext sessionContext) {
        this.mManager = sessionContext;
        this.appName = sessionContext.getAppName();
    }

    public boolean isOverflow() {
        return this.overflowed && !this.mValid;
    }

    public void removeAttribute(String string) {
        this.crossoverCheck("removeAttribute");
        this.removeValue(string);
    }

    public Object getAttribute(String string) {
        this.crossoverCheck("getAttribute");
        return this.getValue(string);
    }

    public Enumeration getAttributeNames() {
        Object[] objectArray = this.getValueNames();
        return new ArrayEnumeration(objectArray);
    }

    public void setAttribute(String string, Object object) {
        this.crossoverCheck("setAttribute");
        if (string != null && object == null) {
            this.removeValue(string);
        } else {
            this.putValue(string, object);
        }
    }

    int getInServiceMethodCount() {
        return this.mInServiceMethodCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementInServiceMethodCount() {
        SessionData sessionData = this;
        synchronized (sessionData) {
            ++this.mInServiceMethodCount;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("incrementInServiceMethodCount is now " + this.mInServiceMethodCount));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementInServiceMethodCount() {
        SessionData sessionData = this;
        synchronized (sessionData) {
            --this.mInServiceMethodCount;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("decrementInServiceMethodCount is now " + this.mInServiceMethodCount));
            }
        }
    }

    void resetInServiceCount() {
        this.mInServiceMethodCount = 0;
    }

    public boolean usingSSL() {
        return this.usingSSLId;
    }

    public void setUsingSSL(boolean bl) {
        this.usingSSLId = bl;
    }

    public void putSecurityInfo(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData:putSecurityInfo");
        }
        this.putValueGuts(SECURITY_PROP_NAME, object, true);
    }

    public void putValue(String string, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData:putValue");
        }
        this.putValueGuts(string, object, false);
    }

    public Object getSecurityInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData:getSecurityInfo");
        }
        return this.getValueGuts(SECURITY_PROP_NAME, true);
    }

    public Object getValue(String string) {
        return this.getValueGuts(string, false);
    }

    public void removeSecurityInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionData:removeSecurityInfo");
        }
        this.removeValueGuts(SECURITY_PROP_NAME, true);
    }

    public void removeValue(String string) {
        this.removeValueGuts(string, false);
    }

    String getPreviousClones() {
        return this.requestClonesId;
    }

    void setPreviousClones(String string) {
        this.requestClonesId = string;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    void setCacheId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionData:setCacheId to " + string));
        }
        this.cacheId = string;
    }

    public ServletContext getServletContext() {
        return this.mManager.getServletContext();
    }

    protected void checkActivationListeners() {
    }

    Hashtable getInMemorySwappableData() {
        return this.mSwappableData;
    }

    void notifyActivateListeners() {
        if (this.readIntoCache) {
            this.readIntoCache = false;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionContext:getIHttpSession - session readIntoCache.  Check for Activation Listener.");
            }
            this.checkActivationListeners();
        }
    }

    public HttpSession getFacade() {
        return null;
    }

    protected void setActive(boolean bl, long l) {
        if (bl != this.active) {
            if (bl) {
                this.mManager.incrementActiveSessionCount(l);
            } else {
                this.mManager.decrementActiveSessionCount();
            }
            this.active = bl;
        }
    }

    protected boolean isActive() {
        return this.active;
    }

    private void crossoverCheck(String string) {
        if (!(this.mIsNew && this.mIsCreatedOnUserThread || this.mManager == null || !this.mManager.crossoverCheck(this.mSessionId))) {
            Object[] objectArray = new Object[]{this.appName, this.mSessionId, string, (String)SessionContext.currentThreadSessionId.get(), new SessionCrossoverStackTrace()};
            Tr.error((TraceComponent)tc, (String)"SessionContext.CrossoverOnReference", (Object)objectArray);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SessionGCount {
        SessionGCount() {
        }

        protected void finalize() throws Throwable {
            try {
                if (SessionData.this.mManager != null) {
                    SessionData.this.mManager.incSessionGarbageCollected(System.currentTimeMillis());
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webcontainer.httpsession.SessionData.finalize", (String)"889", (Object)this);
            }
            super.finalize();
        }
    }

    public class SessionLock
    implements IPoolable {
        public void resetObject() {
        }
    }
}

