/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.httpsession;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.httpsession.SessionContext;
import com.ibm.ws.webcontainer.httpsession.SessionHashSet;
import com.ibm.ws.webcontainer.httpsession.TooManySessionsException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SessionSimpleHashMap
extends HashMap {
    int maxSize;
    int currentSize = 0;
    HashMap OverflowTabl;
    boolean overflowAllowed;
    static TraceComponent tc = SessionContext.tc;

    public SessionSimpleHashMap() {
        this(128, false);
    }

    public SessionSimpleHashMap(int n, boolean bl) {
        super(n + 20, 1.0f);
        this.maxSize = n;
        this.overflowAllowed = bl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleHashMap constructor - capacity is: " + this.maxSize), (Object)(" overflow is: " + this.overflowAllowed));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object put(Object object, Object object2) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionSimpleHashMap.put() - key=" + object + " value=" + object2));
        }
        Object object3 = null;
        Object v = super.get(object);
        if (v != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.put() - replacing existing entry");
            }
            object3 = super.put(object, object2);
        } else if (this.overflowAllowed && this.OverflowTabl != null) {
            hashMap = this.OverflowTabl;
            synchronized (hashMap) {
                v = this.OverflowTabl.get(object);
                if (v != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.put() - replacing existing entry in overflow Hashmap");
                    }
                    object3 = this.OverflowTabl.put(object, object2);
                }
            }
        }
        if (v == null) {
            ++this.currentSize;
            if (this.currentSize <= this.maxSize) {
                object3 = super.put(object, object2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.put() - add new entry to Hashmap");
                }
            } else {
                --this.currentSize;
                if (this.overflowAllowed) {
                    if (this.OverflowTabl == null) {
                        this.OverflowTabl = new HashMap(this.currentSize, 1.0f);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.put() - Creating Overflow Table");
                        }
                    }
                    hashMap = this.OverflowTabl;
                    synchronized (hashMap) {
                        object3 = this.OverflowTabl.put(object, object2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.put() - add new entry to overflow Hashmap");
                        }
                    }
                } else {
                    throw new TooManySessionsException();
                }
            }
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionSimpleHashMap.get() - key=" + object));
        }
        Object v = super.get(object);
        if (tc.isDebugEnabled() && v != null) {
            Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.get() - key found in HashMap");
        }
        if (v == null && this.overflowAllowed && this.OverflowTabl != null) {
            HashMap hashMap = this.OverflowTabl;
            synchronized (hashMap) {
                v = this.OverflowTabl.get(object);
                if (tc.isDebugEnabled() && v != null) {
                    Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.get() - key found in overflow HashMap");
                }
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object remove(Object object) {
        Object v;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SessionSimpleHashMap.remove() - key=" + object));
        }
        if ((v = super.remove(object)) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.remove() - key removed from HashMap");
            }
            --this.currentSize;
            return v;
        }
        if (this.overflowAllowed && this.OverflowTabl != null) {
            HashMap hashMap = this.OverflowTabl;
            synchronized (hashMap) {
                v = this.OverflowTabl.remove(object);
                if (tc.isDebugEnabled() && v != null) {
                    Tr.debug((TraceComponent)tc, (String)"SessionSimpleHashMap.remove() - key removed from overflow HashMap");
                }
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        super.clear();
        this.currentSize = 0;
        if (this.OverflowTabl != null) {
            HashMap hashMap = this.OverflowTabl;
            synchronized (hashMap) {
                this.OverflowTabl.clear();
            }
            this.OverflowTabl = null;
        }
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Object object;
        Object[] objectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SessionSimpleHashMap.keySet()");
        }
        int n = 0;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        int n2 = 0;
        Set set = super.keySet();
        SessionSimpleHashMap sessionSimpleHashMap = this;
        synchronized (sessionSimpleHashMap) {
            objectArray = set.toArray();
            n = objectArray.length;
            if (this.OverflowTabl != null) {
                Set set2 = this.OverflowTabl.keySet();
                object = this.OverflowTabl;
                synchronized (object) {
                    objectArray3 = set2.toArray();
                    n2 = objectArray3.length;
                }
            }
        }
        int n3 = n + n2;
        if (n3 != 0) {
            objectArray2 = new Object[n3];
            if (n != 0) {
                System.arraycopy(objectArray, 0, objectArray2, 0, n);
            }
            if (n2 != 0) {
                System.arraycopy(objectArray3, 0, objectArray2, n, n2);
            }
        }
        object = new SessionHashSet(objectArray2);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SessionSimpleHashMap.keySet() returning keySet" + object));
        }
        return object;
    }

    public Object accessEntry(Object object) {
        return this.get(object);
    }

    public Object insertEntry(Object object, Object object2) {
        return this.put(object, object2);
    }
}

