/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.ConflictState;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextAdapter;
import com.ibm.ws.sm.workspace.impl.RepositoryContextAdapterManager;
import com.ibm.ws.sm.workspace.impl.RepositoryContextPluggable;
import com.ibm.ws.sm.workspace.impl.WorkSpaceCatalogManager;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceEventImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceFileImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.impl.WorkSpacePersistentObjectImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceResourceSet;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.migration.MOFContextImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RepositoryContextImpl
extends MOFContextImpl
implements RepositoryContextPluggable,
WorkSpaceConstant,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(class$com$ibm$ws$sm$workspace$impl$RepositoryContextImpl == null ? (class$com$ibm$ws$sm$workspace$impl$RepositoryContextImpl = RepositoryContextImpl.class$("com.ibm.ws.sm.workspace.impl.RepositoryContextImpl")) : class$com$ibm$ws$sm$workspace$impl$RepositoryContextImpl);
    private WorkSpacePersistentObjectImpl data;
    private String relativeURI;
    private String fullPath;
    private String fullURI;
    protected RepositoryContextType type;
    protected RepositoryContext parent = null;
    protected WorkSpaceImpl workSpace = null;
    protected RepositoryContextAdapter adapter = null;
    private boolean fullFileList = false;
    protected HashMap files = new HashMap();
    protected HashMap childTypeMap = new HashMap();
    protected List children = new ArrayList();
    static /* synthetic */ Class class$com$ibm$ws$sm$workspace$impl$RepositoryContextImpl;

    public RepositoryContextImpl(WorkSpace workSpace, RepositoryContextType repositoryContextType, String string, RepositoryContext repositoryContext) {
        super(workSpace);
        this.workSpace = (WorkSpaceImpl)workSpace;
        this.type = repositoryContextType;
        this.setParent(repositoryContext);
        this.data = new WorkSpacePersistentObjectImpl(string);
        this.setState(WorkSpaceFileState.UPDATED);
    }

    void buildContext() throws WorkSpaceException {
        this.disableSave();
        this.clearAll();
        this.buildContextOnly(true);
        this.finalizeAll();
        this.enableSave();
        this.save();
        this.workSpace.notify(new WorkSpaceEventImpl(this, 10));
    }

    void buildContextOnly(boolean bl) throws WorkSpaceException {
        this.setState(WorkSpaceFileState.UPDATED);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("\tContext:" + this.getURI()));
        }
        Iterator iterator = this.getType().getChildContextTypes().iterator();
        while (iterator.hasNext()) {
            RepositoryContextType repositoryContextType = (RepositoryContextType)iterator.next();
            Map map = this.getAdapter().getChildContextsInRepository(repositoryContextType);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("\t\tType:" + repositoryContextType.getName()));
            }
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                String string2 = (String)map.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("\t\t\tName:" + string + ",uri:" + string2));
                }
                RepositoryContextImpl repositoryContextImpl = this.createLocal(repositoryContextType, string, string2);
                repositoryContextImpl.setState(WorkSpaceFileState.UPDATED);
                if (!bl) continue;
                repositoryContextImpl.buildContextOnly(bl);
            }
        }
    }

    private void disableSave() {
        this.workSpace.disableSave();
    }

    private void enableSave() {
        this.workSpace.enableSave();
    }

    private boolean isEnableSave() {
        return this.workSpace.isEnableSave();
    }

    public Map checkSynchState() throws WorkSpaceException {
        return this.checkSynchState(false);
    }

    Map checkSynchState(boolean bl) throws WorkSpaceException {
        this.workSpace.checkValid();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Iterator iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)iterator.next();
            Integer n = this.checkSynchState(workSpaceFileImpl);
            if (n == ConflictState.UN_MODIFIED) continue;
            hashMap.put(workSpaceFileImpl.getURI(), n);
        }
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            Map map = repositoryContextImpl.checkSynchState(bl);
            if (map.size() <= 0) continue;
            hashMap.putAll(map);
        }
        return hashMap;
    }

    private Integer checkSynchState(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        return this.getRepositoryAdapter().checkSynchState(workSpaceFile);
    }

    void clearAll() {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            repositoryContextImpl.clearAll();
        }
        this.setState(WorkSpaceFileState.NONE);
        this.clearLocalFile(null);
    }

    private void clearLocalFile(List list) {
        if (list == null) {
            this.getAllFiles().clear();
        } else {
            this.getAllFiles().removeAll(list);
        }
        this.fullFileList = false;
    }

    void finalizeAll() throws WorkSpaceException {
        ArrayList<RepositoryContextImpl> arrayList = new ArrayList<RepositoryContextImpl>();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            if (repositoryContextImpl.getState() == WorkSpaceFileState.NONE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CHILD:" + repositoryContextImpl.getURI() + " is NONE!!"));
                }
                arrayList.add(repositoryContextImpl);
                this.getChildTypeMap(repositoryContextImpl.getType()).remove(repositoryContextImpl.getName());
            }
            repositoryContextImpl.finalizeAll();
        }
        this.children.removeAll(arrayList);
    }

    public RepositoryContext create(RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        String string2 = this.getAdapter().getChildContextURI(repositoryContextType, string);
        RepositoryContext repositoryContext = this.create(repositoryContextType, string, string2);
        return repositoryContext;
    }

    public RepositoryContext create(RepositoryContextType repositoryContextType, String string, String string2) throws WorkSpaceException {
        this.workSpace.checkValid();
        RepositoryContextImpl repositoryContextImpl = this.createLocal(repositoryContextType, string, string2);
        repositoryContextImpl.setState(WorkSpaceFileState.ADDED);
        this.save();
        return repositoryContextImpl;
    }

    RepositoryContextImpl createLocal(RepositoryContextType repositoryContextType, String string, String string2) throws WorkSpaceException {
        HashMap hashMap;
        RepositoryContextImpl repositoryContextImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createLocal:" + repositoryContextType.getName() + "," + string + "," + string2));
        }
        if ((repositoryContextImpl = (RepositoryContextImpl)(hashMap = this.getChildTypeMap(repositoryContextType)).get(string)) != null && !repositoryContextImpl.isDeleted()) {
            throw WorkSpaceLogger.createException(tc, "WKSP0003E Context {0} already exists", new Object[]{string});
        }
        if (repositoryContextImpl == null) {
            repositoryContextImpl = new RepositoryContextImpl(this.workSpace, repositoryContextType, string, this);
            hashMap.put(string, repositoryContextImpl);
            this.children.add(repositoryContextImpl);
            repositoryContextImpl.setRelativeURI(string2);
        }
        return repositoryContextImpl;
    }

    void setRelativeURI(String string) {
        this.relativeURI = string;
        this.fullPath = null;
        this.fullURI = null;
        this.getWorkSpaceResourceSet().refreshPath();
    }

    public synchronized void delete(String string) throws WorkSpaceException {
        this.workSpace.checkValid();
        this.deleteOnly(string);
        this.save();
    }

    private synchronized void deleteOnly(String string) throws WorkSpaceException {
        String string2 = string.replace(WorkSpaceConstant.FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(string2)) {
            this.extractOnly(string2, false);
            this.getWorkSpaceResourceSet().release(string);
            this.notifyChangedOnly(2, string2);
        }
    }

    private WorkSpaceResourceSet getWorkSpaceResourceSet() {
        return (WorkSpaceResourceSet)this.getResourceSet();
    }

    public synchronized void delete(boolean bl) throws WorkSpaceException {
        this.workSpace.checkValid();
        this.disableSave();
        this.deleteOnly(bl);
        this.enableSave();
        this.save();
    }

    void deleteOnly(boolean bl) throws WorkSpaceException {
        WorkSpaceConstant workSpaceConstant;
        Iterator iterator;
        if (bl) {
            iterator = this.children.iterator();
            while (iterator.hasNext()) {
                workSpaceConstant = (RepositoryContextImpl)iterator.next();
                ((RepositoryContextImpl)workSpaceConstant).deleteOnly(bl);
            }
        }
        this.checkFullList();
        iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            workSpaceConstant = (WorkSpaceFileImpl)iterator.next();
            this.deleteOnly(((WorkSpaceFileImpl)workSpaceConstant).getName());
        }
        this.setState(WorkSpaceFileState.DELETED);
        this.delete();
    }

    private void checkFullList() throws WorkSpaceException {
        if (this.fullFileList) {
            return;
        }
        this.fullFileList = true;
        String[] stringArray = this.getRepositoryAdapter().getCatalog(this.workSpace, this.getURI(), 1, -1);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addLocalFile(stringArray[i]);
        }
    }

    private void addLocalFile(String string) throws WorkSpaceException {
        boolean bl = true;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            if (!string.startsWith(repositoryContextImpl.getRelativeURI())) continue;
            bl = false;
            break;
        }
        if (bl && this.getFileForRebuild(string) == null) {
            this.setFileState(string, WorkSpaceFileState.CLEAN);
        }
    }

    public synchronized void extract(String string, boolean bl) throws WorkSpaceException {
        this.workSpace.checkValid();
        this.extractOnly(string, bl);
        this.save();
    }

    private synchronized void extractOnly(String string, boolean bl) throws WorkSpaceException {
        WorkSpaceFileImpl workSpaceFileImpl;
        String string2 = string.replace(WorkSpaceConstant.FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(string2) && (!this.isExtracted(string2) || bl) && (workSpaceFileImpl = this.getFileForRebuild(string2)).getState() != WorkSpaceFileState.ADDED) {
            this.extract(workSpaceFileImpl);
            this.notifyChangedOnly(3, workSpaceFileImpl.getName());
        }
    }

    public synchronized void extract(boolean bl) throws WorkSpaceException {
        this.workSpace.checkValid();
        this.checkFullList();
        Iterator iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)iterator.next();
            this.extractOnly(workSpaceFileImpl.getName(), bl);
        }
        this.save();
    }

    private void extract(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        this.getRepositoryAdapter().extract(workSpaceFile);
    }

    public Collection findContext(RepositoryContextType repositoryContextType) throws WorkSpaceException {
        ArrayList<RepositoryContextImpl> arrayList = new ArrayList<RepositoryContextImpl>();
        Iterator<Object> iterator = this.getChildTypeMap(repositoryContextType).values().iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            if (repositoryContextImpl.isDeleted()) continue;
            arrayList.add(repositoryContextImpl);
        }
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            Collection collection = repositoryContextImpl.findContext(repositoryContextType);
            if (collection.size() <= 0) continue;
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public RepositoryContext findContext(String string) throws WorkSpaceException {
        return this.getAdapter().findContext(string);
    }

    public RepositoryContextAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = RepositoryContextAdapterManager.getManager().getAdapter(this);
        }
        return this.adapter;
    }

    public List getAllList(boolean bl) {
        ArrayList<WorkSpaceFile> arrayList;
        block5: {
            arrayList = new ArrayList<WorkSpaceFile>();
            try {
                this.checkFullList();
                Iterator iterator = this.getAllFiles().iterator();
                while (iterator.hasNext()) {
                    WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
                    if (!this.isAvailable(workSpaceFile)) continue;
                    arrayList.add(workSpaceFile);
                }
                if (bl) {
                    iterator = this.children.iterator();
                    while (iterator.hasNext()) {
                        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
                        List list = repositoryContextImpl.getAllList(bl);
                        if (list.size() <= 0) continue;
                        arrayList.addAll(list);
                    }
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("Exception when getting all the files:" + this.getURI()), (Object)exception);
            }
        }
        return arrayList;
    }

    public RepositoryContext getChild(RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)this.getChildForRebuild(repositoryContextType, string);
        if (repositoryContextImpl != null && repositoryContextImpl.isDeleted()) {
            repositoryContextImpl = null;
        }
        return repositoryContextImpl;
    }

    public RepositoryContext getChildForRebuild(RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        HashMap hashMap = this.getChildTypeMap(repositoryContextType);
        return (RepositoryContextImpl)hashMap.get(string);
    }

    public List getChildren() {
        ArrayList<RepositoryContextImpl> arrayList = new ArrayList<RepositoryContextImpl>();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            if (repositoryContextImpl.isDeleted()) continue;
            arrayList.add(repositoryContextImpl);
        }
        return arrayList;
    }

    boolean isDeleted() {
        return this.getState() == WorkSpaceFileState.DELETED || this.getState() == WorkSpaceFileState.NONE;
    }

    private HashMap getChildTypeMap(RepositoryContextType repositoryContextType) {
        HashMap hashMap = (HashMap)this.childTypeMap.get(repositoryContextType.getName());
        if (hashMap == null) {
            hashMap = new HashMap();
            this.childTypeMap.put(repositoryContextType.getName(), hashMap);
        }
        return hashMap;
    }

    public WorkSpaceRepositoryAdapter getRepositoryAdapter() throws WorkSpaceException {
        return this.workSpace.getRepositoryAdapter();
    }

    private WorkSpaceCatalogManager getCatalogManager() {
        return this.workSpace.getCatalogManager();
    }

    public boolean contentsChangedInRepository() throws WorkSpaceException {
        return this.getDeltaChangesInRepository().size() > 0;
    }

    public Map getDeltaChangesInRepository() throws WorkSpaceException {
        Map map = this.getCatalogManager().getDeltaChangesInRepository(this);
        Map map2 = this.checkSynchState(true);
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Integer n = (Integer)map2.get(string);
            if (n == ConflictState.ADDED) {
                map.put(string, WorkSpaceFileState.ADDED);
                continue;
            }
            if (n == ConflictState.REMOVED) {
                map.put(string, WorkSpaceFileState.DELETED);
                continue;
            }
            if (n != ConflictState.MODIFIED) continue;
            map.put(string, WorkSpaceFileState.UPDATED);
        }
        return map;
    }

    private RepositoryContextType getContextType(String string) {
        return this.getMetaData().getContextType(string);
    }

    private WorkSpaceFileImpl getFileForRebuild(String string) {
        WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)this.files.get(string);
        return workSpaceFileImpl;
    }

    public WorkSpaceFile getFile(String string) {
        if (this.isAvailable(string)) {
            return this.getFileForRebuild(string);
        }
        return null;
    }

    public Set getFiles() {
        HashSet<String> hashSet;
        block3: {
            hashSet = new HashSet<String>();
            try {
                this.checkFullList();
                Iterator iterator = this.getAllFiles().iterator();
                while (iterator.hasNext()) {
                    WorkSpaceFile workSpaceFile = (WorkSpaceFile)iterator.next();
                    if (!this.isAvailable(workSpaceFile)) continue;
                    hashSet.add(workSpaceFile.getName());
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Exception when getting all the files:" + this.getURI()), (Object)exception);
            }
        }
        return hashSet;
    }

    Collection getAllFiles() {
        return this.files.values();
    }

    private void getFiles(boolean bl, Map[] mapArray, Map map) throws WorkSpaceException {
        this.getFilesOnly(bl, mapArray, map);
        this.save();
    }

    private void getFilesOnly(boolean bl, Map[] mapArray, Map map) throws WorkSpaceException {
        Iterator iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)iterator.next();
            this.collectFile((WorkSpaceFile)workSpaceFileImpl, mapArray, map);
        }
        if (bl) {
            iterator = this.children.iterator();
            while (iterator.hasNext()) {
                RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
                repositoryContextImpl.getFilesOnly(bl, mapArray, map);
            }
        }
    }

    private void collectFile(WorkSpaceFile workSpaceFile, Map[] mapArray, Map map) throws WorkSpaceException {
        if (workSpaceFile.getState() == WorkSpaceFileState.ADDED) {
            this.collectFile(workSpaceFile, mapArray[0], map);
        } else if (workSpaceFile.getState() == WorkSpaceFileState.UPDATED) {
            this.collectFile(workSpaceFile, mapArray[1], map);
        } else if (workSpaceFile.getState() == WorkSpaceFileState.DELETED) {
            this.collectFile(workSpaceFile, mapArray[2], map);
        }
    }

    private void collectFile(WorkSpaceFile workSpaceFile, Map map, Map map2) throws WorkSpaceException {
        if (map2.containsKey(workSpaceFile.getURI())) {
            Integer n = (Integer)map2.get(workSpaceFile.getURI());
            if (n == ConflictResolution.OVER_WRITE) {
                map.put(workSpaceFile, n);
            } else if (n == ConflictResolution.DISCARD) {
                if (workSpaceFile.getState() == WorkSpaceFileState.ADDED) {
                    this.setFileState(workSpaceFile.getName(), WorkSpaceFileState.NONE);
                } else {
                    this.setFileState(workSpaceFile.getName(), WorkSpaceFileState.CLEAN);
                }
            }
        } else {
            map.put(workSpaceFile, null);
        }
    }

    public InputStream getInputStream(String string) throws WorkSpaceException {
        FileInputStream fileInputStream = null;
        String string2 = string.replace(WorkSpaceConstant.FILE_SEPERATOR_CHAR, '/');
        if (this.isAvailable(string2)) {
            this.extract(string2, false);
            try {
                WorkSpaceFileImpl workSpaceFileImpl = this.getFileForRebuild(string2);
                fileInputStream = new FileInputStream(workSpaceFileImpl.getPath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0014E Unable to get InputStream for {0} --{1}", new Object[]{string}, fileNotFoundException);
            }
        }
        return fileInputStream;
    }

    private RepositoryMetaData getMetaData() {
        return this.workSpace.getMetaData();
    }

    public List getModifiedList(boolean bl) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object3 = this.getAllFiles().iterator();
        while (object3.hasNext()) {
            object2 = (WorkSpaceFile)object3.next();
            object = object2.getState();
            if (object != WorkSpaceFileState.ADDED && object != WorkSpaceFileState.UPDATED && object != WorkSpaceFileState.DELETED) continue;
            arrayList.add(object2);
        }
        if (bl) {
            object2 = this.children.iterator();
            while (object2.hasNext()) {
                object = (RepositoryContextImpl)object2.next();
                object3 = ((RepositoryContextImpl)object).getModifiedList(bl);
                if (object3.size() <= 0) continue;
                arrayList.addAll((Collection<Object>)object3);
            }
        }
        return arrayList;
    }

    public String getName() {
        return this.data.getName();
    }

    public OutputStream getOutputStream(String string) throws WorkSpaceException {
        FileOutputStream fileOutputStream = null;
        String string2 = string.replace(WorkSpaceConstant.FILE_SEPERATOR_CHAR, '/');
        this.extract(string2, false);
        int n = this.isAvailable(string2) ? 1 : 0;
        this.notifyChanged(n, string2);
        WorkSpaceFileImpl workSpaceFileImpl = this.getFileForRebuild(string2);
        try {
            File file = new File(workSpaceFileImpl.getPath());
            FileUtil.makeDir(file.getParentFile());
            fileOutputStream = new FileOutputStream(workSpaceFileImpl.getPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0015E Unable to get OutputStream for {0} --{1}", new Object[]{string2}, fileNotFoundException);
        }
        return fileOutputStream;
    }

    public RepositoryContext getParentContext() {
        return this.parent;
    }

    public RepositoryContext getParent() {
        return this.parent;
    }

    public String getPath() {
        if (this.fullPath == null) {
            StringBuffer stringBuffer = new StringBuffer(this.workSpace.getPath());
            String string = this.getURI().replace('/', WorkSpaceConstant.FILE_SEPERATOR_CHAR);
            if (stringBuffer.length() > 0 && string.length() > 0) {
                stringBuffer.append(WorkSpaceConstant.FILE_SEPERATOR);
            }
            stringBuffer.append(string);
            this.fullPath = stringBuffer.toString();
        }
        return this.fullPath;
    }

    public String getURI() {
        if (this.fullURI == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getParentContext() != null) {
                stringBuffer.append(this.getParentContext().getURI());
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.getRelativeURI());
            this.fullURI = stringBuffer.toString();
        }
        return this.fullURI;
    }

    String getRelativeURI() {
        return this.relativeURI;
    }

    public String getProperty(String string) {
        return this.data.getProperty(string);
    }

    public Enumeration getPropertyNames() {
        return this.data.getPropertyNames();
    }

    public Integer getState() {
        return this.data.getState();
    }

    private void setState(Integer n) {
        this.data.setState(n);
    }

    public RepositoryContextType getType() {
        return this.type;
    }

    public WorkSpace getWorkSpace() {
        return this.workSpace;
    }

    public boolean isAvailable(String string) {
        WorkSpaceFileImpl workSpaceFileImpl = this.getFileForRebuild(string);
        boolean bl = this.isAvailable(workSpaceFileImpl);
        if (bl) {
            return true;
        }
        if (workSpaceFileImpl == null && !this.fullFileList) {
            bl = this.checkExist(string);
        }
        return bl;
    }

    private boolean isAvailable(WorkSpaceFile workSpaceFile) {
        boolean bl = workSpaceFile != null && workSpaceFile.getState() != WorkSpaceFileState.NONE && workSpaceFile.getState() != WorkSpaceFileState.DELETED;
        return bl;
    }

    private boolean checkExist(String string) {
        boolean bl;
        block4: {
            StringBuffer stringBuffer = new StringBuffer(this.getURI());
            if (stringBuffer.length() > 0 && string.length() > 0) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string.replace(WorkSpaceConstant.FILE_SEPERATOR_CHAR, '/'));
            bl = false;
            try {
                bl = this.getRepositoryAdapter().exist(this.workSpace, stringBuffer.toString());
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Check exist error:" + stringBuffer), (Object)exception);
            }
        }
        if (bl) {
            this.setFileState(string, WorkSpaceFileState.CLEAN);
        }
        return bl;
    }

    public boolean isExtracted(String string) {
        boolean bl = false;
        if (this.isAvailable(string)) {
            Integer n = this.getFileForRebuild(string).getState();
            bl = n != WorkSpaceFileState.CLEAN;
        }
        return bl;
    }

    public void notifyChanged(int n, String string) throws WorkSpaceException {
        this.notifyChangedOnly(n, string);
        this.save();
    }

    private void notifyChangedOnly(int n, String string) throws WorkSpaceException {
        WorkSpaceFile workSpaceFile = null;
        int n2 = 0;
        String string2 = string.replace(WorkSpaceConstant.FILE_SEPERATOR_CHAR, '/');
        if (n == 0) {
            if (!this.isAvailable(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Adding " + string2 + " to " + this.getURI()));
                }
                workSpaceFile = this.setFileState(string2, WorkSpaceFileState.ADDED);
                n2 = 20;
            }
        } else if (n == 2) {
            if (this.isAvailable(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Removing " + string2 + " from " + this.getURI()));
                }
                workSpaceFile = this.setFileState(string2, WorkSpaceFileState.DELETED);
                n2 = 21;
                this.delete(workSpaceFile);
            }
        } else if (n == 1) {
            if (this.isAvailable(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Updating " + string2 + " from " + this.getURI()));
                }
                workSpaceFile = this.setFileState(string2, WorkSpaceFileState.UPDATED);
                n2 = 22;
            }
        } else if (n == 3 && this.isAvailable(string2)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Extracted " + string2 + " from " + this.getURI()));
            }
            workSpaceFile = this.setFileState(string2, WorkSpaceFileState.EXTRACTED);
            n2 = 23;
        }
        if (workSpaceFile != null) {
            this.workSpace.notify(new WorkSpaceEventImpl(workSpaceFile, n2));
        }
    }

    private void delete(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        this.getRepositoryAdapter().delete(workSpaceFile);
    }

    private void delete() throws WorkSpaceException {
        this.getRepositoryAdapter().delete(this);
    }

    public synchronized void notifyChanged(int n, List list) throws WorkSpaceException {
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                this.notifyChangedOnly(n, (String)list.get(i));
            }
        }
        this.save();
    }

    public synchronized void release(boolean bl) throws WorkSpaceException {
        this.workSpace.checkValid();
        this.disableSave();
        this.releaseOnly(bl);
        this.enableSave();
        if (bl) {
            this.buildContext();
        } else {
            this.save();
        }
    }

    void releaseOnly(boolean bl) throws WorkSpaceException {
        Object object;
        Object object2;
        if (bl) {
            object2 = this.children.iterator();
            while (object2.hasNext()) {
                object = (RepositoryContextImpl)object2.next();
                ((RepositoryContextImpl)object).releaseOnly(bl);
            }
        }
        this.resetAdapterNotifier(false);
        try {
            object = this.getAllFiles().iterator();
            while (object.hasNext()) {
                object2 = (WorkSpaceFileImpl)object.next();
                this.release((WorkSpaceFileImpl)object2, false);
            }
            this.workSpace.notify(new WorkSpaceEventImpl(this, 11));
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0005E Error while releasing context {0}-{1}", new Object[]{this.getName(), exception}, exception);
        }
        finally {
            this.clearLocalFile(null);
            this.resetAdapterNotifier(true);
        }
    }

    void resetAdapterNotifier(boolean bl) {
        this.getWorkSpaceResourceSet().setAdapterNotifier(bl);
    }

    public synchronized void releaseUnchanged(boolean bl, boolean bl2) throws WorkSpaceException {
        this.workSpace.checkValid();
        this.disableSave();
        this.releaseUnchangedOnly(bl, bl2);
        this.enableSave();
        this.save();
    }

    void releaseUnchangedOnly(boolean bl, boolean bl2) throws WorkSpaceException {
        WorkSpaceConstant workSpaceConstant;
        Object object;
        if (bl) {
            object = this.children.iterator();
            while (object.hasNext()) {
                workSpaceConstant = (RepositoryContextImpl)object.next();
                ((RepositoryContextImpl)workSpaceConstant).releaseUnchangedOnly(bl, bl2);
            }
        }
        this.resetAdapterNotifier(false);
        object = new ArrayList();
        try {
            Iterator iterator = this.getAllFiles().iterator();
            while (iterator.hasNext()) {
                workSpaceConstant = (WorkSpaceFileImpl)iterator.next();
                if (((WorkSpaceFileImpl)workSpaceConstant).getState() == WorkSpaceFileState.EXTRACTED) {
                    this.release((WorkSpaceFileImpl)workSpaceConstant, bl2);
                }
                if (((WorkSpaceFileImpl)workSpaceConstant).getState() != WorkSpaceFileState.CLEAN && ((WorkSpaceFileImpl)workSpaceConstant).getState() != WorkSpaceFileState.NONE && (((WorkSpaceFileImpl)workSpaceConstant).getState() != WorkSpaceFileState.EXTRACTED || bl2)) continue;
                object.add(workSpaceConstant);
            }
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0005E Error while releasing context {0}-{1}", new Object[]{this.getName(), exception}, exception);
        }
        finally {
            this.clearLocalFile((List)object);
            this.resetAdapterNotifier(true);
        }
    }

    private void release(WorkSpaceFileImpl workSpaceFileImpl, boolean bl) throws WorkSpaceException {
        this.getWorkSpaceResourceSet().release(workSpaceFileImpl.getName());
        if (!bl) {
            this.release(workSpaceFileImpl);
            this.workSpace.notify(new WorkSpaceEventImpl(workSpaceFileImpl, 24));
        }
    }

    private void release(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        this.getRepositoryAdapter().release(workSpaceFile);
    }

    void remove() throws WorkSpaceException {
        this.delete(true);
        this.setState(WorkSpaceFileState.DELETED);
    }

    public String removeProperty(String string) throws WorkSpaceException {
        String string2 = this.data.removeProperty(string);
        this.save();
        return string2;
    }

    void restore() throws WorkSpaceException {
        this.disableSave();
        String string = this.getRepositoryAdapter().restore(this);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "~");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                Object object;
                String string2 = stringTokenizer.nextToken();
                int n2 = string2.indexOf("=");
                if (n2 == -1) continue;
                String string3 = string2.substring(0, n2);
                String string4 = "";
                if (n2 + 1 < string2.length()) {
                    string4 = string2.substring(n2 + 1);
                }
                if (string3.equals("data")) {
                    this.data.restore(string4);
                    continue;
                }
                if (string3.equals("uri")) {
                    this.relativeURI = string4;
                    continue;
                }
                if (string3.equals("file")) {
                    n2 = string4.indexOf("[");
                    if (n2 == -1) continue;
                    String string5 = string4.substring(0, n2);
                    object = this.setFileState(string5, WorkSpaceFileState.CLEAN);
                    ((WorkSpaceFileImpl)object).restore(string4);
                    continue;
                }
                if (!string3.equals("child") || (n2 = string4.indexOf("[")) == -1 || (n = string4.indexOf("[", n2 + 1)) == -1) continue;
                object = string4.substring(0, n2);
                String string6 = string4.substring(n2 + 1, n);
                String string7 = string4.substring(n + 1);
                RepositoryContextType repositoryContextType = this.getContextType(string6);
                RepositoryContext repositoryContext = this.getChildForRebuild(repositoryContextType, (String)object);
                if (repositoryContext == null) {
                    repositoryContext = this.createLocal(repositoryContextType, (String)object, string7);
                }
                ((RepositoryContextImpl)repositoryContext).restore();
            }
        }
        this.enableSave();
    }

    void save() throws WorkSpaceException {
        if (!this.isEnableSave()) {
            return;
        }
        this.getRepositoryAdapter().save(this);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            repositoryContextImpl.save();
        }
    }

    private WorkSpaceFile setFileState(String string, Integer n) {
        String string2;
        WorkSpaceFileImpl workSpaceFileImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setFileState: " + string + "," + n));
        }
        if ((workSpaceFileImpl = this.getFileForRebuild(string2 = string.replace(WorkSpaceConstant.FILE_SEPERATOR_CHAR, '/'))) == null) {
            workSpaceFileImpl = new WorkSpaceFileImpl(this, string2);
            this.files.put(string2, workSpaceFileImpl);
        }
        if (workSpaceFileImpl.getState() == WorkSpaceFileState.ADDED) {
            if (n == WorkSpaceFileState.UPDATED) {
                n = workSpaceFileImpl.getState();
            } else if (n == WorkSpaceFileState.DELETED) {
                n = WorkSpaceFileState.NONE;
            }
        } else if (workSpaceFileImpl.getState() == WorkSpaceFileState.DELETED) {
            if (n == WorkSpaceFileState.ADDED) {
                n = WorkSpaceFileState.UPDATED;
            }
        } else if (workSpaceFileImpl.getState() == WorkSpaceFileState.UPDATED && n == WorkSpaceFileState.EXTRACTED) {
            n = WorkSpaceFileState.UPDATED;
        }
        workSpaceFileImpl.setState(n);
        return workSpaceFileImpl;
    }

    protected void setParent(RepositoryContext repositoryContext) {
        this.parent = repositoryContext;
    }

    public void setProperty(String string, String string2) throws WorkSpaceException {
        this.data.setProperty(string, string2);
        this.save();
    }

    public synchronized void synch(Map map) throws WorkSpaceException {
        int n;
        this.workSpace.checkValid();
        Map[] mapArray = new HashMap[3];
        for (n = 0; n < 3; ++n) {
            mapArray[n] = new HashMap();
        }
        this.getFiles(true, mapArray, map);
        this.update(mapArray);
        this.workSpace.notify(new WorkSpaceEventImpl(this, 12));
        for (n = 0; n < 3; ++n) {
            Iterator iterator = mapArray[n].keySet().iterator();
            while (iterator.hasNext()) {
                this.workSpace.notify(new WorkSpaceEventImpl((WorkSpaceFile)iterator.next(), 25));
            }
        }
        this.release(true);
    }

    public String getPersistData() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("data");
        stringBuffer.append("=");
        stringBuffer.append(this.data.getPersistData());
        stringBuffer.append("~");
        stringBuffer.append("uri");
        stringBuffer.append("~");
        stringBuffer.append(this.getRelativeURI());
        Iterator iterator = this.getAllFiles().iterator();
        while (iterator.hasNext()) {
            WorkSpaceFileImpl workSpaceFileImpl = (WorkSpaceFileImpl)iterator.next();
            stringBuffer.append("~");
            stringBuffer.append("file");
            stringBuffer.append("=");
            stringBuffer.append(workSpaceFileImpl.getPersistData());
        }
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)iterator.next();
            stringBuffer.append("~");
            stringBuffer.append("child");
            stringBuffer.append("=");
            stringBuffer.append(repositoryContextImpl.getName());
            stringBuffer.append("[");
            stringBuffer.append(repositoryContextImpl.getType().getName());
            stringBuffer.append("[");
            stringBuffer.append(repositoryContextImpl.getRelativeURI());
        }
        return stringBuffer.toString();
    }

    private void update(Map[] mapArray) throws WorkSpaceException {
        this.getRepositoryAdapter().update(mapArray);
    }

    public String toString() {
        return this.getURI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

