/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class WorkSpaceCatalogManager
implements WorkSpaceConstant {
    private WorkSpaceImpl workspace;

    WorkSpaceCatalogManager(WorkSpaceImpl workSpaceImpl) {
        this.workspace = workSpaceImpl;
    }

    private WorkSpaceRepositoryAdapter getRepositoryAdapter() throws WorkSpaceException {
        return this.workspace.getRepositoryAdapter();
    }

    Map getDeltaChangesInRepository(RepositoryContextImpl repositoryContextImpl) throws WorkSpaceException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        WorkSpaceRepositoryAdapter workSpaceRepositoryAdapter = repositoryContextImpl.getRepositoryAdapter();
        if (repositoryContextImpl.getState() == WorkSpaceFileState.UPDATED || repositoryContextImpl.getState() == WorkSpaceFileState.DELETED) {
            if (!workSpaceRepositoryAdapter.exist(this.workspace, repositoryContextImpl.getURI())) {
                hashMap.put(repositoryContextImpl.getURI(), WorkSpaceFileState.DELETED);
                return hashMap;
            }
        } else if (repositoryContextImpl.getState() == WorkSpaceFileState.ADDED) {
            if (workSpaceRepositoryAdapter.exist(this.workspace, repositoryContextImpl.getURI())) {
                hashMap.put(repositoryContextImpl.getURI(), WorkSpaceFileState.ADDED);
            }
            return hashMap;
        }
        Iterator iterator = repositoryContextImpl.getType().getChildContextTypes().iterator();
        while (iterator.hasNext()) {
            RepositoryContextType repositoryContextType = (RepositoryContextType)iterator.next();
            Iterator iterator2 = repositoryContextImpl.getAdapter().getChildContextsInRepository(repositoryContextType).keySet().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                RepositoryContext repositoryContext = repositoryContextImpl.getChildForRebuild(repositoryContextType, string);
                if (repositoryContext != null) continue;
                StringBuffer stringBuffer = new StringBuffer(repositoryContextImpl.getURI());
                string = repositoryContextImpl.getAdapter().getChildContextURI(repositoryContextType, string);
                if (stringBuffer.length() > 0 && string.length() > 0) {
                    stringBuffer.append('/');
                }
                stringBuffer.append(string);
                hashMap.put(stringBuffer.toString(), WorkSpaceFileState.ADDED);
            }
        }
        iterator = repositoryContextImpl.getChildren().iterator();
        while (iterator.hasNext()) {
            hashMap.putAll(this.getDeltaChangesInRepository((RepositoryContextImpl)iterator.next()));
        }
        return hashMap;
    }
}

