/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceEvent;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceListener;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceCatalogManager;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceEventImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.migration.MOFWorkSpaceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class WorkSpaceImpl
extends MOFWorkSpaceImpl
implements WorkSpace,
WorkSpaceConstant,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(class$com$ibm$ws$sm$workspace$impl$WorkSpaceImpl == null ? (class$com$ibm$ws$sm$workspace$impl$WorkSpaceImpl = WorkSpaceImpl.class$("com.ibm.ws.sm.workspace.impl.WorkSpaceImpl")) : class$com$ibm$ws$sm$workspace$impl$WorkSpaceImpl);
    protected boolean enableSave = true;
    protected String userName = "";
    protected String sessionId = null;
    protected String path = null;
    protected String userPath = null;
    protected RepositoryContextImpl rootContext = null;
    protected List listeners = new ArrayList();
    private WorkSpaceCatalogManager catalogManager;
    private RepositoryMetaData metaData;
    private WorkSpaceRepositoryAdapter repositoryAdapter;
    static /* synthetic */ Class class$com$ibm$ws$sm$workspace$impl$WorkSpaceImpl;
    static /* synthetic */ Class class$com$ibm$ws$sm$workspace$impl$WorkSpaceMasterRepositoryAdapter;

    public WorkSpaceImpl(String string) throws WorkSpaceException {
        this.userName = string;
    }

    WorkSpaceCatalogManager getCatalogManager() {
        if (this.catalogManager == null) {
            this.catalogManager = new WorkSpaceCatalogManager(this);
        }
        return this.catalogManager;
    }

    public RepositoryMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = this.getRepositoryAdapter().getMetaData();
        }
        return this.metaData;
    }

    WorkSpaceRepositoryAdapter getRepositoryAdapter() {
        return this.repositoryAdapter;
    }

    void setRepositoryAdapter(WorkSpaceRepositoryAdapter workSpaceRepositoryAdapter) {
        this.repositoryAdapter = workSpaceRepositoryAdapter;
    }

    void setMetaData(RepositoryMetaData repositoryMetaData) {
        this.metaData = repositoryMetaData;
    }

    public void addWorkSpaceListener(WorkSpaceListener workSpaceListener) {
        if (!this.listeners.contains(workSpaceListener)) {
            this.listeners.add(workSpaceListener);
        }
    }

    void buildContext() throws WorkSpaceException {
        if (this.getRootContext().getModifiedList(true).size() == 0) {
            ((RepositoryContextImpl)this.getRootContext()).buildContext();
        }
    }

    public Map checkSynchState() throws WorkSpaceException {
        return this.getRootContext().checkSynchState();
    }

    public Map checkSynchState(RepositoryContext repositoryContext) throws WorkSpaceException {
        return repositoryContext.checkSynchState();
    }

    public void checkValid() throws WorkSpaceException {
        if (!this.isValid()) {
            this.notify(new WorkSpaceEventImpl(this, 0));
            throw WorkSpaceLogger.createException(tc, "WKSP0009E Workspace is invalid");
        }
    }

    public synchronized RepositoryContext create(RepositoryContext repositoryContext, RepositoryContextType repositoryContextType, String string) throws WorkSpaceException {
        return repositoryContext.create(repositoryContextType, string);
    }

    private RepositoryContextImpl createRootContext() {
        RepositoryContextImpl repositoryContextImpl = new RepositoryContextImpl(this, this.getRootContextType(), "", null);
        repositoryContextImpl.setRelativeURI("");
        return repositoryContextImpl;
    }

    public void delete(RepositoryContext repositoryContext) throws WorkSpaceException {
        repositoryContext.delete(true);
    }

    public void extract(RepositoryContext repositoryContext, String string, boolean bl) throws WorkSpaceException {
        repositoryContext.extract(string, bl);
    }

    public void extract(RepositoryContext repositoryContext, boolean bl) throws WorkSpaceException {
        repositoryContext.extract(bl);
    }

    public Collection findContext(RepositoryContextType repositoryContextType) throws WorkSpaceException {
        return this.getRootContext().findContext(repositoryContextType);
    }

    public RepositoryContext findContext(String string) throws WorkSpaceException {
        return this.getRootContext().findContext(string);
    }

    public List getModifiedList() {
        return this.getRootContext().getModifiedList(true);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = this.getUserPath() + WorkSpaceConstant.FILE_SEPERATOR + "workspace";
        }
        return this.path;
    }

    public String getUserPath() {
        if (this.userPath == null) {
            this.userPath = WorkSpaceConstant.WORKSPACE_PATH_NAME + WorkSpaceConstant.FILE_SEPERATOR + this.getUserName();
        }
        return this.userPath;
    }

    void setUserRoot(String string) {
        this.userPath = string + WorkSpaceConstant.FILE_SEPERATOR + this.getUserName();
        this.path = null;
    }

    void setPath(String string) {
        this.path = string;
        this.userPath = string;
    }

    public RepositoryContext getRootContext() {
        if (this.rootContext == null) {
            this.rootContext = this.createRootContext();
        }
        return this.rootContext;
    }

    private RepositoryContextType getRootContextType() {
        return this.getMetaData().getRootContextType();
    }

    public boolean isExtracted(RepositoryContext repositoryContext, String string) {
        return repositoryContext.isExtracted(string);
    }

    void enableSave() {
        this.enableSave = true;
    }

    void disableSave() {
        this.enableSave = false;
    }

    boolean isEnableSave() {
        return this.enableSave;
    }

    boolean isValid() throws WorkSpaceException {
        boolean bl = true;
        bl = this.sessionId == null ? false : this.getRepositoryAdapter().isValid(this);
        return bl;
    }

    public void notify(WorkSpaceEvent workSpaceEvent) throws WorkSpaceException {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WorkSpaceListener workSpaceListener = (WorkSpaceListener)iterator.next();
            workSpaceListener.handle(workSpaceEvent);
        }
    }

    void remove() throws WorkSpaceException {
        this.release();
        this.getRepositoryAdapter().remove(this);
    }

    public void release() throws WorkSpaceException {
        this.getRootContext().release(true);
    }

    public void releaseUnchanged(boolean bl) throws WorkSpaceException {
        this.getRootContext().releaseUnchanged(true, bl);
    }

    public void release(RepositoryContext repositoryContext) throws WorkSpaceException {
        repositoryContext.release(true);
    }

    public void removePersistent() throws WorkSpaceException {
        if ((class$com$ibm$ws$sm$workspace$impl$WorkSpaceMasterRepositoryAdapter == null ? (class$com$ibm$ws$sm$workspace$impl$WorkSpaceMasterRepositoryAdapter = WorkSpaceImpl.class$("com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter")) : class$com$ibm$ws$sm$workspace$impl$WorkSpaceMasterRepositoryAdapter).isInstance(this.repositoryAdapter)) {
            FileUtil.deleteTree(this.getPath());
        }
    }

    public void removeWorkSpaceListener(WorkSpaceListener workSpaceListener) {
        if (this.listeners.contains(workSpaceListener)) {
            this.listeners.remove(workSpaceListener);
        }
    }

    void restore() throws WorkSpaceException {
        ((RepositoryContextImpl)this.getRootContext()).restore();
        this.buildContext();
    }

    public void synch(RepositoryContext repositoryContext, Map map) throws WorkSpaceException {
        repositoryContext.synch(map);
    }

    public void synch(Map map) throws WorkSpaceException {
        this.getRootContext().synch(map);
    }

    boolean ofSession(String string) throws WorkSpaceException {
        boolean bl = true;
        if (this.isValid()) {
            if (string == null) {
                string = "";
            }
            bl = this.sessionId.equals(string);
        }
        return bl;
    }

    void setSessionId(String string) throws WorkSpaceException {
        if (string == null) {
            string = "";
        }
        this.sessionId = string;
        this.getRepositoryAdapter().setSessionId(this);
        this.notify(new WorkSpaceEventImpl(this, 1));
    }

    void unsetSessionId() throws WorkSpaceException {
        if (this.sessionId != null) {
            this.getRepositoryAdapter().unsetSessionId(this);
            this.sessionId = null;
        }
        this.notify(new WorkSpaceEventImpl(this, 0));
        this.listeners.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

