/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.util.HashMap;
import java.util.Properties;

public final class WorkSpaceManagerImpl
implements WorkSpaceManager,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(class$com$ibm$ws$sm$workspace$impl$WorkSpaceManagerImpl == null ? (class$com$ibm$ws$sm$workspace$impl$WorkSpaceManagerImpl = WorkSpaceManagerImpl.class$("com.ibm.ws.sm.workspace.impl.WorkSpaceManagerImpl")) : class$com$ibm$ws$sm$workspace$impl$WorkSpaceManagerImpl);
    private HashMap workspaces = new HashMap();
    private boolean init = false;
    private ClassLoader classLoader = null;
    static /* synthetic */ Class class$com$ibm$ws$sm$workspace$impl$WorkSpaceManagerImpl;

    private String getProperty(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        return string2;
    }

    private WorkSpaceImpl createWorkSpace(Properties properties) throws WorkSpaceException {
        WorkSpaceRepositoryAdapter workSpaceRepositoryAdapter;
        String string = this.getProperty(properties, "workspace.user.id");
        String string2 = this.getProperty(properties, "workspace.session.id");
        String string3 = this.getProperty(properties, "workspace.user.root");
        String string4 = this.getProperty(properties, "workspace.root");
        String string5 = this.getProperty(properties, "workspace.metadata.root");
        String string6 = this.getProperty(properties, "workspace.repository.adapter");
        WorkSpaceImpl workSpaceImpl = new WorkSpaceImpl(string);
        this.workspaces.put(string, workSpaceImpl);
        if (string4 != null) {
            workSpaceImpl.setPath(string4);
        } else if (string3 != null) {
            workSpaceImpl.setUserRoot(string3);
        }
        if (string5 != null) {
            workSpaceImpl.setMetaData(RepositoryMetaDataFactory.getFactory().getMetaData(string5));
        }
        if (string6 == null) {
            string6 = "com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Create workspace ... \n\t WorkspaceUserPath: " + workSpaceImpl.getUserPath() + "\n\t WorkspacePath ...: " + workSpaceImpl.getPath() + "\n\t repositoryAdapter: " + string6));
        }
        try {
            workSpaceRepositoryAdapter = (WorkSpaceRepositoryAdapter)this.getInstanceOfType(string6);
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0019E Error getting repository adapter {0} --{1}", new Object[]{string6, exception}, exception);
        }
        workSpaceRepositoryAdapter.initialize(properties);
        workSpaceImpl.setRepositoryAdapter(workSpaceRepositoryAdapter);
        workSpaceImpl.setSessionId(string2);
        workSpaceImpl.restore();
        return workSpaceImpl;
    }

    public synchronized WorkSpace getWorkSpace(String string) throws WorkSpaceException {
        return this.getWorkSpace(string, null);
    }

    public synchronized WorkSpace getWorkSpace(String string, String string2) throws WorkSpaceException {
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("workspace.user.id", string);
        }
        if (string2 != null) {
            properties.setProperty("workspace.session.id", string2);
        }
        return this.getWorkSpace(properties);
    }

    public synchronized WorkSpace getWorkSpace(Properties properties) throws WorkSpaceException {
        String string = properties.getProperty("workspace.user.id");
        String string2 = properties.getProperty("workspace.session.id");
        boolean bl = tc.isDebugEnabled();
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)this.workspaces.get(string);
        if (workSpaceImpl == null) {
            workSpaceImpl = this.createWorkSpace(properties);
        } else if (!workSpaceImpl.isValid()) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"WorkSpace is previously released.");
            }
            workSpaceImpl = this.createWorkSpace(properties);
        } else if (!workSpaceImpl.ofSession(string2) && string2 != null) {
            if (bl) {
                Tr.debug((TraceComponent)tc, (String)"WorkSpace is not previously released.");
            }
            workSpaceImpl.unsetSessionId();
            workSpaceImpl = this.createWorkSpace(properties);
        } else if (bl) {
            Tr.debug((TraceComponent)tc, (String)"The same sessionId share the same WorkSpace.");
        }
        return workSpaceImpl;
    }

    public synchronized void releaseWorkSpace(String string, String string2) throws WorkSpaceException {
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)this.workspaces.get(string);
        if (workSpaceImpl != null && workSpaceImpl.isValid()) {
            boolean bl = tc.isDebugEnabled();
            if (workSpaceImpl.ofSession(string2)) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)("Release WorkSpace from UserId:" + string + ",SessionId:" + string2));
                }
                workSpaceImpl.unsetSessionId();
                this.workspaces.remove(string);
            } else if (bl) {
                Tr.debug((TraceComponent)tc, (String)("Wrong sessionId:" + string2));
            }
        }
    }

    public synchronized void releaseWorkSpace(String string) throws WorkSpaceException {
        this.releaseWorkSpace(string, null);
    }

    public synchronized void removeWorkSpace(String string) throws WorkSpaceException {
        this.removeWorkSpace(string, null);
    }

    public synchronized void removeWorkSpace(String string, String string2) throws WorkSpaceException {
        WorkSpaceImpl workSpaceImpl = (WorkSpaceImpl)this.workspaces.get(string);
        if (workSpaceImpl != null) {
            boolean bl = tc.isDebugEnabled();
            if (workSpaceImpl.ofSession(string2)) {
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)("Remove WorkSpace from User:" + string + ",SessionId:" + string2));
                }
                workSpaceImpl.remove();
                workSpaceImpl.unsetSessionId();
                this.workspaces.remove(string);
            } else if (bl) {
                Tr.debug((TraceComponent)tc, (String)("Wrong sessionId:" + string2));
            }
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (this.classLoader == null) {
            this.classLoader = ClassLoader.getSystemClassLoader();
        }
        return this.classLoader;
    }

    Class getClassOfType(String string) throws Exception {
        Object var2_2 = null;
        return Class.forName(string, true, this.getClassLoader());
    }

    private Object getInstanceOfType(String string) throws Exception {
        Class clazz = this.getClassOfType(string);
        return clazz.newInstance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

