/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.management.repository.RepositoryInputStream;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.ws.sm.workspace.ConflictResolution;
import com.ibm.ws.sm.workspace.ConflictState;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceFileState;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.FileUtil;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.impl.WorkSpaceResourceSet;
import com.ibm.ws.sm.workspace.merger.MergeUtilManager;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class WorkSpaceMasterRepositoryAdapter
implements WorkSpaceRepositoryAdapter,
WorkSpaceMessage,
WorkSpaceConstant {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(class$com$ibm$ws$sm$workspace$impl$WorkSpaceMasterRepositoryAdapter == null ? (class$com$ibm$ws$sm$workspace$impl$WorkSpaceMasterRepositoryAdapter = WorkSpaceMasterRepositoryAdapter.class$("com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter")) : class$com$ibm$ws$sm$workspace$impl$WorkSpaceMasterRepositoryAdapter);
    private boolean debugEnabled = tc.isDebugEnabled();
    private static final String SESSION_ID_FILE_PREFIX = ".workspace_";
    private static final String DIGEST_SUFFIX = ".workspace_save";
    private static final String ORIG_SUFFIX = ".copy";
    private static final String CURRENT_SUFFIX = ".current";
    private static final String WORKSPACE_REPOSITORY = ".repositoryContext";
    private static final String SERVER_INDEX_NAME = "serverindex.xml";
    private static ConfigRepository defaultRepository;
    private static boolean init;
    private static RepositoryMetaData defaultMetaData;
    private ConfigRepository configRepository = null;
    private Properties repositoryProp;
    static /* synthetic */ Class class$com$ibm$ws$sm$workspace$impl$WorkSpaceMasterRepositoryAdapter;

    private ConfigRepository getConfigRepository() throws WorkSpaceException {
        if (this.configRepository == null) {
            this.configRepository = this.repositoryProp != null && this.repositoryProp.getProperty("location") != null ? WorkSpaceMasterRepositoryAdapter.getRepository(this.repositoryProp) : WorkSpaceMasterRepositoryAdapter.getDefaultRepository();
            if (this.configRepository == null) {
                throw WorkSpaceLogger.createException(tc, "WKSP0007E Error getting ConfigRepository -{0}", new Object[]{null});
            }
        }
        return this.configRepository;
    }

    private RepositoryMetaData getDefaultMetaData() {
        if (defaultMetaData == null) {
            try {
                String string = (String)WorkSpaceMasterRepositoryAdapter.getDefaultRepository().getConfig().get("was.repository.root");
                if (string != null) {
                    string = string + File.separator + ".repository";
                }
                if (string == null || !new File(string).isDirectory()) {
                    throw WorkSpaceLogger.createException(tc, "WKSP0020E Error getting meta data root {0}", new Object[]{string});
                }
                defaultMetaData = RepositoryMetaDataFactory.getFactory().getMetaData(string);
            }
            catch (WorkSpaceException workSpaceException) {
                new RuntimeException(workSpaceException.getMessage());
            }
        }
        return defaultMetaData;
    }

    private static ConfigRepository getDefaultRepository() throws WorkSpaceException {
        if (defaultRepository == null) {
            Properties properties = new Properties();
            properties.setProperty("location", "local");
            defaultRepository = WorkSpaceMasterRepositoryAdapter.getRepository(properties);
        }
        return defaultRepository;
    }

    private static ConfigRepository getRepository(Properties properties) throws WorkSpaceException {
        try {
            return ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)properties);
        }
        catch (AdminException adminException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0007E Error getting ConfigRepository -{0}", new Object[]{adminException}, adminException);
        }
    }

    public String[] getCatalog(WorkSpace workSpace, String string, int n, int n2) throws WorkSpaceException {
        int n3 = 1;
        int n4 = n2;
        switch (n) {
            case 1: {
                n3 = 1;
                break;
            }
            case 0: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 255;
            }
        }
        switch (n2) {
            case -1: {
                n4 = Integer.MAX_VALUE;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 0: {
                n4 = 0;
            }
        }
        String[] stringArray = this.getConfigRepository().listResourceNames(string, n3, n4);
        if (string.length() > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].substring(string.length() + 1);
            }
        }
        return stringArray;
    }

    public boolean exist(WorkSpace workSpace, String string) throws WorkSpaceException {
        String[] stringArray = this.getConfigRepository().listResourceNames(string, 255, 0);
        return stringArray.length > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer checkSynchState(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        Integer n = ConflictState.UN_MODIFIED;
        if (workSpaceFile.getState() == WorkSpaceFileState.UPDATED || workSpaceFile.getState() == WorkSpaceFileState.DELETED || workSpaceFile.getState() == WorkSpaceFileState.EXTRACTED) {
            if (!this.exist(workSpaceFile.getContext().getWorkSpace(), workSpaceFile.getURI())) {
                if (!this.debugEnabled) return ConflictState.REMOVED;
                Tr.debug((TraceComponent)tc, (String)(workSpaceFile.getURI() + " has been removed in Master Repository"));
                return ConflictState.REMOVED;
            }
            try {
                DocumentDigest documentDigest = this.getConfigRepository().getDigest(workSpaceFile.getURI());
                if (documentDigest.equals(this.getDigest(workSpaceFile))) return n;
                if (this.debugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)(workSpaceFile.getURI() + " has been modified in Master Repository"));
                }
                n = ConflictState.MODIFIED;
                return this.checkMerge(workSpaceFile, n);
            }
            catch (Exception exception) {
                throw WorkSpaceLogger.createException(tc, "WKSP0008E RepositoryException while checking the state of {0} in the master repository --{1}", new Object[]{workSpaceFile.getURI(), exception}, exception);
            }
        }
        if (workSpaceFile.getState() != WorkSpaceFileState.ADDED) return n;
        if (!this.exist(workSpaceFile.getContext().getWorkSpace(), workSpaceFile.getURI())) return n;
        if (!this.debugEnabled) return ConflictState.ADDED;
        Tr.debug((TraceComponent)tc, (String)(workSpaceFile.getURI() + " has been added in Master Repository"));
        return ConflictState.ADDED;
    }

    private DocumentDigest getDigest(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        DocumentDigest documentDigest = null;
        String string = null;
        if (this.needMerge(workSpaceFile) && !FileUtil.exist(string = workSpaceFile.getPath() + CURRENT_SUFFIX + DIGEST_SUFFIX)) {
            string = null;
        }
        if (string == null) {
            string = workSpaceFile.getPath() + DIGEST_SUFFIX;
        }
        if (this.debugEnabled) {
            Tr.debug((TraceComponent)tc, (String)("Digest version:" + string));
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            documentDigest = (DocumentDigest)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0016E Error get digest for {0} --{1}", new Object[]{string, exception}, exception);
        }
        return documentDigest;
    }

    public void update(Map[] mapArray) throws WorkSpaceException {
        WorkSpaceFile workSpaceFile;
        DocumentContentSource[] documentContentSourceArray = mapArray[0].keySet().iterator();
        while (documentContentSourceArray.hasNext()) {
            workSpaceFile = (WorkSpaceFile)documentContentSourceArray.next();
            File file = new File(workSpaceFile.getPath());
            if (file.exists()) continue;
            if (this.debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)("File " + workSpaceFile.getPath() + " does not exist in wstemp, and will not be updated to master repository."));
            }
            mapArray[0].remove(workSpaceFile);
        }
        documentContentSourceArray = new DocumentContentSource[mapArray[0].size()];
        int n = 0;
        DocumentContentSource[] documentContentSourceArray2 = mapArray[0].keySet().iterator();
        while (documentContentSourceArray2.hasNext()) {
            workSpaceFile = (WorkSpaceFile)documentContentSourceArray2.next();
            documentContentSourceArray[n] = (DocumentContentSource)this.collectFile(workSpaceFile, (Integer)mapArray[0].get(workSpaceFile));
            if (this.debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)(documentContentSourceArray[n].getDocument().getURI() + " will be added to the Master Repository"));
            }
            ++n;
        }
        documentContentSourceArray2 = new DocumentContentSource[mapArray[1].size()];
        n = 0;
        Document[] documentArray = mapArray[1].keySet().iterator();
        while (documentArray.hasNext()) {
            workSpaceFile = (WorkSpaceFile)documentArray.next();
            documentContentSourceArray2[n] = (DocumentContentSource)this.collectFile(workSpaceFile, (Integer)mapArray[1].get(workSpaceFile));
            if (this.debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)(documentContentSourceArray2[n].getDocument().getURI() + " will be updated to the Master Repository"));
            }
            ++n;
        }
        documentArray = new Document[mapArray[2].size()];
        n = 0;
        Iterator iterator = mapArray[2].keySet().iterator();
        while (iterator.hasNext()) {
            workSpaceFile = (WorkSpaceFile)iterator.next();
            documentArray[n] = (Document)this.collectFile(workSpaceFile, (Integer)mapArray[2].get(workSpaceFile));
            if (this.debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)(documentArray[n].getURI() + " will be deleted to the Master Repository"));
            }
            ++n;
        }
        try {
            this.getConfigRepository().update(documentContentSourceArray, documentContentSourceArray2, documentArray);
        }
        catch (RepositoryException repositoryException) {
            throw new WorkSpaceException("RepositoryException while updating documents in master repository", repositoryException);
        }
    }

    public void extract(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        this.extract(workSpaceFile, workSpaceFile.getPath(), this.needMerge(workSpaceFile));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void extract(WorkSpaceFile workSpaceFile, String string, boolean bl) throws WorkSpaceException {
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        String string2 = workSpaceFile.getURI();
        try {
            try {
                File file = new File(string);
                FileUtil.makeDir(file.getParentFile());
                DocumentContentSource documentContentSource = this.getConfigRepository().extract(string2);
                if (this.debugEnabled) {
                    Tr.debug((TraceComponent)tc, (String)("Extracting to " + file + " size = " + documentContentSource.getSource().available()));
                }
                fileOutputStream = new FileOutputStream(string);
                if (bl) {
                    if (this.debugEnabled) {
                        Tr.debug((TraceComponent)tc, (String)"\tKeep original ");
                    }
                    fileOutputStream2 = new FileOutputStream(string + ORIG_SUFFIX);
                }
                InputStream inputStream = documentContentSource.getSource();
                byte[] byArray = new byte[4096];
                int n = inputStream.read(byArray);
                while (n != -1) {
                    fileOutputStream.write(byArray, 0, n);
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.write(byArray, 0, n);
                    }
                    n = inputStream.read(byArray);
                }
                inputStream.close();
                fileOutputStream.flush();
                fileOutputStream.close();
                if (fileOutputStream2 != null) {
                    fileOutputStream2.flush();
                    fileOutputStream2.close();
                }
                this.setDigest(string + DIGEST_SUFFIX, documentContentSource.getDocument().getDigest());
            }
            catch (IOException iOException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0012E Exception when while extracting {0} from Config Repository--{1}", new Object[]{string2, iOException}, iOException);
            }
            catch (RepositoryException repositoryException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0012E Exception when while extracting {0} from Config Repository--{1}", new Object[]{string2, repositoryException}, repositoryException);
            }
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileOutputStream2 == null) throw throwable;
                fileOutputStream2.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
        if (fileOutputStream2 == null) return;
        fileOutputStream2.close();
        return;
    }

    private boolean needMerge(WorkSpaceFile workSpaceFile) {
        return workSpaceFile.getName().equalsIgnoreCase(SERVER_INDEX_NAME);
    }

    private void setDigest(String string, DocumentDigest documentDigest) throws WorkSpaceException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(documentDigest);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP0017E Error keep digest for {0}:{1} --{2}", new Object[]{string, documentDigest, exception}, exception);
        }
    }

    public void release(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        if (this.debugEnabled) {
            Tr.debug((TraceComponent)tc, (String)("release:" + workSpaceFile.getPath()));
        }
        FileUtil.delete(workSpaceFile.getPath());
        FileUtil.delete(workSpaceFile.getPath() + DIGEST_SUFFIX);
        if (FileUtil.exist(workSpaceFile.getPath() + ORIG_SUFFIX)) {
            ((WorkSpaceResourceSet)workSpaceFile.getContext().getResourceSet()).release(workSpaceFile.getName() + ORIG_SUFFIX);
            FileUtil.delete(workSpaceFile.getPath() + ORIG_SUFFIX);
        }
        if (FileUtil.exist(workSpaceFile.getPath() + CURRENT_SUFFIX)) {
            ((WorkSpaceResourceSet)workSpaceFile.getContext().getResourceSet()).release(workSpaceFile.getName() + CURRENT_SUFFIX);
            FileUtil.delete(workSpaceFile.getPath() + CURRENT_SUFFIX);
        }
        FileUtil.delete(workSpaceFile.getPath() + CURRENT_SUFFIX + DIGEST_SUFFIX);
    }

    public void release(RepositoryContext repositoryContext) throws WorkSpaceException {
        FileUtil.deleteTree(repositoryContext.getPath());
    }

    public void delete(RepositoryContext repositoryContext) throws WorkSpaceException {
    }

    public void delete(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        FileUtil.delete(workSpaceFile.getPath());
    }

    public void setSessionId(WorkSpace workSpace) throws WorkSpaceException {
        this.createSessionIdFile(workSpace);
    }

    public void unsetSessionId(WorkSpace workSpace) throws WorkSpaceException {
        this.deleteSessionIdFile(workSpace);
    }

    public boolean isValid(WorkSpace workSpace) throws WorkSpaceException {
        String string = this.getSessionIdFilePath(workSpace);
        File file = new File(string);
        return file.exists();
    }

    private String getSessionIdFilePath(WorkSpace workSpace) {
        return workSpace.getPath() + File.separator + SESSION_ID_FILE_PREFIX + workSpace.getSessionId();
    }

    private void createSessionIdFile(WorkSpace workSpace) throws WorkSpaceException {
        Object object;
        String string = workSpace.getPath();
        String string2 = this.getSessionIdFilePath(workSpace);
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        } else {
            object = file.listFiles(new SessionIdFileFilter());
            for (int i = 0; i < ((Object)object).length; ++i) {
                ((File)object[i]).delete();
            }
        }
        object = new File(string2);
        try {
            ((File)object).createNewFile();
        }
        catch (IOException iOException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0011E Unable to create existing session id file {0} --{1}", new Object[]{string2, iOException}, iOException);
        }
    }

    private void deleteSessionIdFile(WorkSpace workSpace) {
        File file = new File(this.getSessionIdFilePath(workSpace));
        file.delete();
    }

    public void initialize(Properties properties) throws WorkSpaceException {
        this.setRepositoryProp(properties);
    }

    private static void initialize() throws WorkSpaceException {
        if (!init) {
            try {
                Properties properties = new Properties();
                ConfigRepositoryFactory.getConfigRepository().initialize(properties);
            }
            catch (Exception exception) {
                WorkSpaceLogger.createException(tc, "WKSP0000E Error initialize  -- {0}", new Object[]{exception}, exception);
            }
            init = true;
        }
    }

    private void setRepositoryProp(Properties properties) {
        this.repositoryProp = properties;
        this.configRepository = null;
    }

    public void remove(WorkSpace workSpace) throws WorkSpaceException {
        FileUtil.deleteTree(workSpace.getUserPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(RepositoryContext repositoryContext) throws WorkSpaceException {
        BufferedWriter bufferedWriter = null;
        String string = repositoryContext.getPath();
        try {
            try {
                File file = new File(string);
                FileUtil.makeDir(file);
                bufferedWriter = new BufferedWriter(new FileWriter(string + File.separator + WORKSPACE_REPOSITORY));
                bufferedWriter.write(repositoryContext.getPersistData());
            }
            catch (IOException iOException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0006E Error while saving context {0}-{1}", new Object[]{repositoryContext.getName(), iOException}, iOException);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (bufferedWriter == null) throw throwable;
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (bufferedWriter == null) return;
        bufferedWriter.close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String restore(RepositoryContext repositoryContext) throws WorkSpaceException {
        String string = null;
        String string2 = repositoryContext.getPath() + WorkSpaceConstant.FILE_SEPERATOR_CHAR + WORKSPACE_REPOSITORY;
        BufferedReader bufferedReader = null;
        try {
            try {
                File file = new File(string2);
                if (file.exists()) {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    string = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                throw WorkSpaceLogger.createException(tc, "WKSP0001E Error reading serialized context from {0} -- {1}", new Object[]{string2, iOException}, iOException);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (bufferedReader == null) throw throwable;
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (bufferedReader == null) return string;
        bufferedReader.close();
        return string;
    }

    private Object collectFile(WorkSpaceFile workSpaceFile, Integer n) throws WorkSpaceException {
        Document document = this.getDocument(workSpaceFile);
        DocumentContentSource documentContentSource = null;
        if (n != null && n == ConflictResolution.OVER_WRITE) {
            document.setOverwrite(true);
        }
        if (workSpaceFile.getState() == WorkSpaceFileState.ADDED) {
            documentContentSource = this.getDocumentContentSource(document, workSpaceFile.getPath());
        } else if (workSpaceFile.getState() == WorkSpaceFileState.UPDATED) {
            String string = null;
            if (this.needMerge(workSpaceFile) && !FileUtil.exist(string = workSpaceFile.getPath() + CURRENT_SUFFIX)) {
                string = null;
            }
            if (string == null) {
                string = workSpaceFile.getPath();
            }
            if (this.debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)("Source version:" + string));
            }
            documentContentSource = this.getDocumentContentSource(document, string);
        } else {
            documentContentSource = document;
        }
        return documentContentSource;
    }

    private Integer checkMerge(WorkSpaceFile workSpaceFile, Integer n) throws WorkSpaceException {
        Integer n2;
        if (!this.needMerge(workSpaceFile)) {
            return n;
        }
        RepositoryContextImpl repositoryContextImpl = (RepositoryContextImpl)workSpaceFile.getContext();
        repositoryContextImpl.resetAdapterNotifier(false);
        this.extract(workSpaceFile, workSpaceFile.getPath() + CURRENT_SUFFIX, false);
        String string = workSpaceFile.getName();
        if (MergeUtilManager.getUtil(workSpaceFile).merge(workSpaceFile.getContext(), string, string + ORIG_SUFFIX, string + CURRENT_SUFFIX)) {
            if (this.debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)("Can be merged:" + string));
            }
            n2 = ConflictState.UN_MODIFIED;
        } else {
            if (this.debugEnabled) {
                Tr.debug((TraceComponent)tc, (String)("Can not be merged:" + string));
            }
            FileUtil.delete(workSpaceFile.getPath() + CURRENT_SUFFIX);
            FileUtil.delete(workSpaceFile.getPath() + CURRENT_SUFFIX + DIGEST_SUFFIX);
            n2 = ConflictState.MODIFIED;
        }
        repositoryContextImpl.resetAdapterNotifier(true);
        return n2;
    }

    private InputStream readFile(String string) throws IOException {
        File file = new File(string);
        Object var3_3 = null;
        return new RepositoryInputStream(file);
    }

    private DocumentContentSource getDocumentContentSource(Document document, String string) throws WorkSpaceException {
        try {
            return new DocumentContentSource(document, this.readFile(string));
        }
        catch (IOException iOException) {
            throw WorkSpaceLogger.createException(tc, "WKSP0018E Error read file for {0} --{1}", new Object[]{string, iOException}, iOException);
        }
    }

    private Document getDocument(WorkSpaceFile workSpaceFile) throws WorkSpaceException {
        Document document = workSpaceFile.getState() == WorkSpaceFileState.ADDED ? new Document(workSpaceFile.getURI()) : new Document(workSpaceFile.getURI(), this.getDigest(workSpaceFile));
        return document;
    }

    public RepositoryMetaData getMetaData() {
        return this.getDefaultMetaData();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        init = false;
        defaultMetaData = null;
    }

    private class SessionIdFileFilter
    implements FilenameFilter {
        private SessionIdFileFilter() {
        }

        public boolean accept(File file, String string) {
            return string.startsWith(WorkSpaceMasterRepositoryAdapter.SESSION_ID_FILE_PREFIX);
        }
    }
}

