/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.migration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;

public final class WSURIConverter
extends URIConverterImpl {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(class$com$ibm$ws$sm$workspace$migration$WSURIConverter == null ? (class$com$ibm$ws$sm$workspace$migration$WSURIConverter = WSURIConverter.class$("com.ibm.ws.sm.workspace.migration.WSURIConverter")) : class$com$ibm$ws$sm$workspace$migration$WSURIConverter);
    private RepositoryContext context;
    private URI baseURI;
    static /* synthetic */ Class class$com$ibm$ws$sm$workspace$migration$WSURIConverter;

    public WSURIConverter(RepositoryContext repositoryContext) {
        this.context = repositoryContext;
        this.baseURI = URI.createFileURI(repositoryContext.getPath() + File.separator);
    }

    public URI normalize(URI uRI) {
        if (uRI.isRelative() && this.baseURI != null) {
            return uRI.resolve(this.baseURI);
        }
        return super.normalize(uRI);
    }

    public OutputStream createOutputStream(URI uRI) throws IOException {
        URI uRI2 = this.normalize(uRI);
        String string = uRI2.scheme();
        if ("file".equals(string)) {
            this.checkExtracted(uRI);
            return this.createFileOutputStream(uRI2.toFileString());
        }
        return super.createOutputStream(uRI);
    }

    public InputStream createInputStream(URI uRI) throws IOException {
        URI uRI2 = this.normalize(uRI);
        String string = uRI2.scheme();
        if ("file".equals(string)) {
            this.checkExtracted(uRI);
            return this.createFileInputStream(uRI2.toFileString());
        }
        return super.createInputStream(uRI);
    }

    private void checkExtracted(URI uRI) throws IOException {
        String string = uRI.toString();
        if (this.context.isAvailable(string) && !this.context.isExtracted(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("file is not exists,but not extracted " + string));
            }
            try {
                this.context.extract(string, false);
            }
            catch (WorkSpaceException workSpaceException) {
                throw new IOException(workSpaceException.getMessage());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

