/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.template.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.template.RefObjectHelper;
import com.ibm.ws.sm.workspace.template.RefObjectHelperFactory;
import com.ibm.ws.sm.workspace.template.Template;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.impl.TemplateImpl;
import com.ibm.ws.sm.workspace.template.impl.TemplateMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class TemplateManagerImpl
implements TemplateManager,
TemplateMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(class$com$ibm$ws$sm$workspace$template$impl$TemplateManagerImpl == null ? (class$com$ibm$ws$sm$workspace$template$impl$TemplateManagerImpl = TemplateManagerImpl.class$("com.ibm.ws.sm.workspace.template.impl.TemplateManagerImpl")) : class$com$ibm$ws$sm$workspace$template$impl$TemplateManagerImpl);
    private String templateRootURI = "templates";
    private RepositoryContext templateRoot = null;
    private RefObjectHelper refObjectHelper = null;
    private WorkSpace workSpace = null;
    private HashMap templateMap = null;
    static /* synthetic */ Class class$com$ibm$ws$sm$workspace$template$impl$TemplateManagerImpl;

    public static TemplateManagerImpl getManager(WorkSpace workSpace) {
        return new TemplateManagerImpl(workSpace);
    }

    public TemplateManagerImpl(WorkSpace workSpace) {
        this.workSpace = workSpace;
        this.refObjectHelper = RefObjectHelperFactory.getRefObjectHelper();
        this.templateMap = new HashMap();
    }

    public RefObjectHelper getRefObjectHelper() {
        return this.refObjectHelper;
    }

    public RepositoryContext getRootTemplateContext() throws WorkSpaceException {
        if (this.templateRoot == null) {
            this.templateRoot = this.workSpace.findContext(this.templateRootURI);
        }
        return this.templateRoot;
    }

    public Collection getTemplates(RepositoryContextType repositoryContextType) throws WorkSpaceException {
        Tr.entry((TraceComponent)tc, (String)"getTemplates", (Object)new Object[]{repositoryContextType.getName()});
        Collection collection = this.getTemplateContext(repositoryContextType);
        ArrayList<Template> arrayList = new ArrayList<Template>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
            arrayList.add(this.getTemplate(repositoryContext));
        }
        Tr.exit((TraceComponent)tc, (String)"getTemplates");
        return arrayList;
    }

    public Template getTemplate(RepositoryContext repositoryContext) throws WorkSpaceException {
        Tr.entry((TraceComponent)tc, (String)"getTemplate", (Object)new Object[]{repositoryContext.getURI()});
        String string = repositoryContext.getURI();
        Template template = (Template)this.templateMap.get(string);
        if (template == null) {
            template = new TemplateImpl(repositoryContext);
            this.templateMap.put(string, template);
        }
        Tr.exit((TraceComponent)tc, (String)"getTemplate");
        return template;
    }

    public RepositoryContext createContext(RepositoryContext repositoryContext, String string, Template template, HashMap hashMap) throws WorkSpaceException {
        Tr.entry((TraceComponent)tc, (String)"createContext", (Object)new Object[]{repositoryContext.getURI(), string, template.getName(), hashMap});
        RepositoryContext repositoryContext2 = repositoryContext.create(template.getType(), string);
        List list = template.getFiles();
        for (int i = 0; i < list.size(); ++i) {
            this.createFile(repositoryContext2, (String)list.get(i), template, hashMap);
        }
        Tr.exit((TraceComponent)tc, (String)"createContext");
        return repositoryContext2;
    }

    public void createFile(RepositoryContext repositoryContext, String string, Template template, HashMap hashMap) throws WorkSpaceException {
        this.copyFile(repositoryContext, string, template, hashMap);
    }

    public Collection getTemplateObjects(RepositoryContext repositoryContext, String string, String string2) throws WorkSpaceException {
        Tr.entry((TraceComponent)tc, (String)"getTemplateObjects", (Object)new Object[]{repositoryContext.getURI(), string, string2});
        try {
            EList eList = repositoryContext.getResourceSet().getResource(URI.createURI(string), true).getContents();
            ArrayList<EObject> arrayList = new ArrayList<EObject>();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                if (!eObject.eClass().getName().endsWith(string2)) continue;
                arrayList.add(eObject);
            }
            Tr.exit((TraceComponent)tc, (String)"getTemplateObjects");
            return arrayList;
        }
        catch (Exception exception) {
            throw WorkSpaceLogger.createException(tc, "WKSP1000 Error load extent of {0}--{1}.", new Object[]{string, exception}, exception);
        }
    }

    private void copyFile(RepositoryContext repositoryContext, String string, Template template, HashMap hashMap) throws WorkSpaceException {
        Tr.entry((TraceComponent)tc, (String)"copyFile", (Object)new Object[]{repositoryContext.getURI(), template.getName(), hashMap});
        try {
            OutputStream outputStream = repositoryContext.getOutputStream(string);
            outputStream.write(this.getConvertedContentBytes(template, string, hashMap));
            outputStream.flush();
            outputStream.close();
            Tr.exit((TraceComponent)tc, (String)"copyFile");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private byte[] getConvertedContentBytes(Template template, String string, HashMap hashMap) throws WorkSpaceException {
        byte[] byArray;
        Tr.entry((TraceComponent)tc, (String)"getConvertedContent", (Object)new Object[]{template.getName(), string, hashMap});
        if (hashMap.size() == 0) {
            byArray = ((TemplateImpl)template).getContentBytes(string);
        } else {
            String string2 = ((TemplateImpl)template).getContent(string);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)hashMap.get(string3);
                int n = string2.indexOf(string3);
                while (n != -1) {
                    string2 = string2.substring(0, n) + string4 + string2.substring(n + string3.length());
                    n = string2.indexOf(string3, n + string3.length());
                }
            }
            byArray = string2.getBytes();
        }
        Tr.exit((TraceComponent)tc, (String)"getConvertedContent");
        return byArray;
    }

    private Collection getTemplateContext(RepositoryContextType repositoryContextType) throws WorkSpaceException {
        return this.getRootTemplateContext().findContext(repositoryContextType);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

