/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Change;
import com.ibm.etools.emf.event.ChangeUtil;
import com.ibm.etools.emf.event.impl.ChangeHelper;
import com.ibm.etools.emf.event.impl.EventHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ChangeUtilImpl
implements ChangeUtil {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public List getAddedObjects(Change[] changeArray) {
        BasicEList basicEList = new BasicEList();
        int n = 0;
        while (n < changeArray.length) {
            Change change = changeArray[n];
            if (change.getOldEObject() == null) {
                basicEList.add(change.getNewEObject());
            }
            ++n;
        }
        return basicEList;
    }

    public List getRemovedObjects(Change[] changeArray) {
        BasicEList basicEList = new BasicEList();
        int n = 0;
        while (n < changeArray.length) {
            Change change = changeArray[n];
            if (change.getNewEObject() == null) {
                basicEList.add(change.getOldEObject());
            }
            ++n;
        }
        return basicEList;
    }

    public String displaySummary(Change[] changeArray) {
        Object object;
        String string = "";
        int n = 6;
        int n2 = 6;
        int n3 = 0;
        while (n3 < changeArray.length) {
            Change change = changeArray[n3];
            object = ChangeUtilImpl.getURIString(change.getOldEObject());
            String string2 = ChangeUtilImpl.getURIString(change.getNewEObject());
            if (object != null && ((String)object).length() > n) {
                n = ((String)object).length();
            }
            if (string2 != null && string2.length() > n2) {
                n2 = string2.length();
            }
            ++n3;
        }
        if (changeArray.length > 0) {
            string = string + "\t" + ChangeUtilImpl.padding("oldURI", n + 1) + ChangeUtilImpl.padding("newURI", n2 + 1) + "\n";
            string = string + "\t" + ChangeUtilImpl.padding("------", n + 1) + ChangeUtilImpl.padding("------", n2 + 1) + "\n";
        }
        int n4 = 0;
        while (n4 < changeArray.length) {
            object = changeArray[n4];
            string = string + "\t" + ChangeUtilImpl.padding(ChangeUtilImpl.getURIString(object.getOldEObject()), n + 1) + ChangeUtilImpl.padding(ChangeUtilImpl.getURIString(object.getNewEObject()), n2 + 1) + "\n";
            ++n4;
        }
        return string;
    }

    private static String padding(String string, int n) {
        String string2 = string == null ? "<null>" : string;
        int n2 = string2.length();
        while (n2 < n) {
            string2 = string2 + " ";
            ++n2;
        }
        return string2;
    }

    public String displayDetails(Change[] changeArray) {
        String string = "";
        int n = 0;
        while (n < changeArray.length) {
            Change change = changeArray[n];
            EObject eObject = change.getOldEObject();
            EObject eObject2 = change.getNewEObject();
            String string2 = ChangeUtilImpl.getURIString(eObject);
            String string3 = ChangeUtilImpl.getURIString(eObject2);
            string = string + string2 + "=>" + string3 + "\n";
            string = string + "\told: " + EventHelper.objectToString(eObject) + "\n\tnew: " + EventHelper.objectToString(eObject2) + "\n";
            Change.Setting[] settingArray = change.getSettings();
            int n2 = 0;
            while (n2 < settingArray.length) {
                List list;
                Change.Setting setting = settingArray[n2];
                string = string + "\t\t" + setting.toString() + "\n";
                List list2 = setting.getAddedValues();
                if (list2 != null && list2.size() > 0) {
                    string = string + "\t\t\tAddedValues=" + EventHelper.objectToString(list2) + "\n";
                }
                if ((list = setting.getRemovedValues()) != null && list.size() > 0) {
                    string = string + "\t\t\tRemovedValues=" + EventHelper.objectToString(list) + "\n";
                }
                ++n2;
            }
            ++n;
        }
        return string;
    }

    protected static String getURIString(Object object) {
        EObject eObject;
        Resource resource;
        if (object == null) {
            return null;
        }
        if (object instanceof EObject && (resource = (eObject = (EObject)object).eResource()) != null) {
            String string = resource.getURIFragment(eObject);
            String string2 = eObject.eResource().getURI().appendFragment(string).toString();
            return string2;
        }
        return null;
    }

    public Change[] getChanges(Notifier notifier, Notifier notifier2, Map map) {
        ChangeHelper changeHelper = new ChangeHelper(map);
        return changeHelper.createChanges(notifier, notifier2);
    }

    public Map createInverseMap(Map map) {
        HashMap hashMap = new HashMap();
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(entry.getValue(), entry.getKey());
        }
        return hashMap;
    }
}

