/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Add;
import com.ibm.etools.emf.event.AddMany;
import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.EventFactory;
import com.ibm.etools.emf.event.EventKind;
import com.ibm.etools.emf.event.EventPackage;
import com.ibm.etools.emf.event.Move;
import com.ibm.etools.emf.event.NotifierKind;
import com.ibm.etools.emf.event.Remove;
import com.ibm.etools.emf.event.RemoveMany;
import com.ibm.etools.emf.event.Set;
import com.ibm.etools.emf.event.Unset;
import com.ibm.etools.emf.event.impl.EventHelper;
import com.ibm.etools.emf.event.impl.EventWriterHelper;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class EventAdapter
extends EContentAdapter {
    public static final Object EVENT_ADAPTER = "Event Adapter";
    EventFactory factory;
    EventWriterHelper helper;
    List eventsList;
    boolean isActive = true;

    public EventAdapter(Notifier notifier, List list, ResourceSet resourceSet) {
        this.helper = new EventWriterHelper(notifier, resourceSet);
        this.eventsList = list;
        this.factory = EventPackage.eINSTANCE.getEventFactory();
        if (notifier instanceof EObject) {
            this.helper.scanOriginalObjects(((EObject)notifier).eContents());
        } else if (notifier instanceof Resource) {
            this.helper.scanOriginalObjects(((Resource)notifier).getContents());
        } else if (notifier instanceof ResourceSet) {
            this.helper.scanOriginalObjects((ResourceSet)notifier);
        }
    }

    public List getEventsList() {
        return this.eventsList;
    }

    public void setEventsList(List list) {
        this.eventsList = list;
    }

    public void execute(List list) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Notification notification = (Notification)list.get(n);
            this.notifyChanged(notification);
            ++n;
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification != null) {
            if (this.isActive()) {
                switch (notification.getEventType()) {
                    case 1: {
                        this.set(notification);
                        break;
                    }
                    case 2: {
                        this.unSet(notification);
                        break;
                    }
                    case 3: {
                        this.add(notification);
                        break;
                    }
                    case 4: {
                        this.remove(notification);
                        break;
                    }
                    case 5: {
                        this.addMany(notification);
                        break;
                    }
                    case 6: {
                        this.removeMany(notification);
                        break;
                    }
                    case 7: {
                        this.move(notification);
                        break;
                    }
                }
            }
            super.notifyChanged(notification);
        }
    }

    protected void set(Notification notification) {
        Set set = (Set)this.createEvent(notification);
        if (set == null) {
            return;
        }
        Object object = notification.getOldValue();
        Object object2 = notification.getNewValue();
        if (object2 != null) {
            set.setNewLiteral(this.helper.convertValueToString(set, object2, true));
        }
        if (object != null) {
            set.setOldLiteral(this.helper.convertValueToString(set, object, false));
        }
    }

    protected void unSet(Notification notification) {
        Unset unset = (Unset)this.createEvent(notification);
        if (unset == null) {
            return;
        }
        Object object = notification.getOldValue();
        unset.setLiteral(this.helper.convertValueToString(unset, object, false));
    }

    protected void add(Notification notification) {
        Add add = (Add)this.createEvent(notification);
        if (add == null) {
            return;
        }
        add.setPosition(notification.getPosition());
        Object object = notification.getNewValue();
        add.setLiteral(this.helper.convertValueToString(add, object, true));
    }

    protected void remove(Notification notification) {
        Remove remove = (Remove)this.createEvent(notification);
        if (remove == null) {
            return;
        }
        remove.setPosition(notification.getPosition());
        Object object = notification.getOldValue();
        remove.setLiteral(this.helper.convertValueToString(remove, object, false));
    }

    protected void addMany(Notification notification) {
        AddMany addMany = (AddMany)this.createEvent(notification);
        if (addMany == null) {
            return;
        }
        List list = (List)notification.getNewValue();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Object e = list.get(n);
            addMany.getLiterals().add(this.helper.convertValueToString(addMany, e, true));
            EList eList = this.helper.getNotifierContents(addMany);
            int n3 = eList.indexOf(e);
            addMany.getPositions().add(new Integer(n3));
            ++n;
        }
    }

    protected void removeMany(Notification notification) {
        int n;
        Object object;
        RemoveMany removeMany = (RemoveMany)this.createEvent(notification);
        if (removeMany == null) {
            return;
        }
        Object object2 = notification.getNewValue();
        if (object2 != null) {
            object = (int[])object2;
            n = 0;
            while (n < ((Object)object).length) {
                removeMany.getPositions().add(new Integer((int)object[n]));
                ++n;
            }
        }
        object = (List)notification.getOldValue();
        n = 0;
        int n2 = object.size();
        while (n < n2) {
            Object e = object.get(n);
            removeMany.getLiterals().add(this.helper.convertValueToString(removeMany, e, false));
            ++n;
        }
    }

    protected void move(Notification notification) {
        Move move = (Move)this.createEvent(notification);
        if (move == null) {
            return;
        }
        move.setNewPosition(notification.getPosition());
        move.setOldPosition((Integer)notification.getOldValue());
    }

    protected Event createEvent(Notification notification) {
        Notifier notifier = (Notifier)notification.getNotifier();
        if (this.helper.isNotifierVisible(notifier)) {
            Event event = this.factory.createEvent(notification.getEventType());
            String string = this.helper.getURIString(notifier);
            event.setNotifierURI(string);
            EStructuralFeature eStructuralFeature = (EStructuralFeature)notification.getFeature();
            if (eStructuralFeature != null) {
                event.setFeatureName(eStructuralFeature.getName());
            }
            if (EventHelper.getNotifierKind(event) == NotifierKind.RESOURCE_LITERAL && event.getEventKind() == EventKind.SET_LITERAL) {
                return null;
            }
            this.eventsList.add(event);
            return event;
        }
        return null;
    }

    public boolean isAdapterForType(Object object) {
        return object == EVENT_ADAPTER;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsActive(boolean bl) {
        this.isActive = bl;
    }
}

