/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.FeatureKind;
import com.ibm.etools.emf.event.NotifierKind;
import com.ibm.etools.emf.event.impl.EventAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public abstract class EventHelper {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    Notifier topNotifier;
    ResourceSet defaultResourceSet;
    static final String EVENT_ID_PREFIX = "event:";

    protected EventHelper(Notifier notifier, ResourceSet resourceSet) {
        this.topNotifier = notifier;
        this.defaultResourceSet = resourceSet;
    }

    protected Notifier getTopNotifier() {
        return this.topNotifier;
    }

    protected boolean isContainedInTopNotifier(EObject eObject) {
        if (this.topNotifier instanceof EObject) {
            return EcoreUtil.isAncestor((EObject)((EObject)this.topNotifier), (EObject)eObject);
        }
        return EcoreUtil.isAncestor((Resource)((Resource)this.topNotifier), (EObject)eObject);
    }

    protected EObject getEObjectFromURI(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf("#");
        if (n == -1) {
            return null;
        }
        if (n == 0) {
            if (this.topNotifier instanceof Resource) {
                Resource resource = (Resource)this.topNotifier;
                return resource.getEObject(string.substring(n + 1));
            }
            EObject eObject = this.getEObject(string.substring(n + 1));
            return eObject;
        }
        URI uRI = URI.createURI((String)string.substring(0, n));
        Resource resource = this.defaultResourceSet.getResource(uRI, true);
        if (resource != null) {
            EObject eObject = resource.getEObject(string.substring(n + 1));
            return eObject;
        }
        return null;
    }

    public FeatureKind getFeatureKind(Event event) {
        if (EventHelper.getNotifierKind(event) == NotifierKind.RESOURCE_LITERAL) {
            return FeatureKind.REFERENCE_LITERAL;
        }
        EStructuralFeature eStructuralFeature = this.getFeature(event);
        if (eStructuralFeature instanceof EAttribute) {
            return FeatureKind.ATTRIBUTE_LITERAL;
        }
        return FeatureKind.REFERENCE_LITERAL;
    }

    public Notifier getNotifier(Event event) {
        if (EventHelper.getNotifierKind(event) == NotifierKind.RESOURCE_LITERAL) {
            return this.topNotifier;
        }
        return this.getEObjectFromURI(event.getNotifierURI());
    }

    public EStructuralFeature getFeature(Event event) {
        if (EventHelper.getNotifierKind(event) == NotifierKind.EOBJECT_LITERAL) {
            EClass eClass = ((EObject)this.getNotifier(event)).eClass();
            return eClass.getEStructuralFeature(event.getFeatureName());
        }
        return null;
    }

    public static NotifierKind getNotifierKind(Event event) {
        String string = event.getNotifierURI();
        if (string == null || string.length() == 0 || string.indexOf("#") == -1) {
            return NotifierKind.RESOURCE_LITERAL;
        }
        return NotifierKind.EOBJECT_LITERAL;
    }

    protected static void copyAttributes(EObject eObject, EObject eObject2) {
        EClass eClass;
        EClass eClass2 = eObject.eClass();
        if (eClass2 != (eClass = eObject2.eClass())) {
            return;
        }
        EList eList = eClass2.getEAllAttributes();
        int n = 0;
        int n2 = eList.size();
        while (n < n2) {
            EAttribute eAttribute = (EAttribute)eList.get(n);
            if (eObject2.eIsSet((EStructuralFeature)eAttribute)) {
                if (eAttribute.isMany()) {
                    EList eList2 = (EList)eObject2.eGet((EStructuralFeature)eAttribute);
                    EList eList3 = (EList)eObject.eGet((EStructuralFeature)eAttribute);
                    eList3.clear();
                    eList3.addAll(eList2);
                } else {
                    eObject.eSet((EStructuralFeature)eAttribute, eObject2.eGet((EStructuralFeature)eAttribute));
                }
            } else if (!eAttribute.isID()) {
                eObject.eUnset((EStructuralFeature)eAttribute);
            }
            ++n;
        }
    }

    protected static boolean identicalAttributes(EObject eObject, EObject eObject2) {
        EClass eClass;
        if (eObject == null || eObject2 == null) {
            return eObject == eObject2;
        }
        EClass eClass2 = eObject.eClass();
        if (eClass2 != (eClass = eObject2.eClass())) {
            return false;
        }
        EList eList = eClass2.getEAllAttributes();
        int n = 0;
        int n2 = eList.size();
        while (n < n2) {
            EAttribute eAttribute = (EAttribute)eList.get(n);
            if (eAttribute.isMany()) {
                EList eList2 = (EList)eObject.eGet((EStructuralFeature)eAttribute);
                EList eList3 = (EList)eObject2.eGet((EStructuralFeature)eAttribute);
                if (eList2.size() != eList3.size()) {
                    return false;
                }
                int n3 = 0;
                while (n3 < eList2.size()) {
                    if (eList2.get(n3) != eList3.get(n3)) {
                        return false;
                    }
                    ++n3;
                }
            } else if (eObject.eGet((EStructuralFeature)eAttribute) != eObject2.eGet((EStructuralFeature)eAttribute)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public EList getNotifierContents(Event event) {
        Notifier notifier = this.getNotifier(event);
        EList eList = null;
        if (EventHelper.getNotifierKind(event) == NotifierKind.RESOURCE_LITERAL) {
            eList = ((Resource)this.topNotifier).getContents();
        } else {
            EStructuralFeature eStructuralFeature = this.getFeature(event);
            if (eStructuralFeature.isMany()) {
                eList = (EList)((EObject)notifier).eGet(eStructuralFeature);
            }
        }
        return eList;
    }

    protected boolean isEventId(String string) {
        return string.startsWith(EVENT_ID_PREFIX);
    }

    protected String removeResourceFromURIString(String string) {
        int n = string.indexOf("#");
        if (n != -1) {
            return string.substring(n, string.length());
        }
        return string;
    }

    public String getURIString(Object object) {
        if (object == null) {
            return null;
        }
        if (object.equals(this.topNotifier)) {
            if (object instanceof Resource) {
                return null;
            }
            return "#";
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (!this.isContainedInTopNotifier(eObject)) {
                Resource resource = eObject.eResource();
                return resource.getURI().toFileString() + "#" + resource.getURIFragment(eObject);
            }
            if (this.topNotifier instanceof Resource) {
                Resource resource = (Resource)this.topNotifier;
                return "#" + resource.getURIFragment(eObject);
            }
            return this.getURIFragment(eObject);
        }
        Resource resource = (Resource)object;
        return resource.getURI().toString();
    }

    public String getURIFragment(EObject eObject) {
        EObject eObject2 = eObject;
        ArrayList<String> arrayList = new ArrayList<String>();
        EObject eObject3 = eObject2.eContainer();
        while (eObject3 != null) {
            arrayList.add(((InternalEObject)eObject3).eURIFragmentSegment((EStructuralFeature)eObject2.eContainmentFeature(), eObject2));
            eObject2 = eObject3;
            eObject3 = eObject2.eContainer();
        }
        Resource resource = eObject.eResource();
        if (this.topNotifier.equals(eObject2) || this.topNotifier.equals(resource)) {
            StringBuffer stringBuffer = new StringBuffer("#");
            if (this.topNotifier.equals(resource)) {
                stringBuffer.append('/');
                stringBuffer.append(Integer.toString(resource.getContents().indexOf(eObject2)));
            }
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            while (listIterator.hasPrevious()) {
                stringBuffer.append('/');
                stringBuffer.append((String)listIterator.previous());
            }
            return stringBuffer.toString();
        }
        String string = resource.getURIFragment(eObject);
        String string2 = resource.getURI().appendFragment(string).toString();
        return string2;
    }

    public EObject getEObject(String string) {
        if (string.startsWith("//")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(2), "/");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return this.getEObject(arrayList);
        }
        if (string.startsWith("/")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            return this.getEObject(arrayList);
        }
        return null;
    }

    protected EObject getEObject(List list) {
        Iterator iterator = list.iterator();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(!iterator.hasNext() ? "" : (String)iterator.next());
        while (iterator.hasNext() && eObject != null) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment((String)iterator.next());
        }
        return eObject;
    }

    protected EObject getEObjectForURIFragmentRootSegment(String string) {
        if (this.topNotifier instanceof EObject) {
            return ((InternalEObject)this.topNotifier).eObjectForURIFragmentSegment(string);
        }
        Resource resource = (Resource)this.topNotifier;
        int n = 0;
        if (string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new WrappedException((Exception)numberFormatException);
            }
        }
        if (n < resource.getContents().size()) {
            return (EObject)resource.getContents().get(n);
        }
        return null;
    }

    public static String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            StringBuffer stringBuffer = new StringBuffer();
            EClass eClass = eObject.eClass();
            EList eList = eClass.getEAllAttributes();
            stringBuffer.append(object.getClass().getName() + " (");
            boolean bl = true;
            int n = 0;
            int n2 = eList.size();
            while (n < n2) {
                EAttribute eAttribute = (EAttribute)eList.get(n);
                if (eObject.eIsSet((EStructuralFeature)eAttribute)) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    bl = false;
                    String string = eAttribute.getName();
                    Object object2 = eObject.eGet((EStructuralFeature)eAttribute);
                    String string2 = object2 == null ? "null" : object2.toString();
                    stringBuffer.append(string + ": " + string2);
                }
                ++n;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        if (object instanceof EList) {
            EList eList = (EList)object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            boolean bl = true;
            int n = 0;
            int n3 = eList.size();
            while (n < n3) {
                Object e = eList.get(n);
                if (!bl) {
                    stringBuffer.append(", ");
                }
                bl = false;
                stringBuffer.append(EventHelper.objectToString(e));
                ++n;
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        if (object instanceof Resource) {
            StringBuffer stringBuffer = new StringBuffer();
            Resource resource = (Resource)object;
            stringBuffer.append(resource.getClass().getName() + " uri='" + resource.getURI() + "'");
            return stringBuffer.toString();
        }
        return object.toString();
    }

    public EventAdapter getEventAdapter() {
        return (EventAdapter)EcoreUtil.getAdapter((List)this.topNotifier.eAdapters(), (Object)EventAdapter.EVENT_ADAPTER);
    }

    public void attachEventAdapter(List list) {
        EventAdapter eventAdapter = this.getEventAdapter();
        if (eventAdapter != null) {
            this.topNotifier.eAdapters().remove((Object)eventAdapter);
        }
        EventAdapter eventAdapter2 = new EventAdapter(this.topNotifier, list, this.defaultResourceSet);
        this.topNotifier.eAdapters().add(eventAdapter2);
    }
}

