/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.Add;
import com.ibm.etools.emf.event.AddMany;
import com.ibm.etools.emf.event.Change;
import com.ibm.etools.emf.event.ChangeUtil;
import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.EventUtil;
import com.ibm.etools.emf.event.FeatureKind;
import com.ibm.etools.emf.event.Move;
import com.ibm.etools.emf.event.Remove;
import com.ibm.etools.emf.event.RemoveMany;
import com.ibm.etools.emf.event.Set;
import com.ibm.etools.emf.event.Unset;
import com.ibm.etools.emf.event.impl.EventAdapter;
import com.ibm.etools.emf.event.impl.EventReaderHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EventUtilImpl
implements EventUtil {
    EventReaderHelper helper = null;

    protected EventUtilImpl(Notifier notifier, ResourceSet resourceSet) {
        this.helper = new EventReaderHelper(notifier, resourceSet);
    }

    protected EventUtilImpl(EventReaderHelper eventReaderHelper) {
        this.helper = eventReaderHelper;
    }

    public void activateEventAdapter(List list) {
        list.clear();
        this.helper.attachEventAdapter(list);
    }

    public void deactivateEventAdapter() {
        EventAdapter eventAdapter = this.helper.getEventAdapter();
        if (eventAdapter != null) {
            eventAdapter.setIsActive(false);
        }
    }

    public EventUtil makeCopy() {
        return this.makeCopy(new EcoreUtil.Copier());
    }

    public EventUtil makeCopy(EcoreUtil.Copier copier) {
        EventReaderHelper eventReaderHelper = this.helper.makeCopy(copier);
        EventUtilImpl eventUtilImpl = new EventUtilImpl(eventReaderHelper);
        return eventUtilImpl;
    }

    public EventUtil doForwardEvents(List list) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Object e = list.get(n);
            if (e instanceof Event) {
                Event event = (Event)e;
                this.replayEvent(event);
            }
            ++n;
        }
        return this;
    }

    public EventUtil doBackwardEvents(List list) {
        int n = list.size() - 1;
        while (n >= 0) {
            Object e = list.get(n);
            if (e instanceof Event) {
                Event event = (Event)e;
                this.undoEvent(event);
            }
            --n;
        }
        return this;
    }

    public Change[] getBackwardChanges(List list) {
        if (list == null) {
            return new Change[0];
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EventReaderHelper eventReaderHelper = this.helper.makeCopy(copier);
        EventUtilImpl eventUtilImpl = new EventUtilImpl(eventReaderHelper);
        eventUtilImpl.doBackwardEvents(list);
        Map map = ChangeUtil.eINSTANCE.createInverseMap((Map)copier);
        return ChangeUtil.eINSTANCE.getChanges(eventReaderHelper.getTopNotifier(), this.helper.getTopNotifier(), map);
    }

    public Iterator getBackwardIterator(List list) {
        if (list == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new BackwardEventIterator(list);
    }

    public Iterator getForwardIterator(List list) {
        if (list == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new ForwardEventIterator(list);
    }

    public Change[] getForwardChanges(List list) {
        if (list == null) {
            return new Change[0];
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EventReaderHelper eventReaderHelper = this.helper.makeCopy(copier);
        EventUtilImpl eventUtilImpl = new EventUtilImpl(eventReaderHelper);
        eventUtilImpl.doForwardEvents(list);
        return ChangeUtil.eINSTANCE.getChanges(this.helper.getTopNotifier(), eventReaderHelper.getTopNotifier(), (Map)copier);
    }

    protected void replayEvent(Event event) {
        this.helper.createObjectsFromDescriptorList(event, event.getAddedEObjects(), event.getAddedDescriptors());
        event.setNotifier(this.helper.getNotifier(event));
        event.setFeature(this.helper.getFeature(event));
        switch (event.getEventKind().getValue()) {
            case 0: {
                this.replaySet((Set)event);
                break;
            }
            case 1: {
                this.replayUnset((Unset)event);
                break;
            }
            case 2: {
                this.replayAdd((Add)event);
                break;
            }
            case 3: {
                this.replayRemove((Remove)event);
                break;
            }
            case 4: {
                this.replayAddMany((AddMany)event);
                break;
            }
            case 5: {
                this.replayRemoveMany((RemoveMany)event);
                break;
            }
            case 6: {
                this.replayMove((Move)event);
            }
        }
        this.helper.rememberEventIdsInDescriptorList(event, event.getRemovedEObjects(), event.getRemovedDescriptors());
    }

    protected void replaySet(Set set) {
        EObject eObject = (EObject)this.helper.getNotifier(set);
        Object object = eObject.eGet(this.helper.getFeature(set));
        if (this.helper.getFeatureKind(set) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberEventId((EObject)object, set.getOldLiteral());
        }
        if (set.isSetOldLiteral()) {
            set.setOldObject(object);
        } else {
            set.unsetOldObject();
        }
        set.setNewObject(this.helper.createFromString(set, set.getNewLiteral()));
        if (set.getNewObject() == null && set.getAddedEObjects().size() == 1) {
            EObject eObject2 = (EObject)set.getAddedEObjects().get(0);
            set.setNewObject(EcoreUtil.copy((EObject)eObject2));
        }
        this.helper.setValue(set, set.getNewObject());
    }

    protected void replayUnset(Unset unset) {
        EObject eObject = (EObject)this.helper.getNotifier(unset);
        Object object = eObject.eGet(this.helper.getFeature(unset));
        if (this.helper.getFeatureKind(unset) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberEventId((EObject)object, unset.getLiteral());
        }
        unset.setObject(object);
        this.helper.unsetValue(unset);
    }

    protected void replayAdd(Add add) {
        if (add.getLiteral() != null) {
            add.setObject(this.helper.createFromString(add, add.getLiteral()));
        }
        if (add.getObject() == null && add.getAddedEObjects().size() == 1) {
            EObject eObject = (EObject)add.getAddedEObjects().get(0);
            add.setObject(EcoreUtil.copy((EObject)eObject));
        }
        this.helper.setValue(add, add.getObject(), add.getPosition());
    }

    protected void replayRemove(Remove remove) {
        EList eList = this.helper.getNotifierContents(remove);
        if (this.helper.getFeatureKind(remove) == FeatureKind.REFERENCE_LITERAL) {
            Object object = this.helper.getEObjectFromString(remove.getLiteral());
            if (object == null) {
                object = eList.get(remove.getPosition());
            }
            remove.setObject(object);
            this.helper.rememberEventId((EObject)object, remove.getLiteral());
            eList.remove(remove.getObject());
        } else {
            Object e = eList.remove(remove.getPosition());
            remove.setObject(e);
        }
    }

    protected void replayAddMany(AddMany addMany) {
        addMany.getObjects().clear();
        EList eList = this.helper.getNotifierContents(addMany);
        int n = 0;
        int n2 = addMany.getLiterals().size();
        while (n < n2) {
            String string = (String)addMany.getLiterals().get(n);
            addMany.getObjects().add(this.helper.createFromString(addMany, string));
            ++n;
        }
        if (addMany.getObjects().size() == 0) {
            int n3 = 0;
            int n4 = addMany.getAddedEObjects().size();
            while (n3 < n4) {
                EObject eObject = (EObject)addMany.getAddedEObjects().get(n3);
                addMany.getObjects().add(EcoreUtil.copy((EObject)eObject));
                ++n3;
            }
        }
        this.helper.addAll(addMany, addMany.getObjects(), addMany.getPositions());
    }

    protected void replayRemoveMany(RemoveMany removeMany) {
        int n;
        removeMany.getObjects().clear();
        EList eList = this.helper.getNotifierContents(removeMany);
        if (this.helper.getFeatureKind(removeMany) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberAllEventIds(eList, removeMany.getPositions(), removeMany.getLiterals());
        }
        if (removeMany.getPositions().size() > 0) {
            n = 0;
            int n2 = removeMany.getPositions().size();
            while (n < n2) {
                Object object = null;
                if (removeMany.getLiterals().size() > 0) {
                    object = this.helper.getEObjectFromString((String)removeMany.getLiterals().get(n));
                }
                if (object == null) {
                    int n3 = (Integer)removeMany.getPositions().get(n);
                    object = eList.get(n3);
                }
                removeMany.getObjects().add(object);
                ++n;
            }
        } else {
            n = 0;
            int n4 = eList.size();
            while (n < n4) {
                removeMany.getObjects().add(eList.get(n));
                ++n;
            }
        }
        EList eList2 = this.helper.getNotifierContents(removeMany);
        this.helper.removeAll(eList2, removeMany.getPositions(), removeMany.getLiterals());
    }

    protected void replayMove(Move move) {
        EList eList = this.helper.getNotifierContents(move);
        eList.move(move.getNewPosition(), move.getOldPosition());
    }

    protected void undoEvent(Event event) {
        this.helper.createObjectsFromDescriptorList(event, event.getRemovedEObjects(), event.getRemovedDescriptors());
        event.setNotifier(this.helper.getNotifier(event));
        event.setFeature(this.helper.getFeature(event));
        switch (event.getEventKind().getValue()) {
            case 0: {
                this.undoSet((Set)event);
                break;
            }
            case 1: {
                this.undoUnset((Unset)event);
                break;
            }
            case 2: {
                this.undoAdd((Add)event);
                break;
            }
            case 3: {
                this.undoRemove((Remove)event);
                break;
            }
            case 4: {
                this.undoAddMany((AddMany)event);
                break;
            }
            case 5: {
                this.undoRemoveMany((RemoveMany)event);
                break;
            }
            case 6: {
                this.undoMove((Move)event);
            }
        }
        this.helper.rememberEventIdsInDescriptorList(event, event.getAddedEObjects(), event.getAddedDescriptors());
    }

    protected void undoSet(Set set) {
        EObject eObject = (EObject)this.helper.getNotifier(set);
        Object object = eObject.eGet(this.helper.getFeature(set));
        if (this.helper.getFeatureKind(set) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberEventId((EObject)object, set.getNewLiteral());
        }
        set.setNewObject(object);
        if (set.isSetOldLiteral()) {
            set.setOldObject(this.helper.createFromString(set, set.getOldLiteral()));
            if (set.getOldObject() == null && set.getRemovedEObjects().size() == 1) {
                EObject eObject2 = (EObject)set.getRemovedEObjects().get(0);
                set.setOldObject(EcoreUtil.copy((EObject)eObject2));
            }
        } else {
            set.unsetOldObject();
        }
        if (set.isSetOldObject()) {
            this.helper.setValue(set, set.getOldObject());
        } else {
            this.helper.unsetValue(set);
        }
    }

    protected void undoUnset(Unset unset) {
        unset.setObject(this.helper.createFromString(unset, unset.getLiteral()));
        this.helper.setValue(unset, unset.getObject());
    }

    protected void undoAdd(Add add) {
        EList eList = this.helper.getNotifierContents(add);
        if (this.helper.getFeatureKind(add) == FeatureKind.REFERENCE_LITERAL) {
            Object object = this.helper.getEObjectFromString(add.getLiteral());
            if (object == null) {
                object = eList.get(add.getPosition());
            }
            add.setObject(object);
            this.helper.rememberEventId((EObject)object, add.getLiteral());
            eList.remove(add.getObject());
        } else {
            Object e = eList.remove(add.getPosition());
            add.setObject(e);
        }
    }

    protected void undoRemove(Remove remove) {
        remove.setObject(this.helper.createFromString(remove, remove.getLiteral()));
        if (remove.getObject() == null && remove.getRemovedEObjects().size() == 1) {
            EObject eObject = (EObject)remove.getRemovedEObjects().get(0);
            remove.setObject(EcoreUtil.copy((EObject)eObject));
        }
        this.helper.setValue(remove, remove.getObject(), remove.getPosition());
    }

    protected void undoAddMany(AddMany addMany) {
        int n;
        addMany.getObjects().clear();
        EList eList = this.helper.getNotifierContents(addMany);
        if (this.helper.getFeatureKind(addMany) == FeatureKind.REFERENCE_LITERAL) {
            this.helper.rememberAllEventIds(eList, addMany.getPositions(), addMany.getLiterals());
        }
        if (addMany.getPositions().size() > 0) {
            n = 0;
            int n2 = addMany.getPositions().size();
            while (n < n2) {
                Integer n3 = (Integer)addMany.getPositions().get(n);
                addMany.getObjects().add(eList.get(n3));
                ++n;
            }
        } else {
            n = 0;
            int n4 = eList.size();
            while (n < n4) {
                addMany.getObjects().add(eList.get(n));
                ++n;
            }
        }
        EList eList2 = this.helper.getNotifierContents(addMany);
        this.helper.removeAll(eList2, addMany.getPositions(), addMany.getLiterals());
    }

    protected void undoRemoveMany(RemoveMany removeMany) {
        removeMany.getObjects().clear();
        EList eList = this.helper.getNotifierContents(removeMany);
        int n = 0;
        int n2 = removeMany.getLiterals().size();
        while (n < n2) {
            String string = (String)removeMany.getLiterals().get(n);
            removeMany.getObjects().add(this.helper.createFromString(removeMany, string));
            ++n;
        }
        this.helper.addAll(removeMany, removeMany.getObjects(), removeMany.getPositions());
    }

    protected void undoMove(Move move) {
        EList eList = this.helper.getNotifierContents(move);
        eList.move(move.getOldPosition(), move.getNewPosition());
    }

    protected class BackwardEventIterator
    implements Iterator {
        int position = -1;
        List eventsList = null;

        protected BackwardEventIterator(List list) {
            this.eventsList = list;
            this.position = list.size() - 1;
        }

        public boolean hasNext() {
            return this.position > -1;
        }

        public Object next() {
            Event event = (Event)this.eventsList.get(this.position--);
            EventUtilImpl.this.undoEvent(event);
            return event;
        }

        public void remove() {
            this.eventsList.remove(this.position);
        }
    }

    protected class ForwardEventIterator
    implements Iterator {
        Iterator i = null;

        protected ForwardEventIterator(List list) {
            this.i = list.iterator();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            Event event = (Event)this.i.next();
            EventUtilImpl.this.replayEvent(event);
            return event;
        }

        public void remove() {
            this.i.remove();
        }
    }
}

