/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.emf.event.impl;

import com.ibm.etools.emf.event.EObjectDescriptor;
import com.ibm.etools.emf.event.Event;
import com.ibm.etools.emf.event.EventFactory;
import com.ibm.etools.emf.event.FeatureKind;
import com.ibm.etools.emf.event.Setting;
import com.ibm.etools.emf.event.impl.EventHelper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EventWriterHelper
extends EventHelper {
    int nextEventId = 0;
    private Map eObjectToDataMap = null;

    private Map getEObjectMap() {
        if (this.eObjectToDataMap == null) {
            this.eObjectToDataMap = new HashMap();
        }
        return this.eObjectToDataMap;
    }

    private EObjectData getEObjectData(EObject eObject) {
        Map map = this.getEObjectMap();
        return (EObjectData)map.get(eObject);
    }

    private EObjectData createEObjectData(EObject eObject) {
        Map map = this.getEObjectMap();
        EObjectData eObjectData = new EObjectData();
        map.put(eObject, eObjectData);
        return eObjectData;
    }

    public EventWriterHelper(Notifier notifier, ResourceSet resourceSet) {
        super(notifier, resourceSet);
    }

    public void scanOriginalObjects(EList eList) {
        int n = 0;
        int n2 = eList.size();
        while (n < n2) {
            EObject eObject = (EObject)eList.get(n);
            this.createEObjectData(eObject);
            EList eList2 = eObject.eContents();
            this.scanOriginalObjects(eList2);
            ++n;
        }
    }

    public void scanOriginalObjects(ResourceSet resourceSet) {
        int n = 0;
        int n2 = resourceSet.getResources().size();
        while (n < n2) {
            Resource resource = (Resource)resourceSet.getResources().get(n);
            this.scanOriginalObjects(resource.getContents());
            ++n;
        }
    }

    protected boolean isNewObject(EObject eObject) {
        EObjectData eObjectData = this.getEObjectData(eObject);
        return eObjectData == null;
    }

    public boolean isNotifierVisible(Notifier notifier) {
        if (notifier.equals(this.topNotifier)) {
            return true;
        }
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            if (this.topNotifier.equals(eObject.eResource())) {
                return true;
            }
            return this.isEObjectVisible(eObject);
        }
        return false;
    }

    protected boolean isEObjectVisible(EObject eObject) {
        if (this.topNotifier.equals(eObject.eContainer())) {
            return true;
        }
        if (eObject.eContainer() != null) {
            return this.isEObjectVisible(eObject.eContainer());
        }
        return false;
    }

    public String convertValueToString(Event event, Object object, boolean bl) {
        if (this.getFeatureKind(event) == FeatureKind.ATTRIBUTE_LITERAL) {
            EStructuralFeature eStructuralFeature = this.getFeature(event);
            EDataType eDataType = (EDataType)eStructuralFeature.getEType();
            EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
            return eFactory.convertToString(eDataType, object);
        }
        EObject eObject = (EObject)object;
        return this.createDescriptorIfNeeded(event, eObject, bl);
    }

    protected String createDescriptorIfNeeded(Event event, EObject eObject, boolean bl) {
        String string = null;
        if (eObject != null) {
            if (this.isNewObject(eObject)) {
                this.createEObjectData(eObject);
                string = this.createDescriptor(event, eObject, bl);
            } else {
                EObjectData eObjectData = this.getEObjectData(eObject);
                if (eObject.eResource() == null && !this.isContainedInTopNotifier(eObject)) {
                    if (!bl) {
                        if (eObjectData.getFirstDeleteEvent() == null) {
                            this.createDescriptor(event, eObject, bl);
                            eObjectData.setFirstDeleteEvent(event);
                        } else {
                            int n = event.getRemovedEObjects().size();
                            event.getRemovedEObjects().add(eObjectData.getEmptyTemplate(eObject));
                            event.getRemovedDescriptors().add(eObjectData.getEmptyDescriptor(eObject, n));
                            eObjectData.unsetLastDeleteEvent();
                            eObjectData.setLastDeleteEvent(event);
                        }
                    }
                    string = this.getEObjectData(eObject).getEventId();
                } else {
                    if (eObjectData.getFirstDeleteEvent() != null) {
                        this.createDescriptor(event, eObject, bl);
                        this.removeIdenticalDescriptors(event, eObjectData.getFirstDeleteEvent());
                        eObjectData.unsetFirstDeleteEvent();
                        eObjectData.unsetLastDeleteEvent();
                    }
                    String string2 = this.getEObjectData(eObject).getEventId();
                    string = this.isContainmentRef(event) && string2 != null ? string2 : this.getURIString(eObject);
                }
            }
        }
        return string;
    }

    private boolean isContainmentRef(Event event) {
        EStructuralFeature eStructuralFeature = this.getFeature(event);
        return eStructuralFeature == null || eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment();
    }

    protected EObject createEmptyTemplate(EObject eObject) {
        EObject eObject2 = EcoreUtil.create((EClass)eObject.eClass());
        return eObject2;
    }

    protected EObjectDescriptor createEmptyDescriptor(EObject eObject) {
        EObjectDescriptor eObjectDescriptor = EventFactory.eINSTANCE.createEObjectDescriptor();
        eObjectDescriptor.setEventId(this.getEObjectData(eObject).getEventId());
        return eObjectDescriptor;
    }

    protected String createDescriptor(Event event, EObject eObject, boolean bl) {
        EList eList = bl ? event.getAddedEObjects() : event.getRemovedEObjects();
        EList eList2 = bl ? event.getAddedDescriptors() : event.getRemovedDescriptors();
        EObject eObject2 = this.createEmptyTemplate(eObject);
        int n = eList.size();
        eList.add(eObject2);
        EObjectData eObjectData = this.getEObjectData(eObject);
        String string = eObjectData.getEventId();
        if (string == null) {
            string = this.constructEventId(event, bl, eObject2);
            eObjectData.setEventId(string);
        }
        EObjectDescriptor eObjectDescriptor = EventFactory.eINSTANCE.createEObjectDescriptor();
        eObjectDescriptor.setEventId(string);
        eObjectDescriptor.setEObjectPosition(n);
        eList2.add(eObjectDescriptor);
        EventHelper.copyAttributes(eObject2, eObject);
        EClass eClass = eObject.eClass();
        EList eList3 = eClass.getEAllReferences();
        int n2 = 0;
        int n3 = eList3.size();
        while (n2 < n3) {
            EReference eReference = (EReference)eList3.get(n2);
            Object object = eObject.eGet((EStructuralFeature)eReference);
            this.createSettings(event, eReference, eObjectDescriptor.getSettings(), object, bl);
            ++n2;
        }
        return string;
    }

    protected String constructEventId(Event event, boolean bl, EObject eObject) {
        String string;
        EList eList = bl ? event.getAddedEObjects() : event.getRemovedEObjects();
        int n = eList.indexOf(eObject);
        if (n == -1) {
            return null;
        }
        if ((string = new Integer(this.nextEventId++).toString()).endsWith("#/")) {
            string = string + "0";
        }
        String string2 = "event:" + string;
        string2 = string2 + "/";
        if (!bl) {
            string2 = string2 + "-";
        }
        string2 = string2 + n;
        return string2;
    }

    protected void createSettings(Event event, EReference eReference, EList eList, Object object, boolean bl) {
        if (object != null && !eReference.isContainer()) {
            if (eReference.isMany()) {
                EList eList2 = (EList)object;
                int n = 0;
                int n2 = eList2.size();
                while (n < n2) {
                    Setting setting = EventFactory.eINSTANCE.createSetting();
                    setting.setRefName(eReference.getName());
                    EObject eObject = (EObject)eList2.get(n);
                    setting.setValue(this.createDescriptorIfNeeded(event, eObject, bl));
                    setting.setPosition(n);
                    eList.add(setting);
                    ++n;
                }
            } else {
                Setting setting = EventFactory.eINSTANCE.createSetting();
                setting.setRefName(eReference.getName());
                EObject eObject = (EObject)object;
                setting.setValue(this.createDescriptorIfNeeded(event, eObject, bl));
                setting.setPosition(-1);
                eList.add(setting);
            }
        }
    }

    protected int findMatchingId(String string, EList eList) {
        int n = 0;
        int n2 = eList.size();
        while (n < n2) {
            EObjectDescriptor eObjectDescriptor = (EObjectDescriptor)eList.get(n);
            if (string.equals(eObjectDescriptor.getEventId())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected void removeIdenticalDescriptors(Event event, Event event2) {
        EList eList = event.getAddedEObjects();
        EList eList2 = event2.getRemovedEObjects();
        EList eList3 = event.getAddedDescriptors();
        EList eList4 = event2.getRemovedDescriptors();
        int n = 0;
        while (n < eList3.size()) {
            EObjectDescriptor eObjectDescriptor = (EObjectDescriptor)eList3.get(n);
            int n2 = eObjectDescriptor.getEObjectPosition();
            EObject eObject = n2 == -1 ? null : (EObject)eList.get(n2);
            int n3 = this.findMatchingId(eObjectDescriptor.getEventId(), eList4);
            if (n3 != -1) {
                boolean bl;
                EObjectDescriptor eObjectDescriptor2 = (EObjectDescriptor)eList4.get(n3);
                int n4 = eObjectDescriptor2.getEObjectPosition();
                EObject eObject2 = n4 == -1 ? null : (EObject)eList2.get(n4);
                boolean bl2 = EventHelper.identicalAttributes(eObject, eObject2);
                if (bl2) {
                    this.removeTemplate(eObjectDescriptor, n2, eList, eList3);
                    this.removeTemplate(eObjectDescriptor2, n4, eList2, eList4);
                }
                if (bl = this.compareReferences(eObjectDescriptor.getSettings(), eObjectDescriptor2.getSettings())) {
                    eObjectDescriptor.getSettings().clear();
                    eObjectDescriptor2.getSettings().clear();
                }
                if (bl2 && bl) {
                    eList3.remove(n--);
                    eList4.remove(n3);
                }
            }
            ++n;
        }
    }

    private void removeTemplate(EObjectDescriptor eObjectDescriptor, int n, EList eList, EList eList2) {
        if (n == -1) {
            return;
        }
        eObjectDescriptor.setEObjectPosition(-1);
        eList.remove(n);
        int n2 = 0;
        int n3 = eList2.size();
        while (n2 < n3) {
            EObjectDescriptor eObjectDescriptor2 = (EObjectDescriptor)eList2.get(n2);
            if (eObjectDescriptor2.getEObjectPosition() > n) {
                eObjectDescriptor2.setEObjectPosition(eObjectDescriptor2.getEObjectPosition() - 1);
            }
            ++n2;
        }
    }

    protected boolean compareReferences(EList eList, EList eList2) {
        boolean bl = true;
        if (eList.size() != eList2.size()) {
            return false;
        }
        int n = 0;
        int n2 = eList.size();
        while (n < n2) {
            Setting setting = (Setting)eList.get(n);
            Setting setting2 = (Setting)eList2.get(n);
            if (!setting.getRefName().equals(setting2.getRefName())) {
                return false;
            }
            if (!setting.getValue().equals(setting2.getValue())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected class EObjectData {
        String eventId = null;
        Event firstDeleteEvent = null;
        Event lastDeleteEvent = null;
        EObject emptyTemplate = null;
        EObjectDescriptor emptyDescriptor = null;

        EObjectData() {
        }

        public void setEventId(String string) {
            this.eventId = string;
        }

        public void setFirstDeleteEvent(Event event) {
            this.firstDeleteEvent = event;
        }

        public void unsetFirstDeleteEvent() {
            this.firstDeleteEvent = null;
        }

        public void setLastDeleteEvent(Event event) {
            this.lastDeleteEvent = event;
        }

        public void unsetLastDeleteEvent() {
            if (this.getLastDeleteEvent() != null) {
                EList eList = this.getLastDeleteEvent().getRemovedEObjects();
                EList eList2 = this.getLastDeleteEvent().getRemovedDescriptors();
                int n = eList.indexOf(this.emptyTemplate);
                eList.remove(this.emptyTemplate);
                eList2.remove(this.emptyDescriptor);
                int n2 = 0;
                int n3 = eList2.size();
                while (n2 < n3) {
                    EObjectDescriptor eObjectDescriptor = (EObjectDescriptor)eList2.get(n2);
                    if (eObjectDescriptor.getEObjectPosition() > n) {
                        eObjectDescriptor.setEObjectPosition(eObjectDescriptor.getEObjectPosition() - 1);
                    }
                    ++n2;
                }
                this.setLastDeleteEvent(null);
            }
        }

        public String getEventId() {
            return this.eventId;
        }

        public Event getFirstDeleteEvent() {
            return this.firstDeleteEvent;
        }

        public Event getLastDeleteEvent() {
            return this.lastDeleteEvent;
        }

        public EObject getEmptyTemplate(EObject eObject) {
            if (this.emptyTemplate == null) {
                this.emptyTemplate = EventWriterHelper.this.createEmptyTemplate(eObject);
            }
            return this.emptyTemplate;
        }

        public EObject getEmptyDescriptor(EObject eObject, int n) {
            if (this.emptyDescriptor == null) {
                this.emptyDescriptor = EventWriterHelper.this.createEmptyDescriptor(eObject);
            }
            this.emptyDescriptor.setEObjectPosition(n);
            return this.emptyDescriptor;
        }
    }
}

