/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFOperation_SOAP;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.soap.SOAPException;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.WSIFCorrelationServiceLocator;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.jms.WSIFJMSCorrelationId;
import org.apache.wsif.util.jms.WSIFJMSDestination;

public class WSIFJmsSender
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static final long SYNC_TIMEOUT = WSIFProperties.getSyncTimeout();
    private static final long ASYNC_TIMEOUT = WSIFProperties.getAsyncTimeout();
    private static final String DUMMY_RESPONSE = "<?xml version='1.0' encoding='UTF-8'?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\">\n<SOAP-ENV:Body>\n<ns1:addEntryResponse xmlns:ns1=\"http://wsifservice.addressbook/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n</ns1:addEntryResponse>\n\n</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>";

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        this._invoke(messageContext);
    }

    public void _invoke(MessageContext messageContext) throws WebServicesFault {
        Trc.entry((Object)this, messageContext);
        try {
            boolean asyncMode = messageContext.isPropertyTrue("asyncOperation");
            WSIFJMSDestination dest = (WSIFJMSDestination)messageContext.getProperty("destination");
            Long transportSyncTimeoutValue = (Long)messageContext.getProperty("syncTimeout");
            long syncTimeout = transportSyncTimeoutValue == null ? SYNC_TIMEOUT : transportSyncTimeoutValue;
            Message message = messageContext.getRequestMessage();
            SOAPConstants sc = messageContext.getSOAPConstants();
            String ct = message.getContentType(sc);
            dest.setProperty("WSIFContentType", ct);
            dest.setProperty("contentType", ct);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            String contents = baos.toString();
            if (asyncMode) {
                this.performAsyncSend(messageContext, dest, contents);
            } else {
                boolean oneWay = dest.isOneWay();
                String id = dest.send(contents, null);
                if (!oneWay) {
                    String response = dest.receiveString(id, syncTimeout);
                    ct = (String)dest.getProperty("contentType");
                    if (ct == null) {
                        ct = (String)dest.getProperty("WSIFContentType");
                    }
                    String cl = (String)dest.getProperty("WSIFContentLocation");
                    Message responseMessage = ct != null || cl != null ? new Message((Object)new ByteArrayInputStream(response.getBytes()), false, ct, cl) : new Message((Object)response);
                    messageContext.setResponseMessage(responseMessage);
                } else {
                    Message responseMessage = new Message((Object)DUMMY_RESPONSE);
                    messageContext.setResponseMessage(responseMessage);
                }
            }
        }
        catch (IOException ioe) {
            Trc.exception(ioe);
            throw new WebServicesFault(ioe.toString());
        }
        catch (SOAPException se) {
            Trc.exception(se);
            throw new WebServicesFault(se.toString());
        }
        Trc.exit();
    }

    public void undo(MessageContext messageContext) {
        Trc.entry((Object)this, messageContext);
        Trc.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAsyncSend(MessageContext messageContext, WSIFJMSDestination dest, String data) throws WSIFException {
        String msgID;
        WSIFOperation_SOAP wsifOp = (WSIFOperation_SOAP)messageContext.getProperty("wsifOperation");
        if (wsifOp.getResponseHandler() == null) {
            msgID = dest.send(data);
            WSIFJMSCorrelationId cid = new WSIFJMSCorrelationId(msgID);
        } else {
            WSIFCorrelationService correlator;
            Long transportAsyncTimeoutValue = (Long)messageContext.getProperty("asyncTimeout");
            long asyncTimeout = transportAsyncTimeoutValue == null ? ASYNC_TIMEOUT : transportAsyncTimeoutValue;
            WSIFCorrelationService wSIFCorrelationService = correlator = WSIFCorrelationServiceLocator.getCorrelationService();
            synchronized (wSIFCorrelationService) {
                msgID = dest.send(data);
                WSIFJMSCorrelationId cid = new WSIFJMSCorrelationId(msgID);
                if (correlator != null) {
                    correlator.put(cid, wsifOp, asyncTimeout);
                }
            }
        }
        wsifOp.setAsyncRequestID(new WSIFJMSCorrelationId(msgID));
        Message responseMessage = new Message((Object)DUMMY_RESPONSE);
        messageContext.setResponseMessage(responseMessage);
    }
}

