/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsif.providers.soap;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.attachments.AttachmentPart;
import com.ibm.ws.webservices.engine.client.Call;
import com.ibm.ws.webservices.engine.client.Service;
import com.ibm.ws.webservices.engine.client.Transport;
import com.ibm.ws.webservices.engine.encoding.DeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializerFactory;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBodyElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import com.ibm.ws.webservices.wsif.providers.soap.MIMEHelper;
import com.ibm.ws.webservices.wsif.providers.soap.SOAPConstants;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFJmsTransport;
import com.ibm.ws.webservices.wsif.providers.soap.WSIFPort_SOAP;
import com.ibm.ws.webservices.wsif.providers.soap.jrom.JROMUtils;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanDeserializerFactory;
import com.ibm.ws.webservices.wsif.providers.soap.ser.BeanSerializerFactory;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.jms.TextMessage;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMimeXml;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.attachments.WSIFAttachmentPart;
import org.apache.wsif.base.WSIFDefaultOperation;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.util.TypeSerializerInfo;
import org.apache.wsif.util.WSIFProperties;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WSIFOperation_SOAP
extends WSIFDefaultOperation {
    private static final long serialVersionUID = 2L;
    protected transient WSIFPort_SOAP wsifPort;
    protected transient Operation portTypeOperation;
    protected transient BindingOperation bindingOperation;
    protected transient SOAPOperation soapOperation;
    protected transient List inputSOAPParts;
    protected transient List inputUnwrappedSOAPParts;
    protected transient List inputMIMEParts;
    protected transient Part inputSOAPHeader;
    protected transient Part inputSOAPHeaderFault;
    protected List outputSOAPParts;
    protected List outputUnwrappedSOAPParts;
    protected List outputMIMEParts;
    protected Part outputSOAPHeader;
    protected Part outputSOAPHeaderFault;
    protected transient String inputEncodingStyle;
    protected transient String inputNamespace;
    protected transient String soapActionURI;
    protected transient String inputUse;
    protected transient HashMap responseMessageParameters;
    protected transient boolean asyncOperation;
    protected transient WSIFCorrelationId asyncRequestID;
    protected transient boolean oneWayOperation;
    protected WSIFResponseHandler responseHandler;
    protected String outputEncodingStyle;
    protected WSIFDynamicTypeMap typeMap;
    protected String operationStyle;
    protected boolean usingJROM;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPBody;
    static /* synthetic */ Class class$javax$wsdl$extensions$mime$MIMEMultipartRelated;
    static /* synthetic */ Class class$javax$wsdl$extensions$mime$MIMEMimeXml;
    static /* synthetic */ Class class$org$apache$wsif$wsdl$extensions$jms$JMSProperty;
    static /* synthetic */ Class class$org$apache$wsif$wsdl$extensions$jms$JMSPropertyValue;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPFault;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPHeader;
    static /* synthetic */ Class class$javax$wsdl$extensions$soap$SOAPHeaderFault;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$encoding$SimpleType;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public WSIFOperation_SOAP(WSIFPort_SOAP wsifPort, Operation portTypeOperation, WSIFDynamicTypeMap typeMap) throws WSIFException {
        Trc.entry(this, wsifPort, portTypeOperation, typeMap);
        this.wsifPort = wsifPort;
        this.portTypeOperation = portTypeOperation;
        this.typeMap = typeMap;
        this.bindingOperation = this.getBindingOperation(portTypeOperation);
        this.inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        this.outputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    protected WSIFOperation_SOAP copy() throws WSIFException {
        Trc.entry(this);
        WSIFOperation_SOAP op = new WSIFOperation_SOAP(this.wsifPort, this.portTypeOperation, this.typeMap);
        op.inputSOAPParts = this.inputSOAPParts;
        op.inputUnwrappedSOAPParts = this.inputUnwrappedSOAPParts;
        op.inputMIMEParts = this.inputMIMEParts;
        op.inputSOAPHeader = this.inputSOAPHeader;
        op.inputSOAPHeaderFault = this.inputSOAPHeaderFault;
        op.outputSOAPParts = this.outputSOAPParts;
        op.outputUnwrappedSOAPParts = this.outputUnwrappedSOAPParts;
        op.outputMIMEParts = this.outputMIMEParts;
        op.outputSOAPHeader = this.outputSOAPHeader;
        op.outputSOAPHeaderFault = this.outputSOAPHeaderFault;
        op.soapOperation = this.soapOperation;
        op.setSoapActionURI(this.getSoapActionURI());
        op.setInputNamespace(this.getInputNamespace());
        op.setInputUse(this.getInputUse());
        op.setInputEncodingStyle(this.getInputEncodingStyle());
        op.setOutputEncodingStyle(this.getOutputEncodingStyle());
        op.setAsyncOperation(this.isAsyncOperation());
        op.setOneWayOperation(this.isOneWayOperation());
        op.setResponseHandler(this.getResponseHandler());
        op.setInputJmsProperties(this.getInputJmsProperties());
        op.setOutputJmsProperties(this.getOutputJmsProperties());
        op.setInputJmsPropertyValues(this.getInputJmsPropertyValues());
        op.setOperationStyle(this.getOperationStyle());
        if (Trc.ON) {
            Trc.exit(op.deep());
        }
        return op;
    }

    private void parseSoapOperation() throws WSIFException {
        this.soapOperation = this.wsifPort.getSOAPOperation(this.bindingOperation);
        this.soapActionURI = this.soapOperation.getSoapActionURI();
        this.operationStyle = this.soapOperation.getStyle();
        if (this.operationStyle == null || this.operationStyle.length() < 1) {
            this.operationStyle = this.wsifPort.getBindingStyle();
        } else if (!SOAPConstants.VALID_STYLES.contains(this.operationStyle)) {
            throw new WSIFException("unsupported style " + this.operationStyle + " for operation " + this.portTypeOperation.getName());
        }
        if (this.operationStyle == null || this.operationStyle.length() < 1) {
            this.operationStyle = "document";
        }
    }

    private void parseBindingInput() throws WSIFException {
        List inJmsPropVals;
        MIMEMimeXml inMimeMimeXml;
        List inExtElems;
        BindingInput bindinginput = this.bindingOperation.getBindingInput();
        SOAPBody inSoapBody = (SOAPBody)this.wsifPort.getExtElem(bindinginput, class$javax$wsdl$extensions$soap$SOAPBody == null ? (class$javax$wsdl$extensions$soap$SOAPBody = WSIFOperation_SOAP.class$("javax.wsdl.extensions.soap.SOAPBody")) : class$javax$wsdl$extensions$soap$SOAPBody, inExtElems = bindinginput.getExtensibilityElements());
        if (inSoapBody != null) {
            this.inputSOAPParts = this.parseSoapBody(inSoapBody, true);
        }
        MIMEMultipartRelated inMimeMultipart = (MIMEMultipartRelated)this.wsifPort.getExtElem(bindinginput, class$javax$wsdl$extensions$mime$MIMEMultipartRelated == null ? (class$javax$wsdl$extensions$mime$MIMEMultipartRelated = WSIFOperation_SOAP.class$("javax.wsdl.extensions.mime.MIMEMultipartRelated")) : class$javax$wsdl$extensions$mime$MIMEMultipartRelated, inExtElems);
        if (inSoapBody != null && inMimeMultipart != null) {
            throw new WSIFException("In a binding operation that contains a mime:multipartRelated, a soap:body was found that was not in a mime:part. OperationName=" + this.getName());
        }
        if (inSoapBody == null && inMimeMultipart == null) {
            throw new WSIFException("binding operation input must contain either a soap:body or a mime:multipartRelated element. OperationName=" + this.getName());
        }
        if (inMimeMultipart != null) {
            this.parseMimeMultipart(inMimeMultipart, true);
        }
        if ((inMimeMimeXml = (MIMEMimeXml)this.wsifPort.getExtElem(bindinginput, class$javax$wsdl$extensions$mime$MIMEMimeXml == null ? (class$javax$wsdl$extensions$mime$MIMEMimeXml = WSIFOperation_SOAP.class$("javax.wsdl.extensions.mime.MIMEMimeXml")) : class$javax$wsdl$extensions$mime$MIMEMimeXml, inExtElems)) != null) {
            throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
        }
        this.parseSOAPHeaderElement(bindinginput);
        List inJmsProps = this.wsifPort.getExtElems(bindinginput, class$org$apache$wsif$wsdl$extensions$jms$JMSProperty == null ? (class$org$apache$wsif$wsdl$extensions$jms$JMSProperty = WSIFOperation_SOAP.class$("org.apache.wsif.wsdl.extensions.jms.JMSProperty")) : class$org$apache$wsif$wsdl$extensions$jms$JMSProperty, bindinginput.getExtensibilityElements());
        if (inJmsProps != null && inJmsProps.size() > 0) {
            if (this.wsifPort.isTransportJMS()) {
                this.setInputJmsProperties(inJmsProps);
            } else {
                throw new WSIFException("jms:property found in non-jms binding");
            }
        }
        if ((inJmsPropVals = this.wsifPort.getExtElems(bindinginput, class$org$apache$wsif$wsdl$extensions$jms$JMSPropertyValue == null ? (class$org$apache$wsif$wsdl$extensions$jms$JMSPropertyValue = WSIFOperation_SOAP.class$("org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue")) : class$org$apache$wsif$wsdl$extensions$jms$JMSPropertyValue, bindinginput.getExtensibilityElements())) != null && inJmsPropVals.size() > 0) {
            if (this.wsifPort.isTransportJMS()) {
                this.addInputJmsPropertyValues(inJmsPropVals);
            } else {
                throw new WSIFException("jms:propertyValue found in non-jms binding");
            }
        }
    }

    private void parseBindingOutput() throws WSIFException {
        BindingOutput bindingoutput = this.bindingOperation.getBindingOutput();
        if (bindingoutput != null) {
            MIMEMimeXml outMimeMimeXml;
            List outExtElems;
            SOAPBody outSoapBody = (SOAPBody)this.wsifPort.getExtElem(bindingoutput, class$javax$wsdl$extensions$soap$SOAPBody == null ? (class$javax$wsdl$extensions$soap$SOAPBody = WSIFOperation_SOAP.class$("javax.wsdl.extensions.soap.SOAPBody")) : class$javax$wsdl$extensions$soap$SOAPBody, outExtElems = bindingoutput.getExtensibilityElements());
            if (outSoapBody != null) {
                this.outputSOAPParts = this.parseSoapBody(outSoapBody, false);
            }
            MIMEMultipartRelated outMimeMultipart = (MIMEMultipartRelated)this.wsifPort.getExtElem(bindingoutput, class$javax$wsdl$extensions$mime$MIMEMultipartRelated == null ? (class$javax$wsdl$extensions$mime$MIMEMultipartRelated = WSIFOperation_SOAP.class$("javax.wsdl.extensions.mime.MIMEMultipartRelated")) : class$javax$wsdl$extensions$mime$MIMEMultipartRelated, outExtElems);
            if (outSoapBody != null && outMimeMultipart != null) {
                throw new WSIFException("In a binding operation that contains a mime:multipartRelated, a soap:body was found that was not in a mime:part. OperationName=" + this.getName());
            }
            if (outSoapBody == null && outMimeMultipart == null) {
                throw new WSIFException("binding operation output must contain either a soap:body or a mime:multipartRelated element. OperationName=" + this.getName());
            }
            if (outMimeMultipart != null) {
                this.parseMimeMultipart(outMimeMultipart, false);
            }
            if ((outMimeMimeXml = (MIMEMimeXml)this.wsifPort.getExtElem(bindingoutput, class$javax$wsdl$extensions$mime$MIMEMimeXml == null ? (class$javax$wsdl$extensions$mime$MIMEMimeXml = WSIFOperation_SOAP.class$("javax.wsdl.extensions.mime.MIMEMimeXml")) : class$javax$wsdl$extensions$mime$MIMEMimeXml, outExtElems)) != null) {
                throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
            }
            this.parseSOAPHeaderElement(bindingoutput);
            Iterator iterator1 = this.bindingOperation.getBindingFaults().values().iterator();
            while (iterator1.hasNext()) {
                BindingFault bindingfault = (BindingFault)iterator1.next();
                SOAPFault soapfault = (SOAPFault)this.wsifPort.getExtElem(bindingfault, class$javax$wsdl$extensions$soap$SOAPFault == null ? WSIFOperation_SOAP.class$("javax.wsdl.extensions.soap.SOAPFault") : class$javax$wsdl$extensions$soap$SOAPFault, bindingfault.getExtensibilityElements());
            }
            List outJmsProps = this.wsifPort.getExtElems(bindingoutput, class$org$apache$wsif$wsdl$extensions$jms$JMSProperty == null ? (class$org$apache$wsif$wsdl$extensions$jms$JMSProperty = WSIFOperation_SOAP.class$("org.apache.wsif.wsdl.extensions.jms.JMSProperty")) : class$org$apache$wsif$wsdl$extensions$jms$JMSProperty, outExtElems);
            if (outJmsProps != null && outJmsProps.size() > 0) {
                if (this.wsifPort.isTransportJMS()) {
                    this.setOutputJmsProperties(outJmsProps);
                } else {
                    throw new WSIFException("jms:properties found in non-jms binding");
                }
            }
        }
    }

    private void parseSOAPHeaderElement(Object element) throws WSIFException {
        List extensabilityElements;
        if (element instanceof BindingInput) {
            extensabilityElements = ((BindingInput)element).getExtensibilityElements();
        } else if (element instanceof BindingOutput) {
            extensabilityElements = ((BindingOutput)element).getExtensibilityElements();
        } else {
            throw new WSIFException("internal error, unexpected object: " + element);
        }
        Part soapHeaderPart = null;
        Part soapHeaderFaultPart = null;
        List soapHeaderList = this.wsifPort.getExtElems(element, class$javax$wsdl$extensions$soap$SOAPHeader == null ? (class$javax$wsdl$extensions$soap$SOAPHeader = WSIFOperation_SOAP.class$("javax.wsdl.extensions.soap.SOAPHeader")) : class$javax$wsdl$extensions$soap$SOAPHeader, extensabilityElements);
        javax.wsdl.extensions.soap.SOAPHeader soapHeader = null;
        if (soapHeaderList != null) {
            soapHeader = (javax.wsdl.extensions.soap.SOAPHeader)soapHeaderList.get(0);
        }
        if (soapHeader != null) {
            QName messageName = soapHeader.getMessage();
            if (messageName == null) {
                throw new WSIFException("no message attribute on soap:header: " + soapHeader);
            }
            String messagePart = soapHeader.getPart();
            if (messagePart == null) {
                throw new WSIFException("no part attribute on soap:header: " + soapHeader);
            }
            soapHeaderPart = this.getPart(messageName, messagePart);
            if (soapHeaderPart == null) {
                throw new WSIFException("non existent part specified on soap:header: " + soapHeader);
            }
            SOAPHeaderFault soapHeaderFault = (SOAPHeaderFault)this.wsifPort.getExtElem(soapHeader, class$javax$wsdl$extensions$soap$SOAPHeaderFault == null ? (class$javax$wsdl$extensions$soap$SOAPHeaderFault = WSIFOperation_SOAP.class$("javax.wsdl.extensions.soap.SOAPHeaderFault")) : class$javax$wsdl$extensions$soap$SOAPHeaderFault, extensabilityElements);
            if (soapHeaderFault != null) {
                messageName = soapHeader.getMessage();
                if (messageName == null) {
                    throw new WSIFException("no message attribute on soap:header: " + soapHeader);
                }
                messagePart = soapHeader.getPart();
                if (messagePart == null) {
                    throw new WSIFException("no part attribute on soap:header: " + soapHeader);
                }
                soapHeaderFaultPart = this.getPart(messageName, messagePart);
                if (soapHeaderFaultPart == null) {
                    throw new WSIFException("non existent part specified on soap:header: " + soapHeader);
                }
            }
        }
        if (element instanceof BindingInput) {
            this.inputSOAPHeader = soapHeaderPart;
            this.inputSOAPHeaderFault = soapHeaderFaultPart;
        } else {
            this.outputSOAPHeader = soapHeaderPart;
            this.outputSOAPHeaderFault = soapHeaderFaultPart;
        }
    }

    private List parseSoapBody(SOAPBody soapbody, boolean isInput) throws WSIFException {
        List l;
        String use;
        String ns;
        Trc.entry(this, soapbody, new Boolean(isInput));
        if (isInput && (ns = soapbody.getNamespaceURI()) != null) {
            this.setInputNamespace(soapbody.getNamespaceURI());
        }
        if (!SOAPConstants.VALID_USES.contains(use = soapbody.getUse())) {
            throw new WSIFException("unsupported use " + use + " in " + this.soapOperation);
        }
        if (isInput) {
            this.setInputUse(use);
        }
        if (isInput && (l = soapbody.getEncodingStyles()) != null && l.size() > 0) {
            this.setInputEncodingStyle((String)l.get(0));
        }
        javax.wsdl.Message m = null;
        if (isInput) {
            Input in = this.portTypeOperation.getInput();
            if (in != null) {
                m = in.getMessage();
            }
        } else {
            Output out = this.portTypeOperation.getOutput();
            if (out != null) {
                m = out.getMessage();
            }
        }
        ArrayList al = this.getParts(m, soapbody.getParts());
        Trc.exit(al);
        return al;
    }

    private ArrayList getParts(javax.wsdl.Message m, List partNames) throws WSIFException {
        ArrayList<Part> al = new ArrayList<Part>();
        List parts = null;
        if (m != null) {
            parts = m.getOrderedParts(null);
        }
        if ((parts == null || parts.size() < 1) && partNames != null && partNames.size() > 0) {
            throw new WSIFException("part '" + partNames.get(0) + "' not defined in message " + m);
        }
        if (partNames == null) {
            if (parts != null) {
                al.addAll(parts);
            }
        } else {
            Iterator i = partNames.iterator();
            while (i.hasNext()) {
                String partName = (String)i.next();
                Part p = m.getPart(partName);
                if (p == null) {
                    throw new WSIFException("Part '" + partName + "' in soap:body parts not in message " + m);
                }
                if (al.contains(p)) continue;
                al.add(p);
            }
        }
        return al;
    }

    private void parseMimeMultipart(MIMEMultipartRelated mimeMultipart, boolean isInput) throws WSIFException {
        Trc.entry((Object)this, mimeMultipart);
        ArrayList<String> mimePartNames = new ArrayList<String>();
        SOAPBody soapBody = null;
        Operation op = this.bindingOperation.getOperation();
        Map inMessageParts = op.getInput().getMessage().getParts();
        Map outMessageParts = op.getOutput() == null ? new HashMap() : op.getOutput().getMessage().getParts();
        List mimeParts = mimeMultipart.getMIMEParts();
        Iterator mimePartIt = mimeParts.iterator();
        while (mimePartIt.hasNext()) {
            Object nextMimePart = mimePartIt.next();
            if (!(nextMimePart instanceof MIMEPart)) continue;
            MIMEPart mimePart = (MIMEPart)nextMimePart;
            if (!"http://schemas.xmlsoap.org/wsdl/mime/".equals(mimePart.getElementType().getNamespaceURI())) {
                throw new WSIFException("A MIME part in binding operation " + this.bindingOperation.getName() + " did not have the correct namespace URI of " + "http://schemas.xmlsoap.org/wsdl/mime/" + ".");
            }
            boolean containsSoapBody = false;
            boolean containsMimeContent = false;
            List mimePartChildren = mimePart.getExtensibilityElements();
            Iterator mimePartChildrenIt = mimePartChildren.iterator();
            while (mimePartChildrenIt.hasNext()) {
                Object nextChild = mimePartChildrenIt.next();
                if (nextChild instanceof MIMEContent) {
                    MIMEContent mimeContent = (MIMEContent)nextChild;
                    if (!"http://schemas.xmlsoap.org/wsdl/mime/".equals(mimePart.getElementType().getNamespaceURI())) {
                        throw new WSIFException("A MIME part in binding operation " + this.bindingOperation.getName() + " did not have the correct namespace URI of " + "http://schemas.xmlsoap.org/wsdl/mime/" + ".");
                    }
                    containsMimeContent = true;
                    if (containsSoapBody) {
                        throw new WSIFException("A mime:part that contains a mime:content also contains a soap:body. Operation=" + this.getName());
                    }
                    String partName = mimeContent.getPart();
                    if (partName == null || partName.length() == 0) {
                        throw new WSIFException("No part name for a mime:content. Operation=" + this.getName());
                    }
                    mimePartNames.add(partName);
                    continue;
                }
                if (nextChild instanceof SOAPBody) {
                    if (soapBody != null) {
                        throw new WSIFException("Multiple soap:body tags found in a mime:multipartRelated. Operation=" + this.getName());
                    }
                    soapBody = (SOAPBody)nextChild;
                    containsSoapBody = true;
                    if (!containsMimeContent) continue;
                    throw new WSIFException("A mime:part that contains a mime:content also contains a soap:body. Operation=" + this.getName());
                }
                if (nextChild instanceof MIMEMultipartRelated) {
                    throw new WSIFException("WSIF does not support nesting mime:multipartRelated inside a mime:part. Operation=" + this.getName());
                }
                if (!(nextChild instanceof MIMEMimeXml)) continue;
                throw new WSIFException("WSIF does not support mime:mimeXml. Operation=" + this.getName());
            }
        }
        ArrayList mimePartList = new ArrayList();
        if (mimePartNames != null && !mimePartNames.isEmpty()) {
            javax.wsdl.Message m = null;
            if (isInput) {
                Input in = this.portTypeOperation.getInput();
                if (in != null) {
                    m = in.getMessage();
                }
            } else {
                Output out = this.portTypeOperation.getOutput();
                if (out != null) {
                    m = out.getMessage();
                }
            }
            mimePartList = this.getParts(m, mimePartNames);
        }
        Map messageParts = null;
        messageParts = isInput ? inMessageParts : outMessageParts;
        List soapParts = null;
        if (soapBody != null) {
            soapParts = this.parseSoapBody(soapBody, isInput);
            if (isInput) {
                this.inputSOAPParts = soapParts;
            } else {
                this.outputSOAPParts = soapParts;
            }
        }
        if (isInput) {
            this.inputMIMEParts = mimePartList;
        } else {
            this.outputMIMEParts = mimePartList;
        }
        Trc.exit();
    }

    private void unwrapSOAPParts() throws WSIFException {
        if ("document".equals(this.operationStyle)) {
            Part p;
            QName elementName;
            String operationName = this.getName();
            if (this.inputSOAPParts.size() == 1 && (elementName = (p = (Part)this.inputSOAPParts.get(0)).getElementName()) != null && operationName.equals(elementName.getLocalPart())) {
                this.inputUnwrappedSOAPParts = ProviderUtils.unWrapPart(p, this.getDefinition(), this.context);
            }
            if (this.outputSOAPParts.size() == 1) {
                String s = operationName + "Response";
                Part p2 = (Part)this.outputSOAPParts.get(0);
                QName elementName2 = p2.getElementName();
                if (elementName2 != null && s.equals(elementName2.getLocalPart())) {
                    this.outputUnwrappedSOAPParts = ProviderUtils.unWrapPart(p2, this.getDefinition(), this.context);
                }
            }
        }
    }

    private BindingOperation getBindingOperation(Operation operation) throws WSIFException {
        Binding binding = this.wsifPort.getPort().getBinding();
        BindingOperation bindingOp = WSIFUtils.getBindingOperation(binding, operation);
        if (bindingOp == null) {
            throw new WSIFException("cannot find binding operation for port operation:" + operation.getName());
        }
        return bindingOp;
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Definition d = this.wsifPort.getDefinition();
        Trc.exit(d);
        return d;
    }

    public WSIFPort_SOAP getDynamicWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.wsifPort);
        return this.wsifPort;
    }

    public String getInputEncodingStyle() {
        Trc.entry(this);
        Trc.exit(this.inputEncodingStyle);
        return this.inputEncodingStyle;
    }

    public String getInputNamespace() {
        Trc.entry(this);
        Trc.exit(this.inputNamespace);
        return this.inputNamespace;
    }

    public String getName() {
        Trc.entry(this);
        String s = this.portTypeOperation.getName();
        Trc.exit(s);
        return s;
    }

    public Operation getOperation() {
        Trc.entry(this);
        Operation o = this.getPortTypeOperation();
        Trc.exit(o);
        return o;
    }

    private Part getPart(QName message, String partName) {
        Part p = null;
        Definition def = this.wsifPort.getDefinition();
        javax.wsdl.Message m = def.getMessage(message);
        if (m != null) {
            p = m.getPart(partName);
        }
        return p;
    }

    public Operation getPortTypeOperation() {
        Trc.entry(this);
        Trc.exit(this.portTypeOperation);
        return this.portTypeOperation;
    }

    public String getOutputEncodingStyle() {
        Trc.entry(this);
        Trc.exit(this.outputEncodingStyle);
        return this.outputEncodingStyle;
    }

    public String getSoapActionURI() {
        Trc.entry(this);
        Trc.exit(this.soapActionURI);
        return this.soapActionURI;
    }

    public Transport getTransport() throws WSIFException {
        Trc.entry(this);
        Transport t = this.wsifPort.getTransport();
        Trc.exit(t);
        return t;
    }

    public WSIFCorrelationId getAsyncRequestID() {
        Trc.entry(this);
        Trc.exit(this.asyncRequestID);
        return this.asyncRequestID;
    }

    private HashMap getResponseMessageParameters() {
        return this.responseMessageParameters;
    }

    public WSIFPort getWSIFPort() {
        Trc.entry(this);
        Trc.exit(this.wsifPort);
        return this.wsifPort;
    }

    public boolean isAsyncOperation() {
        Trc.entry(this);
        Trc.exit(this.asyncOperation);
        return this.asyncOperation;
    }

    public void executeInputOnlyOperation(WSIFMessage inMsg) throws WSIFException {
        Trc.entry((Object)this, inMsg);
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        this.setAsyncOperation(false);
        this.setOneWayOperation(true);
        this.invokeRequestResponseOperation(inMsg, null, null);
        Trc.exit();
    }

    public boolean executeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        Trc.entry(this, inMsg, outMsg, faultMsg);
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        if (outMsg == null) {
            throw new IllegalArgumentException("output message is null");
        }
        if (faultMsg == null) {
            throw new IllegalArgumentException("fault message is null");
        }
        this.close();
        this.setAsyncOperation(false);
        this.setOneWayOperation(false);
        boolean succ = this.invokeRequestResponseOperation(inMsg, outMsg, faultMsg);
        Trc.exit(succ);
        return succ;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage inMsg) throws WSIFException {
        Trc.entry((Object)this, inMsg);
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        WSIFCorrelationId id = this.executeRequestResponseAsync(inMsg, null);
        Trc.exit(id);
        return id;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage inMsg, WSIFResponseHandler handler) throws WSIFException {
        Trc.entry(this, inMsg, handler);
        if (inMsg == null) {
            throw new IllegalArgumentException("input message is null");
        }
        this.close();
        if (!this.wsifPort.supportsAsync()) {
            throw new WSIFException("asynchronous operations not available");
        }
        this.setAsyncOperation(true);
        this.setOneWayOperation(false);
        this.setResponseHandler(handler);
        WSIFJmsTransport transport = (WSIFJmsTransport)this.getTransport();
        transport.setWsifOperation(this);
        transport.setAsyncOperation("true");
        this.invokeRequestResponseOperation(inMsg, null, null);
        transport.setAsyncOperation("false");
        WSIFCorrelationId id = this.getAsyncRequestID();
        Trc.exit(id);
        return id;
    }

    public void fireAsyncResponse(Object response) throws WSIFException {
        Trc.entry((Object)this, response);
        Object result = this.deserialiseResponseObject(response);
        WSIFMessage outMsg = this.createOutputMessage();
        WSIFMessage faultMsg = this.createFaultMessage();
        this.buildResponseMessages(result, outMsg, faultMsg);
        this.getResponseHandler().executeAsyncResponse(outMsg, faultMsg);
        Trc.exit(outMsg);
    }

    public boolean processAsyncResponse(Object response, WSIFMessage output, WSIFMessage fault) throws WSIFException {
        Trc.entry(this, response, output, fault);
        Object result = this.deserialiseResponseObject(response);
        boolean ok = this.buildResponseMessages(result, output, fault);
        Trc.exit(ok);
        return ok;
    }

    private Object deserialiseResponseObject(Object msg) throws WSIFException {
        if (msg == null) {
            throw new WSIFException("null response to async send");
        }
        if (!(msg instanceof TextMessage)) {
            throw new WSIFException("response not a javax.jms.TextMessage");
        }
        try {
            TextMessage m = (TextMessage)msg;
            Message responseMessage = new Message((Object)m.getText());
            responseMessage.setMessageType(MessageType.RESPONSE);
            Service service = new Service();
            MessageContext msgContext = new MessageContext(service.getEngine());
            msgContext.setResponseMessage(responseMessage);
            TypeMappingRegistry tmr = msgContext.getTypeMappingRegistry();
            TypeMapping tm = (TypeMapping)tmr.getTypeMapping(this.outputEncodingStyle);
            if (this.usingJROM) {
                JROMUtils.registerJROMSerializers((javax.xml.rpc.encoding.TypeMapping)tm);
            }
            WSIFOperation_SOAP.registerDefaultTypeMappings((javax.xml.rpc.encoding.TypeMapping)tm, this.getContext());
            WSIFOperation_SOAP.registerDynamicTypes((javax.xml.rpc.encoding.TypeMapping)tm, this.typeMap, this.getContext(), this.usingJROM);
            Message resMsg = msgContext.getResponseMessage();
            SOAPEnvelope resEnv = resMsg.getSOAPEnvelope();
            com.ibm.ws.webservices.engine.xmlsoap.SOAPBody b = (com.ibm.ws.webservices.engine.xmlsoap.SOAPBody)resEnv.getBody();
            RequestResponse body = b.getRequestResponse();
            Object result = null;
            Vector resArgs = body.getParams();
            if (resArgs != null && resArgs.size() > 0) {
                ParamValue param = (ParamValue)resArgs.get(0);
                result = param.getValue();
                if (resArgs.size() > 1) {
                    HashMap<String, Object> outParams = new HashMap<String, Object>();
                    int i = 1;
                    while (i < resArgs.size()) {
                        ParamValue p = (ParamValue)resArgs.get(i);
                        outParams.put(p.getName(), p.getValue());
                        ++i;
                    }
                    this.setResponseMessageParameters(outParams);
                }
            }
            return result;
        }
        catch (Exception ex) {
            Trc.exception(ex);
            throw new WSIFException(ex.getMessage());
        }
    }

    private boolean buildResponseMessages(Object resp, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        boolean respOK;
        if (resp instanceof WebServicesFault) {
            respOK = false;
            if (faultMsg != null) {
                WebServicesFault f = (WebServicesFault)resp;
                faultMsg.setName("org.apache.wsif.soap.fault");
                faultMsg.setObjectPart("org.apache.wsif.soap.fault.object", (Object)f);
                this.processFault(f, faultMsg);
            }
        } else {
            respOK = true;
            this.populateOutMsgReturnPart(resp, outMsg);
            this.populateOutMsgParts(outMsg);
        }
        return respOK;
    }

    private void processFault(WebServicesFault f, WSIFMessage faultMsg) throws WSIFException {
        Trc.entry(this, f, faultMsg);
        boolean throwException = false;
        Object obj = null;
        try {
            obj = this.context != null ? this.context.getObjectPart("org.apache.wsif.soap.throw.unchecked.fault") : this.getWSIFPort().getContext().getObjectPart("org.apache.wsif.soap.throw.unchecked.fault");
        }
        catch (WSIFException notFound) {
            // empty catch block
        }
        if (obj != null) {
            try {
                throwException = (Boolean)obj;
            }
            catch (ClassCastException ignored) {
                Trc.ignoredException(ignored);
            }
        }
        Trc.event(this, "throw WSIFException for unchecked faults is " + throwException);
        QName faultCodeToFind = f.getFaultCode();
        if (faultCodeToFind == null) {
            if (throwException) {
                throw new WSIFException("Cannot find fault code", f);
            }
            Trc.exit();
            return;
        }
        Exception userException = f.getUserException();
        if (userException == null) {
            if (throwException) {
                throw new WSIFException("Cannot find user exception", f);
            }
            Trc.exit();
            return;
        }
        Operation operation = this.getOperation();
        Map faults = operation.getFaults();
        if (faults.isEmpty()) {
            if (throwException) {
                throw new WSIFException("No faults defined in wsdl", userException);
            }
            Trc.exit();
            return;
        }
        boolean foundFault = false;
        Set faultNamesSet = faults.keySet();
        Iterator it = faultNamesSet.iterator();
        while (it.hasNext() && !foundFault) {
            Object faultKey = it.next();
            Fault fault = (Fault)faults.get(faultKey);
            QName[] qNames = this.getQNamesFromFault(fault);
            if (qNames == null) {
                Trc.event(this, "nothing found in fault, trying next fault");
                continue;
            }
            QName faultCode = qNames[0];
            QName messageQName = qNames[1];
            QName partQName = qNames[2];
            QName partXmlType = qNames[3];
            String partName = qNames[4].getLocalPart();
            if (!faultCodeToFind.equals(faultCode)) continue;
            faultMsg.setName(fault.getName());
            faultMsg.setMessageDefinition(fault.getMessage());
            faultMsg.setObjectPart(partName, userException);
            foundFault = true;
        }
        if (!foundFault && throwException) {
            throw new WSIFException("Unable to match fault in wsdl", userException);
        }
        Trc.exit(faultMsg);
    }

    private void populateOutMsgReturnPart(Object resp, WSIFMessage outMsg) throws WSIFException {
        if (outMsg != null) {
            List soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
            Part returnPart = null;
            if (soapParts.size() > 0) {
                returnPart = (Part)soapParts.get(0);
                WSIFOperation_SOAP.setSOAPMessagePart(outMsg, returnPart.getName(), resp);
            } else if (this.outputMIMEParts.size() > 0) {
                returnPart = (Part)this.outputMIMEParts.get(0);
                WSIFOperation_SOAP.setMIMEMessagePart(outMsg, returnPart.getName(), resp, resp == null ? null : resp.getClass());
            }
        }
    }

    private void populateOutMsgParts(WSIFMessage outMsg) throws WSIFException {
        HashMap respParms;
        if (outMsg != null && (respParms = this.getResponseMessageParameters()) != null) {
            List soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
            if (!this.outputMIMEParts.isEmpty()) {
                soapParts = new ArrayList(soapParts);
                soapParts.removeAll(this.outputMIMEParts);
            }
            int i = 1;
            while (i < soapParts.size()) {
                Part p = (Part)soapParts.get(i);
                String name = p.getName();
                Object value = respParms.get(name);
                WSIFOperation_SOAP.setSOAPMessagePart(outMsg, name, value);
                ++i;
            }
            int startMIMEindex = soapParts.size() > 0 ? 0 : 1;
            int i2 = startMIMEindex;
            while (i2 < this.outputMIMEParts.size()) {
                Object value;
                String name;
                Part p = (Part)this.outputMIMEParts.get(i2);
                WSIFOperation_SOAP.setMIMEMessagePart(outMsg, name, value, (value = respParms.get(name = p.getName())) == null ? null : value.getClass());
                ++i2;
            }
        }
    }

    private static void setSOAPMessagePart(WSIFMessage msg, String name, Object value) throws WSIFException {
        Trc.entry(null, msg, name, value);
        msg.setObjectPart(name, value);
        Trc.exit();
    }

    private static void setMIMEMessagePart(WSIFMessage msg, String name, Object value, Class type) throws WSIFException {
        Trc.entry(null, msg, name, value, type);
        MIMEHelper.setMIMEMessagePart(msg, name, value, type);
        Trc.exit();
    }

    private QName getPartType(Part p) {
        QName type = p.getTypeName();
        if (type == null) {
            type = p.getElementName();
        }
        return type;
    }

    protected boolean invokeRequestResponseOperation(WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        String s;
        Trc.entry(this, inMsg, outMsg, faultMsg);
        boolean workedOK = false;
        this.usingJROM = "http://www.apache.org/namespaces/jrom".equals(inMsg.getRepresentationStyle());
        Call call = this.usingJROM ? this.wsifPort.getJROMCall() : this.wsifPort.getCall();
        call.removeAllParameters();
        call.clearHeaders();
        URL transportUrl = this.wsifPort.getEndPoint();
        try {
            String transportUrlString = (String)this.getContext().getObjectPart("transport.url");
            if (transportUrlString != null) {
                transportUrl = new URL(transportUrlString);
                this.getTransport().setUrl(transportUrlString);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        call.setTargetEndpointAddress(transportUrl);
        if (this.inputSOAPParts == null) {
            this.prepare(call);
        }
        if ((s = this.getSoapActionURI()) != null && s.length() > 0) {
            call.setSOAPActionURI(s);
            call.setUseSOAPAction(true);
        }
        this.operationStyle = this.getOperationStyle(inMsg);
        Transport soaptransport = this.getTransport();
        WSIFJMSDestination dest = null;
        if (soaptransport != null) {
            call.setTransport(soaptransport);
            if (soaptransport instanceof WSIFJmsTransport) {
                WSIFJmsTransport jmst = (WSIFJmsTransport)soaptransport;
                dest = jmst.getDestination();
                dest.setAsyncMode(this.isAsyncOperation());
                dest.setOneWayMode(this.isOneWayOperation());
                jmst.setSyncTimeout(null);
                jmst.setAsyncTimeout(null);
            }
        }
        if (dest != null && this.inJmsPropVals != null && !this.inJmsPropVals.isEmpty()) {
            this.checkForTimeoutProperties(this.inJmsPropVals, dest);
            dest.setProperties(this.inJmsPropVals);
        }
        this.setDestinationContext(dest);
        this.setCallContext(call);
        workedOK = "message".equals(this.operationStyle) ? this.invokeSOAPMessaging(call, inMsg, outMsg, faultMsg) : ("rpc".equals(this.operationStyle) ? this.invokeSOAPRPCStyle(call, inMsg, outMsg, faultMsg, dest) : ("lazyParse".equals(this.operationStyle) ? this.invokeSOAPLazyParse(call, inMsg, outMsg, faultMsg) : this.invokeSOAPDocStyle(call, inMsg, outMsg, faultMsg)));
        if (!this.isOneWayOperation()) {
            this.setResponseContext(call);
        }
        Trc.exit(workedOK);
        return workedOK;
    }

    protected String getOperationStyle(WSIFMessage msg) {
        String style;
        block7: {
            style = this.operationStyle;
            try {
                Object part;
                Iterator i = msg.getPartNames();
                if (i.hasNext() && (part = msg.getObjectPart((String)i.next())) instanceof com.ibm.ws.webservices.engine.xmlsoap.SOAPBody) {
                    style = "lazyParse";
                    return style;
                }
                WSIFMessage context = this.getContext();
                style = (String)context.getObjectPart("org.apache.wsif.axis.operationStyle");
            }
            catch (WSIFException e) {
                Trc.ignoredException(e);
                if ("document".equals(this.operationStyle) && this.isInputMessageUnWrapped(msg)) {
                    style = "wrapped";
                }
                if (this.isMessaging(msg)) {
                    style = "message";
                    break block7;
                }
                String partName = null;
                Object part = null;
                try {
                    partName = (String)this.getContext().getObjectPart("wsif.operationStyle.message.element_part_name");
                    part = msg.getObjectPart(partName);
                    if (part == null) break block7;
                    style = "message";
                }
                catch (WSIFException ex) {
                    Trc.ignoredException(ex);
                }
            }
        }
        return style;
    }

    private boolean isInputMessageUnWrapped(WSIFMessage msg) {
        boolean unWrapped = true;
        Object style = null;
        try {
            WSIFMessage context = this.getContext();
            style = context.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException e) {
            Trc.ignoredException(e);
        }
        if ("wrapped".equals(style)) {
            unWrapped = true;
        } else if ("unwrapped".equals(style)) {
            unWrapped = false;
        } else if (this.inputUnwrappedSOAPParts != null && this.inputUnwrappedSOAPParts.size() > 0) {
            unWrapped = true;
            Iterator i = this.inputUnwrappedSOAPParts.iterator();
            while (i.hasNext() && unWrapped) {
                Part p = (Part)i.next();
                try {
                    msg.getObjectPart(p.getName());
                }
                catch (WSIFException e) {
                    unWrapped = false;
                }
            }
        } else {
            unWrapped = false;
        }
        return unWrapped;
    }

    private boolean isMessaging(WSIFMessage msg) {
        boolean allDOMElements = true;
        boolean anyDOMElements = false;
        if (msg != null) {
            Iterator i = this.inputSOAPParts.iterator();
            while (i.hasNext()) {
                Part p = (Part)i.next();
                try {
                    Object o = msg.getObjectPart(p.getName());
                    if (o instanceof Element) {
                        anyDOMElements = true;
                        continue;
                    }
                    allDOMElements = false;
                }
                catch (WSIFException e) {
                    Trc.ignoredException(e);
                }
            }
        }
        return anyDOMElements && allDOMElements;
    }

    private boolean invokeSOAPLazyParse(Call call, WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        Iterator i;
        SOAPEnvelope outEnv;
        SOAPEnvelope inEnv;
        boolean workedOK;
        block18: {
            workedOK = true;
            inEnv = null;
            outEnv = null;
            List attachments = this.addReferencedAttachments(inMsg, call);
            this.addUnreferencedAttachments(inMsg, call);
            try {
                inEnv = ((SOAPFactory)SOAPFactory.newInstance()).createSOAPEnvelope();
                WSIFMessage contextMsg = this.getContext();
                if (contextMsg != null) {
                    Hashtable namespaces = (Hashtable)contextMsg.getObjectPart("NamespaceScope");
                    if (namespaces != null) {
                        Iterator i2 = namespaces.keySet().iterator();
                        while (i2.hasNext()) {
                            String prefix = (String)i2.next();
                            String uri = (String)namespaces.get(prefix);
                            inEnv.addNamespaceDeclaration(prefix, uri);
                        }
                    }
                    try {
                        String requestType = (String)contextMsg.getObjectPart("com.ibm.wsgw.channels.soaphttp.ProxyOperationMode");
                        if (requestType.equals("requestresponse")) {
                            call.setReturnQName(new QName("local", "lazyParse"));
                        }
                    }
                    catch (Exception ignored) {
                        Trc.ignoredException(ignored);
                    }
                }
                if (!(i = inMsg.getPartNames()).hasNext()) break block18;
                Object part = inMsg.getObjectPart((String)i.next());
                if (part instanceof com.ibm.ws.webservices.engine.xmlsoap.SOAPBody) {
                    com.ibm.ws.webservices.engine.xmlsoap.SOAPBody soapBody = (com.ibm.ws.webservices.engine.xmlsoap.SOAPBody)part;
                    inEnv.addChildElement((javax.xml.soap.SOAPElement)soapBody);
                    break block18;
                }
                throw new WSIFException("exception on SOAP invoke: invalid part for lazy parse operation");
            }
            catch (SOAPException se) {
                throw new WSIFException("exception on SOAP invoke: " + se.getLocalizedMessage());
            }
        }
        call.setOperationStyle("rpc");
        Trc.event(this, "Invoking SOAP call", call, inEnv);
        try {
            outEnv = call.invoke(inEnv);
        }
        catch (RemoteException ex) {
            Trc.exception(ex);
            try {
                if (ex instanceof WebServicesFault) {
                    WebServicesFault f = (WebServicesFault)ex;
                    faultMsg.setName("org.apache.wsif.soap.fault");
                    faultMsg.setObjectPart("org.apache.wsif.soap.fault.object", (Object)f);
                }
                return false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            Hashtable<String, String> namespaces = new Hashtable<String, String>();
            i = outEnv.getNamespacePrefixes();
            while (i.hasNext()) {
                String prefix = (String)i.next();
                String uri = outEnv.getNamespaceURI(prefix);
                namespaces.put(prefix, uri);
            }
            this.context.setObjectPart("ResponseNamespaceScope", namespaces);
            if (!this.oneWayOperation) {
                com.ibm.ws.webservices.engine.xmlsoap.SOAPBody outBody = (com.ibm.ws.webservices.engine.xmlsoap.SOAPBody)outEnv.getBody();
                outMsg.setObjectPart(outBody.getLocalPart(), outBody);
            }
        }
        catch (SOAPException e) {
            throw new WSIFException("exception on SOAP invoke: " + e.getLocalizedMessage());
        }
        return workedOK;
    }

    private boolean invokeSOAPRPCStyle(Call call, WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg, WSIFJMSDestination dest) throws WSIFException {
        QName opName = new QName(this.getInputNamespace(), this.portTypeOperation.getName());
        call.setOperationName(opName);
        this.setCallParameterNames(call);
        call.setOperationUse(this.getInputUse());
        Object[] inputValues = this.getInputMessageValues(inMsg, dest);
        this.addUnreferencedAttachments(inMsg, call);
        Object response = null;
        boolean respOK = true;
        try {
            String name = this.portTypeOperation.getName();
            Trc.event(this, "Invoking operation ", name, " input namespace ", this.getInputNamespace(), " parameters ", inputValues, " call object ", call);
            if (this.isOneWayOperation()) {
                Trc.event(this, "invoke One Way");
                call.invokeOneWay(inputValues);
                response = null;
            } else {
                response = call.invoke(opName, inputValues);
            }
        }
        catch (RemoteException e) {
            Trc.exception(e);
            response = e;
            respOK = false;
        }
        Trc.event(this, "Returned from operation, response ", response);
        if (!(this.isAsyncOperation() || this.isOneWayOperation() || this.outputSOAPParts.size() <= 0 && this.outputMIMEParts.size() <= 0)) {
            Map callParams = call.getOutputParams();
            if (callParams != null) {
                HashMap outParams = new HashMap();
                Iterator i = callParams.keySet().iterator();
                while (i.hasNext()) {
                    QName qn = (QName)i.next();
                    outParams.put(qn.getLocalPart(), callParams.get(qn));
                }
                this.setResponseMessageParameters(outParams);
            }
            respOK = this.buildResponseMessages(response, outMsg, faultMsg);
        }
        return respOK;
    }

    private void setCallParameterNames(Call call) throws WSIFException {
        int startMIMEIndex;
        Part p;
        QName type;
        QName name;
        boolean wrappedStyleOp = ProviderUtils.isUnwrapable(this.getPortTypeOperation());
        String inputNamespace = "literal".equals(this.getInputUse()) && !wrappedStyleOp ? "" : this.getInputNamespace();
        String outputNamespace = "";
        List soapParts = "wrapped".equals(this.operationStyle) ? this.inputUnwrappedSOAPParts : this.inputSOAPParts;
        if (this.inputMIMEParts.isEmpty()) {
            int i = 0;
            while (i < soapParts.size()) {
                Part p2 = (Part)soapParts.get(i);
                String partName = p2.getName();
                if (!this.inJmsProps.containsKey(partName)) {
                    QName qn;
                    if ("document".equals(this.operationStyle) && (qn = p2.getElementName()) != null) {
                        partName = qn.getLocalPart();
                    }
                    name = new QName(inputNamespace, partName);
                    type = this.getPartType(p2);
                    call.addParameter(name, type, ParameterMode.IN);
                }
                ++i;
            }
        } else {
            List order = this.portTypeOperation.getInput().getMessage().getOrderedParts(null);
            Iterator it = order.iterator();
            while (it.hasNext()) {
                p = (Part)it.next();
                if (!this.inputMIMEParts.contains(p) && !soapParts.contains(p)) continue;
                name = new QName(inputNamespace, p.getName());
                type = this.getPartType(p);
                call.addParameter(name, type, ParameterMode.IN);
            }
        }
        soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts;
        Part returnPart = null;
        if (soapParts.size() > 0) {
            returnPart = (Part)soapParts.get(0);
        } else if (this.outputMIMEParts.size() > 0) {
            returnPart = (Part)this.outputMIMEParts.get(0);
        }
        if (!this.isOneWayOperation()) {
            if (returnPart == null) {
                call.setReturnType(Constants.WEBSERVICES_VOID);
            } else {
                QName type2 = this.getPartType(returnPart);
                call.setReturnType(type2);
            }
        }
        int i = 1;
        while (i < soapParts.size()) {
            p = (Part)soapParts.get(i);
            name = new QName(outputNamespace, p.getName());
            type = this.getPartType(p);
            call.addParameter(name, type, ParameterMode.OUT);
            ++i;
        }
        int i2 = startMIMEIndex = soapParts.size() > 0 ? 0 : 1;
        while (i2 < this.outputMIMEParts.size()) {
            Part p3 = (Part)this.outputMIMEParts.get(i2);
            QName name2 = new QName(outputNamespace, p3.getName());
            QName type3 = this.getPartType(p3);
            call.addParameter(name2, type3, ParameterMode.OUT);
            ++i2;
        }
    }

    private boolean invokeSOAPDocStyle(Call call, WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        List soapParts;
        Object response;
        boolean respOK = false;
        call.setOperationName(new QName(this.wsifPort.getPortTypeNamespace(), this.portTypeOperation.getName()));
        call.setProperty("send_type_attr", (Object)Boolean.FALSE);
        call.setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        call.setOperationStyle(this.operationStyle);
        call.setOperationUse(this.getInputUse());
        this.setCallParameterNames(call);
        Object[] inputValues = this.getInputMessageValues(inMsg, null);
        this.addUnreferencedAttachments(inMsg, call);
        Trc.event(this, "Invoking SOAP call ", call, inputValues);
        try {
            if (this.isOneWayOperation()) {
                Trc.event(this, "invoke One Way");
                call.invokeOneWay(inputValues);
                response = null;
            } else {
                response = call.invoke(inputValues);
            }
            respOK = true;
        }
        catch (RemoteException ex) {
            Trc.exception(ex);
            response = ex;
            respOK = false;
        }
        Trc.event(this, "Returned from SOAP invoke, response: ", response);
        if (!(this.isAsyncOperation() || this.isOneWayOperation() || (soapParts = "wrapped".equals(this.operationStyle) ? this.outputUnwrappedSOAPParts : this.outputSOAPParts).size() <= 0 && this.outputMIMEParts.size() <= 0)) {
            Map callParams = call.getOutputParams();
            if (callParams != null) {
                HashMap outParams = new HashMap();
                Iterator i = callParams.keySet().iterator();
                while (i.hasNext()) {
                    QName qn = (QName)i.next();
                    outParams.put(qn.getLocalPart(), callParams.get(qn));
                }
                this.setResponseMessageParameters(outParams);
            }
            respOK = this.buildResponseMessages(response, outMsg, faultMsg);
        }
        return respOK;
    }

    private void setFaults(Call call) {
        Trc.entry((Object)this, call);
        Operation operation = this.getOperation();
        Map faults = operation.getFaults();
        if (faults.isEmpty()) {
            Trc.exit();
            return;
        }
        Set faultNamesSet = faults.keySet();
        Iterator it = faultNamesSet.iterator();
        while (it.hasNext()) {
            Object faultKey = it.next();
            Fault fault = (Fault)faults.get(faultKey);
            QName[] qNames = this.getQNamesFromFault(fault);
            if (qNames == null) {
                Trc.event(this, "nothing found in fault, trying next fault");
                continue;
            }
            QName faultCode = qNames[0];
            QName messageQName = qNames[1];
            QName partQName = qNames[2];
            QName partXmlType = qNames[3];
            Class className = this.typeMap.getClassForXmlType(partXmlType);
            if (className == null) {
                Trc.event(this, "classname not found for xml type" + partXmlType + ", trying next fault");
                continue;
            }
            Trc.event(this, "calling addFault with ", faultCode, className, messageQName, partXmlType, partQName);
            call.addFault(faultCode, className, messageQName, partXmlType, partQName);
        }
        Trc.exit(call);
    }

    private QName[] getQNamesFromFault(Fault fault) {
        Trc.entry((Object)this, fault);
        javax.wsdl.Message faultMessage = fault.getMessage();
        if (faultMessage == null) {
            Trc.exit(null);
            return null;
        }
        QName messageQName = faultMessage.getQName();
        Map partsMap = faultMessage.getParts();
        if (partsMap.size() == 0) {
            Trc.exit(null);
            return null;
        }
        if (partsMap.size() > 1) {
            Trc.event(this, "Warning: more than 1 part found in fault message. Only 1st part will be used (see WSDL 1.1)");
        }
        Set faultPartsSet = partsMap.keySet();
        Iterator partsIt = faultPartsSet.iterator();
        Object partKey = partsIt.next();
        Part faultPart = (Part)partsMap.get(partKey);
        boolean hasElement = false;
        QName partElementQName = faultPart.getElementName();
        if (partElementQName != null) {
            hasElement = true;
        }
        QName faultCode = null;
        QName partQName = null;
        QName partXmlType = null;
        QName partName = new QName(faultPart.getName());
        if (!hasElement) {
            partXmlType = faultPart.getTypeName();
            faultCode = messageQName;
            partQName = partXmlType;
        } else {
            partXmlType = partElementQName;
            faultCode = partElementQName;
            partQName = partElementQName;
        }
        QName[] returnArray = new QName[]{faultCode, messageQName, partQName, partXmlType, partName};
        if (Trc.isTraceEnabled()) {
            Trc.exit(faultCode + "," + messageQName + "," + partQName + "," + partXmlType + "," + partName);
        }
        return returnArray;
    }

    private boolean invokeSOAPMessaging(Call call, WSIFMessage inMsg, WSIFMessage outMsg, WSIFMessage faultMsg) throws WSIFException {
        Object soapResponse;
        boolean workedOK;
        block17: {
            workedOK = false;
            List attachments = this.addReferencedAttachments(inMsg, call);
            this.addUnreferencedAttachments(inMsg, call);
            ArrayList<SOAPBodyElement> soapBodies = new ArrayList<SOAPBodyElement>();
            try {
                SOAPFactory f = (SOAPFactory)SOAPFactory.newInstance();
                Object[] inputValues = this.getInputMessageValues(inMsg, null);
                int i = 0;
                while (i < inputValues.length) {
                    Element el;
                    if (inputValues[i] instanceof Element) {
                        el = (Element)inputValues[i];
                        if (attachments.size() > 0 && i == 0) {
                            this.fixAttachmentPartsCID(el, attachments);
                        }
                    } else {
                        throw new WSIFException("unexpected input type: " + inputValues[i]);
                    }
                    SOAPBodyElement sbe = f.createSOAPBodyElement("", "");
                    sbe.setAlternateContent((Object)el);
                    soapBodies.add(sbe);
                    ++i;
                }
            }
            catch (SOAPException e) {
                // empty catch block
            }
            call.setOperationStyle(this.operationStyle);
            call.setOperationName(new QName(this.wsifPort.getPortTypeNamespace(), this.portTypeOperation.getName()));
            SOAPBodyElement[] soapInputs = soapBodies.toArray(new SOAPBodyElement[0]);
            MessageContext msgContext = call.getMessageContext();
            if (msgContext != null) {
                msgContext.setHighFidelity(true);
            } else {
                Trc.event(this, "Call message context is null");
            }
            Trc.event(this, "Invoking SOAP call ", call, soapInputs);
            try {
                if (this.isOneWayOperation()) {
                    call.setReturnType(null);
                    Trc.event(this, "invoke One Way");
                    try {
                        call.invokeOneWay(soapInputs);
                    }
                    catch (JAXRPCException exc) {
                        Trc.ignoredException(exc);
                    }
                    soapResponse = null;
                    break block17;
                }
                soapResponse = call.invoke(soapInputs);
            }
            catch (RemoteException ex) {
                Trc.exception(ex);
                soapResponse = ex;
                try {
                    if (ex instanceof WebServicesFault) {
                        WebServicesFault f = (WebServicesFault)ex;
                        faultMsg.setName("org.apache.wsif.soap.fault");
                        faultMsg.setObjectPart("org.apache.wsif.soap.fault.object", (Object)f);
                    }
                    return false;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        Trc.event(this, "Returned from SOAP invoke, response: ", soapResponse);
        if (!this.isOneWayOperation()) {
            this.setOutputMessageValues(soapResponse, outMsg);
        }
        workedOK = true;
        return workedOK;
    }

    private void fixAttachmentPartsCID(Element body, List attachments) throws WSIFException {
        ArrayList al = new ArrayList();
        WSIFOperation_SOAP.getAttachmentElements(al, body);
        if (al.size() != attachments.size()) {
            throw new WSIFException("unexpected number of attachments," + attachments.size() + " AttachmentParts, " + al.size() + " attachment href elements");
        }
        int i = 0;
        while (i < attachments.size()) {
            AttachmentPart attachment = (AttachmentPart)attachments.get(i);
            Element attachmentElement = (Element)al.get(i);
            attachmentElement.setAttribute("href", "cid:" + attachment.getContentId());
            ++i;
        }
    }

    private static void getAttachmentElements(ArrayList al, Element el) {
        NodeList childNodes = el.getChildNodes();
        int j = 0;
        while (j < childNodes.getLength()) {
            Node n = childNodes.item(j);
            if (n instanceof Element) {
                Element childElement = (Element)n;
                String s = childElement.getAttribute("href");
                if (s != null && s.toLowerCase().startsWith("cid:")) {
                    al.add(childElement);
                } else {
                    WSIFOperation_SOAP.getAttachmentElements(al, childElement);
                }
            }
            ++j;
        }
    }

    private void prepare(Call call) throws WSIFException {
        Trc.entry((Object)this, call);
        this.inputSOAPParts = new ArrayList();
        this.inputMIMEParts = new ArrayList();
        this.outputSOAPParts = new ArrayList();
        this.outputMIMEParts = new ArrayList();
        this.parseSoapOperation();
        this.parseBindingInput();
        this.parseBindingOutput();
        this.unwrapSOAPParts();
        this.addInputJmsPropertyValues(this.wsifPort.getJmsAddressPropVals());
        if (!"rpc".equals(this.operationStyle)) {
            call.setEncodingStyle(null);
            this.inputEncodingStyle = "";
            this.outputEncodingStyle = "";
        }
        if (this.inputNamespace == null || this.inputNamespace.length() < 1) {
            this.inputNamespace = this.getTargetNamespaceURI();
        }
        Service s = call.getService();
        TypeMapping tm = WSIFOperation_SOAP.getTypeMapping(s, "http://schemas.xmlsoap.org/soap/encoding/");
        WSIFMessage context = this.getContext();
        WSIFOperation_SOAP.registerDefaultTypeMappings((javax.xml.rpc.encoding.TypeMapping)tm, context);
        WSIFOperation_SOAP.registerDynamicTypes((javax.xml.rpc.encoding.TypeMapping)tm, this.typeMap, context, this.usingJROM);
        this.registerMIMETypes(this.inputMIMEParts, call);
        this.registerMIMETypes(this.outputMIMEParts, call);
        this.setFaults(call);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    static TypeMapping getTypeMapping(Service service, String encoding) {
        TypeMappingRegistry tmr = service.getEngine().getTypeMappingRegistry();
        TypeMapping tm = (TypeMapping)tmr.getTypeMapping(encoding);
        TypeMapping defaultTM = (TypeMapping)tmr.getDefaultTypeMapping();
        if (tm == null || tm == defaultTM) {
            tm = (TypeMapping)tmr.createTypeMapping();
            tm.setSupportedEncodings(new String[]{encoding, ""});
            tmr.register(encoding, (javax.xml.rpc.encoding.TypeMapping)tm);
            tmr.register("", (javax.xml.rpc.encoding.TypeMapping)tm);
        }
        return tm;
    }

    static void registerDefaultTypeMappings(javax.xml.rpc.encoding.TypeMapping callTypeMappings, WSIFMessage context) throws WSIFException {
        Object value = null;
        try {
            value = context.getObjectPart("org.apache.wsif.soap.default.type.serializers");
        }
        catch (WSIFException e) {
            Trc.ignoredException(e);
        }
        if (value == null) {
            return;
        }
        if (!(value instanceof List)) {
            throw new WSIFException("context part 'org.apache.wsif.soap.default.type.serializers' value is not an instance of java.util.List: " + value);
        }
        List defaultMappings = (List)value;
        Iterator i = defaultMappings.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof TypeSerializerInfo)) {
                throw new WSIFException("context part 'org.apache.wsif.soap.default.type.serializers' value List contains an entry that is not an instance of org.apache.wsif.util.TypeSerializer: " + value);
            }
            TypeSerializerInfo ts = (TypeSerializerInfo)o;
            Class javaType = ts.getJavaType();
            QName elementType = ts.getElementType();
            Object tmp = ts.getSerializer();
            SerializerFactory sf = null;
            if (tmp instanceof SerializerFactory) {
                sf = (SerializerFactory)tmp;
            } else if (tmp instanceof Class) {
                sf = (SerializerFactory)WSIFOperation_SOAP.instantiateDSF((Class)tmp, javaType, elementType);
            }
            tmp = ts.getDeserializer();
            DeserializerFactory df = null;
            if (tmp instanceof DeserializerFactory) {
                df = (DeserializerFactory)tmp;
            } else if (tmp instanceof Class) {
                df = (DeserializerFactory)WSIFOperation_SOAP.instantiateDSF((Class)tmp, javaType, elementType);
            }
            if (javaType != null && elementType != null && (sf != null || df != null)) {
                callTypeMappings.register(javaType, elementType, (javax.xml.rpc.encoding.SerializerFactory)sf, (javax.xml.rpc.encoding.DeserializerFactory)df);
                continue;
            }
            Trc.event(null, "ignoring default TypeSerializer invalid for SOAP:" + ts);
        }
    }

    static Object instantiateDSF(Class factoryClass, Class javaType, QName elementType) {
        final Class factoryClassFin = factoryClass;
        Method createMethod = null;
        try {
            createMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NoSuchMethodException {
                    return factoryClassFin.getMethod("create", class$java$lang$Class == null ? (class$java$lang$Class = WSIFOperation_SOAP.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = WSIFOperation_SOAP.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                }
            });
            Object result = createMethod.invoke(null, javaType, elementType);
            return result;
        }
        catch (Exception ignored) {
            Trc.ignoredException(ignored);
            Constructor ctor = null;
            try {
                ctor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NoSuchMethodException {
                        return factoryClassFin.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = WSIFOperation_SOAP.class$("java.lang.Class")) : class$java$lang$Class, class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = WSIFOperation_SOAP.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
                    }
                });
                Object result = ctor.newInstance(javaType, elementType);
                return result;
            }
            catch (Exception ignored2) {
                Trc.ignoredException(ignored2);
                try {
                    Object result = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IllegalAccessException, InstantiationException {
                            return factoryClassFin.newInstance();
                        }
                    });
                    return result;
                }
                catch (Exception ignored3) {
                    Trc.ignoredException(ignored3);
                    return null;
                }
            }
        }
    }

    static void registerDynamicTypes(javax.xml.rpc.encoding.TypeMapping tm, WSIFDynamicTypeMap typeMap, WSIFMessage context, boolean usingJROM) throws WSIFException {
        Iterator iterator = typeMap.iterator();
        while (iterator.hasNext()) {
            WSIFDynamicTypeMapping wsifdynamictypemapping = (WSIFDynamicTypeMapping)iterator.next();
            Class objClass = wsifdynamictypemapping.getJavaType();
            QName xmlType = wsifdynamictypemapping.getXmlType();
            String namespaceURI = wsifdynamictypemapping.getXmlType().getNamespaceURI();
            if (WSIFOperation_SOAP.isDefaultSOAPNamespace(namespaceURI) && !usingJROM) continue;
            Object sf = null;
            Object df = null;
            TypeSerializerInfo contextTypeSerializer = WSIFOperation_SOAP.findContextTypeSerialzer(context, objClass, xmlType);
            if (contextTypeSerializer != null) {
                objClass = contextTypeSerializer.getJavaType();
                xmlType = contextTypeSerializer.getElementType();
                sf = (SerializerFactory)contextTypeSerializer.getSerializer();
                df = (DeserializerFactory)contextTypeSerializer.getDeserializer();
            } else if (usingJROM) {
                JROMUtils.registerJROMComplexType((javax.xml.rpc.encoding.TypeMapping)((TypeMapping)tm), xmlType, objClass);
            } else {
                if (sf == null && tm.getSerializer(objClass, xmlType) == null) {
                    sf = objClass.isArray() ? new ArraySerializerFactory(objClass, xmlType) : ((class$com$ibm$ws$webservices$engine$encoding$SimpleType == null ? WSIFOperation_SOAP.class$("com.ibm.ws.webservices.engine.encoding.SimpleType") : class$com$ibm$ws$webservices$engine$encoding$SimpleType).isAssignableFrom(objClass) ? new SimpleSerializerFactory(objClass, xmlType) : new BeanSerializerFactory(objClass, xmlType));
                }
                if (df == null && tm.getDeserializer(objClass, xmlType) == null) {
                    df = objClass.isArray() ? new ArrayDeserializerFactory(objClass, xmlType) : ((class$com$ibm$ws$webservices$engine$encoding$SimpleType == null ? WSIFOperation_SOAP.class$("com.ibm.ws.webservices.engine.encoding.SimpleType") : class$com$ibm$ws$webservices$engine$encoding$SimpleType).isAssignableFrom(objClass) ? new SimpleDeserializerFactory(objClass, xmlType) : new BeanDeserializerFactory(objClass, xmlType));
                }
            }
            String localPart = wsifdynamictypemapping.getXmlType().getLocalPart();
            QName qn = new QName(namespaceURI, localPart);
            if (sf == null && df == null) continue;
            tm.register(objClass, qn, (javax.xml.rpc.encoding.SerializerFactory)sf, (javax.xml.rpc.encoding.DeserializerFactory)df);
        }
    }

    private static TypeSerializerInfo findContextTypeSerialzer(WSIFMessage context, Class clazz, QName xmlType) throws WSIFException {
        Object value = null;
        try {
            value = context.getObjectPart("org.apache.wsif.soap.type.serializers");
        }
        catch (WSIFException e) {
            Trc.ignoredException(e);
        }
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            throw new WSIFException("context part 'org.apache.wsif.soap.type.serializers' value is not an instance of java.util.List: " + value);
        }
        List typeSerializers = (List)value;
        Iterator i = typeSerializers.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof TypeSerializerInfo)) {
                throw new WSIFException("context part 'org.apache.wsif.soap.type.serializers' value List contains an entry that is not an instance of org.apache.wsif.util.TypeSerializer: " + value);
            }
            TypeSerializerInfo tm = (TypeSerializerInfo)o;
            Class javaType = tm.getJavaType();
            QName elementType = tm.getElementType();
            Object serializer = tm.getSerializer();
            Object deserializer = tm.getDeserializer();
            if (javaType == null && (!javaType.isAssignableFrom(clazz) || elementType == null && !elementType.equals(xmlType)) || !(serializer == null || serializer instanceof SerializerFactory && deserializer == null || deserializer instanceof DeserializerFactory && serializer != null) && deserializer == null) continue;
            return tm;
        }
        return null;
    }

    private static boolean isDefaultSOAPNamespace(String ns) {
        boolean soapNamespace = false;
        if ("http://www.w3.org/1999/XMLSchema".equals(ns) || "http://www.w3.org/2000/10/XMLSchema".equals(ns) || "http://www.w3.org/2001/XMLSchema".equals(ns) || "http://schemas.xmlsoap.org/soap/encoding/".equals(ns) || "http://www.w3.org/2002/06/soap-encoding".equals(ns)) {
            soapNamespace = true;
        }
        return soapNamespace;
    }

    private Object[] getInputMessageValues(WSIFMessage inMsg, WSIFJMSDestination dest) throws WSIFException {
        ArrayList<Object> soapInputs = new ArrayList<Object>();
        List soapParts = "wrapped".equals(this.operationStyle) ? this.inputUnwrappedSOAPParts : this.inputSOAPParts;
        if ("message".equals(this.operationStyle)) {
            try {
                String partName = (String)this.getContext().getObjectPart("wsif.operationStyle.message.element_part_name");
                Object part = inMsg.getObjectPart(partName);
                if (part != null) {
                    soapInputs.add(part);
                    return soapInputs.toArray();
                }
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
        if (this.inputMIMEParts.isEmpty()) {
            int i = 0;
            while (i < soapParts.size()) {
                Object value;
                Part p = (Part)soapParts.get(i);
                String partName = p.getName();
                try {
                    value = inMsg.getObjectPart(partName);
                }
                catch (WSIFException e) {
                    Trc.ignoredException(e);
                    value = null;
                }
                if (this.inJmsProps.containsKey(partName) && dest != null) {
                    String name = (String)this.inJmsProps.get(partName);
                    if (!this.timeoutProperty(dest, name, value)) {
                        dest.setProperty(name, value);
                    }
                } else {
                    soapInputs.add(value);
                }
                ++i;
            }
        } else {
            List order = this.portTypeOperation.getInput().getMessage().getOrderedParts(null);
            Iterator it = order.iterator();
            while (it.hasNext()) {
                Object value;
                Part p = (Part)it.next();
                String partName = p.getName();
                if (!soapParts.contains(p) && (!this.inputMIMEParts.contains(p) || "message".equals(this.operationStyle))) continue;
                try {
                    value = inMsg.getObjectPart(partName);
                }
                catch (WSIFException e) {
                    Trc.ignoredException(e);
                    value = null;
                }
                if (this.inJmsProps.containsKey(partName) && dest != null) {
                    String name = (String)this.inJmsProps.get(partName);
                    if (this.timeoutProperty(dest, name, value)) continue;
                    dest.setProperty(name, value);
                    continue;
                }
                if (value instanceof WSIFAttachmentPart) {
                    WSIFAttachmentPart ap = (WSIFAttachmentPart)value;
                    soapInputs.add(ap.getDataHandler());
                    continue;
                }
                soapInputs.add(value);
            }
        }
        return soapInputs.toArray();
    }

    private List addReferencedAttachments(WSIFMessage inMsg, Call call) throws WSIFException {
        Trc.entry(this, inMsg, call);
        ArrayList<AttachmentPart> attachments = new ArrayList<AttachmentPart>();
        int i = 0;
        while (i < this.inputMIMEParts.size()) {
            Part p = (Part)this.inputMIMEParts.get(i);
            try {
                String partName = p.getName();
                Object value = inMsg.getObjectPart(partName);
                AttachmentPart ap = MIMEHelper.getAttachementPart(value);
                call.addAttachmentPart((Object)ap);
                attachments.add(ap);
            }
            catch (WSIFException e) {
                throw new WSIFException("attachment part '" + p.getName() + "' not in input WSIFMessage");
            }
            ++i;
        }
        Trc.exit(attachments);
        return attachments;
    }

    private void addUnreferencedAttachments(WSIFMessage inMsg, Call call) throws WSIFException {
        Trc.entry(this, inMsg, call);
        if (WSIFProperties.areUnreferencedAttachmentsSupported()) {
            List l = null;
            try {
                WSIFMessage context = this.getContext();
                if (context != null) {
                    l = (List)context.getObjectPart("org.apache.wsif.attachments.request.unreferenced_attachment_parts");
                }
            }
            catch (Exception e) {
                Trc.ignoredException(e);
            }
            if (l != null && !l.isEmpty()) {
                ListIterator it = l.listIterator();
                while (it.hasNext()) {
                    Object next = it.next();
                    AttachmentPart ap = MIMEHelper.getAttachementPart(next);
                    call.addAttachmentPart((Object)ap);
                }
            }
        }
        Trc.exit();
    }

    private void setOutputMessageValues(Object soapResponse, WSIFMessage outMsg) throws WSIFException {
        Trc.entry(this, soapResponse, outMsg);
        if (!(soapResponse instanceof List)) {
            throw new WSIFException("expect response type of java.util.List of SOAPBodyElement, found: " + soapResponse);
        }
        List al = (List)soapResponse;
        Iterator i = al.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof SOAPBodyElement) {
                Element e;
                SOAPBodyElement sbe = (SOAPBodyElement)o;
                try {
                    e = sbe.getAsDOM();
                }
                catch (Exception ex) {
                    throw new WSIFException("excpetion extracting DOM Element from response" + ex.getLocalizedMessage(), ex);
                }
                outMsg.setName(e.getLocalName());
                QName qn = new QName(e.getNamespaceURI(), e.getLocalName());
                Part p = this.findPart(this.outputSOAPParts, qn);
                if (p != null) {
                    outMsg.setObjectPart(p.getName(), e);
                    continue;
                }
                if (!this.wsifPort.getBindingStyle().equals("rpc")) continue;
                this.context.setObjectPart("org.apache.wsif.soap.top.level.element.qname", qn);
                Iterator it = sbe.getChildElements();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof SOAPElement)) continue;
                    SOAPElement se = (SOAPElement)obj;
                    try {
                        e = se.getAsDOM();
                    }
                    catch (Exception ex) {
                        throw new WSIFException("exception extracting DOM Element from response child" + ex.getLocalizedMessage(), ex);
                    }
                    qn = new QName(e.getNamespaceURI(), e.getLocalName());
                    p = this.findPart(this.outputSOAPParts, qn);
                    if (p == null) continue;
                    outMsg.setObjectPart(p.getName(), e);
                }
                continue;
            }
            throw new WSIFException("expecting response type of SOAPBodyElement, found: " + o);
        }
        Trc.exit(outMsg);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAttachmentPart(WSIFMessage outMsg, RequestResponse rr) throws WSIFException {
        Vector params;
        try {
            params = rr.getParams();
        }
        catch (SAXException e) {
            throw new WSIFException("SAXException getting response MIME part: " + e.getLocalizedMessage(), e);
        }
        if (params == null || params.size() < 1) {
            throw new WSIFException("no attachments found in response element: " + rr);
        }
        ParamValue rpcParam = (ParamValue)params.get(0);
        QName qn = rpcParam.getQName();
        Part p = this.findPart(this.outputMIMEParts, qn);
        if (p == null) throw new WSIFException("cannot find a WSDL output MIME part for response element: " + rr);
        Object responseValue = rpcParam.getValue();
        if (!(responseValue instanceof AttachmentPart)) throw new WSIFException("expecting response AttachmentPart but found: " + responseValue);
        try {
            DataHandler attachment = ((AttachmentPart)responseValue).getDataHandler();
            String partName = p.getName();
            outMsg.setObjectPart(partName, attachment);
            return;
        }
        catch (SOAPException e) {
            throw new WSIFException("SOAPException getting DataHandler from AttachmentPart: " + e.getLocalizedMessage(), e);
        }
    }

    private Part findPart(List partsList, QName partName) {
        Trc.entry(this, partsList, partName);
        Part part = null;
        Iterator i = partsList.iterator();
        while (i.hasNext() && part == null) {
            Part p = (Part)i.next();
            if (partName.equals(p.getElementName())) {
                part = p;
                continue;
            }
            if (!partName.getLocalPart().equals(p.getName())) continue;
            part = p;
        }
        Trc.exit(part);
        return part;
    }

    private void registerMIMETypes(List mimeParts, Call call) {
        if (mimeParts != null && !mimeParts.isEmpty()) {
            Iterator i = mimeParts.iterator();
            while (i.hasNext()) {
                Part p = (Part)i.next();
                QName type = this.getPartType(p);
                MIMEHelper.registerAttachmentType(call, type);
            }
        }
    }

    private void setResponseHandler(WSIFResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    WSIFResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setDefinition(Definition definition1) {
        Trc.entry((Object)this, definition1);
        throw new RuntimeException("method nolonger supported");
    }

    public void setDynamicWSIFPort(WSIFPort_SOAP wsifport_soap) {
        Trc.entry((Object)this, wsifport_soap);
        this.wsifPort = wsifport_soap;
        Trc.exit();
    }

    public void setInputEncodingStyle(String s) {
        Trc.entry((Object)this, s);
        this.inputEncodingStyle = s;
        Trc.exit();
    }

    public void setInputNamespace(String s) {
        Trc.entry((Object)this, s);
        this.inputNamespace = s;
        Trc.exit();
    }

    public void setOperation(Operation operation1) {
        Trc.entry((Object)this, operation1);
        this.portTypeOperation = operation1;
        Trc.exit();
    }

    public void setOutputEncodingStyle(String s) {
        Trc.entry((Object)this, s);
        this.outputEncodingStyle = s;
        Trc.exit();
    }

    public void setSoapActionURI(String s) {
        Trc.entry((Object)this, s);
        this.soapActionURI = s;
        Trc.exit();
    }

    private void setResponseMessageParameters(HashMap hm) {
        this.responseMessageParameters = hm;
    }

    private void setAsyncOperation(boolean b) {
        this.asyncOperation = b;
    }

    private void setOneWayOperation(boolean b) {
        this.oneWayOperation = b;
    }

    private boolean isOneWayOperation() {
        return this.oneWayOperation;
    }

    public String getTargetNamespaceURI() {
        Trc.entry(this);
        Definition d = this.getDefinition();
        String s = d == null ? "" : d.getTargetNamespace();
        Trc.exit(s);
        return s;
    }

    private void setJMSOutPropsInContext(WSIFJMSDestination dest) throws WSIFException {
        if (dest == null) {
            return;
        }
        HashMap props = dest.getProperties();
        if (props != null) {
            this.getContext().setParts(props);
        }
    }

    private void setDestinationContext(WSIFJMSDestination dest) throws WSIFException {
        if (dest == null) {
            return;
        }
        WSIFMessage context = this.getContext();
        HashMap<String, Object> jmsProps = new HashMap<String, Object>();
        Iterator i = context.getPartNames();
        while (i.hasNext()) {
            String partName = (String)i.next();
            try {
                Object value = context.getObjectPart(partName);
                if (this.timeoutProperty(dest, partName, value) || !partName.startsWith("JMSProperty.")) continue;
                String propertyName = partName.substring("JMSProperty.".length());
                jmsProps.put(propertyName, value);
            }
            catch (WSIFException ex) {
                Trc.ignoredException(ex);
            }
        }
        if (jmsProps.size() > 0) {
            dest.setProperties(jmsProps);
        }
    }

    private void setCallContext(Call call) throws WSIFException {
        Object o;
        WSIFMessage context = this.getContext();
        String name = "org.apache.wsif.http.UserName";
        try {
            o = context.getObjectPart(name);
            if (o instanceof String) {
                this.addHTTPHeader(call, name, (String)o);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        name = "org.apache.wsif.http.Password";
        try {
            o = context.getObjectPart(name);
            if (o instanceof String) {
                this.addHTTPHeader(call, name, (String)o);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        try {
            name = "org.apache.wsif.soap.RequestHeaders";
            o = context.getObjectPart(name);
            if (o instanceof List) {
                this.addSOAPHeader(call, (List)o);
            }
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        o = null;
        try {
            name = "org.apache.wsif.http.RequestHeaders";
            o = context.getObjectPart(name);
        }
        catch (WSIFException ex) {
            Trc.ignoredException(ex);
        }
        if (o != null) {
            if (o != null && o instanceof Hashtable) {
                call.setProperty("HTTP-Request-Headers", (Object)((Hashtable)o));
            } else {
                throw new WSIFException("value type must be java.util.Hashtable for context part 'org.apache.wsif.http.RequestHeaders'");
            }
        }
        this.setProxyUserFromContext(context);
        Iterator i = context.getPartNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = context.getObjectPart(key);
            call.setProperty(key, value);
        }
    }

    private void setProxyUserFromContext(WSIFMessage ctx) throws WSIFException {
        String pswd;
        String uid;
        block7: {
            uid = null;
            pswd = null;
            try {
                Object o = ctx.getObjectPart("org.apache.wsif.http.proxy.UserName");
                if (o != null) {
                    if (o instanceof String) {
                        uid = (String)o;
                    } else {
                        throw new WSIFException("invalid value type for context part 'org.apache.wsif.http.proxy.UserName', found value: " + o);
                    }
                }
                if ((o = ctx.getObjectPart("org.apache.wsif.http.proxy.Password")) == null) break block7;
                if (o instanceof String) {
                    pswd = (String)o;
                    break block7;
                }
                throw new WSIFException("invalid value type for context part 'org.apache.wsif.http.proxy.Password', found value: " + o);
            }
            catch (WSIFException e) {
                Trc.ignoredException(e);
            }
        }
        if (uid != null) {
            WebServicesProperties.setProperty((String)"http.proxyUser", uid);
            WebServicesProperties.setProperty((String)"http.proxyPassword", pswd);
        }
    }

    private void setResponseContext(Call call) throws WSIFException {
        Message m = call.getResponseMessage();
        if (m != null) {
            SOAPEnvelope env;
            try {
                env = m.getSOAPEnvelope();
            }
            catch (WebServicesFault e) {
                throw new WSIFException("WebServicesFault getting response SOAP envelope", e);
            }
            if (env != null) {
                SOAPHeader soapHeader;
                try {
                    soapHeader = env.getHeader();
                }
                catch (SOAPException e) {
                    throw new WSIFException("SOAPException getting response headers from SOAP envelope", e);
                }
                this.addContextResponseSOAPHeaders(soapHeader);
            }
        }
        Hashtable<String, Object> responseContextProperties = new Hashtable<String, Object>();
        MessageContext msgContext = call.getMessageContext();
        Iterator i = msgContext.getPropertyNames();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = msgContext.getProperty(key);
            if (value == null || !(value instanceof Serializable) && !(value instanceof Cloneable)) continue;
            responseContextProperties.put(key, value);
        }
        if (this.context != null) {
            this.context.setObjectPart("ResponseContextProperties", responseContextProperties);
        }
    }

    private void addSOAPHeader(Call call, List soapHeaders) throws WSIFException {
        SOAPFactory f;
        try {
            f = (SOAPFactory)SOAPFactory.newInstance();
        }
        catch (SOAPException e) {
            throw new WSIFException("SOAPException getting SOAPFactory", e);
        }
        Iterator i = soapHeaders.iterator();
        while (i.hasNext()) {
            SOAPHeaderElement she;
            Object o = i.next();
            if (!(o instanceof Element)) continue;
            try {
                she = f.createSOAPHeaderElement("", "");
                she.setAlternateContent((Object)((Element)o));
            }
            catch (SOAPException e) {
                throw new WSIFException("SOAPException creating SOAPHeader", e);
            }
            call.addHeader(she);
        }
    }

    private void addContextResponseSOAPHeaders(SOAPHeader soapHeader) throws WSIFException {
        if (soapHeader != null) {
            ArrayList<Element> headers = new ArrayList<Element>();
            Iterator i = soapHeader.getChildElements();
            while (i.hasNext()) {
                Object o = i.next();
                if (o instanceof SOAPHeaderElement) {
                    SOAPHeaderElement she = (SOAPHeaderElement)o;
                    try {
                        headers.add(she.getAsDOM());
                        continue;
                    }
                    catch (Exception e) {
                        throw new WSIFException("exception getting response SOAP header", e);
                    }
                }
                Trc.event("unexpected response SOAP header type: ", o);
            }
            if (headers.size() > 0) {
                WSIFMessage context = this.getContext();
                context.setObjectPart("org.apache.wsif.soap.ResponseHeaders", headers);
                this.setContext(context);
            }
        }
    }

    private void addHTTPHeader(Call call, String name, String value) {
        if (name.equals("org.apache.wsif.http.UserName")) {
            call.setProperty("javax.xml.rpc.security.auth.username", (Object)value);
        } else if (name.equals("org.apache.wsif.http.Password")) {
            call.setProperty("javax.xml.rpc.security.auth.password", (Object)value);
        }
    }

    private void checkForTimeoutProperties(HashMap inJmsPropVals, WSIFJMSDestination dest) throws WSIFException {
        Iterator i = inJmsPropVals.keySet().iterator();
        while (i.hasNext()) {
            Object value;
            String name = (String)i.next();
            if (!this.timeoutProperty(dest, name, value = inJmsPropVals.get(name))) continue;
            i.remove();
        }
    }

    private boolean timeoutProperty(WSIFJMSDestination dest, String propertyName, Object value) throws WSIFException {
        boolean isTimeoutProperty = false;
        try {
            if ("wsif.syncrequest.timeout".equals(propertyName)) {
                isTimeoutProperty = true;
                Long syncTimeout = new Long(value.toString());
                WSIFJmsTransport transport = (WSIFJmsTransport)this.getTransport();
                transport.setSyncTimeout(syncTimeout);
                Trc.event(this, "overridding syncTimeout to " + syncTimeout);
            } else if ("wsif.asyncrequest.timeout".equals(propertyName)) {
                isTimeoutProperty = true;
                Long asyncTimeout = new Long(value.toString());
                WSIFJmsTransport transport = (WSIFJmsTransport)this.getTransport();
                transport.setAsyncTimeout(asyncTimeout);
                Trc.event(this, "overridding asyncTimeout to " + asyncTimeout);
            }
        }
        catch (NumberFormatException ex) {
            Trc.ignoredException(ex);
        }
        return isTimeoutProperty;
    }

    private static boolean isPrimitiveOf(Class clazz, Class primitive) {
        return primitive.equals(Boolean.TYPE) && (class$java$lang$Boolean == null ? (class$java$lang$Boolean = WSIFOperation_SOAP.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(clazz) || primitive.equals(Character.TYPE) && (class$java$lang$Character == null ? (class$java$lang$Character = WSIFOperation_SOAP.class$("java.lang.Character")) : class$java$lang$Character).isAssignableFrom(clazz) || primitive.equals(Byte.TYPE) && (class$java$lang$Byte == null ? (class$java$lang$Byte = WSIFOperation_SOAP.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(clazz) || primitive.equals(Short.TYPE) && (class$java$lang$Short == null ? (class$java$lang$Short = WSIFOperation_SOAP.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(clazz) || primitive.equals(Integer.TYPE) && (class$java$lang$Integer == null ? (class$java$lang$Integer = WSIFOperation_SOAP.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(clazz) || primitive.equals(Long.TYPE) && (class$java$lang$Long == null ? (class$java$lang$Long = WSIFOperation_SOAP.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(clazz) || primitive.equals(Float.TYPE) && (class$java$lang$Float == null ? (class$java$lang$Float = WSIFOperation_SOAP.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(clazz) || primitive.equals(Double.TYPE) && (class$java$lang$Double == null ? (class$java$lang$Double = WSIFOperation_SOAP.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(clazz);
    }

    void setAsyncRequestID(WSIFCorrelationId asyncRequestID) {
        Trc.entry((Object)this, asyncRequestID);
        this.asyncRequestID = asyncRequestID;
        Trc.exit();
    }

    public String getStyle() {
        return this.operationStyle;
    }

    public String getInputUse() {
        return this.inputUse;
    }

    protected void setInputUse(String inputUse) {
        this.inputUse = inputUse;
    }

    public String getOperationStyle() {
        return this.operationStyle;
    }

    public void setStyle(String style) {
        this.operationStyle = style;
    }

    public void setOperationStyle(String style) {
        this.operationStyle = style;
    }

    public String deep() {
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(super.toString()).append(":\n");
            buff.append("wsifPort:").append(this.wsifPort);
            buff.append(" portTypeOperation:").append(Trc.brief(this.portTypeOperation));
            buff.append(" bindingOperation:").append(this.bindingOperation);
            buff.append(" soapOperation:").append(this.soapOperation);
            buff.append(" operationStyle:").append(this.operationStyle);
            buff.append(" inputSOAPParts:").append(this.inputSOAPParts);
            buff.append(" inputUnwrappedSOAPParts:").append(this.inputUnwrappedSOAPParts);
            buff.append(" inputMIMEParts:").append(this.inputMIMEParts);
            buff.append(" inputSOAPHeader:").append(this.inputSOAPHeader);
            buff.append(" inputSOAPHeaderFault:").append(this.inputSOAPHeaderFault);
            buff.append(" outputSOAPParts:").append(this.outputSOAPParts);
            buff.append(" outputUnwrappedSOAPParts:").append(this.outputUnwrappedSOAPParts);
            buff.append(" outputMIMEParts:").append(this.outputMIMEParts);
            buff.append(" outputSOAPHeader:").append(this.outputSOAPHeader);
            buff.append(" outputSOAPHeaderFault:").append(this.outputSOAPHeaderFault);
            buff.append(" inputEncodingStyle:").append(this.inputEncodingStyle);
            buff.append(" inputNamespace:").append(this.inputNamespace);
            buff.append(" actionUri:").append(this.soapActionURI);
            buff.append(" inJmsProps:").append(this.inJmsProps);
            buff.append(" outJmsProps:").append(this.outJmsProps);
            buff.append(" inJmsPropVals:").append(this.inJmsPropVals);
            buff.append(" context:").append(this.context);
            buff.append(" asyncOperation:").append(this.asyncOperation);
            buff.append(" asyncRequestID:").append(this.asyncRequestID);
            buff.append(" oneWayOperation:").append(this.oneWayOperation);
            buff.append(" responseHandler:").append(this.responseHandler);
            buff.append(" responseMessageParameters:").append(this.responseMessageParameters);
            buff.append(" outputEncodingStyle:").append(this.outputEncodingStyle);
            buff.append(" typeMap:").append(this.typeMap);
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

