/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.base.WSIFObjectInputStream;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;

public class WSIFDefaultCorrelationService
implements WSIFCorrelationService {
    private HashMap correlatorStore;
    private HashMap timeouts;
    private Thread timeoutWatcher;
    private boolean shutdown;

    public WSIFDefaultCorrelationService() {
        Trc.entry(this);
        Trc.exit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void put(WSIFCorrelationId correlator, Serializable state, long timeout) throws WSIFException {
        Trc.entry(this, correlator, state, new Long(timeout));
        if (correlator == null || state == null) throw new IllegalArgumentException("cannot put null " + (correlator == null ? "correlator" : "state"));
        if (this.correlatorStore == null) {
            this.initialise();
        }
        try {
            this.correlatorStore.put(correlator, this.serialize(state));
            if (timeout > 0L) {
                if (this.timeouts == null) {
                    this.initTimeouts();
                }
                this.timeouts.put(correlator, new Long(System.currentTimeMillis() + timeout));
            }
        }
        catch (IOException ex) {
            Trc.exception(ex);
            throw new WSIFException(ex.toString());
        }
        Trc.exit();
    }

    public synchronized Serializable get(WSIFCorrelationId id) throws WSIFException {
        Trc.entry((Object)this, id);
        if (this.correlatorStore == null) {
            throw new WSIFException("get called on correlation service but put never done");
        }
        if (id == null) {
            throw new IllegalArgumentException("cannot get null");
        }
        try {
            Serializable s = (Serializable)this.unserialize((byte[])this.correlatorStore.get(id));
            Trc.exit(s);
            return s;
        }
        catch (Exception ex) {
            Trc.exception(ex);
            throw new WSIFException(ex.toString());
        }
    }

    public synchronized void remove(WSIFCorrelationId id) throws WSIFException {
        Trc.entry((Object)this, id);
        if (this.correlatorStore == null) {
            throw new WSIFException("corelation service has been shutdown");
        }
        if (id == null) {
            throw new IllegalArgumentException("cannot remove null");
        }
        this.correlatorStore.remove(id);
        if (this.timeouts != null) {
            this.timeouts.remove(id);
        }
        Trc.exit();
    }

    private synchronized void remove(ArrayList expiredKeys) {
        Trc.entry((Object)this, expiredKeys);
        if (expiredKeys != null && this.correlatorStore != null) {
            Iterator i = expiredKeys.iterator();
            while (i.hasNext()) {
                Serializable id = (Serializable)i.next();
                this.correlatorStore.remove(id);
                this.timeouts.remove(id);
                MessageLogger.log("WSIF.0008W", id);
            }
        }
        Trc.exit();
    }

    public void shutdown() {
        Trc.entry(this);
        this.shutdown = true;
        Trc.exit();
    }

    private void initialise() {
        this.shutdown = false;
        this.correlatorStore = new HashMap();
    }

    private void initTimeouts() {
        this.timeouts = new HashMap();
        this.timeoutWatcher = new Thread(){

            public void run() {
                while (!WSIFDefaultCorrelationService.this.shutdown) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        Trc.ignoredException(ex);
                    }
                    WSIFDefaultCorrelationService.this.checkForTimeouts();
                }
                if (WSIFDefaultCorrelationService.this.correlatorStore != null) {
                    WSIFDefaultCorrelationService.this.correlatorStore = null;
                }
                if (WSIFDefaultCorrelationService.this.timeouts != null) {
                    WSIFDefaultCorrelationService.this.timeouts = null;
                }
            }
        };
        this.timeoutWatcher.setName("WSIFDefaultCorrelationService timeout watcher");
        this.timeoutWatcher.start();
    }

    private void checkForTimeouts() {
        ArrayList<Serializable> expiredKeys = new ArrayList<Serializable>();
        Long now = new Long(System.currentTimeMillis());
        try {
            Iterator i = this.timeouts.keySet().iterator();
            while (i.hasNext()) {
                Serializable key = (Serializable)i.next();
                Long expireTime = (Long)this.timeouts.get(key);
                if (now.compareTo(expireTime) <= 0) continue;
                expiredKeys.add(key);
            }
        }
        catch (ConcurrentModificationException ex) {
            Trc.ignoredException(ex);
        }
        if (expiredKeys.size() > 0) {
            this.remove(expiredKeys);
        }
    }

    private byte[] serialize(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream so = new ObjectOutputStream(baos);
        so.writeObject(o);
        so.flush();
        return baos.toByteArray();
    }

    private Object unserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        WSIFObjectInputStream si = new WSIFObjectInputStream(bais);
        return si.readObject();
    }
}

