/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import com.ibm.jrom.JROMValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Message;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.base.WSIFObjectInputStream;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.logging.Trc;

public class WSIFDefaultMessage
implements WSIFMessage {
    private static final long serialVersionUID = 1L;
    protected Map parts;
    protected String name;
    protected String style;
    protected Message msgDefinition;
    private boolean JROMAvailable = false;

    public WSIFDefaultMessage() {
        Trc.entry(this);
        this.JROMAvailable = WSIFServiceImpl.getJROMAvailability();
        Trc.exit();
    }

    public String getName() {
        Trc.entry(this);
        Trc.exit(this.name);
        return this.name;
    }

    public void setName(String name) {
        Trc.entry((Object)this, name);
        this.name = name;
        Trc.exit();
    }

    public String getRepresentationStyle() {
        Trc.entry(this);
        Trc.exit(this.style);
        return this.style;
    }

    public void setRepresentationStyle(String rStyle) {
        Trc.entry((Object)this, rStyle);
        this.style = rStyle;
        Trc.exit();
    }

    public Iterator getParts() {
        Trc.entry(this);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        Iterator it = this.parts.values().iterator();
        Trc.exit(it);
        return it;
    }

    public void setParts(Map sourceParts) {
        Trc.entry((Object)this, sourceParts);
        if (this.parts == null) {
            this.parts = new HashMap();
        } else {
            this.parts.clear();
        }
        Iterator names = sourceParts.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            Object part = sourceParts.get(name);
            this.parts.put(name, part);
        }
        Trc.exit();
    }

    public Message getMessageDefinition() {
        Trc.entry(this);
        Trc.exit(this.msgDefinition);
        return this.msgDefinition;
    }

    public void setMessageDefinition(Message msgDef) {
        Trc.entry((Object)this, this.msgDefinition);
        this.msgDefinition = msgDef;
        Trc.exit();
    }

    public void setObjectPart(String name, Object part) throws WSIFException {
        Trc.entry(this, name, part);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        if (this.JROMAvailable && part instanceof JROMValue) {
            this.style = "http://www.apache.org/namespaces/jrom";
        }
        this.parts.put(name, part);
        Trc.exit();
    }

    public Object getObjectPart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "Object");
            Trc.exit(null);
            return null;
        }
        if (this.parts.get(name) == null) {
            if (!this.parts.keySet().contains(name)) {
                this.handlePartNotFoundException(name);
            }
            Trc.exit(null);
            return null;
        }
        Object o = this.parts.get(name);
        Trc.exit(o);
        return o;
    }

    public Object getObjectPart(String name, Class sourceClass) throws WSIFException {
        Trc.entry(this, name, sourceClass);
        if (this.parts == null) {
            this.handleNoPartsException(name, "Object");
            Trc.exit(null);
            return null;
        }
        Object part = this.parts.get(name);
        if (part == null) {
            if (!this.parts.keySet().contains(name)) {
                this.handlePartNotFoundException(name);
            }
            Trc.exit(null);
            return null;
        }
        if (part.getClass().getName().equals(sourceClass.getName())) {
            Trc.exit(part);
            return part;
        }
        this.handleSourcedPartNotFoundException(name, sourceClass);
        Trc.exit(null);
        return null;
    }

    public byte getBytePart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "byte");
        }
        try {
            byte b = (Byte)this.parts.get(name);
            Trc.exit(b);
            return b;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name, this.parts.get(name).getClass().getName(), "Byte");
            Trc.exit(0);
            return 0;
        }
    }

    public void setBytePart(String name, byte part) {
        Trc.entry(this, name, new Byte(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name, new Byte(part));
        Trc.exit();
    }

    public char getCharPart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "char");
        }
        try {
            char c = ((Character)this.parts.get(name)).charValue();
            Trc.exit(c);
            return c;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name);
            Trc.exit(0);
            return '\u0000';
        }
        catch (ClassCastException ce) {
            try {
                String s = (String)this.parts.get(name);
                if (s != null && s.length() == 1) {
                    char c = s.charAt(0);
                    Trc.exit(c);
                    return c;
                }
                throw ce;
            }
            catch (ClassCastException ce2) {
                Trc.exception(ce);
                this.handlePartCastException(name, this.parts.get(name).getClass().getName(), "Character");
                Trc.exit(0);
                return '\u0000';
            }
        }
    }

    public void setCharPart(String name, char part) {
        Trc.entry(this, name, new Character(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name, new Character(part));
        Trc.exit();
    }

    public int getIntPart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "int");
        }
        try {
            int i = (Integer)this.parts.get(name);
            Trc.exit(i);
            return i;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name, this.parts.get(name).getClass().getName(), "Integer");
            Trc.exit(0);
            return 0;
        }
    }

    public void setIntPart(String name, int part) {
        Trc.entry(this, name, new Integer(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name, new Integer(part));
        Trc.exit();
    }

    public long getLongPart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "long");
        }
        try {
            long l = (Long)this.parts.get(name);
            Trc.exit(new Long(l));
            return l;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name);
            Trc.exit(0);
            return 0L;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name, this.parts.get(name).getClass().getName(), "Long");
            Trc.exit(0);
            return 0L;
        }
    }

    public void setLongPart(String name, long part) {
        Trc.entry(this, name, new Long(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name, new Long(part));
        Trc.exit();
    }

    public short getShortPart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "short");
        }
        try {
            short s = (Short)this.parts.get(name);
            Trc.exit(s);
            return s;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name, this.parts.get(name).getClass().getName(), "Short");
            Trc.exit(0);
            return 0;
        }
    }

    public void setShortPart(String name, short part) {
        Trc.entry(this, name, new Short(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name, new Short(part));
        Trc.exit();
    }

    public float getFloatPart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "float");
        }
        try {
            float f = ((Float)this.parts.get(name)).floatValue();
            Trc.exit(new Float(f));
            return f;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name);
            Trc.exit(0);
            return 0.0f;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name, this.parts.get(name).getClass().getName(), "Float");
            Trc.exit(0);
            return 0.0f;
        }
    }

    public void setFloatPart(String name, float part) {
        Trc.entry(this, name, new Float(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name, new Float(part));
        Trc.exit();
    }

    public double getDoublePart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "double");
        }
        try {
            double d = (Double)this.parts.get(name);
            Trc.exit(new Double(d));
            return d;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name);
            Trc.exit(0);
            return 0.0;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name, this.parts.get(name).getClass().getName(), "Double");
            Trc.exit(0);
            return 0.0;
        }
    }

    public void setDoublePart(String name, double part) {
        Trc.entry(this, name, new Double(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name, new Double(part));
        Trc.exit();
    }

    public boolean getBooleanPart(String name) throws WSIFException {
        Trc.entry((Object)this, name);
        if (this.parts == null) {
            this.handleNoPartsException(name, "boolean");
        }
        try {
            boolean b = (Boolean)this.parts.get(name);
            Trc.exit(b);
            return b;
        }
        catch (NullPointerException ne) {
            Trc.exception(ne);
            this.handlePartNotFoundException(name);
            Trc.exit(false);
            return false;
        }
        catch (ClassCastException ce) {
            Trc.exception(ce);
            this.handlePartCastException(name, this.parts.get(name).getClass().getName(), "Boolean");
            Trc.exit(false);
            return false;
        }
    }

    public void setBooleanPart(String name, boolean part) {
        Trc.entry(this, name, new Boolean(part));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(name, new Boolean(part));
        Trc.exit();
    }

    public Iterator getPartNames() {
        Trc.entry(this);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        Iterator it = this.parts.keySet().iterator();
        Trc.exit(it);
        return it;
    }

    public Object clone() throws CloneNotSupportedException {
        Trc.entry(this);
        WSIFDefaultMessage dm = new WSIFDefaultMessage();
        dm.setName(this.name);
        dm.setRepresentationStyle(this.style);
        dm.setMessageDefinition(this.msgDefinition);
        if (this.parts != null) {
            Iterator it = this.getPartNames();
            while (it.hasNext()) {
                String pn = (String)it.next();
                Object po = this.parts.get(pn);
                if (po == null) {
                    try {
                        dm.setObjectPart(pn, null);
                        continue;
                    }
                    catch (Exception e) {
                        Trc.exception(e);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + ". Message is " + e.getMessage());
                    }
                }
                Object simpleTypeObj = null;
                if (po instanceof String || po instanceof Integer || po instanceof Float || po instanceof Byte || po instanceof Long || po instanceof Short || po instanceof Double || po instanceof Boolean) {
                    simpleTypeObj = po;
                }
                try {
                    if (simpleTypeObj != null) {
                        dm.setObjectPart(pn, simpleTypeObj);
                        continue;
                    }
                }
                catch (Exception e) {
                    Trc.exception(e);
                    throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + ". Message is " + e.getMessage());
                }
                if (po instanceof Cloneable) {
                    final Class<?> cls = po.getClass();
                    try {
                        Method clone = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws NoSuchMethodException {
                                return cls.getMethod("clone", null);
                            }
                        });
                        Object poc = clone.invoke(po, null);
                        dm.setObjectPart(pn, poc);
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        Trc.exception(e);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + ". Message is " + e.getTargetException().getMessage());
                    }
                    catch (Exception e) {
                        if (e instanceof PrivilegedActionException) {
                            e = ((PrivilegedActionException)e).getException();
                        }
                        Trc.exception(e);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + ". Message is " + e.getMessage());
                    }
                }
                if (po instanceof Serializable) {
                    try {
                        ByteArrayOutputStream b = new ByteArrayOutputStream();
                        ObjectOutputStream out = new ObjectOutputStream(b);
                        out.writeObject(po);
                        out.flush();
                        out.close();
                        byte[] data = b.toByteArray();
                        WSIFObjectInputStream in = new WSIFObjectInputStream(new ByteArrayInputStream(data));
                        Object poc = in.readObject();
                        in.close();
                        dm.setObjectPart(pn, poc);
                        continue;
                    }
                    catch (Exception e) {
                        Trc.exception(e);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + pn + " by serialization. Message is " + e.getMessage());
                    }
                }
                throw new CloneNotSupportedException("Part " + pn + " cannot be cloned");
            }
        }
        if (Trc.ON) {
            Trc.exit(dm.deep());
        }
        return dm;
    }

    private void handleNoPartsException(String part, String type) throws WSIFException {
        throw new WSIFException("Cannot get " + type + " part '" + part + "'. No parts are set on the message");
    }

    private void handlePartNotFoundException(String part) throws WSIFException {
        throw new WSIFException("Cannot get part '" + part + "'. Part was not found in message");
    }

    private void handleSourcedPartNotFoundException(String part, Class sclass) throws WSIFException {
        throw new WSIFException("Cannot get part. Part '" + part + "' with source '" + sclass + "' was not found in message");
    }

    private void handlePartCastException(String part, String act, String exp) throws WSIFException {
        throw new WSIFException("Cannot get part '" + part + "'. Cannot convert " + "from " + act + " to " + exp);
    }

    public String toString() {
        return this.deep();
    }

    public String deep() {
        String buff;
        block3: {
            buff = "";
            try {
                buff = new String(super.toString());
                buff = buff + " name:" + this.name;
                buff = buff + " JROM:" + this.JROMAvailable;
                if (this.parts == null) {
                    buff = buff + " parts:null";
                    break block3;
                }
                buff = buff + Trc.brief(2, " parts", this.parts.values());
            }
            catch (Exception e) {
                Trc.exceptionInTrace(e);
            }
        }
        return buff;
    }
}

