/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFService;
import org.apache.wsif.base.PrivateCompositeExtensionRegistry;
import org.apache.wsif.base.WSIFClientProxy;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.WSIFMapper;
import org.apache.wsif.mapping.WSIFMapperFactory;
import org.apache.wsif.mapping.WSIFMappingConvention;
import org.apache.wsif.mapping.WSIFMappingConventionFactory;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.schema.Parser;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.util.WSIFPluggableProviders;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.AuthenticatingProxyWSDLLocatorImpl;
import org.apache.wsif.wsdl.ClosableLocator;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;

public class WSIFServiceImpl
implements WSIFService {
    private static PrivateCompositeExtensionRegistry providersExtRegs = new PrivateCompositeExtensionRegistry();
    private Definition def = null;
    private Service service;
    private PortType portType;
    private Map availablePorts;
    private WSIFDynamicTypeMap typeMap = new WSIFDynamicTypeMap();
    private String preferredPort = null;
    private static boolean jromAvailable = false;
    private static boolean jromChecked = false;
    private Map typeReg = null;
    private Port chosenPort = null;
    private WSIFMessage context;
    protected ArrayList schemaTypes = new ArrayList();
    protected WSIFMappingConvention mapCon = null;
    protected WSIFMapper mapper = null;
    private boolean typeMapInitialised = false;
    private boolean schemaTypesInitialised = false;
    private WSDLLocator specialistLocator = null;
    protected Map features = null;

    WSIFServiceImpl(String wsdlLoc, String serviceNS, String serviceName, String portTypeNS, String portTypeName, Map factoryFeatures) throws WSIFException {
        Trc.entry(this, wsdlLoc, serviceNS, serviceName, portTypeNS, portTypeName);
        this.features = factoryFeatures;
        Definition def = null;
        try {
            PasswordAuthentication pa = this.getProxyAuthentication();
            if (pa != null) {
                def = WSIFUtils.readWSDLThroughAuthProxy(wsdlLoc, pa);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(wsdlLoc, pa);
            }
            if (def == null) {
                def = WSIFUtils.readWSDL(null, wsdlLoc);
            }
            this.checkWSDL(def);
        }
        catch (WSDLException ex) {
            Trc.exception(ex);
            throw new WSIFException("could not load " + wsdlLoc, ex);
        }
        Service service = WSIFUtils.selectService(def, serviceNS, serviceName);
        PortType portType = WSIFUtils.selectPortType(def, portTypeNS, portTypeName);
        this.init(def, service, portType);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(String wsdlLoc, ClassLoader cl, String serviceNS, String serviceName, String portTypeNS, String portTypeName, Map factoryFeatures) throws WSIFException {
        Trc.entry(this, wsdlLoc, cl, serviceNS, serviceName, portTypeNS, portTypeName);
        this.features = factoryFeatures;
        Definition def = null;
        try {
            PasswordAuthentication pa = this.getProxyAuthentication();
            if (pa != null) {
                def = WSIFUtils.readWSDLThroughAuthProxy(wsdlLoc, pa);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(wsdlLoc, pa);
            }
            if (def == null) {
                def = WSIFUtils.readWSDL(null, wsdlLoc, cl);
                this.specialistLocator = new WSIFWSDLLocatorImpl(null, wsdlLoc, cl);
            }
            this.checkWSDL(def);
        }
        catch (WSDLException ex) {
            Trc.exception(ex);
            throw new WSIFException("could not load " + wsdlLoc, ex);
        }
        Service service = WSIFUtils.selectService(def, serviceNS, serviceName);
        PortType portType = WSIFUtils.selectPortType(def, portTypeNS, portTypeName);
        this.init(def, service, portType);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(Definition def, Map factoryFeatures) throws WSIFException {
        this(def, null, factoryFeatures);
    }

    WSIFServiceImpl(Definition def, Service service, Map factoryFeatures) throws WSIFException {
        this(def, service, null, factoryFeatures);
    }

    WSIFServiceImpl(Definition def, Service service, PortType portType, Map factoryFeatures) throws WSIFException {
        Trc.entry(this, def, service, portType, factoryFeatures);
        this.features = factoryFeatures;
        try {
            PasswordAuthentication pa = this.getProxyAuthentication();
            if (pa != null) {
                def = WSIFUtils.readWSDLThroughAuthProxy(def.getDocumentBaseURI(), pa);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(def.getDocumentBaseURI(), pa);
            }
        }
        catch (WSDLException we) {
            Trc.ignoredException(we);
        }
        this.init(def, service, portType);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(Definition def, String serviceNS, String serviceName, Map factoryFeatures) throws WSIFException {
        Trc.entry(this, def, serviceNS, serviceName, factoryFeatures);
        this.features = factoryFeatures;
        try {
            PasswordAuthentication pa = this.getProxyAuthentication();
            if (pa != null) {
                def = WSIFUtils.readWSDLThroughAuthProxy(def.getDocumentBaseURI(), pa);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(def.getDocumentBaseURI(), pa);
            }
        }
        catch (WSDLException we) {
            Trc.ignoredException(we);
        }
        Service service = WSIFUtils.selectService(def, serviceNS, serviceName);
        this.init(def, service, null);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(Definition def, String serviceNS, String serviceName, String portTypeNS, String portTypeName, Map factoryFeatures) throws WSIFException {
        Trc.entry(this, def, serviceNS, serviceName, portTypeNS, portTypeName, factoryFeatures);
        this.features = factoryFeatures;
        try {
            PasswordAuthentication pa = this.getProxyAuthentication();
            if (pa != null) {
                def = WSIFUtils.readWSDLThroughAuthProxy(def.getDocumentBaseURI(), pa);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(def.getDocumentBaseURI(), pa);
            }
        }
        catch (WSDLException we) {
            Trc.ignoredException(we);
        }
        this.checkWSDLForWSIF(def);
        Service service = WSIFUtils.selectService(def, serviceNS, serviceName);
        PortType portType = WSIFUtils.selectPortType(def, portTypeNS, portTypeName);
        this.init(def, service, portType);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(WSIFServiceImpl wsi) throws WSIFException {
        Trc.entry((Object)this, wsi);
        this.copyInitializedService(wsi);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    private void copyInitializedService(WSIFServiceImpl svc) {
        this.def = svc.def;
        this.service = svc.service;
        this.portType = svc.portType;
        this.availablePorts = (Map)((Hashtable)svc.availablePorts).clone();
        this.typeMap = svc.typeMap.copy();
        this.schemaTypesInitialised = svc.schemaTypesInitialised;
        this.typeMapInitialised = svc.typeMapInitialised;
        this.schemaTypes = (ArrayList)svc.schemaTypes.clone();
        this.mapCon = svc.mapCon;
        this.mapper = svc.mapper;
        this.features = svc.features instanceof Hashtable ? (Map)((Hashtable)svc.features).clone() : (svc.features instanceof HashMap ? (Map)((HashMap)svc.features).clone() : svc.features);
    }

    public void setPreferredPort(String portName) throws WSIFException {
        Trc.entry((Object)this, portName);
        if (portName == null) {
            throw new WSIFException("Preferred port name cannot be null");
        }
        PortType pt = this.getPortTypeFromPortName(portName);
        if (!pt.getQName().equals(this.portType.getQName())) {
            throw new WSIFException("Preferred port " + portName + "is not available for the port type " + this.portType.getQName());
        }
        this.preferredPort = portName;
        Trc.exit();
    }

    private PortType getPortTypeFromPortName(String portName) throws WSIFException {
        if (portName == null) {
            throw new WSIFException("Unable to find port type from a null port name");
        }
        Port port = this.service.getPort(portName);
        if (port == null) {
            throw new WSIFException("Port '" + portName + "' cannot be found in the service");
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            throw new WSIFException("No binding found for port '" + portName + "'");
        }
        PortType pt = binding.getPortType();
        if (pt == null) {
            throw new WSIFException("No port type found for binding '" + binding.getQName() + "'");
        }
        this.checkPortTypeInformation(this.def, pt);
        return pt;
    }

    public Iterator getAvailablePortNames() throws WSIFException {
        Trc.entry(this);
        Iterator it = null;
        if (this.availablePorts != null) {
            it = this.availablePorts.keySet().iterator();
        }
        Trc.exit(it);
        return it;
    }

    private WSIFPort createDynamicWSIFPort(Definition def, Service service, Port port) throws WSIFException {
        this.checkWSDLForWSIF(def);
        List bindingExList = port.getBinding().getExtensibilityElements();
        ExtensibilityElement bindingFirstEx = (ExtensibilityElement)bindingExList.get(0);
        String bindingNS = bindingFirstEx.getElementType().getNamespaceURI();
        WSIFProvider provider = WSIFPluggableProviders.getProvider(bindingNS);
        if (provider == null) {
            throw new WSIFException("could not find suitable provider for binding namespace '" + bindingNS + "'");
        }
        WSIFPort wsifPort = provider.createDynamicWSIFPort(def, service, port, this.typeMap);
        wsifPort.setContext(this.getContext());
        return wsifPort;
    }

    public WSIFPort getPort() throws WSIFException {
        Trc.entry(this);
        WSIFPort wp = null;
        if (this.preferredPort != null && this.availablePorts.get(this.preferredPort) != null) {
            wp = this.getPort(this.preferredPort);
        } else {
            if (this.preferredPort != null) {
                MessageLogger.log("WSIF.0011I", this.preferredPort);
            }
            wp = this.getPort(null);
        }
        Trc.exit(wp);
        return wp;
    }

    public WSIFPort getPort(String portName) throws WSIFException {
        Trc.entry((Object)this, portName);
        Port port = null;
        if (portName == null) {
            if (this.availablePorts.size() > 0) {
                port = (Port)this.availablePorts.values().iterator().next();
            }
            if (port == null) {
                throw new WSIFException("Unable to find an available port");
            }
        } else {
            port = (Port)this.availablePorts.get(portName);
            if (port == null) {
                throw new WSIFException("Port '" + portName + "' is not available and " + " no alternative can be found");
            }
        }
        this.setupTypeMappings();
        WSIFPort portInstance = this.createDynamicWSIFPort(this.def, this.service, port);
        if (portInstance == null) {
            throw new WSIFException("Provider was unable to create WSIFPort for port " + port.getName());
        }
        this.chosenPort = port;
        Trc.exit(portInstance);
        return portInstance;
    }

    private void mapType(QName xmlType, Class javaType, boolean force) throws WSIFException {
        Trc.entry(this, xmlType, javaType, new Boolean(force));
        this.typeMap.mapType(xmlType, javaType, force);
        Trc.exit();
    }

    public void mapType(QName xmlType, Class javaType) throws WSIFException {
        Trc.entry(this, xmlType, javaType);
        if (this.mapper != null) {
            this.mapper.overrideTypeMapping(xmlType, javaType.getName());
        }
        if (!this.schemaTypesInitialised) {
            this.typeMap.mapType(xmlType, javaType, true);
        }
        Trc.exit();
    }

    public void mapType(QName xmlType, String className) throws WSIFException {
        Trc.entry(this, xmlType, className);
        if (this.mapper != null) {
            this.mapper.overrideTypeMapping(xmlType, className);
        }
        if (!this.schemaTypesInitialised) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                Trc.ignoredException(e);
            }
            if (clazz != null) {
                this.typeMap.mapType(xmlType, clazz, true);
            }
        }
        Trc.exit();
    }

    public void mapPackage(String namespace, String packageName) throws WSIFException {
        Trc.entry((Object)namespace, packageName);
        this.populateSchemaTypes(this.specialistLocator);
        if (this.mapCon != null) {
            this.mapCon.overridePackageMapping(namespace, packageName);
        }
        Trc.exit();
    }

    public static WSIFProvider getDynamicWSIFProvider(String namespaceURI) {
        Trc.entry(null, namespaceURI);
        WSIFProvider p = WSIFPluggableProviders.getProvider(namespaceURI);
        Trc.exit(p);
        return p;
    }

    public static void setDynamicWSIFProvider(String providerNamespaceURI, WSIFProvider provider) {
        Trc.entry(null, providerNamespaceURI, provider);
        WSIFPluggableProviders.overrideDefaultProvider(providerNamespaceURI, provider);
        Trc.exit();
    }

    public static void setAutoLoadProviders(boolean b) {
        Trc.entry(null, b);
        WSIFPluggableProviders.setAutoLoadProviders(b);
        Trc.exit();
    }

    public Object getStub(String portName, Class iface) throws WSIFException {
        Trc.entry(this, portName, iface);
        this.populateSchemaTypes(this.specialistLocator);
        WSIFPort wsifPort = this.getPort(portName);
        PortType pt = this.getPortTypeFromPortName(portName);
        WSIFClientProxy clientProxy = WSIFClientProxy.newInstance(iface, this.def, this.service.getQName().getNamespaceURI(), this.service.getQName().getLocalPart(), this.portType.getQName().getNamespaceURI(), this.portType.getQName().getLocalPart(), this.typeMap);
        clientProxy.setPort(wsifPort);
        Object proxy = clientProxy.getProxy();
        Trc.exit();
        return proxy;
    }

    public Object getStub(Class iface) throws WSIFException {
        Trc.entry((Object)this, iface);
        this.populateSchemaTypes(this.specialistLocator);
        WSIFPort wsifPort = this.getPort();
        String portName = this.chosenPort.getName();
        PortType pt = this.getPortTypeFromPortName(portName);
        WSIFClientProxy clientProxy = WSIFClientProxy.newInstance(iface, this.def, this.service.getQName().getNamespaceURI(), this.service.getQName().getLocalPart(), pt.getQName().getNamespaceURI(), pt.getQName().getLocalPart(), this.typeMap);
        clientProxy.setPort(wsifPort);
        Object proxy = clientProxy.getProxy();
        Trc.exit();
        return proxy;
    }

    public static void addExtensionRegistry(ExtensionRegistry reg) {
        Trc.entry(null, reg);
        providersExtRegs.addExtensionRegistry(reg);
        Trc.exit();
    }

    public static ExtensionRegistry getCompositeExtensionRegistry() {
        Trc.entry(null);
        Trc.exit(providersExtRegs);
        return providersExtRegs;
    }

    private void init(Definition def, Service service, PortType portType) throws WSIFException {
        Port port;
        Iterator i;
        Map ports;
        if (def == null) {
            throw new IllegalArgumentException("WSDL definition can not be null");
        }
        this.checkWSDLForWSIF(def);
        if (service == null) {
            Map services = WSIFUtils.getAllItems(def, "Service");
            service = (Service)WSIFUtils.getNamedItem(services, null, "Service");
        }
        if (portType == null) {
            ports = service.getPorts();
            if (ports.size() == 0) {
                throw new WSIFException("WSDL must contain at least one port in " + service.getQName());
            }
            i = ports.values().iterator();
            while (i.hasNext()) {
                port = (Port)i.next();
                if (portType == null) {
                    portType = port.getBinding().getPortType();
                    continue;
                }
                PortType pt = port.getBinding().getPortType();
                if (pt.getQName().equals(portType.getQName())) continue;
                throw new WSIFException("when no port type was specified all ports must have the same port type in WSDL service " + service.getQName());
            }
            if (portType == null) {
                throw new IllegalArgumentException("WSDL more than one portType in service " + service);
            }
        }
        this.def = def;
        this.service = service;
        this.portType = portType;
        this.checkPortTypeInformation(def, portType);
        ports = service.getPorts();
        if (ports.size() == 0) {
            throw new WSIFException("WSDL must contain at least one port in " + service.getQName());
        }
        this.availablePorts = new Hashtable();
        i = ports.values().iterator();
        while (i.hasNext()) {
            String addressNS;
            List bindingExList;
            port = (Port)i.next();
            Binding binding = port.getBinding();
            if (binding == null || (bindingExList = binding.getExtensibilityElements()).size() <= 0) continue;
            ExtensibilityElement bindingFirstEx = (ExtensibilityElement)bindingExList.get(0);
            String bindingNS = bindingFirstEx.getElementType().getNamespaceURI();
            List addressExList = port.getExtensibilityElements();
            if (addressExList.size() > 0) {
                ExtensibilityElement addressFirstEx = (ExtensibilityElement)addressExList.get(0);
                addressNS = addressFirstEx.getElementType().getNamespaceURI();
            } else {
                addressNS = bindingNS;
            }
            if (!WSIFPluggableProviders.isProviderAvailable(bindingNS, addressNS)) continue;
            QName ptName = portType.getQName();
            if (!binding.getPortType().getQName().equals(ptName)) continue;
            String portName = port.getName();
            this.availablePorts.put(portName, port);
        }
        String mapperClass = null;
        String mappingConvClass = null;
        try {
            mapperClass = (String)this.features.get("org.apache.wsif.mapper");
        }
        catch (ClassCastException cce) {
            Trc.ignoredException(cce);
        }
        try {
            mappingConvClass = (String)this.features.get("org.apache.wsif.mappingconvention");
        }
        catch (ClassCastException cce) {
            Trc.ignoredException(cce);
        }
        this.overrideMapper(mapperClass);
        this.overrideMappingConvention(mappingConvClass);
        if (this.autoMapTypesOn()) {
            this.populateSchemaTypes(this.specialistLocator);
        }
    }

    private void checkPortTypeInformation(Definition def, PortType portType) throws WSIFException {
        List operationList = portType.getOperations();
        Iterator i = operationList.iterator();
        while (i.hasNext()) {
            Input input;
            Operation op = (Operation)i.next();
            String name = op.getName();
            if (op.isUndefined()) {
                throw new WSIFException("operation " + name + " is undefined!");
            }
            OperationType opType = op.getStyle();
            if (opType == null) {
                throw new WSIFException("operation " + name + " has no type!");
            }
            if (opType.equals(OperationType.REQUEST_RESPONSE)) {
                input = op.getInput();
                Output output = op.getOutput();
                if (input == null) {
                    throw new WSIFException("missing input message for operation " + name);
                }
                if (output != null) continue;
                throw new WSIFException("missing output message for operation " + name);
            }
            if (opType.equals(OperationType.ONE_WAY)) {
                input = op.getInput();
                if (input != null) continue;
                throw new WSIFException("missing input message for operation " + name);
            }
            MessageLogger.log("WSIF.0004E", opType, portType.getQName().getLocalPart());
            throw new WSIFException("operation type " + opType + " is not supported in port instance for " + portType.getQName());
        }
    }

    private void checkWSDLForWSIF(Definition def) throws WSIFException {
        try {
            this.checkWSDL(def);
        }
        catch (WSDLException ex) {
            Trc.exception(ex);
            throw new WSIFException("invalid WSDL defintion " + def.getQName(), ex);
        }
    }

    private void checkWSDL(Definition def) throws WSDLException {
        Iterator i = def.getMessages().values().iterator();
        while (i.hasNext()) {
            Message v = (Message)i.next();
            if (!v.isUndefined()) continue;
            throw new WSDLException("INVALID_WSDL", "referencing undefined message " + v);
        }
        Iterator i2 = def.getPortTypes().values().iterator();
        while (i2.hasNext()) {
            PortType v = (PortType)i2.next();
            if (!v.isUndefined()) continue;
            throw new WSDLException("INVALID_WSDL", "referencing undefined portType " + v);
        }
        Iterator i3 = def.getBindings().values().iterator();
        while (i3.hasNext()) {
            Binding v = (Binding)i3.next();
            if (!v.isUndefined()) continue;
            throw new WSDLException("INVALID_WSDL", "referencing undefined binding " + v);
        }
    }

    public static boolean getJROMAvailability() {
        Trc.entry(null);
        if (!jromChecked) {
            jromAvailable = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class<?> c = Class.forName("com.ibm.jrom.JROMValue", true, Thread.currentThread().getContextClassLoader());
                        return new Boolean(true);
                    }
                    catch (ClassNotFoundException ignored) {
                        Trc.ignoredException(ignored);
                        return new Boolean(false);
                    }
                }
            });
            jromChecked = true;
        }
        Trc.exit(jromAvailable);
        return jromAvailable;
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.def);
        return this.def;
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage contextCopy;
        Trc.entry(this);
        if (this.context == null) {
            contextCopy = new WSIFDefaultMessage();
        } else {
            try {
                contextCopy = (WSIFMessage)this.context.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new WSIFException("CloneNotSupportedException cloning context", e);
            }
        }
        Trc.exit(contextCopy);
        return contextCopy;
    }

    public void setContext(WSIFMessage context) {
        Trc.entry((Object)this, context);
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = context;
        Trc.exit();
    }

    protected void overrideMapper(String mapperClassName) throws WSIFException {
        this.mapper = mapperClassName != null ? WSIFMapperFactory.newMapper(mapperClassName) : WSIFMapperFactory.newMapper();
    }

    protected void overrideMappingConvention(String mappingConvClassName) throws WSIFException {
        this.mapCon = mappingConvClassName != null ? WSIFMappingConventionFactory.newMappingConvention(mappingConvClassName) : WSIFMappingConventionFactory.newMappingConvention();
        this.mapper.setMappingConvention(this.mapCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateSchemaTypes(WSDLLocator loc) throws WSIFException {
        ArrayList arrayList = this.schemaTypes;
        synchronized (arrayList) {
            if (this.schemaTypesInitialised) {
                return;
            }
            if (loc == null) {
                loc = new WSIFWSDLLocatorImpl((String)null, (String)null, (ClassLoader)null);
            }
            Parser.getAllSchemaTypes(this.def, this.schemaTypes, loc);
            if (loc instanceof ClosableLocator) {
                try {
                    ((ClosableLocator)((Object)loc)).close();
                }
                catch (IOException ioe) {
                    Trc.ignoredException(ioe);
                }
            }
            WSIFMessage ctx = this.getContext();
            ctx.setObjectPart("org.apache.wsif.schematypes", Collections.unmodifiableList(this.schemaTypes));
            this.setContext(ctx);
            this.schemaTypesInitialised = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupTypeMappings() throws WSIFException {
        ArrayList arrayList = this.schemaTypes;
        synchronized (arrayList) {
            if (this.typeMapInitialised) {
                return;
            }
            if (this.mapper == null) {
                Trc.event(this, "Automatic mapping of types did not take place because mapper was null");
                return;
            }
            SchemaType[] types = new SchemaType[this.schemaTypes.size()];
            this.schemaTypes.toArray(types);
            Map mappings = this.mapper.getMappings(types);
            if (mappings != null) {
                Iterator it = mappings.keySet().iterator();
                while (it.hasNext()) {
                    QName xmlType = (QName)it.next();
                    String clsName = (String)mappings.get(xmlType);
                    if (clsName == null) continue;
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(clsName, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        Trc.ignoredException(e);
                    }
                    if (clazz != null) {
                        this.mapType(xmlType, clazz, false);
                        continue;
                    }
                    clsName = clsName + "Element";
                    try {
                        clazz = Class.forName(clsName, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        Trc.ignoredException(e);
                    }
                    if (clazz == null) continue;
                    this.mapType(xmlType, clazz, false);
                }
            }
            this.typeMapInitialised = true;
        }
    }

    private boolean autoMapTypesOn() {
        if (this.features == null) {
            return false;
        }
        Object on = this.features.get("org.apache.wsif.automaptypes");
        if (on != null && on instanceof Boolean) {
            return (Boolean)on != false;
        }
        return false;
    }

    private PasswordAuthentication getProxyAuthentication() {
        Object pa;
        if (this.features != null && (pa = this.features.get("org.apache.wsif.proxyauthentication")) != null && pa instanceof PasswordAuthentication) {
            return (PasswordAuthentication)pa;
        }
        return null;
    }

    public String deep() {
        String buff = "";
        try {
            buff = new String(this.toString());
            buff = buff + "\nprovidersExtRegs:" + (providersExtRegs == null ? "null" : providersExtRegs.toString());
            buff = buff + "\ndef:" + Trc.brief(this.def);
            buff = buff + "\nservice:" + Trc.brief(this.service);
            buff = buff + "\nportType:" + Trc.brief(this.portType);
            buff = buff + "\navailablePorts:" + Trc.brief(this.availablePorts);
            buff = buff + "\ntypeMap:" + (this.typeMap == null ? "null" : this.typeMap.toString());
            buff = buff + "\ntypeMapInitialised:" + this.typeMapInitialised;
            buff = buff + "\npreferredPort:" + (this.preferredPort == null ? "null" : this.preferredPort);
            buff = buff + " jromAvailable:" + jromAvailable;
            buff = buff + " jromChecked:" + jromChecked;
            buff = buff + "\nchosenPort:" + Trc.brief(this.chosenPort);
            buff = buff + "\ncontext:" + this.context;
        }
        catch (Exception e) {
            Trc.exceptionInTrace(e);
        }
        return buff;
    }
}

