/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.compiler.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.wsif.WSIFException;
import org.apache.wsif.compiler.schema.tools.Conventions;

public class StreamFactory {
    public OutputStream getOutputStream(String root, String name, boolean overwrite) throws WSIFException {
        File directory;
        File directoryFin;
        Boolean dirExists;
        boolean verbose = Conventions.getVerbose();
        if (root != null && !(dirExists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(directoryFin = (directory = new File(root))){
            private final /* synthetic */ File val$directoryFin;
            {
                this.val$directoryFin = val$directoryFin;
            }

            public Object run() {
                return new Boolean(this.val$directoryFin.exists());
            }
        })).booleanValue()) {
            Boolean dirMade = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(directoryFin.mkdirs());
                }
            });
            if (!dirMade.booleanValue()) {
                throw new WSIFException("Failed to create directory '" + root + "'.");
            }
            if (verbose) {
                System.out.println("Created directory '" + directory.getAbsolutePath() + "'.");
            }
        }
        File file = new File(root, name);
        String absolutePath = file.getAbsolutePath();
        final File fileFin = file;
        Boolean fileExists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(fileFin.exists());
            }
        });
        if (fileExists.booleanValue()) {
            if (!overwrite) {
                throw new WSIFException("File '" + absolutePath + "' already exists. Please remove it or " + "enable the overwrite option.");
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    fileFin.delete();
                    return null;
                }
            });
            if (verbose) {
                System.out.println("Deleted file '" + absolutePath + "'.");
            }
        }
        if (verbose) {
            System.out.println("Created file '" + absolutePath + "'.");
        }
        try {
            return new FileOutputStream(absolutePath);
        }
        catch (FileNotFoundException e) {
            throw new WSIFException("Problem getting output stream.", e);
        }
    }

    public InputStream getInputStream(String root, String name) throws IOException {
        String fileName = root != null ? root + File.separatorChar + name : name;
        URL url = null;
        Object content = null;
        try {
            url = StreamFactory.getURL(null, fileName, 1);
            content = url.getContent();
        }
        catch (SecurityException e) {
            throw new IOException("Your JVM's security manager has disallowed access to '" + fileName + "'.");
        }
        catch (IOException e) {
            throw new IOException("The resource at '" + fileName + "' was not found.");
        }
        if (content == null) {
            throw new IllegalArgumentException("No content at '" + fileName + "'.");
        }
        if (content instanceof InputStream) {
            return (InputStream)content;
        }
        throw new IOException("The content of '" + fileName + "' is not a stream.");
    }

    private static URL getURL(URL contextURL, String spec, int recursiveDepth) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(contextURL, spec);
            try {
                url.openStream();
            }
            catch (IOException ioe1) {
                throw new MalformedURLException("This file was not found: " + url);
            }
        }
        catch (MalformedURLException e1) {
            url = new URL("file", "", spec);
            try {
                url.openStream();
            }
            catch (IOException ioe2) {
                String contextFileName;
                String parentName;
                if (contextURL != null && (parentName = new File(contextFileName = contextURL.getFile()).getParent()) != null && recursiveDepth < 3) {
                    return StreamFactory.getURL(new URL("file", "", parentName + '/'), spec, recursiveDepth + 1);
                }
                throw new MalformedURLException("This file was not found: " + url);
            }
        }
        return url;
    }
}

