/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers;

import com.ibm.wsdl.PartImpl;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.schema.ComplexType;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.Parser;
import org.apache.wsif.schema.SequenceElement;

public class ProviderUtils {
    public static Object stringArrayToCharacterArray(Object obj) throws WSIFException {
        return ProviderUtils.stringArrayToCharacterArray(obj, null);
    }

    protected static Object stringArrayToCharacterArray(Object obj, Object ret) throws WSIFException {
        if (obj.getClass().isArray()) {
            Object[] objs = (Object[])obj;
            ret = new Object[objs.length];
            int i = 0;
            while (i < objs.length) {
                Object temp = ProviderUtils.stringArrayToCharacterArray(objs[i], ret[i]);
                if (i == 0) {
                    Class<?> tempc = temp.getClass();
                    ret = Array.newInstance(tempc, objs.length);
                }
                ret[i] = temp;
                ++i;
            }
            return ret;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 1) {
                ret = new Character(s.charAt(0));
                return ret;
            }
            throw new WSIFException("String is longer than 1 character");
        }
        throw new WSIFException("Array entry is not a String or another array");
    }

    public static Object stringArrayToCharArray(Object obj) throws WSIFException {
        return ProviderUtils.stringArrayToCharArray(obj, null);
    }

    protected static Object stringArrayToCharArray(Object obj, Object ret) throws WSIFException {
        if (obj.getClass().isArray()) {
            Object[] objs = (Object[])obj;
            ret = new Object[objs.length];
            int i = 0;
            while (i < objs.length) {
                Object temp = ProviderUtils.stringArrayToCharArray(objs[i], ret[i]);
                if (i == 0) {
                    Class<?> tempc = temp.getClass();
                    ret = Array.newInstance(tempc, objs.length);
                }
                ret[i] = temp;
                if (temp instanceof Character && i == objs.length - 1) {
                    char[] tempca = new char[objs.length];
                    int j = 0;
                    while (j < objs.length) {
                        tempca[j] = ((Character[])ret)[j].charValue();
                        ++j;
                    }
                    ret = tempca;
                }
                ++i;
            }
            return ret;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 1) {
                ret = new Character(s.charAt(0));
                return ret;
            }
            throw new WSIFException("String is longer than 1 character");
        }
        throw new WSIFException("Array entry is not a String or another array");
    }

    public static Object characterArrayToStringArray(Object obj) throws WSIFException {
        return ProviderUtils.characterArrayToStringArray(obj, null);
    }

    protected static Object characterArrayToStringArray(Object obj, Object ret) throws WSIFException {
        if (obj.getClass().isArray()) {
            Object[] objs = (Object[])obj;
            ret = new Object[objs.length];
            int i = 0;
            while (i < objs.length) {
                Object temp = ProviderUtils.characterArrayToStringArray(objs[i], ret[i]);
                if (i == 0) {
                    Class<?> tempc = temp.getClass();
                    ret = Array.newInstance(tempc, objs.length);
                }
                ret[i] = temp;
                ++i;
            }
            return ret;
        }
        if (obj instanceof Character) {
            String s = obj.toString();
            return s;
        }
        throw new WSIFException("Array entry is not a Character or another array");
    }

    public static Object charArrayToStringArray(Object obj) throws WSIFException {
        return ProviderUtils.charArrayToStringArray(obj, null);
    }

    protected static Object charArrayToStringArray(Object obj, Object ret) throws WSIFException {
        if (obj.getClass().isArray()) {
            if (obj instanceof char[]) {
                char[] ca = obj;
                Character[] chra = new Character[ca.length];
                int j = 0;
                while (j < ca.length) {
                    chra[j] = new Character(ca[j]);
                    ++j;
                }
                obj = chra;
            }
            Object[] objs = obj;
            ret = new Object[objs.length];
            int i = 0;
            while (i < objs.length) {
                Object temp = ProviderUtils.charArrayToStringArray(objs[i], ret[i]);
                if (i == 0) {
                    Class<?> tempc = temp.getClass();
                    ret = Array.newInstance(tempc, objs.length);
                }
                ret[i] = temp;
                ++i;
            }
            return ret;
        }
        if (obj instanceof Character) {
            String s = obj.toString();
            return s;
        }
        throw new WSIFException("Array entry is not a char or another array");
    }

    public static Character stringToCharacter(String str) {
        if (str.length() != 1) {
            return null;
        }
        return new Character(str.charAt(0));
    }

    public static Object getDefaultObject(Class cls) {
        if (cls == null) {
            return null;
        }
        if (cls.isPrimitive()) {
            if (cls.getName().equals("int")) {
                return new Integer(0);
            }
            if (cls.getName().equals("char")) {
                return new Character('0');
            }
            if (cls.getName().equals("long")) {
                return new Long(0L);
            }
            if (cls.getName().equals("short")) {
                short s = 0;
                return new Short(s);
            }
            if (cls.getName().equals("double")) {
                return new Double(0.0);
            }
            if (cls.getName().equals("boolean")) {
                return new Boolean(false);
            }
            if (cls.getName().equals("byte")) {
                byte b = 0;
                return new Byte(b);
            }
            return new Float(0.0f);
        }
        return null;
    }

    public static boolean isUnwrapable(Operation op) {
        String name;
        List parts;
        Message outMsg;
        Output out;
        String name2;
        List parts2;
        Message inMsg;
        boolean unwrapable = true;
        Input in = op.getInput();
        if (in != null && (inMsg = in.getMessage()) != null && (parts2 = inMsg.getOrderedParts(null)).size() > 0 && ProviderUtils.getWrapperPart(parts2, name2 = op.getName()) == null) {
            unwrapable = false;
        }
        if (unwrapable && (out = op.getOutput()) != null && (outMsg = out.getMessage()) != null && (parts = outMsg.getOrderedParts(null)).size() > 0 && ProviderUtils.getWrapperPart(parts, name = op.getName() + "Response") == null) {
            unwrapable = false;
        }
        return unwrapable;
    }

    public static Part getWrapperPart(List parts, String operationName) {
        boolean wrapped = parts != null;
        Part elementPart = null;
        int i = 0;
        while (wrapped && i < parts.size()) {
            Part p = (Part)parts.get(i);
            if (p.getElementName() != null) {
                if (elementPart == null) {
                    elementPart = p;
                    String pName = p.getElementName().getLocalPart();
                    if (!operationName.equals(pName)) {
                        wrapped = false;
                    }
                } else {
                    wrapped = false;
                }
            }
            ++i;
        }
        if (!wrapped) {
            elementPart = null;
        }
        return elementPart;
    }

    public static List unWrapPart(Part p, Definition def) throws WSIFException {
        return ProviderUtils.unWrapPart(p, def, null);
    }

    public static List unWrapPart(Part p, Definition def, WSIFMessage context) throws WSIFException {
        ArrayList l = null;
        if (context != null) {
            try {
                l = (ArrayList)context.getObjectPart("org.apache.wsif.schematypes");
            }
            catch (Exception e) {
                Trc.ignoredException(e);
            }
        }
        if (l == null) {
            l = new ArrayList();
            Parser.getAllSchemaTypes(def, l, null);
        }
        if (l == null || l.size() < 1) {
            throw new WSIFException("no schema elements found");
        }
        QName partQN = p.getElementName();
        if (partQN == null) {
            throw new WSIFException("part has no QName");
        }
        ElementType et = ProviderUtils.getElementType(l, partQN);
        if (et == null) {
            throw new WSIFException("no ElementType found for part: " + p);
        }
        ArrayList<PartImpl> unWrappedParts = new ArrayList<PartImpl>();
        List children = et.getChildren();
        ComplexType ct = null;
        ct = children == null || children.size() < 1 ? ProviderUtils.getComplexType(l, et.getElementType()) : (ComplexType)children.get(0);
        if (ct == null) {
            throw new WSIFException("cannot find complex type from ElementType: " + et);
        }
        SequenceElement[] se = ct.getSequenceElements();
        if (se == null) {
            throw new WSIFException("no sequence elements found on: " + ct);
        }
        int i = 0;
        while (i < se.length) {
            PartImpl np = new PartImpl();
            QName type = se[i].getTypeName();
            if (type == null) {
                throw new WSIFException("sequence element has no type name: " + se[i]);
            }
            np.setName(type.getLocalPart());
            np.setElementName(se[i].getElementType());
            if (np.getElementName() == null) {
                np.setTypeName(se[i].getTypeName());
            }
            unWrappedParts.add(np);
            ++i;
        }
        return unWrappedParts;
    }

    protected static ElementType getElementType(List l, QName qn) {
        ElementType et = null;
        int i = 0;
        while (i < l.size() && et == null) {
            QName etQN;
            Object o = l.get(i);
            if (o instanceof ElementType && qn.equals(etQN = ((ElementType)o).getTypeName())) {
                et = (ElementType)o;
            }
            ++i;
        }
        return et;
    }

    protected static ComplexType getComplexType(List l, QName type) {
        ComplexType ct = null;
        if (type != null && l != null) {
            String name = type.getLocalPart();
            int i = 0;
            while (i < l.size() && ct == null) {
                Object o = l.get(i);
                if (o instanceof ComplexType && name.equals(((ComplexType)o).getTypeName().getLocalPart())) {
                    ct = (ComplexType)o;
                }
                ++i;
            }
        }
        return ct;
    }

    public static QName getPartType(Part p) {
        QName type = p.getTypeName();
        if (type == null) {
            type = p.getElementName();
        }
        return type;
    }

    public static String capitalizeFirst(String s) {
        StringBuffer sb = new StringBuffer(s);
        if (sb.length() > 0) {
            sb.setCharAt(0, (char)(sb.charAt(0) & 0xDF));
        }
        return sb.toString();
    }

    public static String lowercaseFirst(String s) {
        StringBuffer sb = new StringBuffer(s);
        if (sb.length() > 0) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        return sb.toString();
    }
}

