/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.providers.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.base.WSIFDefaultPort;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.java.WSIFOperation_Java;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.format.TypeMap;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;
import org.apache.wsif.wsdl.extensions.java.JavaAddress;

public class WSIFPort_Java
extends WSIFDefaultPort
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Definition fieldDefinition;
    private Port fieldPortModel;
    private transient Class serviceObjectClass;
    private transient Method[] serviceObjectMethods;
    private transient Constructor[] serviceObjectConstructors;
    private transient Object fieldObjectReference;
    private final boolean separatedObjectRef;
    private Map fieldTypeMaps;
    protected transient Map operationInstances;

    public WSIFPort_Java(Definition def, Port port, WSIFDynamicTypeMap typeMap) throws WSIFException {
        Trc.entry(this, def, port, typeMap);
        this.separatedObjectRef = true;
        this.fieldDefinition = def;
        this.fieldPortModel = port;
        this.operationInstances = new HashMap();
        this.buildTypeMap();
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    public WSIFOperation createOperation(String operationName) throws WSIFException {
        Trc.entry((Object)this, operationName);
        WSIFOperation wo = this.createOperation(operationName, null, null);
        Trc.exit(wo);
        return wo;
    }

    public WSIFOperation createOperation(String operationName, String inputName, String outputName) throws WSIFException {
        Trc.entry(this, operationName, inputName, outputName);
        WSIFOperation_Java op = this.getDynamicWSIFOperation(operationName, inputName, outputName);
        if (op == null) {
            throw new WSIFException("Could not create operation: " + operationName + ":" + inputName + ":" + outputName);
        }
        WSIFOperation_Java wo = op.copy();
        Trc.exit(wo);
        return wo;
    }

    protected WSIFOperation_Java getDynamicWSIFOperation(String name, String inputName, String outputName) throws WSIFException {
        BindingOperation bindingOperationModel;
        Trc.entry(this, name, inputName, outputName);
        WSIFOperation_Java operation = (WSIFOperation_Java)this.operationInstances.get(this.getKey(name, inputName, outputName));
        if (operation == null && (bindingOperationModel = WSIFUtils.getBindingOperation(this.fieldPortModel.getBinding(), name, inputName, outputName)) != null) {
            operation = new WSIFOperation_Java(this.fieldPortModel, bindingOperationModel, this, this.fieldTypeMaps);
            this.setDynamicWSIFOperation(name, inputName, outputName, operation);
        }
        Trc.exit(operation);
        return operation;
    }

    protected void setDynamicWSIFOperation(String name, String inputName, String outputName, WSIFOperation_Java value) {
        Trc.entry(this, name, inputName, outputName, value);
        this.operationInstances.put(this.getKey(name, inputName, outputName), value);
        Trc.exit();
    }

    Class getServiceObjectClass() throws WSIFException {
        Trc.entry(this);
        if (this.serviceObjectClass == null) {
            ExtensibilityElement portExtension = (ExtensibilityElement)this.fieldPortModel.getExtensibilityElements().get(0);
            if (portExtension == null) {
                throw new WSIFException("missing port extension");
            }
            JavaAddress address = (JavaAddress)portExtension;
            try {
                this.serviceObjectClass = Class.forName(address.getClassName(), true, Thread.currentThread().getContextClassLoader());
            }
            catch (Throwable ex) {
                Trc.exception(ex);
                throw new WSIFException("Exception getting target object class '" + address.getClassName() + "'", ex);
            }
        }
        Trc.exit(this.serviceObjectClass);
        return this.serviceObjectClass;
    }

    Constructor[] getServiceObjectConstructors() throws WSIFException {
        Trc.entry(this);
        if (this.serviceObjectConstructors == null) {
            final Class c = this.getServiceObjectClass();
            this.serviceObjectConstructors = (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return c.getConstructors();
                }
            });
        }
        Trc.exit(this.serviceObjectConstructors);
        return this.serviceObjectConstructors;
    }

    Method[] getServiceObjectMethods() throws WSIFException {
        Trc.entry(this);
        if (this.serviceObjectMethods == null) {
            final Class c = this.getServiceObjectClass();
            this.serviceObjectMethods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return c.getMethods();
                }
            });
        }
        Trc.exit(this.serviceObjectMethods);
        return this.serviceObjectMethods;
    }

    public Object getObjectReference() throws WSIFException {
        Trc.entry(this);
        if (this.fieldObjectReference == null) {
            Class c = this.getServiceObjectClass();
            try {
                this.fieldObjectReference = c.newInstance();
            }
            catch (Exception ex) {
                Trc.exception(ex);
                throw new WSIFException("Could not instantiate target object of class '" + c.getName() + "'", ex);
            }
        }
        Trc.exit(this.fieldObjectReference);
        return this.fieldObjectReference;
    }

    void setObjectReference(Object newObjectReference) {
        Trc.entry((Object)this, newObjectReference);
        this.fieldObjectReference = newObjectReference;
        Trc.exit();
    }

    private void buildTypeMap() throws WSIFException {
        Trc.entry(this);
        TypeMapping typeMapping = null;
        Iterator bindingIterator = this.fieldPortModel.getBinding().getExtensibilityElements().iterator();
        while (bindingIterator.hasNext()) {
            Object next = bindingIterator.next();
            if (!(next instanceof TypeMapping)) continue;
            typeMapping = (TypeMapping)next;
            if ("Java".equals(typeMapping.getEncoding()) && "Java".equals(typeMapping.getStyle())) break;
            typeMapping = null;
        }
        if (typeMapping == null) {
            QName bindingName = this.fieldPortModel.getBinding().getQName();
            throw new WSIFException("Binding " + (bindingName == null ? "<null>" : bindingName.toString()) + " does not contain a typeMap with encoding=Java and style=Java");
        }
        this.fieldTypeMaps = new HashMap();
        bindingIterator = typeMapping.getMaps().iterator();
        while (bindingIterator.hasNext()) {
            TypeMap typeMap = (TypeMap)bindingIterator.next();
            QName typeName = typeMap.getTypeName();
            if (typeName == null) {
                typeName = typeMap.getElementName();
            }
            String type = typeMap.getFormatType();
            if (typeName != null && type != null) {
                if (this.fieldTypeMaps.containsKey(typeName)) {
                    Vector<Object> v = null;
                    Object obj = this.fieldTypeMaps.get(typeName);
                    if (obj instanceof Vector) {
                        v = (Vector<Object>)obj;
                    } else {
                        v = new Vector<Object>();
                        v.addElement(obj);
                    }
                    v.addElement(type);
                    this.fieldTypeMaps.put(typeName, v);
                    continue;
                }
                this.fieldTypeMaps.put(typeName, type);
                continue;
            }
            throw new WSIFException("Error in binding TypeMap. Key or Value is null");
        }
        Trc.exit();
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.fieldDefinition);
        return this.fieldDefinition;
    }

    public Port getPortModel() {
        Trc.entry(this);
        Trc.exit(this.fieldPortModel);
        return this.fieldPortModel;
    }

    public String deep() {
        Iterator it;
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append(super.toString()).append(":\n");
        buff.append("definition:");
        if (this.fieldDefinition == null) {
            buff.append("null");
        } else if (this.fieldDefinition.getQName() == null) {
            buff.append("unknown");
        } else {
            buff.append(this.fieldDefinition.getQName().toString());
        }
        buff.append(" portModel:");
        if (this.fieldPortModel == null) {
            buff.append("null");
        } else if (this.fieldPortModel.getName() == null) {
            buff.append("unknown");
        } else {
            buff.append(this.fieldPortModel.getName().toString());
        }
        buff.append(" serviceObjectReference:").append(this.fieldObjectReference);
        buff.append(" serviceObjectClass: ").append(this.serviceObjectClass);
        buff.append(" serviceObjectConstructors: ");
        if (this.serviceObjectConstructors == null) {
            buff.append("null");
        } else {
            buff.append(this.serviceObjectConstructors);
            buff.append(" size:").append(this.serviceObjectConstructors.length);
        }
        buff.append(" serviceObjectMethods: ");
        if (this.serviceObjectMethods == null) {
            buff.append("null");
        } else {
            buff.append(this.serviceObjectMethods);
            buff.append(" size:").append(this.serviceObjectMethods.length);
        }
        buff.append(" formatTypeMaps: ");
        if (this.fieldTypeMaps == null) {
            buff.append("null");
        } else {
            buff.append(" size:").append(this.fieldTypeMaps.size());
            i = 0;
            it = this.fieldTypeMaps.keySet().iterator();
            while (it.hasNext()) {
                QName type = (QName)it.next();
                Object value = this.fieldTypeMaps.get(type);
                buff.append("\nformatTypeMaps[").append(i++).append("]:");
                buff.append(type).append(", ").append(value);
            }
            buff.append("\n");
        }
        buff.append(" operationInstances:");
        if (this.operationInstances == null) {
            buff.append("null");
        } else {
            buff.append(" size:").append(this.operationInstances.size());
            i = 0;
            it = this.operationInstances.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                WSIFOperation_Java woj = (WSIFOperation_Java)this.operationInstances.get(key);
                buff.append("\noperationInstances[").append(i++).append("]:");
                buff.append(key).append(" ").append(woj).append(" ");
            }
            buff.append("\n");
        }
        return buff.toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        if (this.fieldObjectReference != null && !(this.fieldObjectReference instanceof Serializable)) {
            oos.writeObject(null);
        } else {
            oos.writeObject(this.fieldObjectReference);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        if (this.separatedObjectRef) {
            Object ref;
            this.fieldObjectReference = ref = ois.readObject();
        }
        this.operationInstances = new HashMap();
    }
}

