/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wsif.schema.ComplexType;
import org.apache.wsif.schema.ElementType;
import org.apache.wsif.schema.SimpleType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Schema
implements Serializable {
    static final long serialVersionUID = 1L;
    private String targetNamespace = "";
    private ArrayList types = new ArrayList();
    private ArrayList iai = new ArrayList();

    Schema(Element el) {
        this.targetNamespace = el.getAttribute("targetNamespace");
        NodeList children = el.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String loc;
                Element subEl = (Element)child;
                String elType = subEl.getLocalName();
                if (elType.equals("complexType")) {
                    this.types.add(new ComplexType(subEl, this.targetNamespace));
                } else if (elType.equals("simpleType")) {
                    this.types.add(new SimpleType(subEl, this.targetNamespace));
                } else if (elType.equals("element")) {
                    this.types.add(new ElementType(subEl, this.targetNamespace));
                } else if ((elType.equals("import") || elType.equals("include")) && (loc = subEl.getAttribute("schemaLocation")) != null && !loc.equals("")) {
                    this.iai.add(loc);
                }
            }
            ++i;
        }
    }

    List getTypes() {
        return this.types;
    }

    String getTargetNamespace() {
        return this.targetNamespace;
    }

    String[] getImportsAndIncludes() {
        return this.iai.toArray(new String[this.iai.size()]);
    }
}

