/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.base.WSIFServiceImpl;
import org.apache.wsif.format.WSIFFormatHandler;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.MappingHelper;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.util.WSIFPluggableProviders;
import org.apache.wsif.wsdl.AuthenticatingProxyWSDLLocatorImpl;
import org.apache.wsif.wsdl.ClosableLocator;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;
import org.apache.wsif.wsdl.extensions.format.TypeMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSIFUtils {
    private static Class initContextClass;
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String FORMAT_HANDLER = "FormatHandler";
    private static final String ELEMENT_FORMAT_HANDLER = "ElementFormatHandler";
    private static final String PHYSICALREP = "physicalrep/";
    private static final String FORMATBINDING = "formatbinding/";
    private static final String XMLSEPARATORS = "-.:\u00b7\u0387\u06dd\u06de\u30fb";
    private static final String XMLSEPARATORS_NODOT = "-:\u00b7\u0387\u06dd\u06de";
    private static final String UNDERSCORE = "_";
    private static final String WWW = "www";
    private static final String lookupPrefix = "java:comp/env/";
    private static final String emptyString = "";
    private static Boolean providersInitialized;
    private static boolean simpleTypesMapCreated;
    private static HashMap simpleTypesMap;
    private static HashMap keywordMap;

    public static boolean isJNDIAvailable() {
        Trc.entry(null);
        initContextClass = (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName("javax.naming.InitialContext", true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable ignored) {
                    Trc.ignoredException(ignored);
                    return null;
                }
            }
        });
        boolean b = true;
        if (initContextClass == null) {
            b = false;
        }
        Trc.exit(b);
        return b;
    }

    public static Service selectService(Definition def, String serviceNS, String serviceName) throws WSIFException {
        Trc.entry(null, def, serviceNS, serviceName);
        Map services = WSIFUtils.getAllItems(def, "Service");
        QName serviceQName = serviceNS != null && serviceName != null ? new QName(serviceNS, serviceName) : null;
        Service service = (Service)WSIFUtils.getNamedItem(services, serviceQName, "Service");
        Trc.exit(service);
        return service;
    }

    public static PortType selectPortType(Definition def, String portTypeNS, String portTypeName) throws WSIFException {
        Trc.entry(null, def, portTypeNS, portTypeName);
        Map portTypes = WSIFUtils.getAllItems(def, "PortType");
        QName portTypeQName = portTypeNS != null && portTypeName != null ? new QName(portTypeNS, portTypeName) : null;
        PortType portType = (PortType)WSIFUtils.getNamedItem(portTypes, portTypeQName, "PortType");
        Trc.exit(portType);
        return portType;
    }

    public static void addDefinedItems(Map fromItems, String itemType, Map toItems) {
        Trc.entry(null, fromItems, itemType, toItems);
        if (fromItems != null) {
            Iterator entryIterator = fromItems.entrySet().iterator();
            if (itemType.equals("Message")) {
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    Message message = (Message)entry.getValue();
                    if (message.isUndefined()) continue;
                    toItems.put(entry.getKey(), message);
                }
            } else if (itemType.equals("Operation")) {
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    Operation operation = (Operation)entry.getValue();
                    if (operation.isUndefined()) continue;
                    toItems.put(entry.getKey(), operation);
                }
            } else if (itemType.equals("PortType")) {
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    PortType portType = (PortType)entry.getValue();
                    if (portType.isUndefined()) continue;
                    toItems.put(entry.getKey(), portType);
                }
            } else if (itemType.equals("Binding")) {
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    Binding binding = (Binding)entry.getValue();
                    if (binding.isUndefined()) continue;
                    toItems.put(entry.getKey(), binding);
                }
            } else if (itemType.equals("Service")) {
                while (entryIterator.hasNext()) {
                    Map.Entry entry = entryIterator.next();
                    Service service = (Service)entry.getValue();
                    toItems.put(entry.getKey(), service);
                }
            }
        }
        Trc.exit();
    }

    private static void getAllItems(Definition def, String itemType, Map toItems) {
        Trc.entry(null, def, itemType, toItems);
        Map items = null;
        if (itemType.equals("PortType")) {
            items = def.getPortTypes();
        } else if (itemType.equals("Service")) {
            items = def.getServices();
        } else {
            throw new IllegalArgumentException("Don't know how to find all " + itemType + "s.");
        }
        WSIFUtils.addDefinedItems(items, itemType, toItems);
        Map imports = def.getImports();
        if (imports != null) {
            Iterator valueIterator = imports.values().iterator();
            while (valueIterator.hasNext()) {
                List importList = (List)valueIterator.next();
                if (importList == null) continue;
                Iterator importIterator = importList.iterator();
                while (importIterator.hasNext()) {
                    Definition importedDef;
                    Import tempImport = (Import)importIterator.next();
                    if (tempImport == null || (importedDef = tempImport.getDefinition()) == null) continue;
                    WSIFUtils.getAllItems(importedDef, itemType, toItems);
                }
            }
        }
        Trc.exit();
    }

    public static Map getAllItems(Definition def, String itemType) {
        Trc.entry(null, def, itemType);
        HashMap ret = new HashMap();
        WSIFUtils.getAllItems(def, itemType, ret);
        Trc.exit(ret);
        return ret;
    }

    public static Object getNamedItem(Map items, QName qname, String itemType) throws WSIFException {
        Trc.entry(null, items, qname, itemType);
        if (qname != null) {
            Object item = items.get(qname);
            if (item != null) {
                Trc.exit(item);
                return item;
            }
            throw new WSIFException(itemType + " '" + qname + "' not found. Choices are: " + WSIFUtils.getCommaListFromQNameMap(items));
        }
        int size = items.size();
        if (size == 1) {
            Iterator valueIterator = items.values().iterator();
            Object o = valueIterator.next();
            Trc.exit(o);
            return o;
        }
        if (size == 0) {
            throw new WSIFException("WSDL document contains no " + itemType + "s.");
        }
        throw new WSIFException("Please specify a " + itemType + ". Choices are: " + WSIFUtils.getCommaListFromQNameMap(items));
    }

    private static String getCommaListFromQNameMap(Map qnameMap) {
        StringBuffer strBuf = new StringBuffer("{");
        Set keySet = qnameMap.keySet();
        Iterator keyIterator = keySet.iterator();
        int index = 0;
        while (keyIterator.hasNext()) {
            QName key = (QName)keyIterator.next();
            strBuf.append((index > 0 ? ", " : emptyString) + key);
            ++index;
        }
        strBuf.append("}");
        return strBuf.toString();
    }

    public static Definition readWSDL(String contextURL, String wsdlLoc) throws WSDLException {
        Trc.entry(null, contextURL, wsdlLoc);
        WSIFUtils.initializeProviders();
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        try {
            Definition def = wsdlReader.readWSDL(contextURL, wsdlLoc);
            Trc.exitExpandWsdl(def);
            return def;
        }
        catch (WSDLException e) {
            Trc.exception(e);
            MessageLogger.log("WSIF.0002E", wsdlLoc);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Definition readWSDLThroughAuthProxy(String wsdlLoc, PasswordAuthentication pa) throws WSDLException {
        Definition definition;
        Trc.entry(null, wsdlLoc, pa);
        WSIFUtils.initializeProviders();
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        AuthenticatingProxyWSDLLocatorImpl lo = null;
        try {
            lo = new AuthenticatingProxyWSDLLocatorImpl(wsdlLoc, pa);
            Definition def = wsdlReader.readWSDL(lo);
            Trc.exitExpandWsdl(def);
            definition = def;
        }
        catch (WSDLException e) {
            try {
                Trc.exception(e);
                MessageLogger.log("WSIF.0002E", wsdlLoc);
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    if (lo == null) throw throwable;
                    if (!(lo instanceof ClosableLocator)) throw throwable;
                    ((ClosableLocator)lo).close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    Trc.ignoredException(ioe);
                    throw throwable;
                }
            }
        }
        try {
            if (lo == null) return definition;
            if (!(lo instanceof ClosableLocator)) return definition;
            ((ClosableLocator)lo).close();
            return definition;
        }
        catch (IOException ioe) {
            Trc.ignoredException(ioe);
        }
        return definition;
    }

    public static Definition readWSDL(WSDLLocator loc) throws WSDLException {
        Trc.entry(null, loc);
        if (loc == null) {
            throw new WSDLException("CONFIGURATION_ERROR", "Cannot use null WSDLLocator for reading wsdl");
        }
        WSIFUtils.initializeProviders();
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        try {
            Definition def = wsdlReader.readWSDL(loc);
            Trc.exitExpandWsdl(def);
            return def;
        }
        catch (WSDLException e) {
            Trc.exception(e);
            MessageLogger.log("WSIF.0002E", loc.getBaseURI());
            throw e;
        }
    }

    public static Definition readWSDL(URL documentBase, Reader reader, ClassLoader cl) throws WSDLException {
        String base = documentBase == null ? null : documentBase.toString();
        return WSIFUtils.readWSDL(base, reader, cl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Definition readWSDL(String documentBase, Reader reader, ClassLoader cl) throws WSDLException {
        Definition definition;
        Trc.entry(null, documentBase, reader, cl);
        WSIFUtils.initializeProviders();
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        WSIFWSDLLocatorImpl lo = null;
        try {
            try {
                lo = new WSIFWSDLLocatorImpl(documentBase, reader, cl);
                Definition def = wsdlReader.readWSDL(lo);
                Trc.exitExpandWsdl(def);
                definition = def;
                Object var9_9 = null;
            }
            catch (WSDLException e) {
                Trc.exception(e);
                MessageLogger.log("WSIF.0002E", documentBase);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (lo == null) throw throwable;
                lo.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Trc.ignoredException(ioe);
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            Trc.ignoredException(ioe);
            return definition;
        }
        if (lo == null) return definition;
        lo.close();
        return definition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Definition readWSDL(URL contextURL, String wsdlLoc, ClassLoader cl) throws WSDLException {
        Definition definition;
        Trc.entry(null, contextURL, wsdlLoc, cl);
        WSIFUtils.initializeProviders();
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        final WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        WSIFWSDLLocatorImpl lo = null;
        try {
            try {
                String url = contextURL == null ? null : contextURL.toString();
                final WSIFWSDLLocatorImpl loFin = lo = new WSIFWSDLLocatorImpl(url, wsdlLoc, cl);
                Definition def = (Definition)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSDLException {
                        return wsdlReader.readWSDL(loFin);
                    }
                });
                Trc.exitExpandWsdl(def);
                definition = def;
                Object var11_12 = null;
            }
            catch (PrivilegedActionException ex) {
                WSDLException e = (WSDLException)ex.getException();
                Trc.exception(e);
                MessageLogger.log("WSIF.0002E", wsdlLoc);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                if (lo == null) throw throwable;
                lo.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Trc.ignoredException(ioe);
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe) {
            Trc.ignoredException(ioe);
            return definition;
        }
        if (lo == null) return definition;
        lo.close();
        return definition;
    }

    public static Definition readWSDL(String documentBaseURI, Reader reader) throws WSDLException {
        Trc.entry(null, documentBaseURI, reader);
        WSIFUtils.initializeProviders();
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        Definition def = wsdlReader.readWSDL(documentBaseURI, new InputSource(reader));
        Trc.exitExpandWsdl(def);
        return def;
    }

    public static Definition readWSDL(String documentBaseURI, Document wsdlDocument) throws WSDLException {
        Trc.entry(null, documentBaseURI, wsdlDocument);
        WSIFUtils.initializeProviders();
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        Definition def = wsdlReader.readWSDL(documentBaseURI, wsdlDocument);
        Trc.exitExpandWsdl(def);
        return def;
    }

    public static Definition readWSDL(String documentBaseURI, Element wsdlServicesElement) throws WSDLException {
        Trc.entry(null, documentBaseURI, wsdlServicesElement);
        WSIFUtils.initializeProviders();
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLReader wsdlReader = factory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.verbose", false);
        Definition def = wsdlReader.readWSDL(documentBaseURI, wsdlServicesElement);
        Trc.exitExpandWsdl(def);
        return def;
    }

    public static void writeWSDL(Definition def, Writer sink) throws WSDLException {
        Trc.entry(null, def, sink);
        WSDLFactory factory = WSDLFactory.newInstance("org.apache.wsif.wsdl.WSIFWSDLFactoryImpl");
        WSDLWriter wsdlWriter = factory.newWSDLWriter();
        wsdlWriter.writeWSDL(def, sink);
        Trc.exit();
    }

    public static Definition getDefinitionFromLocation(String contextURL, String location) throws WSIFException {
        Trc.entry(null, contextURL, location);
        if (location == null) {
            throw new WSIFException("WSDL location must not be null.");
        }
        Definition def = null;
        try {
            def = WSIFUtils.readWSDL(contextURL, location);
        }
        catch (WSDLException e) {
            Trc.exception(e);
            throw new WSIFException("Problem reading WSDL document.", e);
        }
        Trc.exitExpandWsdl(def);
        return def;
    }

    public static Definition getDefinitionFromContent(String contextURL, String content) throws WSIFException {
        Trc.entry(null, contextURL, content);
        if (content == null) {
            throw new WSIFException("WSDL content must not be null.");
        }
        Definition def = null;
        try {
            def = WSIFUtils.readWSDL(contextURL, new StringReader(content));
        }
        catch (WSDLException e) {
            Trc.exception(e);
            throw new WSIFException("Problem reading WSDL document.", e);
        }
        Trc.exitExpandWsdl(def);
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeProviders() {
        Boolean bl = providersInitialized;
        synchronized (bl) {
            if (!providersInitialized.booleanValue()) {
                WSIFPluggableProviders.getProvider(SLASH);
                providersInitialized = new Boolean(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSimpleTypesMap() {
        HashMap hashMap = simpleTypesMap;
        synchronized (hashMap) {
            if (!simpleTypesMapCreated) {
                MappingHelper.populateWithStandardXMLJavaMappings(simpleTypesMap, "http://www.w3.org/1999/XMLSchema", true);
                MappingHelper.populateWithStandardXMLJavaMappings(simpleTypesMap, "http://www.w3.org/2000/10/XMLSchema", false);
                MappingHelper.populateWithStandardXMLJavaMappings(simpleTypesMap, "http://www.w3.org/2001/XMLSchema", false);
                simpleTypesMapCreated = true;
            }
        }
    }

    public static Map getSimpleTypesMap() {
        if (!simpleTypesMapCreated) {
            WSIFUtils.createSimpleTypesMap();
        }
        return simpleTypesMap;
    }

    public static WSIFFormatHandler getFormatHandler(Part part, Definition definition, Binding binding) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String typePackageName;
        Trc.entry(null, part, definition, binding);
        WSIFFormatHandler formatHandler = null;
        QName partTypeQName = part.getTypeName();
        if (partTypeQName == null) {
            partTypeQName = part.getElementName();
        }
        if (partTypeQName == null) {
            throw new ClassNotFoundException(part.getName());
        }
        String formatHandlerName = typePackageName = WSIFUtils.getPackageNameFromNamespaceURI(partTypeQName.getNamespaceURI());
        String bindingShortName = WSIFUtils.getPackageNameFromXMLName(definition.getPrefix(WSIFUtils.getBindingNamespace(binding)));
        if (bindingShortName != null) {
            formatHandlerName = formatHandlerName + DOT + bindingShortName;
        }
        if (WSIFUtils.getFormatStylePackage(binding) != null) {
            formatHandlerName = formatHandlerName + DOT + WSIFUtils.getFormatStylePackage(binding);
        }
        String formatHandlerShortName = formatHandlerName + DOT + WSIFUtils.getJavaClassNameFromXMLName(partTypeQName.getLocalPart());
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            formatHandler = (WSIFFormatHandler)cl.loadClass(formatHandlerShortName + FORMAT_HANDLER).newInstance();
        }
        catch (ClassNotFoundException exn1) {
            Trc.ignoredException(exn1);
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                formatHandler = (WSIFFormatHandler)cl.loadClass(formatHandlerShortName + ELEMENT_FORMAT_HANDLER).newInstance();
            }
            catch (ClassNotFoundException exn2) {
                Trc.ignoredException(exn2);
                try {
                    formatHandler = (WSIFFormatHandler)Class.forName(formatHandlerShortName + FORMAT_HANDLER).newInstance();
                }
                catch (ClassNotFoundException exn3) {
                    Trc.ignoredException(exn3);
                    formatHandler = (WSIFFormatHandler)Class.forName(formatHandlerShortName + ELEMENT_FORMAT_HANDLER).newInstance();
                }
            }
        }
        if (formatHandler == null) {
            throw new ClassNotFoundException(formatHandlerName);
        }
        Trc.exit(formatHandler);
        return formatHandler;
    }

    public static String getPackageNameFromNamespaceURI(String namespaceURI) {
        Trc.entry(null, namespaceURI);
        List segments = WSIFUtils.getNamespaceURISegments(namespaceURI);
        StringBuffer packageNameBuffer = new StringBuffer();
        int i = 0;
        while (i < segments.size()) {
            String name;
            if (i == 0) {
                name = WSIFUtils.getPackageNameFromXMLName((String)segments.get(i));
                StringTokenizer tokenizer = new StringTokenizer(name, DOT);
                ArrayList<String> host = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    String nextT = tokenizer.nextToken();
                    host.add(0, nextT);
                }
                StringBuffer buffer = new StringBuffer();
                Iterator hi = host.iterator();
                while (hi.hasNext()) {
                    String nextSegment;
                    if (buffer.length() != 0) {
                        buffer.append('.');
                    }
                    if (!Character.isJavaIdentifierStart((nextSegment = (String)hi.next()).toCharArray()[0])) {
                        nextSegment = UNDERSCORE + nextSegment;
                    }
                    if (WSIFUtils.isJavaKeyword(nextSegment)) {
                        nextSegment = UNDERSCORE + nextSegment;
                    }
                    buffer.append(nextSegment);
                }
                name = buffer.toString();
            } else {
                name = WSIFUtils.getJavaNameFromXMLName((String)segments.get(i));
            }
            if (name.length() != 0) {
                if (packageNameBuffer.length() != 0) {
                    packageNameBuffer.append('.');
                }
                packageNameBuffer.append(name);
            }
            ++i;
        }
        Trc.exit(packageNameBuffer.toString());
        return packageNameBuffer.toString();
    }

    public static String getJavaNameFromXMLName(String xmlName, String delims) {
        Trc.entry(null, xmlName, delims);
        StringTokenizer tokenizer = new StringTokenizer(xmlName, delims);
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
        }
        String result = buffer.toString();
        if (!Character.isJavaIdentifierStart(result.toCharArray()[0])) {
            result = UNDERSCORE + result;
        }
        if (WSIFUtils.isJavaKeyword(result)) {
            result = UNDERSCORE + result;
        }
        Trc.exit(result);
        return result;
    }

    public static String getJavaNameFromXMLName(String xmlName) {
        Trc.entry(null, xmlName);
        String s = WSIFUtils.getJavaNameFromXMLName(xmlName, XMLSEPARATORS);
        Trc.exit(s);
        return s;
    }

    public static String getPackageNameFromXMLName(String xmlName) {
        Trc.entry(null, xmlName);
        String name = WSIFUtils.getJavaNameFromXMLName(xmlName, XMLSEPARATORS_NODOT);
        StringTokenizer tokenizer = new StringTokenizer(name, DOT);
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String nextSegment;
            if (buffer.length() != 0) {
                buffer.append('.');
            }
            if (!Character.isJavaIdentifierStart((nextSegment = tokenizer.nextToken()).toCharArray()[0])) {
                nextSegment = UNDERSCORE + nextSegment;
            }
            if (WSIFUtils.isJavaKeyword(nextSegment)) {
                nextSegment = UNDERSCORE + nextSegment;
            }
            buffer.append(nextSegment);
        }
        Trc.exit(buffer.toString());
        return buffer.toString();
    }

    private static List getNamespaceURISegments(String namespaceURI) {
        Trc.entry(null, namespaceURI);
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(namespaceURI, ":/");
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
        }
        if (!segments.isEmpty()) {
            try {
                URL url = new URL(namespaceURI);
                if (segments.get(0).equals(url.getProtocol())) {
                    segments.remove(0);
                }
            }
            catch (MalformedURLException exn) {
                Trc.ignoredException(exn);
            }
        }
        Trc.exit(segments);
        return segments;
    }

    private static String getBindingNamespace(Binding bindingModel) {
        Trc.entry(null, bindingModel);
        Iterator iterator = bindingModel.getExtensibilityElements().iterator();
        String returnNamespace = null;
        while (iterator.hasNext()) {
            String namespace;
            ExtensibilityElement ee = (ExtensibilityElement)iterator.next();
            if (returnNamespace != null || (namespace = ee.getElementType().getNamespaceURI()).endsWith(PHYSICALREP) || namespace.endsWith(FORMATBINDING)) continue;
            returnNamespace = namespace;
        }
        Trc.exit(returnNamespace);
        return returnNamespace;
    }

    public static String getFormatStylePackage(Binding bindingModel) {
        Trc.entry(null, bindingModel);
        Iterator iterator = bindingModel.getExtensibilityElements().iterator();
        String formatPackageName = null;
        while (iterator.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)iterator.next();
            if (ee instanceof TypeMapping) {
                TypeMapping typeMapping = (TypeMapping)ee;
                formatPackageName = typeMapping.getEncoding();
                if (typeMapping.getStyle() != null) {
                    formatPackageName = formatPackageName + typeMapping.getStyle();
                }
            }
            if (formatPackageName != null) break;
        }
        String s = null;
        s = formatPackageName != null ? WSIFUtils.getPackageNameFromXMLName(formatPackageName) : formatPackageName;
        Trc.exit(s);
        return s;
    }

    public static String getFormatHandlerName(Part part, Definition definition, Binding binding) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String typePackageName;
        Trc.entry(null, part, definition, binding);
        QName partTypeQName = part.getTypeName();
        if (partTypeQName == null) {
            partTypeQName = part.getElementName();
        }
        if (partTypeQName == null) {
            throw new ClassNotFoundException(part.getName());
        }
        String formatHandlerName = typePackageName = WSIFUtils.getPackageNameFromNamespaceURI(partTypeQName.getNamespaceURI());
        String bindingShortName = WSIFUtils.getPackageNameFromXMLName(definition.getPrefix(WSIFUtils.getBindingNamespace(binding)));
        if (bindingShortName != null) {
            formatHandlerName = formatHandlerName + DOT + bindingShortName;
        }
        if (WSIFUtils.getFormatStylePackage(binding) != null) {
            formatHandlerName = formatHandlerName + DOT + WSIFUtils.getFormatStylePackage(binding);
        }
        formatHandlerName = formatHandlerName + DOT + WSIFUtils.getJavaClassNameFromXMLName(partTypeQName.getLocalPart()) + FORMAT_HANDLER;
        Trc.exit(formatHandlerName);
        return formatHandlerName;
    }

    public static String getJavaClassNameFromXMLName(String xmlName) {
        Trc.entry(null, xmlName);
        String s = WSIFUtils.getJavaClassNameFromXMLName(xmlName, XMLSEPARATORS);
        Trc.exit(s);
        return s;
    }

    public static String getJavaClassNameFromXMLName(String xmlName, String delims) {
        Trc.entry(null, xmlName, delims);
        StringTokenizer tokenizer = new StringTokenizer(xmlName, delims);
        StringBuffer buffer = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            String nextSegment = tokenizer.nextToken();
            if (nextSegment.length() > 0) {
                nextSegment = Character.toUpperCase(nextSegment.toCharArray()[0]) + nextSegment.substring(1);
            }
            buffer.append(nextSegment);
        }
        String result = buffer.toString();
        if (!Character.isJavaIdentifierStart(result.toCharArray()[0])) {
            result = UNDERSCORE + result;
        }
        Trc.exit(result);
        if (WSIFUtils.isJavaKeyword(result)) {
            return UNDERSCORE + result;
        }
        return result;
    }

    public static String getXSDNamespaceFromPackageName(String packageName) {
        String result = emptyString;
        StringTokenizer tokenizer = new StringTokenizer(packageName, DOT);
        while (tokenizer.hasMoreTokens()) {
            String nextT = tokenizer.nextToken();
            result = WSIFUtils.removeUnderscores(nextT) + DOT + result;
        }
        if (result.endsWith(DOT)) {
            return "http://" + result.substring(0, result.length() - 1) + SLASH;
        }
        return "http://" + result + SLASH;
    }

    private static String removeUnderscores(String s) {
        String result = emptyString;
        StringTokenizer tokenizer = new StringTokenizer(s, UNDERSCORE);
        while (tokenizer.hasMoreTokens()) {
            String nextT = tokenizer.nextToken();
            result = result + nextT;
        }
        return result;
    }

    public static BindingOperation getBindingOperation(Binding binding, Operation portTypeOp) throws WSIFException {
        Trc.entry(null, binding, portTypeOp);
        BindingOperation bop = portTypeOp == null ? null : WSIFUtils.getBindingOperation(binding, portTypeOp.getName(), portTypeOp.getInput() == null ? null : portTypeOp.getInput().getName(), portTypeOp.getOutput() == null ? null : portTypeOp.getOutput().getName());
        Trc.exit(bop);
        return bop;
    }

    public static BindingOperation getBindingOperation(Binding binding, String opName, String inName, String outName) throws WSIFException {
        Trc.entry(null, binding, opName, inName, outName);
        BindingOperation op = null;
        if (binding != null && opName != null) {
            ArrayList<BindingOperation> matchingOps = new ArrayList<BindingOperation>();
            List bops = binding.getBindingOperations();
            if (bops != null) {
                Iterator i = bops.iterator();
                while (i.hasNext()) {
                    BindingOperation bop = (BindingOperation)i.next();
                    if (!opName.equalsIgnoreCase(bop.getName())) continue;
                    matchingOps.add(bop);
                }
                if (matchingOps.size() == 1) {
                    op = (BindingOperation)matchingOps.get(0);
                } else if (matchingOps.size() > 1) {
                    op = WSIFUtils.chooseBindingOperation(matchingOps, inName, outName);
                }
            }
        }
        Trc.exit(op);
        return op;
    }

    private static BindingOperation chooseBindingOperation(ArrayList bindingOps, String inName, String outName) throws WSIFException {
        BindingOperation choosenOp = null;
        Iterator i = bindingOps.iterator();
        while (i.hasNext()) {
            String boutName;
            BindingOperation bop = (BindingOperation)i.next();
            String binName = bop.getBindingInput() == null ? null : bop.getBindingInput().getName();
            String string = boutName = bop.getBindingOutput() == null ? null : bop.getBindingOutput().getName();
            if (!(inName == null ? binName == null : inName.equalsIgnoreCase(binName))) continue;
            boolean outNamesMatch = true;
            outNamesMatch = outName == null || outName.length() < 1 ? boutName == null || boutName.length() < 1 : outName.equalsIgnoreCase(boutName);
            if (!outNamesMatch) continue;
            if (choosenOp == null) {
                choosenOp = bop;
                continue;
            }
            throw new WSIFException("duplicate operation in binding: " + bop.getName() + ":" + inName + ":" + outName);
        }
        return choosenOp;
    }

    private static boolean isJavaKeyword(String identifier) {
        if (keywordMap == null) {
            Object value = new Object();
            keywordMap = new HashMap();
            keywordMap.put("abstract", value);
            keywordMap.put("default", value);
            keywordMap.put("if", value);
            keywordMap.put("private", value);
            keywordMap.put("this", value);
            keywordMap.put("boolean", value);
            keywordMap.put("do", value);
            keywordMap.put("implements", value);
            keywordMap.put("protected", value);
            keywordMap.put("throw", value);
            keywordMap.put("break", value);
            keywordMap.put("double", value);
            keywordMap.put("import", value);
            keywordMap.put("public", value);
            keywordMap.put("throws", value);
            keywordMap.put("byte", value);
            keywordMap.put("else", value);
            keywordMap.put("instanceof", value);
            keywordMap.put("return", value);
            keywordMap.put("transient", value);
            keywordMap.put("case", value);
            keywordMap.put("extends", value);
            keywordMap.put("int", value);
            keywordMap.put("short", value);
            keywordMap.put("try", value);
            keywordMap.put("catch", value);
            keywordMap.put("final", value);
            keywordMap.put("interface", value);
            keywordMap.put("static", value);
            keywordMap.put("void", value);
            keywordMap.put("char", value);
            keywordMap.put("finally", value);
            keywordMap.put("long", value);
            keywordMap.put("strictfp", value);
            keywordMap.put("volatile", value);
            keywordMap.put("class", value);
            keywordMap.put("float", value);
            keywordMap.put("native", value);
            keywordMap.put("super", value);
            keywordMap.put("while", value);
            keywordMap.put("const", value);
            keywordMap.put("for", value);
            keywordMap.put("new", value);
            keywordMap.put("switch", value);
            keywordMap.put("continue", value);
            keywordMap.put("goto", value);
            keywordMap.put("package", value);
            keywordMap.put("synchronized", value);
            keywordMap.put("null", value);
            keywordMap.put("true", value);
            keywordMap.put("false", value);
            keywordMap.put("assert", value);
        }
        return keywordMap.containsKey(identifier);
    }

    public static boolean wildcardCompare(String s1, String s2, char wild) {
        if (s1 == null) {
            return false;
        }
        String w = wild + emptyString;
        return WSIFUtils.cmp(new StringTokenizer(s1, w, true), s2, w);
    }

    private static boolean cmp(StringTokenizer st, String s, String wild) {
        if (s == null || s.equals(emptyString)) {
            return !st.hasMoreTokens();
        }
        if (st.hasMoreTokens()) {
            int i;
            String s2 = st.nextToken();
            if (wild.equals(s2)) {
                if (!st.hasMoreTokens()) {
                    return true;
                }
                s2 = st.nextToken();
                if (s.equals(s2)) {
                    return false;
                }
            }
            if ((i = s.indexOf(s2)) < 0) {
                return false;
            }
            if ((i += s2.length()) < s.length()) {
                return WSIFUtils.cmp(st, s.substring(i), wild);
            }
            return WSIFUtils.cmp(st, emptyString, wild);
        }
        return false;
    }

    public static boolean isWrappedDocLiteral(List parts, String name) {
        return ProviderUtils.getWrapperPart(parts, name) != null;
    }

    public static Part getWrappedDocLiteralPart(List parts, String operationName) {
        return ProviderUtils.getWrapperPart(parts, operationName);
    }

    public static List unWrapPart(Part p, Definition def) throws WSIFException {
        return ProviderUtils.unWrapPart(p, def);
    }

    public static ExtensionRegistry getExtensionRegistry() {
        Trc.entry(null);
        WSIFUtils.initializeProviders();
        ExtensionRegistry er = WSIFServiceImpl.getCompositeExtensionRegistry();
        Trc.exit(er);
        return er;
    }

    static {
        providersInitialized = new Boolean(false);
        simpleTypesMapCreated = false;
        simpleTypesMap = new HashMap();
        keywordMap = null;
    }
}

