/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.util.jms;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.jms.WSIFJMSConstants;
import org.apache.wsif.util.jms.WSIFJMSDestination;
import org.apache.wsif.util.jms.WSIFJMSFinder;
import org.apache.wsif.util.jms.WSIFJMSListener;

public class JMS2HTTPBridgeDestination
extends WSIFJMSDestination {
    public static final String COLDSTART = "cold";
    public static final String WARMSTART = "warm";
    private boolean verbose;
    private static final ArrayList allStarts = new ArrayList<Object>(Arrays.asList("cold", "warm"));

    public JMS2HTTPBridgeDestination(WSIFJMSFinder finder, String altDestName, long timeout, String startType, boolean verbose) throws WSIFException {
        super(finder, altDestName, timeout);
        Trc.entry(this, finder, altDestName, new Long(timeout), startType, new Boolean(verbose));
        this.verbose = verbose;
        this.readQ = this.writeQ;
        this.writeQ = null;
        if (!allStarts.contains(startType)) {
            throw new WSIFException("StartType must either be warm or cold");
        }
        if (COLDSTART.equals(startType)) {
            if (verbose) {
                System.out.println("Wiping messages off the read queue");
            }
            Message msg = null;
            try {
                QueueReceiver rec = this.session.createReceiver(this.readQ);
                while ((msg = rec.receive(100L)) != null) {
                    if (!verbose) continue;
                    System.out.println("Removing an input message");
                }
            }
            catch (Exception ignored) {
                Trc.exception(ignored);
            }
        }
        Trc.exit();
    }

    public void listen(WSIFJMSListener listener) throws WSIFException {
        Trc.entry((Object)this, listener);
        this.listen(listener, this.readQ);
        Trc.exit();
    }

    public void listen(WSIFJMSListener listener, Queue queue) throws WSIFException {
        Trc.entry(this, listener, queue);
        this.areWeClosed();
        try {
            QueueReceiver qr = this.session.createReceiver(queue);
            qr.setMessageListener((MessageListener)listener);
            this.connection.setExceptionListener((ExceptionListener)listener);
            this.connection.start();
            int i = 1;
            while (!Thread.interrupted()) {
                Thread.yield();
                Thread.sleep(5000L);
                if (this.verbose) {
                    System.out.println("Waiting... " + i);
                }
                ++i;
            }
        }
        catch (JMSException je) {
            Trc.exception(je);
            throw WSIFJMSConstants.ToWsifException(je);
        }
        catch (InterruptedException ignored) {
            Trc.exception(ignored);
            System.out.println("Exitting");
        }
        Trc.exit();
    }

    public void setReplyToQueue() throws WSIFException {
        Trc.entry(this);
        Trc.exit();
    }

    public void setReplyToQueue(String replyTo) throws WSIFException {
        Trc.entry((Object)this, replyTo);
        Trc.exit();
    }

    public void setReplyToQueue(Queue replyTo) throws WSIFException {
        Trc.entry((Object)this, replyTo);
        this.areWeClosed();
        if (this.writeQ == null) {
            this.writeQ = replyTo;
        } else if (!this.writeQ.equals(replyTo)) {
            if (this.sender != null) {
                try {
                    this.sender.close();
                }
                catch (Exception e) {
                    Trc.exception(e);
                }
                this.sender = null;
            }
            this.writeQ = replyTo;
        }
        Trc.exit();
    }
}

